/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementAdapterFactory;
import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.Messages;
import com.tssap.selena.internal.core.providers.java.ParsersCache;
import com.tssap.selena.internal.core.providers.java.SRTOptionListener;
import com.tssap.selena.internal.core.providers.java.delta.CacheUpdater;
import com.tssap.selena.internal.core.providers.java.delta.CloseEditorPatcher;
import com.tssap.selena.internal.core.providers.java.delta.CommentDeltaPatcher;
import com.tssap.selena.internal.core.providers.java.delta.CompilationUnitPatcher;
import com.tssap.selena.internal.core.providers.java.delta.CompilationUnitStates;
import com.tssap.selena.internal.core.providers.java.delta.NonPublicTypesPatcher;
import com.tssap.selena.internal.core.providers.java.delta.ProcessedCompilationUnits;
import com.tssap.selena.internal.core.providers.java.delta.WorkingCopyPatcher;
import com.tssap.selena.internal.core.providers.java.editor.JavaEditorPart;
import com.tssap.selena.internal.core.providers.java.resources.PackageContentClipboard;
import com.tssap.selena.internal.core.providers.java.resources.PackageContentFactoryImpl;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaProviderPlugin
extends Plugin
implements IPropertyChangeListener {
    private static ArrayList ourSRTOptionListener = new ArrayList();
    private static Boolean myIsLogPrintingEnabled;
    private static Boolean myIsJDTDumpEnabled;
    private static Boolean myIsProviderDumpEnabled;
    private static boolean ourIsSRTEnabled;
    private static String outLinkFieldPrefix;
    private static final IPreferenceStore ourWorkpacePreferenceStore;
    private static JavaProviderPlugin ourPlugin;
    public static final String EOL;
    public static final String EOL_TOKEN = "\n\r";
    public static final String ALL_VALUE = "all";
    public static final String NONE_VALUE = "none";
    public static final String AUTOMATIC_VALUE = "automatic";
    public static final String SRT_ENABLED_PREFERENCE_NAME = "srt_enabled";
    public static final String SAVE_RESOURCES_PREFERENCE_NAME = "save_resources_automatically";
    public static final String OPTIMIZE_IMPORT_PREFERENCE_NAME = "optimize_import_enabled";
    public static final String DELETE_ATTRIBUTE_PREFERENCE_NAME = "delete_attribute";
    public static final String UPDATE_EXTENDS_PREFERENCE_NAME = "update_extends";
    public static final String RECOGNIZE_PROPERTIES = "recognize_properties";
    public static final String HIDE_PROPERTIES_PARTICIPANTS = "hide_properties_participants";
    public static final String REFACTOR_DEFAULT_NAMES = "refactor_default_names";
    public static final String LOG_PRINTING = "log_printing";
    public static final String JDT_DELTA_DUMP = "jdt_delta_dump";
    public static final String PROVIDER_DELTA_DUMP = "provider_delta_dump";

    public JavaProviderPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourPlugin = this;
    }

    public static JavaProviderPlugin getDefault() {
        return ourPlugin;
    }

    public void startup() throws CoreException {
        super.startup();
        ourWorkpacePreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        ourIsSRTEnabled = ourWorkpacePreferenceStore.getBoolean(SRT_ENABLED_PREFERENCE_NAME);
        outLinkFieldPrefix = ourWorkpacePreferenceStore.getString("lnk_field_prefix");
        CacheUpdater.startup();
        ElementCacheAccess.startup();
        ParsersCache.startup();
        ElementAdapterFactory.startup();
        JavaEditorPart.startup();
        ProcessedCompilationUnits.startup();
        CompilationUnitStates.startup();
        CommentDeltaPatcher.startup();
        CompilationUnitPatcher.startup();
        WorkingCopyPatcher.startup();
        NonPublicTypesPatcher.startup();
        CloseEditorPatcher.startup();
        PackageContentClipboard.registerFactory(new PackageContentFactoryImpl());
    }

    public void shutdown() throws CoreException {
        ourWorkpacePreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        CacheUpdater.shutdown();
        ElementCacheAccess.shutdown();
        ParsersCache.shutdown();
        ElementAdapterFactory.shutdown();
        JavaEditorPart.shutdown();
        ProcessedCompilationUnits.shutdown();
        CompilationUnitStates.shutdown();
        CommentDeltaPatcher.shutdown();
        CompilationUnitPatcher.shutdown();
        WorkingCopyPatcher.shutdown();
        NonPublicTypesPatcher.shutdown();
        CloseEditorPatcher.shutdown();
        PackageContentClipboard.unregisterAllFactories();
        super.shutdown();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (SRT_ENABLED_PREFERENCE_NAME.equals(property)) {
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            if (newValue instanceof Boolean && oldValue instanceof Boolean) {
                boolean newState = (Boolean)newValue;
                boolean oldState = (Boolean)oldValue;
                ArrayList arrayList = ourSRTOptionListener;
                synchronized (arrayList) {
                    ourIsSRTEnabled = newState;
                    Iterator iter = ((AbstractList)ourSRTOptionListener).iterator();
                    while (iter.hasNext()) {
                        SRTOptionListener listener = (SRTOptionListener)iter.next();
                        if (newState) {
                            listener.onSRT();
                            continue;
                        }
                        listener.offSRT();
                    }
                }
            }
        } else if ("lnk_field_prefix".equals(property)) {
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            if (newValue instanceof String && oldValue instanceof String) {
                outLinkFieldPrefix = (String)newValue;
            }
        }
    }

    public CoreException logException(Exception e) {
        CoreException coreException;
        if (e instanceof CoreException) {
            coreException = (CoreException)((Object)e);
        } else {
            Status status = new Status(4, this.getDescriptor().getUniqueIdentifier(), 0, e.getMessage(), (Throwable)e);
            coreException = new CoreException((IStatus)status);
        }
        if (JavaProviderPlugin.isLogPrintingEnabled()) {
            this.getLog().log(coreException.getStatus());
            e.printStackTrace();
            return coreException;
        }
        return null;
    }

    public static void addSRTOptionListener(SRTOptionListener listener) {
        SRTOptionListener sRTOptionListener = listener;
        synchronized (sRTOptionListener) {
            if (listener != null) {
                ourSRTOptionListener.add(listener);
                if (JavaProviderPlugin.isSRTEnabled()) {
                    listener.onSRT();
                }
            }
        }
    }

    public static void removeSRTOptionListener(SRTOptionListener listener) {
        SRTOptionListener sRTOptionListener = listener;
        synchronized (sRTOptionListener) {
            if (listener != null) {
                ((AbstractCollection)ourSRTOptionListener).remove(listener);
            }
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        return ourWorkpacePreferenceStore;
    }

    public static boolean isSRTEnabled() {
        return ourIsSRTEnabled;
    }

    public static boolean isRefactorDefaultNames() {
        return ourWorkpacePreferenceStore.getBoolean(REFACTOR_DEFAULT_NAMES);
    }

    public static String getLinkFieldPrefix() {
        return outLinkFieldPrefix;
    }

    public static boolean isImportOptimizationEnabled() {
        boolean isEnabled = ourWorkpacePreferenceStore.getBoolean(OPTIMIZE_IMPORT_PREFERENCE_NAME);
        return isEnabled;
    }

    public static boolean isRecognizeProperties() {
        return ourWorkpacePreferenceStore.getBoolean(RECOGNIZE_PROPERTIES);
    }

    public static boolean isHidePropertiesParticipants() {
        return ourWorkpacePreferenceStore.getBoolean(HIDE_PROPERTIES_PARTICIPANTS);
    }

    public static boolean isShowAllAttributes() {
        String value = ourWorkpacePreferenceStore.getString("show_as_attribute");
        return ALL_VALUE.equals(value);
    }

    public static boolean isShowNoneAttributes() {
        String value = ourWorkpacePreferenceStore.getString("show_as_attribute");
        return NONE_VALUE.equals(value);
    }

    public static boolean isShowPrefixedAttributes() {
        String value = ourWorkpacePreferenceStore.getString("show_as_attribute");
        return AUTOMATIC_VALUE.equals(value);
    }

    public static boolean isDeleteAttributes() {
        boolean isEnabled = ourWorkpacePreferenceStore.getBoolean(DELETE_ATTRIBUTE_PREFERENCE_NAME);
        return isEnabled;
    }

    public static boolean isUpdateExtendsList() {
        boolean isEnabled = ourWorkpacePreferenceStore.getBoolean(UPDATE_EXTENDS_PREFERENCE_NAME);
        return isEnabled;
    }

    public static boolean isSaveResources() {
        boolean isEnabled = ourWorkpacePreferenceStore.getBoolean(SAVE_RESOURCES_PREFERENCE_NAME);
        return isEnabled;
    }

    public static boolean isLogPrintingEnabled() {
        if (myIsLogPrintingEnabled == null) {
            boolean flag = JavaProviderPlugin.isRuntimeApplicationOptionEnabled(LOG_PRINTING) || JavaProviderPlugin.isRuntimeWorkbenchOptionEnabled(LOG_PRINTING);
            myIsLogPrintingEnabled = new Boolean(flag);
        }
        return myIsLogPrintingEnabled;
    }

    public static boolean isJDTDumpEnabled() {
        if (myIsJDTDumpEnabled == null) {
            boolean flag = JavaProviderPlugin.isRuntimeApplicationOptionEnabled(JDT_DELTA_DUMP) || JavaProviderPlugin.isRuntimeWorkbenchOptionEnabled(JDT_DELTA_DUMP);
            myIsJDTDumpEnabled = new Boolean(flag);
        }
        return myIsJDTDumpEnabled;
    }

    public static boolean isProviderDumpEnabled() {
        if (myIsProviderDumpEnabled == null) {
            boolean flag = JavaProviderPlugin.isRuntimeApplicationOptionEnabled(PROVIDER_DELTA_DUMP) || JavaProviderPlugin.isRuntimeWorkbenchOptionEnabled(PROVIDER_DELTA_DUMP);
            myIsProviderDumpEnabled = new Boolean(flag);
        }
        return myIsProviderDumpEnabled;
    }

    private static boolean isRuntimeApplicationOptionEnabled(String optionName) {
        String optionValue = Messages.getString(optionName);
        if (optionValue != null) {
            return Boolean.valueOf(optionValue);
        }
        return false;
    }

    private static boolean isRuntimeWorkbenchOptionEnabled(String optionName) {
        String key = JavaProviderPlugin.getDefault().getDescriptor().getUniqueIdentifier() + "/debug/" + optionName;
        String optionValue = Platform.getDebugOption((String)key);
        if (optionValue != null) {
            return Boolean.valueOf(optionValue);
        }
        return false;
    }

    static {
        ourWorkpacePreferenceStore = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
        EOL = System.getProperty("line.separator");
    }
}

