/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.GenericParentProvider;
import com.tssap.selena.internal.core.providers.java.IgnorePreferences;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class JavaPackageProvider
extends GenericParentProvider
implements ChildrenProvider {
    public void registered(Model model) {
        super.registered(model);
        IgnorePreferences.initIgnorePreference(this.myModelUniqueName);
    }

    public void unregistered(Model model) {
        IgnorePreferences.clearIgnorePreference(this.myModelUniqueName);
        super.unregistered(model);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return NameUtil.isJarPackageUniqueName(uniqueName) || NameUtil.isRefPackageUniqueName(uniqueName) || NameUtil.isRootUniqueName(uniqueName);
    }

    public UniqueNameEnumeration children(Entity parent) {
        HashSet<UniqueName> subPackages = new HashSet<UniqueName>();
        UniqueName uniqueName = parent.getUniqueName();
        int rootKing = NameUtil.getRootKind(uniqueName.getLocation());
        try {
            if (NameUtil.isJarPackageUniqueName(uniqueName) || NameUtil.isRefPackageUniqueName(uniqueName)) {
                IPackageFragmentRoot[] allPackageFragmentRoots = JDTUtil.getPackageFragmentRoots(this.myJavaProject, rootKing);
                int i = 0;
                while (i < allPackageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = allPackageFragmentRoots[i];
                    IJavaElement[] javaElements = packageFragmentRoot.getChildren();
                    int j = 0;
                    while (j < javaElements.length) {
                        IPackageFragment packageFragment = (IPackageFragment)javaElements[j];
                        String packageName = packageFragment.getElementName();
                        if (packageName.length() != 0 && !IgnorePreferences.ignore(this.myModelUniqueName, packageName)) {
                            UniqueName subPackageUniqueName;
                            UniqueName uniqueName2 = subPackageUniqueName = rootKing == 2 ? NameUtil.getJarPackageUniqueName(packageFragment) : NameUtil.getRefPackageUniqueName(packageFragment);
                            if (this.isSubPackage(uniqueName, subPackageUniqueName)) {
                                if (!this.myElementsCache.hasPackages(subPackageUniqueName, packageFragment)) {
                                    this.myElementsCache.putPackage(subPackageUniqueName, packageFragment);
                                }
                                subPackages.add(subPackageUniqueName);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(subPackages));
            }
            if (NameUtil.isRootUniqueName(uniqueName)) {
                IPackageFragmentRoot[] allPackageFragmentRoots = JDTUtil.getPackageFragmentRoots(this.myJavaProject, rootKing);
                int i = 0;
                while (i < allPackageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = allPackageFragmentRoots[i];
                    IJavaElement[] javaElements = packageFragmentRoot.getChildren();
                    int j = 0;
                    while (j < javaElements.length) {
                        IPackageFragment packageFragment = (IPackageFragment)javaElements[j];
                        String packageName = packageFragment.getElementName();
                        if (packageName.indexOf(".") == -1 && packageName.length() > 0 && !IgnorePreferences.ignore(this.myModelUniqueName, packageName)) {
                            UniqueName subPackageUniqueName;
                            UniqueName uniqueName3 = subPackageUniqueName = rootKing == 2 ? NameUtil.getJarPackageUniqueName(packageFragment) : NameUtil.getRefPackageUniqueName(packageFragment);
                            if (!this.myElementsCache.hasPackages(subPackageUniqueName, packageFragment)) {
                                this.myElementsCache.putPackage(subPackageUniqueName, packageFragment);
                            }
                            subPackages.add(subPackageUniqueName);
                        }
                        ++j;
                    }
                    ++i;
                }
                return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(subPackages));
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return EmptyEnumeration.getUniqueNameEnumeration();
    }

    private boolean isSubPackage(UniqueName packageUniqueName, UniqueName subPackageUniqueName) {
        if (subPackageUniqueName != null) {
            int dot = subPackageUniqueName.getName().lastIndexOf(".");
            String subPackageName = dot == -1 ? "" : subPackageUniqueName.getName().substring(0, dot);
            return subPackageName.equals(packageUniqueName.getName());
        }
        return false;
    }
}

