/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.swt.widgets.Display;

public class JDTUtil {
    public static IPackageFragmentRoot[] getPackageFragmentRoots(IJavaProject javaProject, int kind) {
        try {
            String projectName = javaProject.getElementName();
            ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < allPackageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = allPackageFragmentRoots[i];
                boolean isRefElement = JDTUtil.isRefElement(projectName, packageFragmentRoot);
                if (packageFragmentRoot.getKind() == kind && !isRefElement) {
                    list.add(packageFragmentRoot);
                } else if (kind == 3 && isRefElement) {
                    list.add(packageFragmentRoot);
                }
                ++i;
            }
            return list.toArray(new IPackageFragmentRoot[list.size()]);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return new IPackageFragmentRoot[0];
        }
    }

    private static boolean isRefElement(String projectName, IPackageFragmentRoot packageFragmentRoot) {
        return !packageFragmentRoot.getJavaProject().getElementName().equals(projectName);
    }

    public static IPackageFragment getPackageFragment(IJavaElement element) {
        while (!(element instanceof IPackageFragment) && element != null) {
            element = element.getParent();
        }
        if (element instanceof IPackageFragment) {
            return (IPackageFragment)element;
        }
        return null;
    }

    public static IDOMCompilationUnit getCompilationUnit(IDOMNode domNode) {
        while (!(domNode instanceof IDOMCompilationUnit) && domNode != null) {
            domNode = domNode.getParent();
        }
        if (domNode instanceof IDOMCompilationUnit) {
            return (IDOMCompilationUnit)domNode;
        }
        return null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement element) {
        while (!(element instanceof ICompilationUnit) && element != null) {
            element = element.getParent();
        }
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        while (!(element instanceof IPackageFragmentRoot) && element != null) {
            element = element.getParent();
        }
        if (element instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)element;
        }
        return null;
    }

    public static IPackageFragment createReadWritePackageFragment(IPackageFragmentRoot packageFragmentRoot, String parentQualifiedName, String nameTemplate) {
        String qualifiedName;
        int unusedNamePostfix = 1;
        IPackageFragment packageFragment = null;
        do {
            qualifiedName = "".equals(parentQualifiedName) ? nameTemplate + unusedNamePostfix : parentQualifiedName + "." + nameTemplate + unusedNamePostfix;
            packageFragment = packageFragmentRoot.getPackageFragment(qualifiedName);
            ++unusedNamePostfix;
        } while (packageFragment != null && packageFragment.exists());
        try {
            return packageFragmentRoot.createPackageFragment(qualifiedName, true, null);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public static IPackageFragmentRoot getReadWritePackageFragmentRoot(IJavaProject javaProject, String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < allPackageFragmentRoots.length) {
                IPackageFragmentRoot packageFragmentRoot = allPackageFragmentRoots[i];
                IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(qualifiedName);
                if (packageFragment.exists() && !packageFragmentRoot.isReadOnly()) {
                    return packageFragmentRoot;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < allPackageFragmentRoots.length) {
                if (!allPackageFragmentRoots[i2].isReadOnly()) {
                    return allPackageFragmentRoots[i2];
                }
                ++i2;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public static void delete(final IType type) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit((IJavaElement)type);
                try {
                    if (compilationUnit != null) {
                        ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
                        type.delete(true, null);
                        if (compilationUnit.getTypes().length == 0) {
                            if (originalCompilationUnit != null) {
                                EditorUtil.closeEditor((IJavaElement)compilationUnit, false);
                                originalCompilationUnit.delete(true, NullMonitor.getSharedInstance());
                            } else {
                                compilationUnit.delete(true, NullMonitor.getSharedInstance());
                            }
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                }
            }
        });
    }

    public static IType[] getAllTypes(IJavaProject javaProject, IPackageFragment packageFragment, boolean compiled) {
        try {
            IType type;
            ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
            ArrayList<IType> classes = new ArrayList<IType>();
            int i = 0;
            while (i < compilationUnits.length) {
                IType[] types = compilationUnits[i].getTypes();
                int j = 0;
                while (j < types.length) {
                    type = types[j];
                    classes.add(type);
                    ++j;
                }
                ++i;
            }
            IClassFile[] classFiles = packageFragment.getClassFiles();
            int i2 = 0;
            while (i2 < classFiles.length) {
                type = classFiles[i2].getType();
                UniqueName uniqueName = NameUtil.getTypeUniqueName(javaProject, type);
                if (!NameUtil.isInnerElement(uniqueName)) {
                    classes.add(type);
                }
                ++i2;
            }
            IType[] types = new IType[classes.size()];
            classes.toArray(types);
            return types;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return new IType[0];
        }
    }

    public static String getRefType(IField field) {
        try {
            if (field.exists()) {
                String typeSignature = field.getTypeSignature();
                typeSignature = typeSignature.replace('$', '#');
                typeSignature = Signature.toString((String)typeSignature);
                typeSignature = typeSignature.replace('#', '$');
                return typeSignature;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public static boolean isArrayType(IField field) {
        return false;
    }

    public static String getRefType(IMethod method) {
        try {
            String typeSignature = method.getReturnType();
            return Signature.toString((String)typeSignature);
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }
}

