/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.preferences.PreferencesPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

public class IgnorePreferences {
    private static final IPreferenceStore ourWorkpacePreferenceStore = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    public static final String IGNORED_FOLDERS_PREFERENCE_NAME = "ignored_folders";
    private static final String DELIMITER = ",";
    private static HashMap ourIgnorePreferences = new HashMap();

    public static boolean ignore(UniqueName modelUniqueName, String name) {
        ArrayList ignorePreference = (ArrayList)ourIgnorePreferences.get(modelUniqueName);
        if (ignorePreference != null) {
            int dot = name.lastIndexOf(".");
            name = dot == -1 ? name : name.substring(dot + 1);
            return ignorePreference.contains(name);
        }
        return false;
    }

    public static ArrayList initIgnorePreference(UniqueName modelUniqueName) {
        if (modelUniqueName != null) {
            ArrayList<String> ignorePreference = (ArrayList<String>)ourIgnorePreferences.get(modelUniqueName);
            if (ignorePreference == null) {
                ignorePreference = new ArrayList<String>();
                String[] preferences = IgnorePreferences.getPreferences(modelUniqueName, IGNORED_FOLDERS_PREFERENCE_NAME);
                int i = 0;
                while (i < preferences.length) {
                    ignorePreference.add(preferences[i]);
                    ++i;
                }
                ourIgnorePreferences.put(modelUniqueName, ignorePreference);
            }
            return ignorePreference;
        }
        return null;
    }

    public static void clearIgnorePreference(UniqueName modelUniqueName) {
        if (modelUniqueName != null) {
            ourIgnorePreferences.remove(modelUniqueName);
        }
    }

    private static String[] getPreferences(UniqueName modelUniqueName, String name) {
        Vector<String> values = new Vector<String>();
        String value = ourWorkpacePreferenceStore.getString(name);
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, DELIMITER);
            while (st.hasMoreElements()) {
                String s = st.nextToken().trim();
                if (values.contains(s)) continue;
                values.add(s);
            }
        }
        String[] sVals = new String[values.size()];
        return values.toArray(sVals);
    }
}

