/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.Clipboard;
import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.CommentUtil;
import com.tssap.selena.internal.core.providers.java.DefaultNameUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.GenericDeleteProvider;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodCreateParam;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.internal.core.providers.java.SiblingUtil;
import com.tssap.selena.internal.core.providers.java.WorkingCopyUtil;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class GenericExistenceProvider
extends GenericDeleteProvider
implements EntityExistenceProvider {
    public boolean exists(UniqueName uniqueName) {
        if (NameUtil.isJavaElementUniqueName(uniqueName, false) || NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            return !GenericDeleteProvider.isDeleted(this.myJavaProject, this.myModelUniqueName, uniqueName);
        }
        if (NameUtil.isRootUniqueName(uniqueName)) {
            return true;
        }
        if (NameUtil.isJavaElementUniqueName(uniqueName, true) || NameUtil.isJavaLinkElementUniqueName(uniqueName, true)) {
            return Clipboard.hasClipboardElement(uniqueName);
        }
        return false;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        if (this.myModelUniqueName.equals(parent.getUniqueName())) {
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.canCreateTypeUniqueName(parent, shapeType, template);
            }
        } else if (NameUtil.isPackageUniqueName(parentUniqueName)) {
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.canCreateTypeUniqueName(parent, shapeType, template);
            }
        } else if (NameUtil.isTypeUniqueName(parentUniqueName)) {
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.canCreateTypeUniqueName(parent, shapeType, template);
            }
            if ("Attribute".equals(shapeType)) {
                return this.canCreateFieldUniqueName(parent, shapeType, template);
            }
            if ("Operation".equals(shapeType)) {
                return this.canCreateMethodUniqueName(parent, shapeType, template);
            }
            if ("Association Link".equals(shapeType)) {
                if (!parent.hasProperty("$readOnly") && template != null) {
                    Entity supplierElement;
                    ElementEnumeration supplierEnum = template.participants("Supplier");
                    if (supplierEnum.hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                        if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                            return false;
                        }
                        String metaclass = supplierElement.getPropertyValue("$metaclass");
                        return ("Class".equals(metaclass) || "Interface".equals(metaclass)) && !supplierElement.hasProperty("$private") && this.canCreateFieldUniqueName(parent, "Attribute", template);
                    }
                    return true;
                }
            } else {
                if ("Generalization Link".equals(shapeType)) {
                    Entity supplierElement;
                    ElementEnumeration supplierEnum;
                    if (template != null && (supplierEnum = template.participants("Supplier")).hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                        if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                            return false;
                        }
                        String refType = NameUtil.normalizeName(supplierElement.getPropertyValue("$fullName"));
                        String parentMetaclass = parent.getPropertyValue("$metaclass");
                        String supplierMetaclass = supplierElement.getPropertyValue("$metaclass");
                        boolean isParentInterface = parent.hasProperty("$interface");
                        boolean isSupplierInterface = supplierElement.hasProperty("$interface");
                        if ("Class".equals(parentMetaclass) && "Class".equals(supplierMetaclass)) {
                            if (supplierElement.hasProperty("$private")) {
                                return false;
                            }
                            if (!isParentInterface && !isSupplierInterface) {
                                return parent.canSetPropertyValue("$extends", refType);
                            }
                            if (isParentInterface && isSupplierInterface) {
                                return parent.canAddProperty("$extends", refType);
                            }
                            return parent.canAddProperty("$implements", refType);
                        }
                    }
                    return !parent.hasProperty("$readOnly");
                }
                if ("Implementation Link".equals(shapeType)) {
                    Entity supplierElement;
                    ElementEnumeration supplierEnum;
                    if (template != null && (supplierEnum = template.participants("Supplier")).hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                        if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                            return false;
                        }
                        String refType = NameUtil.normalizeName(supplierElement.getPropertyValue("$fullName"));
                        String parentMetaclass = parent.getPropertyValue("$metaclass");
                        String supplierMetaclass = supplierElement.getPropertyValue("$metaclass");
                        boolean isParentInterface = parent.hasProperty("$interface");
                        boolean isSupplierInterface = supplierElement.hasProperty("$interface");
                        if ("Class".equals(parentMetaclass) && "Class".equals(supplierMetaclass)) {
                            if (supplierElement.hasProperty("$private")) {
                                return false;
                            }
                            if (!isParentInterface && isSupplierInterface) {
                                return parent.canAddProperty("$implements", refType);
                            }
                        }
                    }
                    return !parent.hasProperty("$readOnly");
                }
                if ("Dependency Link".equals(shapeType) && !parent.hasProperty("$readOnly")) {
                    return this.canCreateDependencyLink(parent, shapeType, template);
                }
            }
        }
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        long startTime = System.currentTimeMillis();
        UniqueName parentUniqueName = parent.getUniqueName();
        if (this.myModelUniqueName.equals(parent.getUniqueName())) {
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.createTypeUniqueName(parent, shapeType, template);
            }
        } else if (NameUtil.isPackageUniqueName(parentUniqueName)) {
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.createTypeUniqueName(parent, shapeType, template);
            }
        } else if (NameUtil.isTypeUniqueName(parentUniqueName)) {
            IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
            WorkingCopyUtil.initWorkingCopy(this.myJavaProject, javaElement);
            if ("Class".equals(shapeType) || "Interface".equals(shapeType)) {
                return this.createTypeUniqueName(parent, shapeType, template);
            }
            if ("Attribute".equals(shapeType)) {
                UniqueName result = this.createFieldUniqueName(parent, shapeType, template);
                System.err.println("creation of attribute in java provider took : " + (System.currentTimeMillis() - startTime));
                return result;
            }
            if ("Operation".equals(shapeType)) {
                return this.createMethodUniqueName(parent, shapeType, template);
            }
            if ("Association Link".equals(shapeType)) {
                Entity supplierElement;
                ElementEnumeration supplierEnum;
                if (template != null && (supplierEnum = template.participants("Supplier")).hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                    if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                        return null;
                    }
                    String refType = supplierElement.getPropertyValue("$fullName");
                    if (refType != null) {
                        if (template.hasProperty("$type")) {
                            template.setPropertyValue("@associates", refType);
                        } else {
                            template.setPropertyValue("$type", refType);
                        }
                        GenericExistenceProvider.createDefaultLinkNameIfNone(template, supplierElement);
                        UniqueName uniqueName = this.createFieldUniqueName(parent, shapeType, template);
                        Entity attr = this.myModel.findEntity(uniqueName);
                        if (attr != null) {
                            IField field = (IField)ElementUtil.getJavaElement(this.myModelUniqueName, attr.getUniqueName());
                            return NameUtil.getAssociationNodeUniqueName(this.myJavaProject, field);
                        }
                    }
                }
            } else if ("Generalization Link".equals(shapeType)) {
                Entity supplierElement;
                ElementEnumeration supplierEnum;
                if (template != null && (supplierEnum = template.participants("Supplier")).hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                    if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                        return null;
                    }
                    String refType = NameUtil.normalizeName(supplierElement.getPropertyValue("$fullName"));
                    IType type = (IType)ElementUtil.getJavaElement(this.myModelUniqueName, parent.getUniqueName());
                    String parentMetaclass = parent.getPropertyValue("$metaclass");
                    String supplierMetaclass = supplierElement.getPropertyValue("$metaclass");
                    boolean isParentInterface = parent.hasProperty("$interface");
                    boolean isSupplierInterface = supplierElement.hasProperty("$interface");
                    if ("Class".equals(parentMetaclass) && "Class".equals(supplierMetaclass)) {
                        if (!isParentInterface && !isSupplierInterface) {
                            parent.setPropertyValue("$extends", refType);
                            return NameUtil.getGeneralizationNodeUniqueName(this.myJavaProject, type, refType);
                        }
                        if (isParentInterface && isSupplierInterface) {
                            parent.addProperty("$extends", refType);
                            return NameUtil.getGeneralizationNodeUniqueName(this.myJavaProject, type, refType);
                        }
                        parent.addProperty("$implements", refType);
                        return NameUtil.getImplementaionNodeUniqueName(this.myJavaProject, type, refType);
                    }
                }
            } else if ("Implementation Link".equals(shapeType)) {
                Entity supplierElement;
                ElementEnumeration supplierEnum;
                if (template != null && (supplierEnum = template.participants("Supplier")).hasMoreElements() && (supplierElement = (Entity)supplierEnum.next()) != null) {
                    if (!NameUtil.isJavaElementUniqueName(supplierElement.getUniqueName(), false)) {
                        return null;
                    }
                    String refType = NameUtil.normalizeName(supplierElement.getPropertyValue("$fullName"));
                    String parentMetaclass = parent.getPropertyValue("$metaclass");
                    String supplierMetaclass = supplierElement.getPropertyValue("$metaclass");
                    boolean isParentInterface = parent.hasProperty("$interface");
                    boolean isSupplierInterface = supplierElement.hasProperty("$interface");
                    if ("Class".equals(parentMetaclass) && "Class".equals(supplierMetaclass) && !isParentInterface && isSupplierInterface) {
                        parent.addProperty("$implements", refType);
                        IType type = (IType)ElementUtil.getJavaElement(this.myModelUniqueName, parent.getUniqueName());
                        return NameUtil.getImplementaionNodeUniqueName(this.myJavaProject, type, refType);
                    }
                }
            } else if ("Dependency Link".equals(shapeType)) {
                return this.createDependencyLink(parent, shapeType, template);
            }
        }
        return null;
    }

    private boolean canCreateTypeUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        if (NameUtil.isTypeUniqueName(parentUniqueName)) {
            IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
            if (javaElement instanceof IType) {
                IType type = (IType)javaElement;
                return ElementUtil.isWritableElement((IJavaElement)type);
            }
            return false;
        }
        if (NameUtil.isPackageUniqueName(parentUniqueName) || this.myModelUniqueName.equals(parentUniqueName)) {
            return ElementUtil.isWritablePackage(this.myModelUniqueName, parentUniqueName);
        }
        return false;
    }

    private UniqueName createTypeUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        String defaultTypeName = template == null ? null : template.getPropertyValue("$name");
        boolean clazz = "Class".equals(shapeType);
        try {
            String comment = "";
            if (NameUtil.isTypeUniqueName(parentUniqueName)) {
                if (defaultTypeName == null) {
                    String string = defaultTypeName = "Class".equals(shapeType) ? DefaultNameUtil.getDefaultInnerClassName() : DefaultNameUtil.getDefaultInnerInterfaceName();
                }
                if (javaElement instanceof IType) {
                    IType type = (IType)javaElement;
                    String name = CodeUtil.getUnusedTypeName(this.myJavaProject, (IJavaElement)type, defaultTypeName, true);
                    if (name == null) {
                        return null;
                    }
                    String body = CodeUtil.getDefaultTypeBody(name, comment, clazz, true, type.isInterface()) + JavaProviderPlugin.EOL;
                    int memberKing = type.isClass() ? 3 : 4;
                    int visibilityKing = 0;
                    IJavaElement siblingElement = SiblingUtil.getSibling(type, memberKing, visibilityKing);
                    type = type.createType(body, siblingElement, true, null);
                    comment = CommentUtil.createTypeComment(type);
                    this.setComment((IMember)type, comment);
                    return NameUtil.getTypeUniqueName(this.myJavaProject, type);
                }
            } else if (NameUtil.isPackageUniqueName(parentUniqueName) || this.myModelUniqueName.equals(parentUniqueName)) {
                String name;
                IPackageFragment[] packageFragments = ElementUtil.getPackageFragmentsByUniqueName(this.myJavaProject, parentUniqueName);
                if (packageFragments == null || packageFragments.length == 0) {
                    return null;
                }
                IPackageFragment packageFragment = packageFragments[0];
                if (defaultTypeName == null) {
                    String string = defaultTypeName = "Class".equals(shapeType) ? DefaultNameUtil.getDefaultClassName() : DefaultNameUtil.getDefaultInterfaceName();
                }
                if ((name = CodeUtil.getUnusedTypeName(this.myJavaProject, (IJavaElement)packageFragment, defaultTypeName, false)) == null) {
                    return null;
                }
                String body = CodeUtil.getDefaultTypeBody(name, comment, clazz, false, false);
                body = CodeUtil.getDefaultCompilationUnitBody(packageFragment, comment, body);
                ICompilationUnit compilationUnit = packageFragment.createCompilationUnit(name + ".java", body, true, null);
                IType type = compilationUnit.getType(name);
                comment = CommentUtil.createTypeComment(type);
                this.setComment((IMember)type, comment);
                return NameUtil.getTypeUniqueName(this.myJavaProject, type);
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private boolean canCreateFieldUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            return ElementUtil.isWritableElement((IJavaElement)type);
        }
        return false;
    }

    private UniqueName createFieldUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        try {
            if (javaElement instanceof IType) {
                String comment;
                String body;
                String name;
                IType type = (IType)javaElement;
                if (template == null) {
                    template = this.myModel.createEntityTemplate();
                    template.setPropertyValue("$private", Boolean.TRUE.toString());
                }
                if (template.hasProperty("$private") && type.isInterface()) {
                    template.setPropertyValue("$public", Boolean.TRUE.toString());
                }
                if ((name = template.getPropertyValue("$name")) != null) {
                    if (name.lastIndexOf(".") > -1) {
                        name = name.substring(name.lastIndexOf(".") + ".".length());
                    }
                    name = CodeUtil.getUnusedFieldName(type, name);
                } else {
                    name = CodeUtil.getUnusedFieldName(type, DefaultNameUtil.getDefaultFieldName());
                }
                if (name == null) {
                    return null;
                }
                template.setPropertyValue("$name", name);
                if (!template.hasProperty("$type")) {
                    template.setPropertyValue("$type", "int");
                }
                String oldType = template.getPropertyValue("$type");
                String newType = null;
                if (ImportStatementSupport.isImportStatamentSupported()) {
                    newType = oldType;
                    String[][] resolvedNames = type.resolveType(newType);
                    if (resolvedNames != null) {
                        newType = resolvedNames[0][1];
                    }
                    template.setPropertyValue("$type", newType);
                }
                if ((body = CodeUtil.getDefaultFieldBody(template, comment = "", type.isClass()) + JavaProviderPlugin.EOL) != null) {
                    int memberKing = 0;
                    int visibilityKing = 0;
                    IJavaElement siblingElement = SiblingUtil.getSibling(type, memberKing, visibilityKing);
                    long startTime = System.currentTimeMillis();
                    IField field = type.createField(body, siblingElement, true, null);
                    System.err.println("JDT creation of field took : " + (System.currentTimeMillis() - startTime));
                    if (ImportStatementSupport.isImportStatamentSupported()) {
                        ImportStatementSupport.addImportStatament(this.myModel, javaElement, oldType);
                    }
                    this.setComment((IMember)field, comment);
                    return NameUtil.getFieldUniqueName(this.myJavaProject, field);
                }
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    private boolean canCreateMethodUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            return ElementUtil.isWritableElement((IJavaElement)type);
        }
        return false;
    }

    private UniqueName createMethodUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName parentUniqueName = parent.getUniqueName();
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            try {
                String comment = "";
                IType type = (IType)javaElement;
                String body = null;
                int memberKing = 2;
                if (template != null && template.hasProperty("$name") && template.hasProperty("$constructor")) {
                    String[][] parameters = MethodCreateParam.getParameters(template);
                    body = CodeUtil.getDefaultConstructorBody(type, parameters, comment, template.hasProperty("useParametersFromTemplate"));
                    memberKing = 1;
                } else {
                    String name;
                    MethodCreateParam methodCreation = template == null ? new MethodCreateParam() : MethodCreateParam.createFrom(template);
                    String namePrefix = methodCreation.getMethodName();
                    if (namePrefix.lastIndexOf(".") > -1) {
                        namePrefix = namePrefix.substring(namePrefix.lastIndexOf(".") + ".".length());
                    }
                    if (namePrefix.lastIndexOf("$") > -1) {
                        namePrefix = namePrefix.substring(namePrefix.lastIndexOf("$") + 1);
                    }
                    if ((name = CodeUtil.getUnusedMethodName(type, namePrefix, methodCreation.getSignature())) == null) {
                        return null;
                    }
                    methodCreation.setMethodName(name);
                    body = CodeUtil.getDefaultMethodBody(methodCreation, type.isInterface());
                }
                if (body != null) {
                    body = body + JavaProviderPlugin.EOL;
                    int visibilityKing = 0;
                    IJavaElement siblingElement = SiblingUtil.getSibling(type, memberKing, visibilityKing);
                    IMethod method = type.createMethod(body, siblingElement, true, null);
                    comment = CommentUtil.createMethodComment(method);
                    this.setComment((IMember)method, comment);
                    return NameUtil.getMethodUniqueName(this.myJavaProject, method);
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return null;
    }

    private boolean canCreateDependencyLink(Entity parent, String shapeType, Entity template) {
        if (!"Dependency Link".equals(shapeType)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement((Element)parent);
        if (!(javaElement instanceof IType)) {
            return false;
        }
        if (!ElementUtil.isWritableElement(javaElement)) {
            return false;
        }
        if (template == null) {
            return true;
        }
        ElementEnumeration suppliers = template.participants("Supplier");
        if (suppliers == null || !suppliers.hasMoreElements()) {
            return true;
        }
        return NameUtil.isTypeUniqueName(suppliers.next().getUniqueName());
    }

    private UniqueName createDependencyLink(Entity parent, String shapeType, Entity template) {
        if (template == null) {
            return null;
        }
        ElementEnumeration suppliers = template.participants("Supplier");
        if (suppliers == null || !suppliers.hasMoreElements()) {
            return null;
        }
        Element destination = template.participants("Supplier").next();
        String destTypeName = NameUtil.normalizeName(NameUtil.getTypeQualifiedName(destination.getUniqueName()));
        String baseLinkName = template.getPropertyValue("$name");
        if (baseLinkName == null) {
            baseLinkName = shapeType;
        }
        baseLinkName = baseLinkName.replace(' ', '_');
        IType type = (IType)ElementUtil.getJavaElement((Element)parent);
        IDependencyLinkParser designLinkParser = DependencyLinkParserCache.get(this.myJavaProject, type);
        String newName = GenericExistenceProvider.findNotUsedName(designLinkParser, baseLinkName);
        designLinkParser.addDependencyLink(newName, destTypeName);
        return NameUtil.getDependencyNodeUniqueName(type, newName);
    }

    private static String findNotUsedName(IDependencyLinkParser parser, String baseName) {
        HashSet<String> usedNames = new HashSet<String>();
        Enumeration links = parser.getDependencyLinks();
        while (links.hasMoreElements()) {
            IDependencyLink curLink = (IDependencyLink)links.nextElement();
            String curName = curLink.getName();
            if (curName == null || !curName.startsWith(baseName)) continue;
            usedNames.add(curName);
        }
        int curSuffix = 1;
        while (usedNames.contains(baseName + curSuffix)) {
            ++curSuffix;
        }
        return baseName + curSuffix;
    }

    private void setComment(IMember member, String comment) {
        try {
            ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit((IJavaElement)member);
            int offSet = member.getSourceRange().getOffset();
            int length = member.getSourceRange().getLength();
            if (compilationUnit != null) {
                int nesting;
                IBuffer buffer = compilationUnit.getBuffer();
                String contents = buffer.getContents();
                String memberContents = contents.substring(offSet, offSet + length);
                memberContents = comment + memberContents;
                String newMemberContents = Formatter.formatBody(memberContents, nesting = Formatter.getNesting(member));
                memberContents = newMemberContents != null ? newMemberContents : memberContents;
                contents = contents.substring(0, offSet) + memberContents + contents.substring(offSet + length);
                buffer.setContents(contents);
                buffer.save(NullMonitor.getSharedInstance(), true);
                compilationUnit.makeConsistent(NullMonitor.getSharedInstance());
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private static void createDefaultLinkNameIfNone(Entity template, Entity supplierElement) {
        if (template.hasProperty("$name")) {
            return;
        }
        String name = JavaProviderPlugin.getLinkFieldPrefix() + supplierElement.getPropertyValue("$name");
        template.setPropertyValue("$name", name);
    }
}

