/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.Clipboard;
import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ExtendsListUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.LinkDeleteUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.internal.core.providers.java.property.JavaCommentsParsersCache;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeleteProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class GenericDeleteProvider
extends ModelAwareProvider
implements DeleteProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (uniqueName instanceof CopyUniqueName) {
            return NameUtil.isJavaElementUniqueName(uniqueName, true) || NameUtil.isJavaLinkElementUniqueName(uniqueName, true);
        }
        return true;
    }

    public boolean canDelete(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (uniqueName instanceof CopyUniqueName) {
            return true;
        }
        if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
            IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName);
            if (javaElement != null) {
                return ElementUtil.isWritableElement(javaElement);
            }
            return true;
        }
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName = NameUtil.getParentUniqueName(this.myModelUniqueName, uniqueName));
            if (javaElement != null) {
                return ElementUtil.isWritableElement(javaElement);
            }
            return true;
        }
        return false;
    }

    public void delete(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        try {
            if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
                IDependencyLink dependencyLink;
                if (NameUtil.isAssociationUniqueName(uniqueName)) {
                    IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName = NameUtil.getFUINFromAUIN(uniqueName));
                    if (javaElement instanceof IField) {
                        GenericDeleteProvider.deletePreservingDesignLinks((IMember)javaElement);
                    }
                } else if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                    String typeName = NameUtil.getRefTNFromLinkUIN(uniqueName);
                    IJavaElement type = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName = NameUtil.getTUINFromGUIN(uniqueName));
                    if (type instanceof IType) {
                        ExtendsListUtil.removeExtends(this.myJavaProject, (IType)type, typeName);
                    }
                } else if (NameUtil.isImplementationUniqueName(uniqueName)) {
                    String typeName = NameUtil.getRefTNFromLinkUIN(uniqueName);
                    IJavaElement type = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName = NameUtil.getTUINFromIUIN(uniqueName));
                    if (type instanceof IType) {
                        ExtendsListUtil.removeExtends(this.myJavaProject, (IType)type, typeName);
                    }
                } else if (NameUtil.isDependencyUniqueName(uniqueName) && (dependencyLink = this.getDependencyLink(element)) != null && !dependencyLink.isReadOnly()) {
                    dependencyLink.delete();
                }
                return;
            }
            if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
                IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName);
                if (javaElement instanceof ISourceManipulation) {
                    IProgressMonitor deleter = null;
                    ISourceManipulation sourceManipulation = (ISourceManipulation)javaElement;
                    if (javaElement instanceof IType && javaElement.getParent() instanceof ICompilationUnit) {
                        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement.getParent();
                        IType[] types = compilationUnit.getTypes();
                        IType type = null;
                        if (types.length == 1) {
                            type = types[0];
                            LinkDeleteUtil.deleteLinks(this.myJavaProject, type);
                            ICompilationUnit originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement();
                            if (originalCompilationUnit != null) {
                                originalCompilationUnit.delete(true, deleter);
                            } else {
                                compilationUnit.delete(true, deleter);
                            }
                        } else {
                            type = (IType)sourceManipulation;
                            LinkDeleteUtil.deleteLinks(this.myJavaProject, type);
                            sourceManipulation.delete(true, deleter);
                        }
                    } else if (!(javaElement instanceof IPackageFragment)) {
                        if (javaElement instanceof IMember) {
                            GenericDeleteProvider.deletePreservingDesignLinks((IMember)javaElement);
                        } else {
                            sourceManipulation.delete(true, deleter);
                        }
                    }
                }
            } else if (NameUtil.isJavaElementUniqueName(uniqueName, true) || NameUtil.isJavaLinkElementUniqueName(uniqueName, true)) {
                Clipboard.removeClipboardElement(uniqueName);
                return;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    public boolean isDeleted(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return GenericDeleteProvider.isDeleted(this.myJavaProject, this.myModelUniqueName, uniqueName);
    }

    public static boolean isDeleted(IJavaProject javaProject, UniqueName modelUniqueName, UniqueName uniqueName) {
        if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
            if (NameUtil.isRootUniqueName(uniqueName)) {
                return false;
            }
            IJavaElement javaElement = ElementUtil.getJavaElement(modelUniqueName, uniqueName);
            if (javaElement != null) {
                return !javaElement.exists();
            }
        } else if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            if (NameUtil.isAssociationUniqueName(uniqueName)) {
                IField field;
                IJavaElement javaElement = ElementUtil.getJavaElement(modelUniqueName, uniqueName = NameUtil.getFUINFromAUIN(uniqueName));
                if (javaElement instanceof IField && (field = (IField)javaElement).exists()) {
                    return CodeUtil.getFieldType(field) == null;
                }
            } else if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                String fullTypeName = NameUtil.getRefTNFromLinkUIN(uniqueName);
                String shortTypeName = NameUtil.getShortName(fullTypeName);
                IJavaElement javaElement = ElementUtil.getJavaElement(modelUniqueName, uniqueName = NameUtil.getTUINFromGUIN(uniqueName));
                if (javaElement instanceof IType && javaElement.exists()) {
                    IType type = (IType)javaElement;
                    try {
                        if (type.isClass()) {
                            String superclassName = type.getSuperclassName();
                            return !shortTypeName.equals(superclassName) && !fullTypeName.equals(superclassName);
                        }
                        Object[] typeNames = type.getSuperInterfaceNames();
                        return !ArrayUtil.contains(typeNames, shortTypeName) && !ArrayUtil.contains(typeNames, fullTypeName);
                    }
                    catch (JavaModelException e) {
                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                    }
                }
            } else if (NameUtil.isImplementationUniqueName(uniqueName)) {
                String fullTypeName = NameUtil.getRefTNFromLinkUIN(uniqueName);
                String shortTypeName = NameUtil.getShortName(fullTypeName);
                IJavaElement javaElement = ElementUtil.getJavaElement(modelUniqueName, uniqueName = NameUtil.getTUINFromIUIN(uniqueName));
                if (javaElement instanceof IType && javaElement.exists()) {
                    IType type = (IType)javaElement;
                    try {
                        if (type.isClass()) {
                            Object[] typeNames = type.getSuperInterfaceNames();
                            return !ArrayUtil.contains(typeNames, shortTypeName) && !ArrayUtil.contains(typeNames, fullTypeName);
                        }
                    }
                    catch (JavaModelException e) {
                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                    }
                }
            } else if (NameUtil.isDependencyUniqueName(uniqueName)) {
                String name = NameUtil.getFNFromDUIN(uniqueName);
                IJavaElement javaElement = ElementUtil.getJavaElement(modelUniqueName, uniqueName = NameUtil.getTUINFromDUIN(uniqueName));
                if (javaElement instanceof IType && javaElement.exists()) {
                    IType type = (IType)javaElement;
                    IDependencyLinkParser designLinkParser = DependencyLinkParserCache.get(javaProject, type);
                    return designLinkParser.getDependencyLink(name) == null;
                }
            }
        } else if (NameUtil.isJavaElementUniqueName(uniqueName, true) || NameUtil.isJavaLinkElementUniqueName(uniqueName, true)) {
            return Clipboard.hasClipboardElement(uniqueName);
        }
        return true;
    }

    private IDependencyLink getDependencyLink(Element element) {
        IDependencyLinkParser dependencyLinkParser = this.getDependencyLinkParser(element);
        if (dependencyLinkParser != null) {
            UniqueName uniqueName = element.getUniqueName();
            String name = NameUtil.getFNFromDUIN(uniqueName);
            IDependencyLink dependencyLink = dependencyLinkParser.getDependencyLink(name);
            return dependencyLink;
        }
        return null;
    }

    private IDependencyLinkParser getDependencyLinkParser(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        UniqueName parentUniqueName = NameUtil.getTUINFromDUIN(uniqueName);
        IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            IDependencyLinkParser designLinkParser = DependencyLinkParserCache.get(this.myJavaProject, type);
            return designLinkParser;
        }
        return null;
    }

    public static void deletePreservingDesignLinks(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return;
        }
        String sourceWithDesignLinks = member.getSource();
        if (!member.getCompilationUnit().isConsistent()) {
            member.getCompilationUnit().makeConsistent(NullMonitor.getSharedInstance());
        }
        int normalizedStartPosition = JavaCommentsParsersCache.getNormalizedSourceStart(member);
        int designLinkStartPosition = -1;
        StringBuffer preservedDesignLinkContent = null;
        if (normalizedStartPosition > 0) {
            designLinkStartPosition = member.getSourceRange().getOffset();
            String oldCUContents = member.getCompilationUnit().getSource();
            preservedDesignLinkContent = new StringBuffer(oldCUContents.length());
            preservedDesignLinkContent.append(oldCUContents.substring(0, designLinkStartPosition + normalizedStartPosition));
            preservedDesignLinkContent.append(oldCUContents.substring(designLinkStartPosition + member.getSourceRange().getLength()));
        }
        ICompilationUnit cu = member.getCompilationUnit();
        member.delete(true, NullMonitor.getSharedInstance());
        if (cu != null && preservedDesignLinkContent != null) {
            IBuffer buffer = cu.getBuffer();
            buffer.setContents(preservedDesignLinkContent.toString());
            buffer.save(NullMonitor.getSharedInstance(), true);
            cu.makeConsistent(NullMonitor.getSharedInstance());
            cu.save(NullMonitor.getSharedInstance(), true);
        }
    }
}

