/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ReferenceParticipant;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.inheritance.InheritanceUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ParticipantAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class GenImplLinkProvider
extends ModelAwareProvider
implements LinkProviderEx {
    private static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return true;
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration(this.participantRolesList(link).iterator());
    }

    public ParticipantEnumeration allParticipants(Entity link) {
        UniqueName linkUniqueName = link.getUniqueName();
        ArrayList<ParticipantAdapter> participants = new ArrayList<ParticipantAdapter>();
        Entity parent = link.getParent();
        if (parent == null) {
            return EmptyEnumeration.getParticipantEnumeration();
        }
        IJavaElement javaElement = ElementUtil.getJavaElement((Element)parent);
        if (!(javaElement instanceof IType)) {
            return EmptyEnumeration.getParticipantEnumeration();
        }
        participants.add(new ParticipantAdapter(parent.getUniqueName(), "Client"));
        IType type = (IType)javaElement;
        try {
            boolean isClass = false;
            isClass = type.isClass();
            if (!isClass && NameUtil.isGeneralizationUniqueName(linkUniqueName) || isClass && NameUtil.isImplementationUniqueName(linkUniqueName)) {
                String[] superinterfaces = type.getSuperInterfaceNames();
                if (superinterfaces.length > 0) {
                    UniqueName uniqueName = link.getUniqueName();
                    String refType = uniqueName.getParameter(0);
                    participants.add(new ReferenceParticipant("Supplier", this.myModel, type, refType));
                }
            } else if (isClass && NameUtil.isGeneralizationUniqueName(linkUniqueName)) {
                String superclass = type.getSuperclassName();
                participants.add(new ReferenceParticipant("Supplier", this.myModel, type, superclass));
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return EnumerationConverter.toParticipantEnumeration(participants.iterator());
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        if (!ArrayUtil.contains(ROLES, role)) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        UniqueName linkUniqueName = link.getUniqueName();
        Entity parent = link.getParent();
        ArrayList participants = new ArrayList();
        if (parent != null) {
            try {
                IJavaElement javaElement = ElementUtil.getJavaElement((Element)parent);
                if (javaElement instanceof IType) {
                    IType type = (IType)javaElement;
                    if (role.equals("Client")) {
                        return SingleEnumeration.createUniqueNameEnumeration((UniqueName)parent.getUniqueName());
                    }
                    if (role.equals("Supplier")) {
                        UniqueName uniqueName;
                        IJavaElement targetType;
                        String stringUniqueName;
                        String superclass;
                        boolean isClass = type.isClass();
                        if (!isClass && NameUtil.isGeneralizationUniqueName(linkUniqueName) || isClass && NameUtil.isImplementationUniqueName(linkUniqueName)) {
                            boolean targetIsClass;
                            IJavaElement targetType2;
                            UniqueName uniqueName2;
                            String refType;
                            String stringUniqueName2;
                            String[] superinterfaces = type.getSuperInterfaceNames();
                            if (superinterfaces.length > 0 && (stringUniqueName2 = TypeNameResolver.resolveType(this.myModel, type, refType = (uniqueName2 = link.getUniqueName()).getParameter(0), true)) != null && (targetType2 = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName2 = ModelAccess.createUniqueName((String)stringUniqueName2))) instanceof IType && !(targetIsClass = ((IType)targetType2).isClass())) {
                                return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uniqueName2);
                            }
                        } else if (type.isClass() && NameUtil.isGeneralizationUniqueName(linkUniqueName) && (superclass = type.getSuperclassName()) != null && (stringUniqueName = TypeNameResolver.resolveType(this.myModel, type, superclass, true)) != null && (targetType = ElementUtil.getJavaElement(this.myModelUniqueName, uniqueName = ModelAccess.createUniqueName((String)stringUniqueName))) instanceof IType && ((IType)targetType).isClass()) {
                            return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uniqueName);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(participants.iterator());
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (link == null || role == null || oldParticipant == null || newParticipant == null) {
            return false;
        }
        if (oldParticipant.equals(newParticipant)) {
            return true;
        }
        if ("Supplier".equals(role)) {
            String oldPropertyName = this.findInheritancePropertyName(link, oldParticipant);
            String newPropertyName = this.findInheritancePropertyName(link, newParticipant);
            if (oldPropertyName == null || newPropertyName == null) {
                return false;
            }
            if (oldPropertyName.equals(newPropertyName)) {
                PropertyMap subPropertyToChange = this.findCorrespondingSubProperty(link, oldParticipant, oldPropertyName);
                return subPropertyToChange != null && subPropertyToChange.canSetPropertyValue("$typeReferencedElement", newParticipant.getUniqueName().toString());
            }
            PropertyMap subPropertyToDelete = this.findCorrespondingSubProperty(link, oldParticipant, oldPropertyName);
            boolean result = subPropertyToDelete != null && subPropertyToDelete.canSetPropertyValue("$typeReferencedElement", null) && newParticipant.getPropertyValue("$fullName") != null && link.getParent().canAddProperty(newPropertyName, newParticipant.getPropertyValue("$fullName"));
            return result;
        }
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        UniqueName newUniqueName;
        Entity parent = link.getParent();
        UniqueName oldUniqueName = oldParticipant.getUniqueName();
        if (oldUniqueName.equals(newUniqueName = newParticipant.getUniqueName())) {
            return;
        }
        String oldPropertyName = this.findInheritancePropertyName(link, oldParticipant);
        String newPropertyName = this.findInheritancePropertyName(link, newParticipant);
        Entity linkParent = link.getParent();
        if (oldPropertyName.equals(newPropertyName)) {
            PropertyMap subPropertyToChange = this.findCorrespondingSubProperty(link, oldParticipant, oldPropertyName);
            subPropertyToChange.setPropertyValue("$typeReferencedElement", newParticipant.getUniqueName().toString());
        } else {
            PropertyMap subPropertyToDelete = this.findCorrespondingSubProperty(link, oldParticipant, oldPropertyName);
            String newValue = newParticipant.getPropertyValue("$fullName");
            linkParent.addProperty(newPropertyName, newValue);
            subPropertyToDelete.setPropertyValue("$typeReferencedElement", null);
        }
    }

    private String findInheritancePropertyName(Entity link, Element target) {
        Entity parent = link.getParent();
        IJavaElement javaSource = ElementUtil.getJavaElement((Element)parent);
        IJavaElement javaTarget = ElementUtil.getJavaElement(target);
        if (javaSource instanceof IType && javaTarget instanceof IType) {
            String inheritanceType = InheritanceUtil.getInheritanceMetaclass((IType)javaSource, (IType)javaTarget);
            if ("Generalization Link".equals(inheritanceType)) {
                return "$extends";
            }
            if ("Implementation Link".equals(inheritanceType)) {
                return "$implements";
            }
        }
        return null;
    }

    private PropertyMap findCorrespondingSubProperty(Entity link, Element oldParticipant, String propertyName) {
        Entity parent = link.getParent();
        if (propertyName != null) {
            PropertyEnumeration propEnum = parent.properties(propertyName);
            UniqueName oldUniqueName = oldParticipant.getUniqueName();
            while (propEnum.hasMoreElements()) {
                Property property = propEnum.next();
                PropertyMap subProperty = property.getSubproperties();
                String refUin = subProperty.getPropertyValue("$typeReferencedElement");
                if (!oldUniqueName.toString().equals(refUin)) continue;
                return subProperty;
            }
            System.err.println("participants ERROR");
            return null;
        }
        return null;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    private List participantRolesList(Entity link) {
        UniqueName uniqueName = link.getUniqueName();
        Entity parent = link.getParent();
        ArrayList<String> participantRoles = new ArrayList<String>();
        if (parent != null) {
            try {
                IJavaElement javaElement = ElementUtil.getJavaElement((Element)parent);
                if (javaElement instanceof IType) {
                    IType type = (IType)javaElement;
                    String superclass = type.getSuperclassName();
                    String[] superinterfaces = type.getSuperInterfaceNames();
                    if (superclass != null || superinterfaces.length > 0) {
                        participantRoles.add("Client");
                        participantRoles.add("Supplier");
                    }
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return participantRoles;
    }
}

