/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import org.eclipse.jdt.internal.formatter.CodeFormatter;

public class Formatter {
    public static String formatBody(String sourceText, int nesting) {
        return Formatter.format(sourceText, nesting, false);
    }

    public static String formatComment(String sourceText, int nesting) {
        return Formatter.format(sourceText, nesting, true);
    }

    public static String format(String sourceText, int nesting) {
        return Formatter.formatBody(sourceText, nesting);
    }

    private static String format(String sourceText, int nesting, boolean comment) {
        if (sourceText == null || sourceText.length() == 0) {
            return null;
        }
        try {
            boolean isEndWithLR;
            String oldSourceText = sourceText = sourceText.trim();
            boolean isStartWithLR = sourceText.startsWith("\n") || sourceText.startsWith("\r\n");
            boolean bl = isEndWithLR = sourceText.endsWith("\n") || sourceText.endsWith("\r\n");
            if (!sourceText.startsWith("\n") && !sourceText.startsWith("\r")) {
                sourceText = JavaProviderPlugin.EOL + sourceText;
            }
            if (comment) {
                sourceText = nesting > 0 ? sourceText + JavaProviderPlugin.EOL + " int xxx;" + JavaProviderPlugin.EOL : sourceText + JavaProviderPlugin.EOL + "class XXX{}" + JavaProviderPlugin.EOL;
            } else {
                StringTokenizer st = new StringTokenizer(sourceText, "\n\r", true);
                sourceText = "";
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    String s = line.trim();
                    sourceText = s.startsWith("/*") || s.startsWith("*") || s.startsWith("*/") ? sourceText + s : sourceText + line;
                }
            }
            int i = 0;
            while (i < nesting) {
                sourceText = "class XXXX {" + sourceText + "}";
                ++i;
            }
            sourceText = new CodeFormatter((Map)null).format(sourceText);
            IDOMType domType = new DOMFactory().createType(sourceText);
            sourceText = oldSourceText;
            if (domType != null) {
                IDOMType domNode = domType;
                int i2 = 0;
                while (i2 < nesting) {
                    domNode = (IDOMNode)domNode.getChildren().nextElement();
                    ++i2;
                }
                if (domNode != null) {
                    if (comment) {
                        IDOMMember domMember = (IDOMMember)domNode;
                        sourceText = domMember.getComment();
                    } else {
                        sourceText = domNode.getContents();
                    }
                    if (sourceText.endsWith(JavaProviderPlugin.EOL)) {
                        sourceText = sourceText.substring(0, sourceText.length() - JavaProviderPlugin.EOL.length());
                    }
                    if (isStartWithLR && !sourceText.startsWith(JavaProviderPlugin.EOL)) {
                        sourceText = JavaProviderPlugin.EOL + sourceText;
                    }
                    if (isEndWithLR && !sourceText.endsWith(JavaProviderPlugin.EOL)) {
                        sourceText = sourceText + JavaProviderPlugin.EOL;
                    }
                    return sourceText;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getNesting(IMember member) {
        int nesting = 0;
        IMember javaElement = member;
        while (!((javaElement = javaElement.getParent()) instanceof ICompilationUnit) && !(javaElement instanceof IClassFile)) {
            if (javaElement == null) {
                return 0;
            }
            ++nesting;
        }
        return nesting;
    }
}

