/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.GenericParentProvider;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.LinksCache;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.HashSet;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class FieldProvider
extends GenericParentProvider
implements ChildrenProvider {
    private LinksCache myLinksCache;

    public void registered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        super.registered(model);
        this.myLinksCache = ElementCacheAccess.getLinksCache(this.myModelUniqueName);
    }

    public void unregistered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)model.getUniqueName().equals(this.myModelUniqueName));
        this.myLinksCache = null;
        super.unregistered(model);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        block10: {
            UniqueName parentUniqueName = parent.getUniqueName();
            try {
                IJavaElement javaElement = ElementUtil.getJavaElement(this.myModelUniqueName, parentUniqueName);
                if (!(javaElement instanceof IType)) break block10;
                IType type = (IType)javaElement;
                HashSet<UniqueName> members = new HashSet<UniqueName>();
                IJavaElement[] javaElements = this.myElementsCache.getTemporarilyChildren(parentUniqueName);
                if (javaElements.length > 0) {
                    int i = 0;
                    while (i < javaElements.length) {
                        if (javaElements[i] instanceof IField) {
                            IField field = (IField)javaElements[i];
                            UniqueName uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, field);
                            members.add(uniqueName);
                            String fieldType = CodeUtil.getFieldType(field);
                            if (fieldType != null) {
                                this.myLinksCache.addTemporarilyAssociationLink(field, fieldType);
                            }
                        }
                        ++i;
                    }
                } else {
                    boolean binary = type.isBinary();
                    IField[] fields = type.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        String name;
                        IField field = fields[i];
                        if (!binary || !(name = field.getElementName()).startsWith("this$")) {
                            UniqueName uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, field);
                            members.add(uniqueName);
                            this.myElementsCache.putPermanentElement(uniqueName, (IJavaElement)field);
                            String fieldType = CodeUtil.getFieldType(field);
                            if (fieldType != null) {
                                this.myLinksCache.addPermanentAssociationLink(field, fieldType);
                            }
                        }
                        ++i;
                    }
                }
                return EnumerationConverter.toUniqueNameEnumeration(members.iterator());
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return EmptyEnumeration.getUniqueNameEnumeration();
    }
}

