/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.TypeHelper;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperation;
import com.tssap.selena.internal.core.providers.java.property.PropertyOperationUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;

class ExtendsListUtil {
    ExtendsListUtil() {
    }

    static void removeExtends(IJavaProject javaProject, IType type, IType delType) {
        String typeName = delType.getElementName();
        ExtendsListUtil.removeExtends(javaProject, type, typeName);
    }

    static void removeExtends(IJavaProject javaProject, IType type, String typeName) {
        try {
            String superClassName = type.getSuperclassName();
            if (superClassName != null && superClassName.equals(typeName)) {
                PropertyOperationUtil.doPropertyOperation(javaProject, (IJavaElement)type, true, "$extends", (Object)typeName, null, (PropertyOperation)new MyPropertyOperation());
            } else {
                PropertyOperationUtil.doPropertyOperation(javaProject, (IJavaElement)type, true, "$implements", (Object)typeName, null, (PropertyOperation)new MyPropertyOperation());
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
    }

    private static class MyPropertyOperation
    implements PropertyOperation {
        private MyPropertyOperation() {
        }

        public String propertyOperation(IJavaElement javaElement, IDOMNode domNode, String propertyName, Object newPropertyValue, Object oldPropertyValue) {
            if (!(domNode instanceof IDOMType)) {
                return null;
            }
            IDOMType domType = (IDOMType)domNode;
            if (domType.isClass() && "$extends".equals(propertyName)) {
                return TypeHelper.removeSuperclass(domType);
            }
            Object[] superTypes = domType.getSuperInterfaces();
            if (superTypes == null) {
                return null;
            }
            int index = ArrayUtil.getIndex(superTypes, newPropertyValue);
            if (index != -1) {
                if (superTypes.length > 1) {
                    superTypes = ArrayUtil.remove((String[])superTypes, index);
                    domType.setSuperInterfaces((String[])superTypes);
                    return domType.getContents();
                }
                return TypeHelper.removeLastSuperinterface(domType);
            }
            return null;
        }
    }
}

