/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ArrayUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.UniqueName;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

class ElementsCacheImpl
implements ElementsCache {
    private UniqueName myModelUniqueName;
    private IJavaProject myJavaProject;
    private Hashtable myPackagesCache = new Hashtable();
    private Hashtable myElementsCache = new Hashtable();
    private Hashtable myWorkingCopies = new Hashtable();
    private Hashtable myAddedClasses = new Hashtable();
    private Hashtable myRemovedClasses = new Hashtable();
    private Hashtable myChildren = new Hashtable();

    ElementsCacheImpl(UniqueName modelUniqueName) {
        this.myModelUniqueName = modelUniqueName;
        this.myJavaProject = ElementUtil.getJavaProject(this.myModelUniqueName);
    }

    public void putPackage(UniqueName uniqueName, IPackageFragment packageFragment) {
        if (uniqueName == null || packageFragment == null) {
            return;
        }
        Object[] packageFragments = (IPackageFragment[])this.myPackagesCache.remove(uniqueName);
        if (packageFragments != null) {
            if (!ArrayUtil.contains(packageFragments, packageFragment)) {
                packageFragments = ArrayUtil.add((IPackageFragment[])packageFragments, packageFragment);
            }
            if (packageFragments != null && packageFragments.length > 0) {
                this.myPackagesCache.put(uniqueName, packageFragments);
            }
        } else {
            packageFragments = new IPackageFragment[]{packageFragment};
            this.putPackages(uniqueName, (IPackageFragment[])packageFragments);
        }
    }

    public void putPackages(UniqueName uniqueName, IPackageFragment[] packageFragments) {
        if (uniqueName == null || packageFragments == null) {
            return;
        }
        this.myPackagesCache.put(uniqueName, packageFragments);
    }

    public IPackageFragment[] getPackages(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return (IPackageFragment[])this.myPackagesCache.get(uniqueName);
    }

    public boolean hasPackages(UniqueName uniqueName, IPackageFragment packageFragment) {
        if (uniqueName == null) {
            return false;
        }
        Object[] packageFragments = (IPackageFragment[])this.myPackagesCache.get(uniqueName);
        if (packageFragments != null) {
            return ArrayUtil.contains(packageFragments, packageFragment);
        }
        return false;
    }

    public void removePackage(UniqueName uniqueName, IPackageFragment packageFragment) {
        if (uniqueName == null || packageFragment == null) {
            return;
        }
        IPackageFragment[] packageFragments = (IPackageFragment[])this.myPackagesCache.remove(uniqueName);
        if (packageFragments != null && (packageFragments = ArrayUtil.remove(packageFragments, packageFragment)) != null && packageFragments.length > 0) {
            this.myPackagesCache.put(uniqueName, packageFragments);
        }
    }

    public void removePackages(UniqueName uniqueName) {
        if (uniqueName == null) {
            return;
        }
        this.myPackagesCache.remove(uniqueName);
    }

    public void dropAllPackages() {
        this.myPackagesCache.clear();
    }

    public IJavaElement getElement(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        IJavaElement javaElement = (IJavaElement)this.myWorkingCopies.get(uniqueName);
        if (javaElement != null) {
            if (javaElement.exists()) {
                return javaElement;
            }
            this.removeTemporarilyElement(uniqueName);
        }
        if ((javaElement = (IJavaElement)this.myElementsCache.get(uniqueName)) != null) {
            if (javaElement.exists()) {
                return javaElement;
            }
            this.removePermanentElement(uniqueName);
        }
        return null;
    }

    public void putPermanentElement(UniqueName uniqueName, IJavaElement javaElement) {
        if (uniqueName != null && javaElement != null && (NameUtil.isTypeUniqueName(uniqueName) || NameUtil.isMemberUniqueName(uniqueName))) {
            this.myElementsCache.put(uniqueName, javaElement);
        }
    }

    public void removePermanentElement(UniqueName uniqueName) {
        if (uniqueName != null) {
            this.myElementsCache.remove(uniqueName);
        }
    }

    public void putTemporarilyElement(UniqueName uniqueName, IJavaElement javaElement) {
        if (javaElement instanceof IMember && javaElement.exists()) {
            IMember member = (IMember)javaElement;
            this.myWorkingCopies.put(uniqueName, member);
            UniqueName typeUniqueName = NameUtil.getParentUniqueName(this.myModelUniqueName, uniqueName);
            if (typeUniqueName != null) {
                this.putChild(typeUniqueName, javaElement);
            }
        }
    }

    public void removeTemporarilyElement(UniqueName uniqueName) {
        if (uniqueName != null) {
            UniqueName typeUniqueName;
            IJavaElement javaElement = (IJavaElement)this.myWorkingCopies.remove(uniqueName);
            if (javaElement instanceof IType) {
                ArrayList list = (ArrayList)this.myChildren.remove(uniqueName);
                if (list == null) {
                    return;
                }
                Iterator iter = ((AbstractList)list).iterator();
                while (iter.hasNext()) {
                    IMember element = (IMember)iter.next();
                    UniqueName childName = NameUtil.getJavaElementUniqueName(this.myJavaProject, (IJavaElement)element);
                    this.myWorkingCopies.remove(childName);
                }
            }
            if (javaElement instanceof IMember && (typeUniqueName = NameUtil.getParentUniqueName(this.myModelUniqueName, uniqueName)) != null) {
                this.removeChild(typeUniqueName, javaElement);
            }
        }
    }

    public IJavaElement[] getTemporarilyChildren(UniqueName uniqueName) {
        ArrayList al;
        if (JavaProviderPlugin.isSRTEnabled() && (al = (ArrayList)this.myChildren.get(uniqueName)) != null) {
            return al.toArray(new IJavaElement[al.size()]);
        }
        return new IJavaElement[0];
    }

    public void addTemporarilyTopLevelChildren(ICompilationUnit compilationUnit, IType type) {
        if (compilationUnit != null && type != null && type.getParent() instanceof ICompilationUnit) {
            String key = compilationUnit.getHandleIdentifier();
            ArrayList<IType> al = (ArrayList<IType>)this.myRemovedClasses.get(key);
            if (al != null) {
                ((AbstractCollection)al).remove(type);
                if (al.isEmpty()) {
                    this.myRemovedClasses.remove(key);
                }
            }
            if ((al = (ArrayList)this.myAddedClasses.get(key)) == null) {
                al = new ArrayList<IType>();
                this.myAddedClasses.put(key, al);
            }
            if (!al.contains(type)) {
                al.add(type);
            }
        }
    }

    public IType[] getAddedTemporarilyTopLevelChildren(ICompilationUnit compilationUnit) {
        String key;
        ArrayList al;
        if (JavaProviderPlugin.isSRTEnabled() && compilationUnit != null && (al = (ArrayList)this.myAddedClasses.get(key = compilationUnit.getHandleIdentifier())) != null) {
            return al.toArray(new IType[al.size()]);
        }
        return new IType[0];
    }

    public void removeTemporarilyTopLevelChildren(ICompilationUnit compilationUnit, IType type) {
        if (compilationUnit != null && type != null && type.getParent() instanceof ICompilationUnit) {
            String key = compilationUnit.getHandleIdentifier();
            ArrayList<IType> al = (ArrayList<IType>)this.myAddedClasses.get(key);
            if (al != null) {
                ((AbstractCollection)al).remove(type);
                if (al.isEmpty()) {
                    this.myAddedClasses.remove(key);
                }
            }
            if ((al = (ArrayList)this.myRemovedClasses.get(key)) == null) {
                al = new ArrayList<IType>();
                this.myRemovedClasses.put(key, al);
            }
            if (!al.contains(type)) {
                al.add(type);
            }
        }
    }

    public IType[] getRemovedTemporarilyTopLevelChildren(ICompilationUnit compilationUnit) {
        String key;
        ArrayList al;
        if (JavaProviderPlugin.isSRTEnabled() && compilationUnit != null && (al = (ArrayList)this.myRemovedClasses.get(key = compilationUnit.getHandleIdentifier())) != null) {
            return al.toArray(new IType[al.size()]);
        }
        return new IType[0];
    }

    public void dropTemporarilyTopLevelChildren(ICompilationUnit compilationUnit) {
        if (compilationUnit != null) {
            String key = compilationUnit.getHandleIdentifier();
            this.myAddedClasses.remove(key);
            this.myRemovedClasses.remove(key);
        }
    }

    private void putChild(UniqueName uniqueName, IJavaElement javaElement) {
        ArrayList<IJavaElement> list = (ArrayList<IJavaElement>)this.myChildren.get(uniqueName);
        if (list == null) {
            list = new ArrayList<IJavaElement>();
            this.myChildren.put(uniqueName, list);
        }
        list.add(javaElement);
    }

    private void removeChild(UniqueName uniqueName, IJavaElement javaElement) {
        ArrayList list = (ArrayList)this.myChildren.get(uniqueName);
        if (list != null) {
            ((AbstractCollection)list).remove(javaElement);
            if (list.isEmpty()) {
                this.myChildren.remove(uniqueName);
            }
        }
    }
}

