/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementCacheAccess;
import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ElementUtil {
    public static IJavaElement getJavaElement(UniqueName modelUniqueName, UniqueName uniqueName) {
        return ElementUtil.getJavaElement(modelUniqueName, uniqueName, true);
    }

    public static IJavaElement getJavaElement(Element element) {
        UniqueName modelUniqueName = element.getModel().getUniqueName();
        UniqueName uniqueName = element.getUniqueName();
        return ElementUtil.getJavaElement(modelUniqueName, uniqueName);
    }

    public static IJavaElement getJavaElement(UniqueName modelUniqueName, UniqueName uniqueName, boolean useCache) {
        if (uniqueName == null || modelUniqueName == null) {
            return null;
        }
        IJavaProject javaProject = ElementUtil.getJavaProject(modelUniqueName);
        if (NameUtil.isPackageUniqueName(uniqueName)) {
            IPackageFragment[] packageFragments = ElementUtil.getPackageFragmentsByUniqueName(javaProject, uniqueName, true);
            return packageFragments.length > 0 ? packageFragments[0] : null;
        }
        if (NameUtil.isJarPackageUniqueName(uniqueName)) {
            IPackageFragment[] packageFragments = ElementUtil.getJarPackageFragmentsByUniqueName(javaProject, uniqueName);
            return packageFragments.length > 0 ? packageFragments[0] : null;
        }
        if (NameUtil.isRefPackageUniqueName(uniqueName)) {
            IPackageFragment[] packageFragments = ElementUtil.getRefPackageFragmentsByUniqueName(javaProject, uniqueName, true);
            return packageFragments.length > 0 ? packageFragments[0] : null;
        }
        if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
            return ElementUtil.internalGetJavaElement(javaProject, modelUniqueName, uniqueName, useCache);
        }
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            if (NameUtil.isAssociationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getFUINFromAUIN(uniqueName);
            } else if (NameUtil.isGeneralizationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getTUINFromGUIN(uniqueName);
            } else if (NameUtil.isImplementationUniqueName(uniqueName)) {
                uniqueName = NameUtil.getTUINFromIUIN(uniqueName);
            }
            return ElementUtil.internalGetJavaElement(javaProject, modelUniqueName, uniqueName, useCache);
        }
        if (modelUniqueName.equals(uniqueName)) {
            return javaProject;
        }
        return null;
    }

    private static IJavaElement internalGetJavaElement(IJavaProject javaProject, UniqueName modelUniqueName, UniqueName uniqueName, boolean useCache) {
        IType javaElement = null;
        ElementsCache elementsCache = null;
        if (useCache && (elementsCache = ElementCacheAccess.getElementsCache(modelUniqueName)) != null && (javaElement = elementsCache.getElement(uniqueName)) != null) {
            return javaElement;
        }
        if (NameUtil.isTypeUniqueName(uniqueName)) {
            javaElement = ElementUtil.getTypeByUniqueName(javaProject, uniqueName, false);
        } else if (NameUtil.isMethodUniqueName(uniqueName)) {
            javaElement = ElementUtil.getMethodByUniqueName(javaProject, uniqueName, false);
        } else if (NameUtil.isFieldUniqueName(uniqueName)) {
            javaElement = ElementUtil.getFieldByUniqueName(javaProject, uniqueName, false);
        }
        if (javaElement == null) {
            if (NameUtil.isJavaElementUniqueName(uniqueName, false)) {
                return null;
            }
        } else if (javaElement.exists()) {
            if (useCache && elementsCache != null) {
                elementsCache.putPermanentElement(uniqueName, (IJavaElement)javaElement);
            }
            return javaElement;
        }
        return null;
    }

    public static IPackageFragment[] getPackageFragmentsByUniqueName(IJavaProject javaProject, UniqueName uniqueName) {
        return ElementUtil.getPackageFragmentsByUniqueName(javaProject, uniqueName, true);
    }

    public static IPackageFragment[] getPackageFragmentsByUniqueName(IJavaProject javaProject, UniqueName uniqueName, boolean useCache) {
        String packageQualifiedName;
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        ElementsCache elementsCache = ElementCacheAccess.getElementsCache(modelUniqueName);
        IPackageFragment[] packageFragments = new IPackageFragment[]{};
        if (useCache && (packageFragments = elementsCache.getPackages(uniqueName)) != null) {
            return packageFragments;
        }
        if (!modelUniqueName.equals(uniqueName)) {
            IRootRelativePath path = RootManagerAccess.getRootManager((IProject)javaProject.getProject()).extractRootRelativePath(uniqueName);
            packageQualifiedName = NameUtil.getPackageQualifiedName((IPath)path);
        } else {
            packageQualifiedName = "";
        }
        int kind = NameUtil.getRootKind("src");
        packageFragments = ElementUtil.getPackageFragmentByQualifiedName(javaProject, packageQualifiedName, kind);
        if (packageFragments.length > 0) {
            elementsCache.putPackages(uniqueName, packageFragments);
        }
        return packageFragments;
    }

    static IPackageFragment[] getJarPackageFragmentsByUniqueName(IJavaProject javaProject, UniqueName uniqueName) {
        String location;
        int kind;
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        ElementsCache elementsCache = ElementCacheAccess.getElementsCache(modelUniqueName);
        IPackageFragment[] packageFragments = elementsCache.getPackages(uniqueName);
        if (packageFragments != null) {
            return packageFragments;
        }
        String packageQualifiedName = NameUtil.getExtPackageQualifiedName(uniqueName);
        packageFragments = ElementUtil.getPackageFragmentByQualifiedName(javaProject, packageQualifiedName, kind = NameUtil.getRootKind(location = "bin"));
        if (packageFragments.length > 0) {
            elementsCache.putPackages(uniqueName, packageFragments);
        }
        return packageFragments;
    }

    public static IPackageFragment[] getRefPackageFragmentsByUniqueName(IJavaProject javaProject, UniqueName uniqueName) {
        return ElementUtil.getRefPackageFragmentsByUniqueName(javaProject, uniqueName, true);
    }

    public static IPackageFragment[] getRefPackageFragmentsByUniqueName(IJavaProject javaProject, UniqueName uniqueName, boolean useCache) {
        String location;
        int kind;
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        ElementsCache elementsCache = ElementCacheAccess.getElementsCache(modelUniqueName);
        IPackageFragment[] packageFragments = new IPackageFragment[]{};
        if (useCache && (packageFragments = elementsCache.getPackages(uniqueName)) != null) {
            return packageFragments;
        }
        String packageQualifiedName = NameUtil.getExtPackageQualifiedName(uniqueName);
        packageFragments = ElementUtil.getPackageFragmentByQualifiedName(javaProject, packageQualifiedName, kind = NameUtil.getRootKind(location = "ref"));
        if (packageFragments.length > 0) {
            elementsCache.putPackages(uniqueName, packageFragments);
        }
        return packageFragments;
    }

    private static IPackageFragment[] getPackageFragmentByQualifiedName(IJavaProject javaProject, String qualifiedName, int kind) {
        IPackageFragmentRoot[] packageFragmentRoots = JDTUtil.getPackageFragmentRoots(javaProject, kind);
        ArrayList<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
        int i = 0;
        while (i < packageFragmentRoots.length) {
            IPackageFragment packageFragment = packageFragmentRoots[i].getPackageFragment(qualifiedName);
            if (packageFragment != null && packageFragment.exists()) {
                packageFragments.add(packageFragment);
            }
            ++i;
        }
        if (!packageFragments.isEmpty()) {
            IPackageFragment[] allPackageFragments = new IPackageFragment[packageFragments.size()];
            return packageFragments.toArray(allPackageFragments);
        }
        return new IPackageFragment[0];
    }

    static IType getTypeByUniqueName(IJavaProject javaProject, UniqueName uniqueName) {
        return ElementUtil.getTypeByUniqueName(javaProject, uniqueName, true);
    }

    static IType getTypeByUniqueName(IJavaProject javaProject, UniqueName uniqueName, boolean useCache) {
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        UniqueName parentUniqueName = NameUtil.getParentUniqueName(modelUniqueName, uniqueName);
        if (NameUtil.isTypeUniqueName(parentUniqueName)) {
            IType type = (IType)ElementUtil.getJavaElement(modelUniqueName, parentUniqueName, useCache);
            if (type == null) {
                return null;
            }
            String typeName = uniqueName.getName();
            int index = typeName.lastIndexOf(36);
            if (index < 0) {
                return null;
            }
            typeName = typeName.substring(index + 1, typeName.length());
            try {
                IType[] types = type.getTypes();
                int i = 0;
                while (i < types.length) {
                    if (types[i].getElementName().equals(typeName)) {
                        return types[i];
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        } else {
            int kind;
            IPackageFragment[] packageFragments;
            if (NameUtil.isPackageUniqueName(parentUniqueName)) {
                packageFragments = ElementUtil.getPackageFragmentsByUniqueName(javaProject, parentUniqueName, true);
            } else if (NameUtil.isJarPackageUniqueName(parentUniqueName)) {
                packageFragments = ElementUtil.getJarPackageFragmentsByUniqueName(javaProject, parentUniqueName);
            } else if (NameUtil.isRefPackageUniqueName(parentUniqueName)) {
                packageFragments = ElementUtil.getRefPackageFragmentsByUniqueName(javaProject, parentUniqueName, true);
            } else if (modelUniqueName.equals(parentUniqueName)) {
                kind = NameUtil.getRootKind("src");
                packageFragments = ElementUtil.getPackageFragmentByQualifiedName(javaProject, "", kind);
            } else if (NameUtil.isRootUniqueName(parentUniqueName)) {
                kind = NameUtil.getRootKind(parentUniqueName.getLocation());
                packageFragments = ElementUtil.getPackageFragmentByQualifiedName(javaProject, "", kind);
            } else {
                return null;
            }
            if (packageFragments == null || packageFragments.length == 0) {
                return null;
            }
            try {
                String typeFullName = NameUtil.getTypeQualifiedName(uniqueName);
                int dot = typeFullName.lastIndexOf(".");
                String typeName = dot == -1 ? typeFullName : typeFullName.substring(dot + 1, typeFullName.length());
                ElementsCache cache = ElementCacheAccess.getElementsCache(modelUniqueName);
                int p = 0;
                while (p < packageFragments.length) {
                    IPackageFragment packageFragment = packageFragments[p];
                    ICompilationUnit[] compilationUnits = packageFragment.getCompilationUnits();
                    int i = 0;
                    while (i < compilationUnits.length) {
                        IType[] types = compilationUnits[i].getTypes();
                        int j = 0;
                        while (j < types.length) {
                            if (types[j].getElementName().equals(typeName)) {
                                return types[j];
                            }
                            ++j;
                        }
                        ++i;
                    }
                    IClassFile[] classFiles = packageFragment.getClassFiles();
                    int i2 = 0;
                    while (i2 < classFiles.length) {
                        IType type = classFiles[i2].getType();
                        String handleIdentifier = type.getHandleIdentifier();
                        if (type.getElementName().equals(typeName) && handleIdentifier.indexOf(36) == -1) {
                            IJavaElement[] children = type.getChildren();
                            int j = 0;
                            while (j < children.length) {
                                cache.putPermanentElement(NameUtil.getJavaElementUniqueName(children[j], "bin"), children[j]);
                                ++j;
                            }
                            return type;
                        }
                        ++i2;
                    }
                    ++p;
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return null;
    }

    static IField getFieldByUniqueName(IJavaProject javaProject, UniqueName uniqueName, boolean useCache) {
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        UniqueName parentUniqueName = NameUtil.getParentUniqueName(modelUniqueName, uniqueName);
        IType type = ElementUtil.getTypeByUniqueName(javaProject, parentUniqueName, useCache);
        if (type == null || !type.exists()) {
            return null;
        }
        String fieldName = uniqueName.getName();
        int dotIndex = fieldName.lastIndexOf(".");
        if (dotIndex < 0) {
            return null;
        }
        IField field = type.getField(fieldName = fieldName.substring(dotIndex + 1, fieldName.length()));
        return field.exists() ? field : null;
    }

    static IMethod getMethodByUniqueName(IJavaProject javaProject, UniqueName uniqueName, boolean useCache) {
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        UniqueName parentUniqueName = NameUtil.getParentUniqueName(modelUniqueName, uniqueName);
        IType type = ElementUtil.getTypeByUniqueName(javaProject, parentUniqueName, useCache);
        if (type == null || !type.exists()) {
            return null;
        }
        String methodName = uniqueName.getName();
        int dotIndex = methodName.lastIndexOf(".");
        if (dotIndex < 0) {
            return null;
        }
        methodName = methodName.substring(dotIndex + 1);
        String signature = uniqueName.getParameter(0);
        try {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(methodName)) {
                    String handleIdentifier = methods[i].getHandleIdentifier();
                    int index = handleIdentifier.indexOf("~");
                    if (index == -1) {
                        return null;
                    }
                    String sign = handleIdentifier.substring(index + 1);
                    if (signature.equals(sign)) {
                        return methods[i];
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return null;
    }

    public static Element getModelElement(UniqueName modelUniqueName, IJavaElement javaElement) {
        IProject project = ModelUinSupport.getProject((UniqueName)modelUniqueName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        UniqueName uniqueName = NameUtil.getJavaElementUniqueName(javaProject, javaElement);
        if (uniqueName == null) {
            return null;
        }
        Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
        if (model != null) {
            return model.findEntity(uniqueName);
        }
        return null;
    }

    public static IJavaProject getJavaProject(String modelID) {
        return JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(modelID));
    }

    public static Model getModel(IJavaProject javaProject) {
        UniqueName modelUniqueName = ModelUinSupport.createModelUin((String)javaProject.getElementName());
        Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
        return model;
    }

    public static IJavaProject getJavaProject(UniqueName modelUniqueName) {
        IProject project = ModelUinSupport.getProject((UniqueName)modelUniqueName);
        return JavaCore.create((IProject)project);
    }

    public static boolean isWritableElement(IJavaElement javaElement) {
        if (javaElement != null) {
            Assert.isLegal((javaElement.getElementType() != 4 ? 1 : 0) != 0);
            ICompilationUnit cu = JDTUtil.getCompilationUnit(javaElement);
            if (cu == null) {
                return false;
            }
            if (cu.isWorkingCopy()) {
                IJavaElement original = cu.getOriginalElement();
                if (original instanceof ICompilationUnit) {
                    cu = (ICompilationUnit)original;
                } else {
                    return false;
                }
            }
            IResource resource = null;
            try {
                resource = cu.getCorrespondingResource();
            }
            catch (JavaModelException e) {
                return false;
            }
            if (resource == null) {
                return false;
            }
            return !resource.isReadOnly();
        }
        return false;
    }

    public static boolean isWritablePackage(UniqueName modelUniqueName, UniqueName parentUniqueName) {
        if (NameUtil.isJarPackageUniqueName(parentUniqueName)) {
            return false;
        }
        String qualifiedName = modelUniqueName.equals(parentUniqueName) ? "" : NameUtil.getPackageQualifiedName(modelUniqueName, parentUniqueName);
        IJavaProject javaProject = ElementUtil.getJavaProject(modelUniqueName);
        IPackageFragmentRoot packageFragmentRoot = JDTUtil.getReadWritePackageFragmentRoot(javaProject, qualifiedName);
        return packageFragmentRoot != null;
    }
}

