/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementsCache;
import com.tssap.selena.internal.core.providers.java.ElementsCacheImpl;
import com.tssap.selena.internal.core.providers.java.LinksCache;
import com.tssap.selena.internal.core.providers.java.LinksCacheImpl;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Hashtable;

public class ElementCacheAccess
implements ModelAccessListener {
    private static Hashtable ourElementsCaches = new Hashtable();
    private static Hashtable ourLinksCaches = new Hashtable();
    private static ElementCacheAccess ourElementCacheProvider;

    public static void startup() {
        ourElementCacheProvider = new ElementCacheAccess();
        ModelAccess.addModelAccessListener((ModelAccessListener)ourElementCacheProvider);
    }

    public static void shutdown() {
        ModelAccess.removeModelAccessListener((ModelAccessListener)ourElementCacheProvider);
    }

    public void modelCreated(ModelAccessEvent event) {
    }

    public void modelRemoved(ModelAccessEvent event) {
        UniqueName modelUniqueName = event.getModel().getUniqueName();
        ourElementsCaches.remove(modelUniqueName);
        ourLinksCaches.remove(modelUniqueName);
    }

    public static ElementsCache getElementsCache(UniqueName modelUniqueName) {
        ElementsCache elementsCache = (ElementsCache)ourElementsCaches.get(modelUniqueName);
        if (elementsCache == null) {
            elementsCache = new ElementsCacheImpl(modelUniqueName);
            ourElementsCaches.put(modelUniqueName, elementsCache);
        }
        return elementsCache;
    }

    public static LinksCache getLinksCache(UniqueName modelUniqueName) {
        LinksCache linksCache = (LinksCache)ourLinksCaches.get(modelUniqueName);
        if (linksCache == null) {
            linksCache = new LinksCacheImpl();
            ourLinksCaches.put(modelUniqueName, linksCache);
        }
        return linksCache;
    }
}

