/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.NullMonitor;
import com.tssap.selena.internal.core.providers.java.WorkingCopyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class EditorUtil {
    public static boolean isChangedFromEditor(IJavaElement javaElement) {
        ICompilationUnit originalCompilationUnit;
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit != null && (originalCompilationUnit = (ICompilationUnit)compilationUnit.getOriginalElement()) != null) {
            boolean isWorkingCopy = originalCompilationUnit != compilationUnit;
            return isWorkingCopy;
        }
        return false;
    }

    public static boolean isEditorDirty(IJavaElement javaElement) {
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit != null) {
            IEditorPart[] editorParts = JavaPlugin.getDirtyEditors();
            int i = 0;
            while (i < editorParts.length) {
                IEditorInput input = editorParts[i].getEditorInput();
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit edtCompilationUnit = manager.getWorkingCopy(input);
                if (compilationUnit == edtCompilationUnit) {
                    return editorParts[i].isDirty();
                }
                ++i;
            }
        }
        return false;
    }

    public static void saveAllEditors(boolean dropCache) {
        IEditorPart[] editorParts = JavaPlugin.getDirtyEditors();
        int i = 0;
        while (i < editorParts.length) {
            editorParts[i].doSave(NullMonitor.getSharedInstance());
            if (dropCache) {
                IEditorInput input = editorParts[i].getEditorInput();
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit compilationUnit = manager.getWorkingCopy(input);
                WorkingCopyUtil.dropWorkingCopies((IJavaElement)compilationUnit);
            }
            ++i;
        }
    }

    public static void saveEditor(IJavaElement javaElement) {
        IEditorPart editorPart = EditorUtil.getDirtyEditorPart(javaElement);
        if (editorPart instanceof CompilationUnitEditor) {
            CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)editorPart;
            compilationUnitEditor.doSave(NullMonitor.getSharedInstance());
        }
    }

    public static void closeEditor(IJavaElement javaElement, boolean prompt) {
        IEditorPart editorPart = EditorUtil.getDirtyEditorPart(javaElement);
        if (editorPart instanceof CompilationUnitEditor) {
            CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)editorPart;
            compilationUnitEditor.close(prompt);
        }
    }

    public static ICompilationUnit getCompilationUnit(IEditorPart editorPart) {
        if (editorPart != null) {
            IEditorPart[] editorParts = JavaPlugin.getDirtyEditors();
            int i = 0;
            while (i < editorParts.length) {
                if (editorPart.equals(editorParts[i])) {
                    IEditorInput input = editorParts[i].getEditorInput();
                    IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                    return manager.getWorkingCopy(input);
                }
                ++i;
            }
        }
        return null;
    }

    private static IEditorPart getDirtyEditorPart(IJavaElement javaElement) {
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit != null) {
            IEditorPart[] editorParts = JavaPlugin.getDirtyEditors();
            return EditorUtil.findEditorPart(editorParts, compilationUnit);
        }
        return null;
    }

    public static void saveEditorPartEvenIfNotDirty(IJavaElement javaElement) {
        IEditorPart[] editorParts;
        IEditorPart editor;
        ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit(javaElement);
        if (compilationUnit != null && (editor = EditorUtil.findEditorPart(editorParts = EditorUtil.getAllOpenEditors(), compilationUnit)) != null) {
            editor.doSave(NullMonitor.getSharedInstance());
        }
    }

    private static IEditorPart findEditorPart(IEditorPart[] editorParts, ICompilationUnit cUnit) {
        int i = 0;
        while (i < editorParts.length) {
            String handleIdentifier2;
            IEditorInput input = editorParts[i].getEditorInput();
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            ICompilationUnit edtCompilationUnit = manager.getWorkingCopy(input);
            String handleIdentifier1 = cUnit.getHandleIdentifier();
            String string = handleIdentifier2 = edtCompilationUnit == null ? null : edtCompilationUnit.getHandleIdentifier();
            if (handleIdentifier1.equals(handleIdentifier2)) {
                return editorParts[i];
            }
            ++i;
        }
        return null;
    }

    private static IEditorPart[] getAllOpenEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorInput input;
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep != null && !inputs.contains(input = ep.getEditorInput())) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }
}

