/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ReferenceParticipant;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Participant;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ParticipantAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.enum.ArrayEnumeration;
import java.util.Enumeration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

public class DependencyLinkProvider
extends ModelAwareProvider
implements LinkProviderEx {
    private static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return NameUtil.isDependencyUniqueName(link.getUniqueName());
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration((Enumeration)new ArrayEnumeration((Object[])ROLES));
    }

    public ParticipantEnumeration allParticipants(Entity link) {
        Entity parent = link.getParent();
        if (parent == null) {
            return EmptyEnumeration.getParticipantEnumeration();
        }
        ParticipantAdapter client = new ParticipantAdapter(parent.getUniqueName(), "Client");
        ReferenceParticipant supplier = null;
        IDependencyLink dependencyLink = this.getDependencyLink(link);
        IJavaElement parentType = ElementUtil.getJavaElement((Element)parent);
        if (parentType instanceof IType && dependencyLink != null) {
            String refType = dependencyLink.getType();
            supplier = new ReferenceParticipant("Supplier", this.myModel, (IType)parentType, refType);
        }
        if (supplier != null) {
            Object[] ps = new Participant[]{client, supplier};
            return EnumerationConverter.toParticipantEnumeration((Enumeration)new ArrayEnumeration(ps));
        }
        return EmptyEnumeration.getParticipantEnumeration();
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        if (!"Client".equals(role) && !"Supplier".equals(role)) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Entity parent = link.getParent();
        if (parent == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        if ("Client".equals(role)) {
            return SingleEnumeration.createUniqueNameEnumeration((UniqueName)parent.getUniqueName());
        }
        if ("Supplier".equals(role)) {
            String refType;
            String stringUniqueName;
            IDependencyLink dependencyLink = this.getDependencyLink(link);
            IJavaElement parentType = ElementUtil.getJavaElement((Element)parent);
            if (parentType instanceof IType && dependencyLink != null && (stringUniqueName = TypeNameResolver.resolveType(this.myModel, (IType)parentType, refType = dependencyLink.getType(), true)) != null) {
                UniqueName uniqueName = ModelAccess.createUniqueName((String)stringUniqueName);
                return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uniqueName);
            }
        }
        return EmptyEnumeration.getUniqueNameEnumeration();
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (oldParticipant == null || newParticipant == null) {
            return false;
        }
        if (oldParticipant.equals(newParticipant)) {
            return true;
        }
        if ("Supplier".equals(role)) {
            UniqueName parentTypeUin = NameUtil.getTUINFromDUIN(link.getUniqueName());
            if (parentTypeUin == null) {
                return false;
            }
            IJavaElement parentType = ElementUtil.getJavaElement(link.getModel().getUniqueName(), parentTypeUin);
            if (!(parentType instanceof IType)) {
                return false;
            }
            IJavaElement newTarget = ElementUtil.getJavaElement(newParticipant);
            if (newTarget instanceof IType) {
                IDependencyLink dependencyLink = this.getDependencyLink(link);
                return dependencyLink != null && !dependencyLink.isReadOnly();
            }
        }
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (oldParticipant.equals(newParticipant)) {
            return;
        }
        IDependencyLink dependencyLink = this.getDependencyLink(link);
        String newTypeName = NameUtil.getTypeQualifiedName(newParticipant.getUniqueName());
        dependencyLink.setType(newTypeName);
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    private IDependencyLink getDependencyLink(Entity modelLink) {
        Entity modelType = modelLink.getParent();
        if (modelType == null) {
            return null;
        }
        String linkName = NameUtil.getFNFromDUIN(modelLink.getUniqueName());
        if (linkName == null) {
            return null;
        }
        IJavaElement parentType = ElementUtil.getJavaElement((Element)modelType);
        if (parentType instanceof IType) {
            IDependencyLinkParser linkParser = DependencyLinkParserCache.get(this.myJavaProject, (IType)parentType);
            if (linkParser == null) {
                return null;
            }
            return linkParser.getDependencyLink(linkName);
        }
        return null;
    }
}

