/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.Clipboard;
import com.tssap.selena.internal.core.providers.java.ClipboardEntity;
import com.tssap.selena.internal.core.providers.java.ClipboardEntityFactory;
import com.tssap.selena.internal.core.providers.java.ClipboardLink;
import com.tssap.selena.internal.core.providers.java.ClipboardUtil;
import com.tssap.selena.internal.core.providers.java.CodeUtil;
import com.tssap.selena.internal.core.providers.java.EditorUtil;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.Formatter;
import com.tssap.selena.internal.core.providers.java.IClipboardElement;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodBodyUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.SiblingUtil;
import com.tssap.selena.internal.core.providers.java.refactor.TypeReferenceFinder;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.PasteProvider;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

public class CopyPasteProvider
extends ModelAwareProvider
implements CopyProvider,
CutProvider,
PasteProvider {
    private boolean isCopyOrCutProviderApplicable(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (NameUtil.isJavaLinkElementUniqueName(uniqueName, false)) {
            return false;
        }
        return NameUtil.isJavaUniqueName(uniqueName) || this.myModelUniqueName.equals(uniqueName);
    }

    public boolean isCopyProviderApplicable(Element element) {
        return this.isCopyOrCutProviderApplicable(element);
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyOrCutProviderApplicable(element);
    }

    public boolean canCopy(Element element) {
        if (NameUtil.isJavaLinkElementUniqueName(element.getUniqueName(), false)) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            try {
                return !member.isBinary() && member.getSource() != null;
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        } else if (javaElement instanceof IPackageFragment) {
            return false;
        }
        return false;
    }

    public void copy(Element element, CopyUniqueName copyUin) {
        UniqueName uniqueName = element.getUniqueName();
        ClipboardEntity clipboardElement = null;
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        clipboardElement = ClipboardEntityFactory.createClipboardEntity(javaElement, copyUin, false);
        if (clipboardElement != null && clipboardElement.isValid()) {
            uniqueName = clipboardElement.getUniqueName();
            Clipboard.putClipboardElement((UniqueName)copyUin, clipboardElement);
        }
    }

    public boolean canCut(Element element) {
        if (this.myModelUniqueName.equals(element.getUniqueName())) {
            return false;
        }
        if (NameUtil.isJavaLinkElementUniqueName(element.getUniqueName(), false)) {
            return false;
        }
        if (NameUtil.isRefUniqueName(element.getUniqueName())) {
            return false;
        }
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        try {
            if (javaElement instanceof IMember) {
                IType type;
                if (javaElement instanceof IType && (type = (IType)javaElement).isBinary()) {
                    return false;
                }
                if (!ElementUtil.isWritableElement(javaElement)) {
                    return false;
                }
                if (javaElement instanceof IMember) {
                    IMember member = (IMember)javaElement;
                    return !member.isBinary() && member.getSource() != null;
                }
            } else if (javaElement instanceof IPackageFragment) {
                return false;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }

    public void cut(Element element, CopyUniqueName copyUin) {
        IJavaElement javaElement = ElementUtil.getJavaElement(element);
        ClipboardEntity clipboardElement = ClipboardEntityFactory.createClipboardEntity(javaElement, copyUin, true);
        if (clipboardElement.isValid()) {
            UniqueName uniqueName = clipboardElement.getUniqueName();
            Clipboard.putClipboardElement((UniqueName)copyUin, clipboardElement);
            try {
                if (javaElement instanceof IType) {
                    JDTUtil.delete((IType)javaElement);
                } else if (javaElement instanceof IMember) {
                    ((IMember)javaElement).delete(true, null);
                } else if (javaElement instanceof IPackageFragment) {
                    ((IPackageFragment)javaElement).delete(true, null);
                }
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
    }

    public boolean isPasteProviderApplicable(Entity container) {
        UniqueName uniqueName = container.getUniqueName();
        return NameUtil.isJavaElementUniqueName(uniqueName, false) || NameUtil.isPackageUniqueName(uniqueName) || this.myModelUniqueName.equals(uniqueName);
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        if (element == null) {
            return false;
        }
        UniqueName containerUniqueName = container.getUniqueName();
        if (NameUtil.isRefUniqueName(containerUniqueName)) {
            return false;
        }
        UniqueName pastingUniqueName = element.getUniqueName();
        if (!Clipboard.hasClipboardElement(pastingUniqueName)) {
            return false;
        }
        IClipboardElement clipboardElement = Clipboard.getClipboardElement(pastingUniqueName);
        if (clipboardElement instanceof ClipboardLink) {
            return false;
        }
        String elementKind = clipboardElement.getElementKind();
        IJavaElement javaElement = ElementUtil.getJavaElement((Element)container);
        if (javaElement instanceof IJavaProject) {
            IPackageFragmentRoot writableRoot = JDTUtil.getReadWritePackageFragmentRoot((IJavaProject)javaElement, "");
            IPackageFragment iPackageFragment = javaElement = writableRoot == null ? null : writableRoot.getPackageFragment("");
        }
        if (javaElement instanceof IPackageFragment) {
            String qualifiedName = NameUtil.getPackageQualifiedName(this.myModelUniqueName, containerUniqueName);
            IPackageFragmentRoot packageFragmentRoot = JDTUtil.getReadWritePackageFragmentRoot(this.myJavaProject, qualifiedName);
            if (packageFragmentRoot != null) {
                return ClipboardUtil.isClipboardEntityKind(elementKind, 7) || ClipboardUtil.isClipboardEntityKind(elementKind, 4);
            }
        } else if (javaElement instanceof IMember) {
            try {
                IType type = javaElement instanceof IField || javaElement instanceof IMethod ? ((IMember)javaElement).getDeclaringType() : (IType)javaElement;
                if (type.isInterface() && ClipboardUtil.isClipboardEntityKind(elementKind, 9)) {
                    return !((ClipboardEntity)clipboardElement).hasProperty("$constructor");
                }
            }
            catch (JavaModelException e) {
                return false;
            }
            if (ElementUtil.isWritableElement(javaElement)) {
                return ClipboardUtil.isClipboardEntityKind(elementKind, 7) || ClipboardUtil.isClipboardEntityKind(elementKind, 9) || ClipboardUtil.isClipboardEntityKind(elementKind, 8) || ClipboardUtil.isClipboardLinkKind(elementKind, "ast") || ClipboardUtil.isClipboardLinkKind(elementKind, "gnt") || ClipboardUtil.isClipboardLinkKind(elementKind, "impl");
            }
        }
        return false;
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        if (createdElement != null) {
            return createdElement.getUniqueName();
        }
        UniqueName containerUniqueName = container.getUniqueName();
        UniqueName pastingUniqueName = element.getUniqueName();
        if (pastingUniqueName == null) {
            return null;
        }
        IClipboardElement clipboardElement = Clipboard.getClipboardElement(pastingUniqueName);
        if (clipboardElement == null) {
            return null;
        }
        UniqueName clipboardElementUniqueName = clipboardElement.getUniqueName();
        if (ClipboardUtil.isClipboardElementUniqueName(clipboardElementUniqueName)) {
            return this.pasteEntity((ClipboardEntity)clipboardElement, container, element, createdElement, anchor, before);
        }
        if (ClipboardUtil.isClipboardLinkUniqueName(clipboardElementUniqueName)) {
            throw new RuntimeException("should not be reachable");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UniqueName pasteEntity(ClipboardEntity clipboardEntity, Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        ICompilationUnit cuToPaste;
        block21: {
            UniqueName uniqueName;
            block30: {
                UniqueName memberKind3;
                block29: {
                    UniqueName uniqueName2;
                    block28: {
                        UniqueName memberKind22;
                        block27: {
                            UniqueName uniqueName3;
                            block26: {
                                UniqueName name2;
                                block25: {
                                    UniqueName uniqueName4;
                                    block24: {
                                        UniqueName uniqueName5;
                                        block23: {
                                            UniqueName uniqueName6;
                                            block22: {
                                                UniqueName containerUniqueName = container.getUniqueName();
                                                String elementName = clipboardEntity.getElementName();
                                                String elementKind = clipboardEntity.getElementKind();
                                                String elementContent = clipboardEntity.getElementContent();
                                                cuToPaste = null;
                                                IJavaElement javaContainer = ElementUtil.getJavaElement((Element)container);
                                                if (javaContainer instanceof IJavaProject) {
                                                    IPackageFragmentRoot writableRoot = JDTUtil.getReadWritePackageFragmentRoot((IJavaProject)javaContainer, "");
                                                    javaContainer = writableRoot == null ? null : writableRoot.getPackageFragment("");
                                                }
                                                try {
                                                    try {
                                                        int nesting;
                                                        String newElementContent;
                                                        if (javaContainer instanceof IPackageFragment) {
                                                            int nesting2;
                                                            String name2;
                                                            if (ClipboardUtil.isClipboardEntityKind(elementKind, 4)) {
                                                                String qualifiedName = NameUtil.getPackageQualifiedName(this.myModelUniqueName, containerUniqueName);
                                                                IPackageFragmentRoot packageFragmentRoot = JDTUtil.getReadWritePackageFragmentRoot(this.myJavaProject, qualifiedName);
                                                                if (packageFragmentRoot == null) break block21;
                                                                IPackageFragment packageFragment = JDTUtil.createReadWritePackageFragment(packageFragmentRoot, qualifiedName, elementName);
                                                                uniqueName6 = NameUtil.getJarPackageUniqueName(packageFragment);
                                                                Object var22_34 = null;
                                                                if (cuToPaste == null) return uniqueName6;
                                                                break block22;
                                                            }
                                                            if (!ClipboardUtil.isClipboardEntityKind(elementKind, 7)) break block21;
                                                            IPackageFragment containerPackage = (IPackageFragment)javaContainer;
                                                            String nameBase = element.getPropertyValue("$nametemplate");
                                                            if (nameBase == null) {
                                                                nameBase = elementName;
                                                            }
                                                            if ((name2 = CodeUtil.getUnusedTypeName(this.myJavaProject, (IJavaElement)containerPackage, nameBase, false)) == null) {
                                                                uniqueName5 = null;
                                                                break block23;
                                                            }
                                                            elementContent = CodeUtil.setTypeName(elementContent, name2);
                                                            String newElementContent2 = Formatter.formatBody(elementContent = CopyPasteProvider.fixupTypeModifier(elementContent), nesting2 = 0);
                                                            elementContent = newElementContent2 != null ? newElementContent2 : elementContent;
                                                            elementContent = CodeUtil.getDefaultCompilationUnitBody(containerPackage, "", elementContent);
                                                            cuToPaste = containerPackage.createCompilationUnit(name2 + ".java", elementContent, true, null);
                                                            IType type = cuToPaste.getTypes()[0];
                                                            this.refactorIncomingDependecies(clipboardEntity, type);
                                                            uniqueName4 = NameUtil.getTypeUniqueName(this.myJavaProject, type);
                                                            break block24;
                                                        }
                                                        if (!(javaContainer instanceof IMember)) break block21;
                                                        if (javaContainer instanceof IField || javaContainer instanceof IMethod) {
                                                            javaContainer = ((IMember)javaContainer).getParent();
                                                        }
                                                        IType type = (IType)javaContainer;
                                                        cuToPaste = type.getCompilationUnit();
                                                        if (ClipboardUtil.isClipboardEntityKind(elementKind, 7)) {
                                                            int nesting3;
                                                            String newElementContent3;
                                                            String name3 = CodeUtil.getUnusedTypeName(this.myJavaProject, (IJavaElement)type, elementName, true);
                                                            if (name3 == null) {
                                                                name2 = null;
                                                                break block25;
                                                            }
                                                            elementContent = CodeUtil.setTypeName(elementContent, name3);
                                                            if (type.isInterface()) {
                                                                elementContent = CopyPasteProvider.fixupTypeModifier(elementContent);
                                                            }
                                                            elementContent = (newElementContent3 = Formatter.formatBody(elementContent, nesting3 = Formatter.getNesting((IMember)type) + 1)) != null ? newElementContent3 + JavaProviderPlugin.EOL : elementContent;
                                                            int memberKind22 = clipboardEntity.hasProperty("$interface") ? 4 : 3;
                                                            IJavaElement siblingElement = SiblingUtil.getSibling(type, memberKind22, 0);
                                                            type = type.createType(elementContent, siblingElement, true, null);
                                                            this.refactorIncomingDependecies(clipboardEntity, type);
                                                            uniqueName3 = NameUtil.getTypeUniqueName(this.myJavaProject, type);
                                                            break block26;
                                                        }
                                                        if (ClipboardUtil.isClipboardEntityKind(elementKind, 9)) {
                                                            String signature = (String)clipboardEntity.getObject();
                                                            int memberKind3 = 2;
                                                            if (clipboardEntity.hasProperty("$constructor")) {
                                                                String typeName = type.getElementName();
                                                                elementContent = CodeUtil.setMethodName(elementContent, typeName);
                                                                elementContent = MethodBodyUtil.fixupMethodParameters(type, elementContent, signature);
                                                                memberKind3 = 1;
                                                            } else {
                                                                String name4 = CodeUtil.getUnusedMethodName(type, elementName, signature);
                                                                if (name4 == null) {
                                                                    memberKind22 = null;
                                                                    break block27;
                                                                }
                                                                if (type.isInterface()) {
                                                                    elementContent = CopyPasteProvider.fixupMethodModifier(elementContent);
                                                                }
                                                                int flags = clipboardEntity.getElementFlags();
                                                                boolean emptyBody = type.isInterface() || Flags.isAbstract((int)flags) || Flags.isNative((int)flags);
                                                                elementContent = MethodBodyUtil.fixupMethodBody(elementContent, emptyBody);
                                                                elementContent = CodeUtil.setMethodName(elementContent, name4);
                                                            }
                                                            int nesting4 = Formatter.getNesting((IMember)type) + 1;
                                                            String newElementContent4 = Formatter.formatBody(elementContent, nesting4);
                                                            elementContent = newElementContent4 != null ? newElementContent4 + JavaProviderPlugin.EOL : elementContent;
                                                            IJavaElement siblingElement = SiblingUtil.getSibling(type, memberKind3, 0);
                                                            IMethod method = type.createMethod(elementContent, siblingElement, true, null);
                                                            uniqueName2 = NameUtil.getMethodUniqueName(this.myJavaProject, method);
                                                            break block28;
                                                        }
                                                        if (!ClipboardUtil.isClipboardEntityKind(elementKind, 8)) break block21;
                                                        String name5 = CodeUtil.getUnusedFieldName(type, elementName);
                                                        if (name5 == null) {
                                                            memberKind3 = null;
                                                            break block29;
                                                        }
                                                        elementContent = CodeUtil.setFieldName(elementContent, name5);
                                                        if (type.isInterface()) {
                                                            elementContent = CopyPasteProvider.fixupFieldModifier(elementContent);
                                                        }
                                                        elementContent = (newElementContent = Formatter.formatBody(elementContent, nesting = Formatter.getNesting((IMember)type) + 1)) != null ? newElementContent + JavaProviderPlugin.EOL : elementContent;
                                                        IJavaElement siblingElement = SiblingUtil.getSibling(type, 0, 0);
                                                        IField field = type.createField(elementContent, siblingElement, true, null);
                                                        uniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, field);
                                                        break block30;
                                                    }
                                                    catch (JavaModelException e) {
                                                        cuToPaste = null;
                                                        JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
                                                        Object var22_44 = null;
                                                        if (cuToPaste == null) return null;
                                                        CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                                        return null;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    Object var22_45 = null;
                                                    if (cuToPaste == null) throw throwable;
                                                    CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                                    throw throwable;
                                                }
                                            }
                                            CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                            return uniqueName6;
                                        }
                                        Object var22_35 = null;
                                        if (cuToPaste == null) return uniqueName5;
                                        CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                        return uniqueName5;
                                    }
                                    Object var22_36 = null;
                                    if (cuToPaste == null) return uniqueName4;
                                    CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                    return uniqueName4;
                                }
                                Object var22_37 = null;
                                if (cuToPaste == null) return name2;
                                CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                                return name2;
                            }
                            Object var22_38 = null;
                            if (cuToPaste == null) return uniqueName3;
                            CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                            return uniqueName3;
                        }
                        Object var22_39 = null;
                        if (cuToPaste == null) return memberKind22;
                        CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                        return memberKind22;
                    }
                    Object var22_40 = null;
                    if (cuToPaste == null) return uniqueName2;
                    CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                    return uniqueName2;
                }
                Object var22_41 = null;
                if (cuToPaste == null) return memberKind3;
                CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
                return memberKind3;
            }
            Object var22_42 = null;
            if (cuToPaste == null) return uniqueName;
            CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
            return uniqueName;
        }
        Object var22_43 = null;
        if (cuToPaste == null) return null;
        CopyPasteProvider.restoreImports(cuToPaste, clipboardEntity);
        return null;
    }

    private void refactorIncomingDependecies(ClipboardEntity clipboardEntity, IType pastedType) {
        if (pastedType == null) {
            return;
        }
        EditorUtil.saveAllEditors(true);
        TypeReferenceFinder refactoring = clipboardEntity.getIncomingDependeciesFinder();
        if (refactoring != null) {
            refactoring.replaceBy(pastedType);
        }
    }

    private static void copyToTemplate(Entity template, IJavaComment javaComment) {
        if (javaComment != null) {
            template.setPropertyValue("$comment", javaComment.getComment());
            Enumeration enumeration = javaComment.getTags();
            while (enumeration.hasMoreElements()) {
                ITag tag = (ITag)enumeration.nextElement();
                template.addProperty(tag.getName(), tag.getValue());
            }
        }
    }

    private static String fixupTypeModifier(String body) {
        IDOMType domType = new DOMFactory().createType(body);
        if (domType != null && domType.isClass()) {
            int flags = domType.getFlags();
            domType.setFlags(flags & 0xFFFFFFF7 & 0xFFFFFFFD & 0xFFFFFFFB);
            return domType.getContents();
        }
        return body;
    }

    private static String fixupMethodModifier(String body) {
        IDOMMethod domMethod = new DOMFactory().createMethod(body);
        if (domMethod != null) {
            domMethod.setFlags(1);
            return domMethod.getContents();
        }
        return body;
    }

    private static String fixupFieldModifier(String body) {
        IDOMField domField = new DOMFactory().createField(body);
        if (domField != null) {
            int flags = domField.getFlags();
            domField.setFlags(1);
            String typeName = domField.getType();
            domField.setInitializer(CodeUtil.getDefaultValue(typeName, false));
            return domField.getContents();
        }
        return body;
    }

    private static void restoreImports(ICompilationUnit cu, ClipboardEntity clipboardEntity) {
        String[] associatedImports = clipboardEntity.getOutgoingReferences();
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            int i = 0;
            while (i < associatedImports.length) {
                IImportDeclaration alreadyExists = cu.getImport(associatedImports[i]);
                if (alreadyExists == null || !alreadyExists.exists()) {
                    cu.createImport(associatedImports[i], null, (IProgressMonitor)monitor);
                }
                ++i;
            }
        }
        catch (JavaModelException cantCreateImport) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)cantCreateImport));
        }
    }
}

