/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.template.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;

class CommentUtil {
    CommentUtil() {
    }

    static String getFileComment(ICompilationUnit compilationUnit) {
        if (JavaPreferencesSettings.getCodeGenerationSettings().createFileComments) {
            try {
                String commment = CommentUtil.createTypeCommment(compilationUnit, 0);
                commment = CommentUtil.patchCommment(commment);
                return commment;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return "";
    }

    static String createTypeComment(IType type) {
        if (JavaPreferencesSettings.getCodeGenerationSettings().createComments) {
            try {
                String commment = CommentUtil.createTypeCommment(type.getCompilationUnit(), type.getSourceRange().getOffset());
                commment = CommentUtil.patchCommment(commment);
                return commment;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return "";
    }

    static String createMethodComment(IMethod method) {
        if (JavaPreferencesSettings.getCodeGenerationSettings().createComments) {
            try {
                IType declaringType = method.getDeclaringType();
                ITypeHierarchy lastTypeHierarchy = declaringType.newSupertypeHierarchy(null);
                StringBuffer buf = new StringBuffer();
                IMethod inheritedMethod = JavaModelUtil.findMethodDeclarationInHierarchy((ITypeHierarchy)lastTypeHierarchy, (IType)declaringType, (String)method.getElementName(), (String[])method.getParameterTypes(), (boolean)method.isConstructor());
                if (inheritedMethod != null) {
                    boolean nonJavaDocComments = JavaPreferencesSettings.getCodeGenerationSettings().createNonJavadocComments;
                    boolean isDeprecated = Flags.isDeprecated((int)inheritedMethod.getFlags());
                    buf.append("/**");
                    buf.append(JavaProviderPlugin.EOL);
                    buf.append(" *");
                    buf.append(CommentUtil.getSeeTag(JavaModelUtil.getFullyQualifiedName((IType)inheritedMethod.getDeclaringType()), inheritedMethod.getElementName(), inheritedMethod.getParameterTypes()));
                    buf.append(JavaProviderPlugin.EOL + " */");
                }
                return buf.toString();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return "";
    }

    static String createFieldComment(IField field) {
        return "";
    }

    private static String createTypeCommment(ICompilationUnit compilationUnit, int pos) throws CoreException {
        StringBuffer buf = new StringBuffer();
        CodeTemplates.getInstance();
        Template template = CodeTemplates.getCodeTemplate((String)"typecomment");
        String comment = JavaContext.evaluateTemplate((Template)template, (ICompilationUnit)compilationUnit, (int)pos);
        buf.append(comment);
        return buf.toString();
    }

    private static String patchCommment(String commment) {
        StringTokenizer st = new StringTokenizer(commment, "\n\r");
        String start = "";
        String end = "";
        ArrayList<String> commmentLines = new ArrayList<String>();
        ArrayList<String> tagsLines = new ArrayList<String>();
        commment = "";
        while (st.hasMoreElements()) {
            String token = st.nextToken().trim();
            if (token.startsWith("/**")) {
                start = token;
                continue;
            }
            if (token.endsWith("*/")) {
                end = token;
                continue;
            }
            if (CommentUtil.isTag(token)) {
                tagsLines.add(token);
                continue;
            }
            commmentLines.add(token);
        }
        int i = 0;
        while (i < commmentLines.size()) {
            commment = commment + commmentLines.get(i) + JavaProviderPlugin.EOL;
            ++i;
        }
        int i2 = 0;
        while (i2 < tagsLines.size()) {
            commment = commment + tagsLines.get(i2) + JavaProviderPlugin.EOL;
            ++i2;
        }
        commment = start + JavaProviderPlugin.EOL + commment + end + JavaProviderPlugin.EOL;
        return commment;
    }

    private static boolean isTag(String token) {
        if ((token = token.trim()).startsWith("*")) {
            token = token.substring(1);
            token = token.trim();
        }
        return token.startsWith("@");
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }
}

