/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.MethodCreateParam;
import com.tssap.selena.internal.core.providers.java.TypeNameUtil;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.internal.JavaCommentsPlugin;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

public class CodeUtil {
    static final String DEFAULT_PREFIX = "#";
    private static final String END_DECLARATION = ";" + JavaProviderPlugin.EOL;
    public static final String VALUE_SEPARATOR = ",";
    static final String DEFAULT_METHOD_SIGNATURE = "()V";
    static final String DEFAULT_PARAMETER_NAME = "parameter";

    public static String getDefaultConstructorBody(IType type, String[][] parameters, String comment, boolean notGenerateParameters) {
        try {
            String parametersString = CodeUtil.getParametersString(parameters);
            if (!notGenerateParameters && "".equals(parametersString)) {
                IMethod[] methods = type.getMethods();
                int n = 0;
                int i = 0;
                while (i < methods.length) {
                    IMethod method = methods[i];
                    if (method.isConstructor()) {
                        String[] types = method.getParameterTypes();
                        int c = CodeUtil.getIntParamCount(types);
                        n = n > c ? n : c;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < n) {
                    parametersString = parametersString + "int param" + (i2 + 1);
                    if (i2 < n - 1) {
                        parametersString = parametersString + ", ";
                    }
                    ++i2;
                }
            }
            return comment + "public " + type.getElementName() + "(" + parametersString + "){" + JavaProviderPlugin.EOL + "}" + JavaProviderPlugin.EOL;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private static int getIntParamCount(String[] types) {
        if (types.length == 0) {
            return 1;
        }
        int i = 0;
        while (i < types.length) {
            String type = Signature.toString((String)types[i]);
            if (!"int".equals(type)) {
                return i + 1;
            }
            ++i;
        }
        return types.length + 1;
    }

    public static String getDefaultMethodBody(MethodCreateParam methodCreation, boolean onlyDeclaration) {
        StringBuffer sb = new StringBuffer();
        methodCreation.fillDelcaration(sb, onlyDeclaration ? 2362 : 0);
        if (onlyDeclaration || Flags.isAbstract((int)methodCreation.getModifiers())) {
            return sb.append(END_DECLARATION).toString();
        }
        sb.append("{" + JavaProviderPlugin.EOL);
        sb.append(CodeUtil.getDefaultReturn(methodCreation.getReturnType(), false));
        return sb.append("}" + JavaProviderPlugin.EOL).toString();
    }

    static String getParametersString(String[][] parameters) {
        String parametersString = "";
        if (parameters != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters[0].length) {
                parametersString = parametersString + parameters[0][i] + " " + parameters[1][i];
                if (i < parameters[0].length - 1) {
                    parametersString = parametersString + ", ";
                }
                ++i;
            }
        }
        return parametersString;
    }

    public static String getUnusedMethodName(IType type, String defaultMethodName, String defaultMethodSignature) {
        boolean template = defaultMethodName.startsWith(DEFAULT_PREFIX);
        if (template) {
            defaultMethodName = defaultMethodName.substring(1);
        }
        try {
            IMethod[] methods = type.getMethods();
            String methodName = defaultMethodName;
            int index = defaultMethodSignature.indexOf(")");
            if (index == -1) {
                return null;
            }
            defaultMethodSignature = defaultMethodSignature.substring(0, index + 1);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < methods.length) {
                String signature = methods[i].getSignature();
                index = signature.indexOf(")");
                if (index == -1) {
                    return null;
                }
                signature = signature.substring(0, index + 1);
                list.add(methods[i].getElementName() + signature);
                ++i;
            }
            if (!template && !list.contains(defaultMethodName + defaultMethodSignature)) {
                return defaultMethodName;
            }
            int postFix = 0;
            while (list.contains(defaultMethodName + ++postFix + defaultMethodSignature)) {
            }
            return defaultMethodName + postFix;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public static String setMethodName(String body, String name) {
        IDOMMethod domMethod = new DOMFactory().createMethod(body);
        if (domMethod == null) {
            return body;
        }
        domMethod.setName(name);
        return domMethod.getContents();
    }

    public static String getUnusedFieldName(IType type, String defaultFieldName) {
        try {
            boolean template = defaultFieldName.startsWith(DEFAULT_PREFIX);
            if (template) {
                defaultFieldName = defaultFieldName.substring(1);
            } else {
                IField newField = type.getField(defaultFieldName);
                if (newField == null || !newField.exists()) {
                    return defaultFieldName;
                }
            }
            IField[] fields = type.getFields();
            List list = CodeUtil.getList((IJavaElement[])fields);
            int postFix = 0;
            while (list.contains(defaultFieldName + ++postFix)) {
            }
            return defaultFieldName + postFix;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public static String getDefaultFieldBody(Entity template, String comment, boolean onlyDeclaration) {
        String name = template.getPropertyValue("$name");
        if (name == null || name.length() == 0) {
            return null;
        }
        String type = template.getPropertyValue("$type");
        if (type == null || type.length() == 0) {
            return null;
        }
        String visibility = "";
        String modifiers = "";
        if (template.hasProperty("$public")) {
            visibility = "public";
        } else if (template.hasProperty("$protected")) {
            visibility = "protected";
        } else if (template.hasProperty("$private")) {
            visibility = "private";
        } else if (template.hasProperty("$static")) {
            modifiers = modifiers + "static ";
        } else if (template.hasProperty("$final")) {
            modifiers = modifiers + "final ";
        } else if (template.hasProperty("$volatile")) {
            modifiers = modifiers + "volatile ";
        } else if (template.hasProperty("$transient")) {
            modifiers = modifiers + "transient ";
        }
        modifiers = modifiers.trim();
        ArrayList<Property> list = new ArrayList<Property>();
        PropertyEnumeration propertyEnumeration = template.properties();
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            if (!property.getName().startsWith("@")) continue;
            list.add(property);
        }
        String commentBody = "";
        if (template.hasProperty("$comment") || list.size() > 0) {
            IJavaComment javaComment = JavaCommentsPlugin.getDefault().getJavaCommentParser();
            String tComment = template.getPropertyValue("$comment");
            if (comment != null) {
                javaComment.setComment(tComment);
            } else {
                javaComment.setComment(comment);
            }
            if (list.size() > 0) {
                int i = 0;
                while (i < list.size()) {
                    Property property = (Property)list.get(i);
                    javaComment.addTag(property.getName(), property.getValue());
                    ++i;
                }
            }
            commentBody = javaComment.getContent() + JavaProviderPlugin.EOL;
        }
        String body = commentBody + (visibility + " " + modifiers + " " + type + " " + name).trim();
        body = onlyDeclaration ? body + END_DECLARATION : body + " =" + CodeUtil.getDefaultValue(type, false) + END_DECLARATION;
        return body;
    }

    public static String setFieldName(String body, String name) {
        IDOMField domField = new DOMFactory().createField(body);
        if (domField == null) {
            return body;
        }
        domField.setName(name);
        return domField.getContents();
    }

    public static String getFieldType(IField field) {
        if (field != null) {
            try {
                String type = Signature.toString((String)field.getTypeSignature());
                return TypeNameUtil.isPrimitiveType(type) ? null : type;
            }
            catch (JavaModelException e) {
                JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            }
        }
        return null;
    }

    public static String getUnusedTypeName(IJavaProject javaProject, IJavaElement javaElement, String defaultTypeName, boolean inner) {
        boolean template = defaultTypeName.startsWith(DEFAULT_PREFIX);
        if (template) {
            defaultTypeName = defaultTypeName.substring(1);
        }
        try {
            ICompilationUnit newCompilationUnit;
            if (inner) {
                String typeName;
                IType newType;
                IType type = (IType)javaElement;
                if (!(template || (newType = type.getType(defaultTypeName)) != null && newType.exists() || defaultTypeName.equals(type.getElementName()))) {
                    return defaultTypeName;
                }
                IType[] types = type.getTypes();
                List list = CodeUtil.getList((IJavaElement[])types);
                int postFix = 0;
                while (list.contains(typeName = defaultTypeName + ++postFix) || typeName.equals(type.getElementName())) {
                }
                return defaultTypeName + postFix;
            }
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            if (!(template || (newCompilationUnit = packageFragment.getCompilationUnit(defaultTypeName + ".java")) != null && newCompilationUnit.exists())) {
                return defaultTypeName;
            }
            IType[] types = JDTUtil.getAllTypes(javaProject, packageFragment, true);
            List list = CodeUtil.getList((IJavaElement[])types);
            int postFix = 0;
            while (list.contains(defaultTypeName + ++postFix)) {
            }
            return defaultTypeName + postFix;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            return null;
        }
    }

    public static String getDefaultTypeBody(String name, String comment, boolean clazz, boolean inner, boolean inInterface) {
        String EMPTY_BODY = " {" + JavaProviderPlugin.EOL + "}" + JavaProviderPlugin.EOL;
        if (clazz) {
            if (inner) {
                if (inInterface) {
                    return comment + "static class " + name + EMPTY_BODY;
                }
                return comment + "private static class " + name + EMPTY_BODY;
            }
            return comment + "public class " + name + EMPTY_BODY;
        }
        if (inner) {
            return comment + "interface " + name + EMPTY_BODY;
        }
        return comment + "public interface " + name + EMPTY_BODY;
    }

    public static String setTypeName(String body, String name) {
        IDOMType domType = new DOMFactory().createType(body);
        if (domType == null) {
            return body;
        }
        domType.setName(name);
        return domType.getContents();
    }

    public static String getDefaultCompilationUnitBody(IPackageFragment packageFragment, String comment, String typeBody) {
        String packageName = packageFragment.getElementName();
        if ("".equals(packageName)) {
            return comment + typeBody;
        }
        return comment + "package " + packageName + END_DECLARATION + typeBody;
    }

    public static String getDefaultReturn(String typeName, boolean isArray) {
        return "return " + CodeUtil.getDefaultValue(typeName, isArray) + ";";
    }

    public static String getDefaultValue(String typeName, boolean isArray) {
        if (typeName == null) {
            return "";
        }
        if ("void".equals(typeName = typeName.trim())) {
            return "";
        }
        if (typeName.equals(TypeNameUtil.PRIMITIVE_TYPES[0])) {
            return isArray ? " new boolean[0]" : " false";
        }
        if (typeName.equals(TypeNameUtil.PRIMITIVE_TYPES[1])) {
            return isArray ? " new char[0]" : " ' '";
        }
        if (TypeNameUtil.isPrimitiveType(typeName)) {
            return isArray ? " new " + typeName + "[0]" : " 0";
        }
        return isArray ? " new Object[0]" : " null";
    }

    private static List getList(IJavaElement[] javaElements) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < javaElements.length) {
            list.add(javaElements[i].getElementName());
            ++i;
        }
        return list;
    }
}

