/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;

public class ClipboardUtil
extends NameUtil {
    static boolean isClipboardLinkUniqueName(UniqueName uniqueName) {
        if (uniqueName instanceof CopyUniqueName) {
            String subDomain = uniqueName.getSubDomain();
            return subDomain.startsWith("l_");
        }
        return false;
    }

    static boolean isClipboardElementUniqueName(UniqueName uniqueName) {
        if (uniqueName instanceof CopyUniqueName) {
            String subDomain = uniqueName.getSubDomain();
            return subDomain.startsWith("e_");
        }
        return false;
    }

    static String getClipboardElementKind(IJavaElement javaElement) {
        String kind = ClipboardUtil.getElementKindAsString(javaElement.getElementType());
        if (kind != null) {
            return "e_" + kind;
        }
        return null;
    }

    static boolean isClipboardEntityKind(String elementKind, int kind) {
        String sKind = ClipboardUtil.getElementKindAsString(kind);
        if (sKind != null) {
            return elementKind.equals("e_" + sKind);
        }
        return false;
    }

    static boolean isClipboardLinkKind(String elementKind, String kind) {
        return elementKind.equals("l_" + kind);
    }

    private static String getElementKindAsString(int kind) {
        switch (kind) {
            case 4: {
                return "package";
            }
            case 7: {
                return "class";
            }
            case 9: {
                return "method";
            }
            case 8: {
                return "field";
            }
        }
        return null;
    }
}

