/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ClipboardAssociationLink;
import com.tssap.selena.internal.core.providers.java.ClipboardDependencyLink;
import com.tssap.selena.internal.core.providers.java.ClipboardInheritanceLink;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.IClipboardElement;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

abstract class ClipboardLink
implements IClipboardElement {
    private boolean myValid = false;
    private UniqueName myLinkUniqueName;
    private String myLinkKind;
    private UniqueName myTargetUin;
    private IJavaComment myJavaComment;
    private Model myModel;

    ClipboardLink(Entity link, UniqueName uin) {
        this.myLinkUniqueName = uin;
        this.myModel = link.getModel();
        this.myLinkKind = link.getUniqueName().getSubDomain();
        this.initTargetUin(link);
    }

    protected void initTargetUin(Entity originalLink) {
        Element target;
        ElementEnumeration participants = originalLink.participants("Supplier");
        if (participants != null && participants.hasMoreElements() && this.checkInitialTarget(target = participants.next())) {
            this.setTargetUin(target.getUniqueName());
            this.myValid = true;
        }
    }

    protected final void setTargetUin(UniqueName targetUin) {
        this.myTargetUin = targetUin;
    }

    public static ClipboardLink createClipboardLink(Entity originalLink, CopyUniqueName copyUin) {
        String metaclass = originalLink.getPropertyValue("$metaclass");
        if (metaclass == null) {
            return null;
        }
        if ("Generalization Link".equals(metaclass) || "Implementation Link".equals(metaclass)) {
            return new ClipboardInheritanceLink(originalLink, copyUin);
        }
        if ("Dependency Link".equals(metaclass)) {
            return new ClipboardDependencyLink(originalLink, copyUin);
        }
        if ("Association Link".equals(metaclass)) {
            return new ClipboardAssociationLink(originalLink, copyUin);
        }
        return null;
    }

    public abstract boolean canPaste(IType var1, Entity var2);

    public abstract Element paste(IType var1, Entity var2);

    protected abstract boolean checkInitialTarget(Element var1);

    public boolean isValid() {
        return this.myValid;
    }

    public UniqueName getUniqueName() {
        return this.myLinkUniqueName;
    }

    public String getElementKind() {
        return this.myLinkKind;
    }

    UniqueName getTargetUin() {
        return this.myTargetUin;
    }

    protected static boolean checkWritable(IType parentType) {
        return parentType != null && parentType.exists() && ElementUtil.isWritableElement((IJavaElement)parentType);
    }

    protected final IType findOldTarget() {
        if (!this.isValid()) {
            return null;
        }
        Entity oldTarget = this.myModel.findEntity(this.myTargetUin);
        if (oldTarget == null) {
            return null;
        }
        IJavaElement javaTarget = ElementUtil.getJavaElement((Element)oldTarget);
        return javaTarget instanceof IType ? (IType)javaTarget : null;
    }

    protected Model getModel() {
        return this.myModel;
    }

    public String[] getOutgoingReferences() {
        return new String[0];
    }

    protected Entity getModelTemplate() {
        Entity result = this.getModel().createEntityTemplate();
        result.setParticipant("Supplier", null, (Element)this.getModel().findEntity(this.getTargetUin()));
        return result;
    }
}

