/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ClipboardLink;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.inheritance.InheritanceUtil;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IType;

class ClipboardInheritanceLink
extends ClipboardLink {
    public ClipboardInheritanceLink(Entity link, CopyUniqueName copyUin) {
        super(link, (UniqueName)copyUin);
    }

    public boolean canPaste(IType javaParent, Entity cachedModelParent) {
        if (!ClipboardLink.checkWritable(javaParent)) {
            return false;
        }
        IType oldTarget = this.findOldTarget();
        if (oldTarget == null) {
            return false;
        }
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return false;
        }
        String metaclass = InheritanceUtil.getInheritanceMetaclass(javaParent, oldTarget);
        if (metaclass == null) {
            return false;
        }
        Entity template = this.getModelTemplate();
        return cachedModelParent.canCreateChildEntity(metaclass, template);
    }

    public Element paste(IType javaParent, Entity cachedModelParent) {
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return null;
        }
        IType oldTarget = this.findOldTarget();
        if (oldTarget == null) {
            return null;
        }
        String metaclass = InheritanceUtil.getInheritanceMetaclass(javaParent, oldTarget);
        if (metaclass == null) {
            return null;
        }
        Entity template = this.getModelTemplate();
        return cachedModelParent.createChildEntity(metaclass, template);
    }

    protected boolean checkInitialTarget(Element target) {
        return NameUtil.isTypeUniqueName(target.getUniqueName());
    }
}

