/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ClipboardUtil;
import com.tssap.selena.internal.core.providers.java.IClipboardElement;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.refactor.TypeReferenceFinder;
import com.tssap.selena.internal.core.providers.java.references.OutgoingReferences;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class ClipboardEntity
implements IClipboardElement {
    protected String[] myRefTypes = new String[0];
    private boolean myValid = true;
    private ArrayList myHasProperty = new ArrayList();
    private UniqueName myElementUniqueName;
    private String myOriginalPackageName;
    private String myElementName;
    private String myElementKind;
    private String myElementContent;
    private int myElementFlags;
    private Object myObject;
    private TypeReferenceFinder myIncomingDependeciesFinder;

    ClipboardEntity(IJavaElement javaElement, UniqueName uin, boolean restoreIncomingDependencies) {
        try {
            IPackageFragment parentPackage;
            IMember member;
            ICompilationUnit compilationUnit;
            this.myElementUniqueName = uin;
            this.myElementName = javaElement.getElementName();
            int dotIndex = this.myElementName.lastIndexOf(".");
            if (dotIndex != -1) {
                this.myElementName = this.myElementName.substring(dotIndex + 1);
            }
            this.myElementKind = ClipboardUtil.getClipboardElementKind(javaElement);
            if (restoreIncomingDependencies && javaElement instanceof IType) {
                this.initIncomingDependencies((IType)javaElement);
            }
            if (javaElement instanceof IMember && (compilationUnit = (member = (IMember)javaElement).getCompilationUnit()) != null) {
                IType type;
                this.myElementFlags = member.getFlags();
                this.myRefTypes = OutgoingReferences.getOutgoingReferences(compilationUnit, member);
                this.myElementContent = ((ISourceReference)javaElement).getSource();
                if (javaElement instanceof IMethod) {
                    IMethod method = (IMethod)javaElement;
                    this.myObject = method.getSignature();
                    if (method.isConstructor()) {
                        this.myHasProperty.add("$constructor");
                    }
                } else if (javaElement instanceof IType && (type = (IType)javaElement).isInterface()) {
                    this.myHasProperty.add("$interface");
                }
            }
            this.myOriginalPackageName = (parentPackage = JDTUtil.getPackageFragment(javaElement.getParent())) != null ? parentPackage.getElementName() : null;
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
            this.myValid = false;
        }
    }

    public String[] getOutgoingReferences() {
        return this.myRefTypes;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public UniqueName getUniqueName() {
        return this.myElementUniqueName;
    }

    public String getElementKind() {
        return this.myElementKind;
    }

    public int getElementFlags() {
        return this.myElementFlags;
    }

    public String getElementName() {
        return this.myElementName;
    }

    String getElementContent() {
        return this.myElementContent;
    }

    Object getObject() {
        return this.myObject;
    }

    boolean hasProperty(String propertyName) {
        return this.myHasProperty.contains(propertyName);
    }

    TypeReferenceFinder getIncomingDependeciesFinder() {
        return this.myIncomingDependeciesFinder;
    }

    private void initIncomingDependencies(IType originalType) throws JavaModelException {
        if (!Flags.isPrivate((int)originalType.getFlags()) || !(originalType.getParent() instanceof IType)) {
            long started = System.currentTimeMillis();
            this.myIncomingDependeciesFinder = new TypeReferenceFinder(originalType);
            this.myIncomingDependeciesFinder.find();
            if (originalType != null && originalType.getResource() != null) {
                this.myIncomingDependeciesFinder.removePathFromResults(originalType.getResource().getFullPath());
            }
        }
    }

    private String getOriginalPackageName() {
        return this.myOriginalPackageName;
    }
}

