/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ClipboardLink;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.designlinks.DependencyLinkParserCache;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLink;
import com.tssap.selena.internal.core.providers.java.designlinks.IDependencyLinkParser;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

class ClipboardDependencyLink
extends ClipboardLink {
    private String myCommentContents;

    public ClipboardDependencyLink(Entity link, CopyUniqueName copyUin) {
        super(link, (UniqueName)copyUin);
        this.initJavaComment(link);
    }

    protected void initJavaComment(Entity link) {
        IJavaElement javaParent;
        Entity parent = link.getParent();
        if (parent != null && (javaParent = ElementUtil.getJavaElement((Element)parent)) instanceof IType) {
            IDependencyLink dependencyLink;
            IJavaProject javaProject = this.getJavaProject();
            IDependencyLinkParser parser = DependencyLinkParserCache.get(javaProject, (IType)javaParent);
            String linkName = NameUtil.getFNFromDUIN(link.getUniqueName());
            if (parser != null && linkName != null && linkName != null && (dependencyLink = parser.getDependencyLink(linkName)) != null && dependencyLink.getJavaComment() != null) {
                this.myCommentContents = dependencyLink.getJavaComment().getContent();
            }
        }
    }

    public boolean canPaste(IType javaParent, Entity cachedModelParent) {
        if (this.getJavaProject() == null) {
            return false;
        }
        if (!ClipboardLink.checkWritable(javaParent)) {
            return false;
        }
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return false;
        }
        Entity template = this.getModelTemplate();
        return cachedModelParent.canCreateChildEntity("Dependency Link", template);
    }

    public Element paste(IType javaParent, Entity cachedModelParent) {
        IDependencyLink newLink;
        String newName;
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return null;
        }
        Entity template = this.getModelTemplate();
        Entity result = cachedModelParent.createChildEntity("Dependency Link", template);
        IJavaProject javaProject = this.getJavaProject();
        IDependencyLinkParser parser = DependencyLinkParserCache.get(javaProject, javaParent);
        if (result != null && javaProject != null && this.myCommentContents != null && parser != null && (newName = NameUtil.getFNFromDUIN(result.getUniqueName())) != null && (newLink = parser.getDependencyLink(newName)) != null) {
            IJavaComment comment = newLink.getJavaComment();
            if (comment != null) {
                comment.setContent(this.myCommentContents);
                parser.markAsChanged();
            } else {
                System.err.println("JavaComment == NULL for dependency link: " + result.getUniqueName());
            }
        }
        return result;
    }

    protected boolean checkInitialTarget(Element target) {
        return NameUtil.isTypeUniqueName(target.getUniqueName());
    }

    protected IJavaProject getJavaProject() {
        Model model = this.getModel();
        return ElementUtil.getJavaProject(model.getUniqueName());
    }
}

