/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ClipboardLink;
import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.property.ImportStatementSupport;
import com.tssap.selena.internal.core.providers.java.property.JavaCommentsParsersCache;
import com.tssap.selena.java.javacomment.IJavaComment;
import com.tssap.selena.java.javacomment.ITag;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class ClipboardAssociationLink
extends ClipboardLink {
    private IJavaComment myJavaComment;
    private String myOriginalName;
    private String myRefType;
    private int myModifiers;
    private Entity myCachedAttribute;
    private UniqueName myAttributeUin;
    private static final int NO_MODIFIERS = -1;

    public ClipboardAssociationLink(Entity link, CopyUniqueName copyUin) {
        super(link, (UniqueName)copyUin);
        this.initAttribute(link);
        this.initRefType();
        this.initJavaComment(link);
    }

    protected void initAttribute(Entity originalLink) {
        this.myAttributeUin = NameUtil.getFUINFromAUIN(originalLink.getUniqueName());
        this.myCachedAttribute = this.getAttribute();
        if (this.myCachedAttribute != null) {
            this.collectAttributeProperties(this.myCachedAttribute);
        }
    }

    protected void initJavaComment(Entity link) {
        this.myJavaComment = JavaCommentsParsersCache.get((Element)link);
    }

    protected void initRefType() {
        Entity cachedAttribute = this.getAttribute();
        if (cachedAttribute != null) {
            IJavaElement javaClazz;
            this.setRefType(cachedAttribute.getPropertyValue("$type"));
            Entity clazz = cachedAttribute.getParent();
            if (clazz != null && (javaClazz = ElementUtil.getJavaElement((Element)clazz)) instanceof IType) {
                try {
                    String[][] fullRefTypes = ((IType)javaClazz).resolveType(this.myRefType);
                    if (fullRefTypes != null && fullRefTypes.length > 0) {
                        String[] firstResolved = fullRefTypes[0];
                        this.setRefType(ClipboardAssociationLink.createTypeNameFromResolved(firstResolved));
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String createTypeNameFromResolved(String[] resolvedPair) {
        if (resolvedPair[0] == null || resolvedPair[0].length() == 0) {
            return resolvedPair[1].replace('$', '.');
        }
        return (resolvedPair[0] + '.' + resolvedPair[1]).replace('$', '.');
    }

    protected Entity getAttribute() {
        if (this.myCachedAttribute == null) {
            this.myCachedAttribute = this.getModel().findEntity(this.myAttributeUin);
        }
        return this.myCachedAttribute;
    }

    public boolean canPaste(IType javaParent, Entity cachedModelParent) {
        if (!ClipboardLink.checkWritable(javaParent)) {
            return false;
        }
        IType oldTarget = this.findOldTarget();
        if (oldTarget == null) {
            return false;
        }
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return false;
        }
        Entity template = this.getModelTemplate();
        return cachedModelParent.canCreateChildEntity("Attribute", template);
    }

    public Element paste(IType javaParent, Entity cachedModelParent) {
        if (cachedModelParent == null && (cachedModelParent = this.getModel().findEntity(NameUtil.getTypeUniqueName(javaParent.getJavaProject(), javaParent))) == null) {
            return null;
        }
        IType oldTarget = this.findOldTarget();
        if (oldTarget == null) {
            return null;
        }
        Entity template = this.getModelTemplate();
        Entity result = cachedModelParent.createChildEntity("Attribute", template);
        if (result != null) {
            this.restoreCollectedProperties(result);
        }
        ImportStatementSupport.addImportStatament(this.getModel(), (IJavaElement)javaParent, this.myRefType);
        return result;
    }

    protected Entity getModelTemplate() {
        Entity template = this.getModel().createEntityTemplate();
        template.setPropertyValue("$name", this.myOriginalName);
        template.setPropertyValue("$type", this.myRefType);
        this.restoreAttributeProperties(template);
        return template;
    }

    protected void restoreCollectedProperties(Entity justPasted) {
        this.restoreComments(justPasted);
    }

    protected void restoreComments(Entity newField) {
        if (newField != null && this.myJavaComment != null) {
            newField.setPropertyValue("$comment", this.myJavaComment.getComment());
            Enumeration enumeration = this.myJavaComment.getTags();
            while (enumeration.hasMoreElements()) {
                ITag tag = (ITag)enumeration.nextElement();
                newField.addProperty(tag.getName(), tag.getValue());
            }
        }
    }

    private void restoreAttributeProperties(Entity template) {
        if (this.myOriginalName != null) {
            template.setPropertyValue("$name", this.myOriginalName);
        }
        if (this.myModifiers != -1) {
            if ((this.myModifiers & 4) > 0) {
                template.setPropertyValue("$private", "true");
            } else if ((this.myModifiers & 2) > 0) {
                template.setPropertyValue("$protected", "true");
            } else if ((this.myModifiers & 1) > 0) {
                template.setPropertyValue("$public", "true");
            }
            if ((this.myModifiers & 0x20) > 0) {
                template.setPropertyValue("$static", "true");
            }
            if ((this.myModifiers & 0x40) > 0) {
                template.setPropertyValue("$final", "true");
            }
        }
    }

    protected void collectAttributeProperties(Entity attribute) {
        this.myModifiers = -1;
        if (attribute != null) {
            this.myOriginalName = attribute.getPropertyValue("$name");
            String stringModifiers = attribute.getPropertyValue("modifiers");
            if (stringModifiers != null) {
                try {
                    this.myModifiers = Integer.parseInt(stringModifiers);
                }
                catch (NumberFormatException notParsable) {
                    System.err.println("Can cot parse Composite_Modifiers property for " + attribute + ", value: " + stringModifiers);
                    this.myModifiers = -1;
                }
            }
        } else {
            this.myOriginalName = null;
        }
    }

    protected boolean checkInitialTarget(Element target) {
        return NameUtil.isTypeUniqueName(target.getUniqueName());
    }

    protected final void setRefType(String refType) {
        this.myRefType = refType;
    }
}

