/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.ReferenceParticipant;
import com.tssap.selena.internal.core.providers.java.TypeNameResolver;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Participant;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProviderEx;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.ParticipantAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.enum.ArrayEnumeration;
import java.util.Enumeration;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

public class AssociationLinkProvider
extends ModelAwareProvider
implements LinkProviderEx {
    private static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return NameUtil.isAssociationUniqueName(link.getUniqueName());
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration((Enumeration)new ArrayEnumeration((Object[])ROLES));
    }

    public ParticipantEnumeration allParticipants(Entity link) {
        String refType;
        IType type;
        Entity parent = link.getParent();
        if (parent == null) {
            return EmptyEnumeration.getParticipantEnumeration();
        }
        ParticipantAdapter client = new ParticipantAdapter(parent.getUniqueName(), "Client");
        ReferenceParticipant supplier = null;
        IJavaElement javaElement = ElementUtil.getJavaElement((Element)parent);
        UniqueName uniqueName = null;
        if (javaElement instanceof IType) {
            type = (IType)javaElement;
            uniqueName = link.getUniqueName();
            String fieldName = uniqueName.getParameter(0);
            IField field = type.getField(fieldName);
            if (field == null) {
                return EmptyEnumeration.getParticipantEnumeration();
            }
            UniqueName fieldUniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, field);
            Entity attribute = this.myModel.findEntity(fieldUniqueName);
            if (attribute == null) {
                return EmptyEnumeration.getParticipantEnumeration();
            }
            refType = attribute.getPropertyValue("@associates");
            if (refType == null) {
                refType = JDTUtil.getRefType(field);
            }
            if (refType == null) {
                return EmptyEnumeration.getParticipantEnumeration();
            }
        } else {
            return EmptyEnumeration.getParticipantEnumeration();
        }
        supplier = new ReferenceParticipant("Supplier", this.myModel, type, refType);
        Object[] ps = new Participant[]{client, supplier};
        return EnumerationConverter.toParticipantEnumeration((Enumeration)new ArrayEnumeration(ps));
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        UniqueName uniqueName;
        String fieldName;
        IType type;
        IField field;
        IJavaElement javaElement;
        if (!"Client".equals(role) && !"Supplier".equals(role)) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Entity parent = link.getParent();
        if (parent == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        if ("Client".equals(role)) {
            return SingleEnumeration.createUniqueNameEnumeration((UniqueName)parent.getUniqueName());
        }
        if ("Supplier".equals(role) && (javaElement = ElementUtil.getJavaElement((Element)parent)) instanceof IType && (field = (type = (IType)javaElement).getField(fieldName = (uniqueName = link.getUniqueName()).getParameter(0))) != null) {
            UniqueName fieldUniqueName = NameUtil.getFieldUniqueName(this.myJavaProject, field);
            Entity attribute = this.myModel.findEntity(fieldUniqueName);
            if (attribute == null) {
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            String desRefType = attribute.getPropertyValue("@associates");
            String defRefType = JDTUtil.getRefType(field);
            String refType = desRefType == null ? defRefType : desRefType;
            String stringUniqueName = TypeNameResolver.resolveType(this.myModel, type, refType, true);
            if (stringUniqueName != null) {
                uniqueName = ModelAccess.createUniqueName((String)stringUniqueName);
                return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uniqueName);
            }
        }
        return EmptyEnumeration.getUniqueNameEnumeration();
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (link == null || role == null || oldParticipant == null && newParticipant == null) {
            return false;
        }
        if (oldParticipant == null) {
            return true;
        }
        if (newParticipant == null) {
            return true;
        }
        IJavaElement newJavaParticipant = ElementUtil.getJavaElement(link.getModel().getUniqueName(), newParticipant.getUniqueName());
        if (!(newJavaParticipant instanceof IType)) {
            return false;
        }
        UniqueName linkUniqueName = link.getUniqueName();
        UniqueName attributeUniqueName = NameUtil.getFUINFromAUIN(linkUniqueName);
        Entity attribute = this.myModel.findEntity(attributeUniqueName);
        if (attribute != null) {
            if ("Client".equals(role)) {
                return attributeUniqueName.equals(oldParticipant) && attributeUniqueName.equals(newParticipant);
            }
            if ("Supplier".equals(role)) {
                String redirectedTagValue = attribute.getPropertyValue("@associates");
                if (redirectedTagValue == null) {
                    return attribute.canSetPropertyValue("$typeReferencedElement", newParticipant.getUniqueName().toString());
                }
                String newRedirectValue = NameUtil.normalizeName(NameUtil.getTypeQualifiedName((IType)newJavaParticipant));
                return attribute.canSetPropertyValue("@associates", newRedirectValue);
            }
        }
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        UniqueName linkUniqueName = link.getUniqueName();
        UniqueName attributeUniqueName = NameUtil.getFUINFromAUIN(linkUniqueName);
        Entity attribute = this.myModel.findEntity(attributeUniqueName);
        if (attribute != null) {
            if ("Client".equals(role)) {
                return;
            }
            if ("Supplier".equals(role)) {
                String redirectedTagValue = attribute.getPropertyValue("@associates");
                IType newJavaParticipant = (IType)ElementUtil.getJavaElement(link.getModel().getUniqueName(), newParticipant.getUniqueName());
                if (redirectedTagValue == null) {
                    attribute.setPropertyValue("$typeReferencedElement", newParticipant.getUniqueName().toString());
                } else {
                    String newRedirectValue = NameUtil.normalizeName(NameUtil.getTypeQualifiedName(newJavaParticipant));
                    attribute.setPropertyValue("@associates", newRedirectValue);
                }
            }
        }
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }
}

