/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;

public class ArrayUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object[] getEmptyArray() {
        return EMPTY_ARRAY;
    }

    public static Object[] merge(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public static ArrayList toList(Object[] a1) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (a1 != null) {
            int i = 0;
            while (i < a1.length) {
                list.add(a1[i]);
                ++i;
            }
        }
        return list;
    }

    public static IJavaElement[] merge(IJavaElement[] a1, IJavaElement[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        IJavaElement[] res = new IJavaElement[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public static IPackageFragment[] add(IPackageFragment[] elements, IPackageFragment element) {
        if (elements == null || elements.length == 0 || element == null) {
            return elements;
        }
        int oldLen = elements.length;
        int newLen = oldLen + 1;
        IPackageFragment[] newElements = new IPackageFragment[newLen];
        System.arraycopy(elements, 0, newElements, 0, oldLen);
        newElements[newLen - 1] = element;
        return newElements;
    }

    public static IPackageFragment[] remove(IPackageFragment[] elements, IPackageFragment element) {
        if (elements == null || elements.length == 0 || element == null) {
            return elements;
        }
        int index = ArrayUtil.getIndex((IJavaElement[])elements, (IJavaElement)element);
        if (index == -1) {
            return elements;
        }
        int oldLen = elements.length;
        if (index == 0 && oldLen == 1) {
            return new IPackageFragment[0];
        }
        int newLen = oldLen - 1;
        IPackageFragment[] newElements = new IPackageFragment[newLen];
        if (index == 0) {
            System.arraycopy(elements, 1, newElements, 0, newLen);
        } else if (index == oldLen) {
            System.arraycopy(elements, 0, newElements, 0, newLen);
        } else {
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index + 1, newElements, index, oldLen - index);
        }
        return newElements;
    }

    public static int getIndex(IJavaElement[] elements, IJavaElement element) {
        int i = 0;
        while (i < elements.length) {
            String hi1 = elements[i].getHandleIdentifier();
            String hi2 = element.getHandleIdentifier();
            if (hi1.equals(hi1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIndex(Object[] objects, Object object) {
        if (object != null) {
            int i = 0;
            while (i < objects.length) {
                if (object.equals(objects[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object anObject) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null && anObject == null) {
                return true;
            }
            if (anObject != null && anObject.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] replace(String[] arr, String newValue, String oldValue) {
        if (arr == null || arr.length == 0 || newValue == null || oldValue == null) {
            return null;
        }
        int i = 0;
        while (i < arr.length) {
            if (oldValue.equals(arr[i])) {
                arr[i] = newValue;
                return arr;
            }
            ++i;
        }
        return null;
    }

    public static String[] merge(String[] a1, String[] a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        int a1Len = a1.length;
        int a2Len = a2.length;
        String[] res = new String[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public static String[] remove(String[] arr, int index) {
        int arrLen = arr.length;
        String[] res = new String[arrLen - 1];
        if (arrLen == 0 && index == 0) {
            return new String[0];
        }
        if (index == 0) {
            System.arraycopy(arr, 1, res, 0, arrLen - 1);
        } else if (arrLen == index + 1) {
            System.arraycopy(arr, 0, res, 0, arrLen - 1);
        } else {
            System.arraycopy(arr, 0, res, 0, index);
            System.arraycopy(arr, index + 1, res, index, arr.length - index - 1);
        }
        return res;
    }

    public static boolean compareArrays(String[] arr1, String[] arr2) {
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length == arr2.length) {
            int i = 0;
            while (i < arr1.length) {
                String prm = arr1[i];
                if (!prm.equals(arr2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

