/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.core.providers.java;

import com.tssap.selena.internal.core.providers.java.ElementUtil;
import com.tssap.selena.internal.core.providers.java.JDTUtil;
import com.tssap.selena.internal.core.providers.java.JavaProviderPlugin;
import com.tssap.selena.internal.core.providers.java.ModelAwareProvider;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AbstractCopyPasteProvider
extends ModelAwareProvider {
    protected static boolean canCutFrom(IJavaElement javaElement) {
        if (javaElement == null || !javaElement.exists() || !ElementUtil.isWritableElement(javaElement)) {
            return false;
        }
        try {
            if (javaElement instanceof IMember) {
                if (((IMember)javaElement).getSource() == null) {
                    return false;
                }
                if (javaElement instanceof IType) {
                    IType type = (IType)javaElement;
                    if (type.isBinary()) {
                        return false;
                    }
                    ICompilationUnit compilationUnit = JDTUtil.getCompilationUnit((IJavaElement)type);
                    IJavaElement originalElement = compilationUnit.getOriginalElement();
                    if (originalElement != null && Flags.isPublic((int)type.getFlags())) {
                        return false;
                    }
                }
                return true;
            }
        }
        catch (JavaModelException e) {
            JavaProviderPlugin.getDefault().logException((Exception)((Object)e));
        }
        return false;
    }
}

