/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ats;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.ConfigReader;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    DirsAndFiles daf;
    FileCreator fCreator;
    String buildFileName;
    String method;
    int br = 0;
    String errMsg = "";
    int currentStep;
    private IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ats$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$ats$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.ats.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$ats$CreateBuildFileAction));
    JlinUtils jlinUtils;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ats$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        this.setVelocityContext();
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    private void setVelocityContext() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> AntPropsDependJars = new ArrayList<String>();
        ArrayList<String> addClasspath = new ArrayList<String>();
        this.fCreator.setStrContext("dc_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_caption", this.daf.getDCCaption());
        this.fCreator.setStrContext("dc_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_scname", componentInfo.getCompartment().getScName());
        this.fCreator.setStrContext("dc_type", this.daf.getDCType());
        this.fCreator.setStrContext("dc_subtype", this.daf.getDcSubtype());
        this.fCreator.setListContext("dc_properties", this.daf.getDCProperties());
        this.fCreator.setStrContext("dc_src_Dir", this.daf.getSrcDir());
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        List dependDirs = this.daf.getDependDirs();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                AntPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        AntPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        String classPathFileName = "cfg" + File.separator + "classpath.properties";
        File classPathFile = new File(this.daf.getRootDir() + File.separator + classPathFileName);
        if (classPathFile.exists()) {
            ConfigReader cr = new ConfigReader();
            cr.setFileName(this.daf.getRootDir() + File.separator + classPathFileName);
            String classPathValue = cr.getPropertyValue("classpath");
            if (classPathValue.length() != 0) {
                StringTokenizer st = new StringTokenizer(classPathValue, ";");
                while (st.hasMoreTokens()) {
                    addClasspath.add(st.nextToken());
                }
            } else {
                this.loc.infoT("classpath.properties: No value for 'classpath' found");
            }
        } else {
            this.loc.infoT("no classpath.properties file, describing additional jars for the classpath found. Compiliation with the jars only from dependent DCs");
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        this.fCreator.setListContext("dc_depend_compileArchives", AntPropsDependJars);
        this.fCreator.setListContext("dc_depend_addClasspath", addClasspath);
        List packageDirs = this.daf.getPackageDirs();
        this.fCreator.setListContext("dc_packageDirs", packageDirs);
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
        this.fCreator.setListContext("dc_sourceDirs", this.daf.getSourceDirs());
        this.fCreator.setStrContext("dc_deploy_Dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_variantDir", this.daf.getGenVariantDir());
        this.fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.jlinUtils.insertJlinContext(this.fCreator);
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_ass_dep", assDep);
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
            String mfName = this.daf.getTempDir() + File.separator + "Manifest.mf";
            this.daf.createManifestFile(mfName);
            this.fCreator.setStrContext("bi_manifest_Name", mfName);
        }
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        this.fCreator.setListContext("dc_depend_allDirs", this.getAllDependencies());
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    protected static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String time = "";
        long test = minutes % 60L;
        if (hours > 0L) {
            time = hours < 10L ? "0" + Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "") : Long.toString(hours) + ":" + Long.toString(minutes % 60L) + (minutes % 60L == 0L ? "0" : "");
        } else if (minutes > 0L) {
            time = "00:" + Long.toString(minutes % 60L);
        }
        return time;
    }

    protected final List getAllDependencies() {
        List compDep = this.daf.getDependencies();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                DCReference component = dep.getComponent();
                String name = component.getName();
                String vendor = component.getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                ComponentDependencies compdep = type == null ? new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", "") : new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType());
                compdep.setAtBuild(dep.isAtBuildTime());
                compdep.setBuildtimeQualifier(dep.getBuildTimeQualifier());
                compdep.setDeploytimeQualifier(dep.getDeployTimeQualifier());
                if (dc != null) {
                    PPReference ppRef = dep.getPublicPartDependency();
                    Map pps = dc.getPublicParts();
                    if (ppRef != null) {
                        String ppName = ppRef.getName();
                        PublicPart pp = (PublicPart)pps.get(ppName);
                        PublicPart.Purpose aPurpose = pp.getPurpose();
                        String rootPath = this.daf.getUsedPublicPartGenFolder(ppRef);
                        compdep.addPublicPart(ppName, aPurpose.toString(), rootPath);
                    } else if (pps != null) {
                        Iterator ppNames = pps.keySet().iterator();
                        while (ppNames.hasNext()) {
                            String ppName = (String)ppNames.next();
                            PublicPart pp = (PublicPart)pps.get(ppName);
                            PublicPart.Purpose aPurpose = pp.getPurpose();
                            ppRef = new PPReference(ppName, component);
                            String rootPath = this.daf.getUsedPublicPartGenFolder(ppRef);
                            compdep.addPublicPart(ppName, aPurpose.toString(), rootPath);
                        }
                    }
                }
                allDep.add(compdep);
            }
        }
        return allDep;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

