/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.AbstractTest;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.core.EdoAtomicValue;
import com.sap.tc.col.edo.core.EdoIndexTable;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.edo.core.XMLHelper;
import java.util.Arrays;

public class TestXMLEventHandler
extends AbstractTest {
    private String ENCODING = "UTF-8";
    private XMLHelper x = new XMLHelper();
    static final StructureDescriptor[] descriptors = new StructureDescriptor[]{AbstractTest.desc1, AbstractTest.desc1a};
    static final String[][] fieldNValues = new String[][]{{"FIELD1", "field1 value"}, {"FIELD2", "field2 value"}, {"XX/FIELD_N", "field_N value"}};
    static final String[][] structDataStrings = new String[][]{{"Simple", "<FBSTRUCTURE1><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></FBSTRUCTURE1>"}, {"With unknown field", "<FBSTRUCTURE1><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><UKN_FIELD>unknown field value</UKN_FIELD><XX_-FIELD_N>field_N value</XX_-FIELD_N></FBSTRUCTURE1>"}};
    static final String[][] tableDataStrings = new String[][]{{"One row", "<FBSTRUCTURE1><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item></FBSTRUCTURE1>", "1"}, {"Six rows", "<FBSTRUCTURE1><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item></FBSTRUCTURE1>", "6"}, {"With Unknown field", "<FBSTRUCTURE1><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N><UKN_FIELD>unknown field value</UKN_FIELD></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N><UKN_FIELD>unknown field value</UKN_FIELD></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N><UKN_FIELD>unknown field value</UKN_FIELD></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><UKN_FIELD>unknown field value</UKN_FIELD><XX_-FIELD_N>field_N value</XX_-FIELD_N></item><item><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N><UKN_FIELD>unknown field value</UKN_FIELD></item><item><FIELD1>field1 value</FIELD1><UKN_FIELD>unknown field value</UKN_FIELD><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></item></FBSTRUCTURE1>", "6"}};
    static final String[][] indexTableDataStrings = new String[][]{{"Simple", "<SCOL_RELATION_INDEX><item><INRECORD>1</INRECORD><OUTRECORD>2</OUTRECORD></item></SCOL_RELATION_INDEX>"}, {"With unknown field", "<SCOL_RELATION_INDEX><item><INRECORD>1</INRECORD><OUTRECORD>2</OUTRECORD><UKN_-FIELD>some description</UKN_-FIELD></item></SCOL_RELATION_INDEX>"}, {"a few relations ", "<SCOL_RELATION_INDEX><item><INRECORD>1</INRECORD><OUTRECORD>2</OUTRECORD></item><item><INRECORD>1</INRECORD><OUTRECORD>3</OUTRECORD></item><item><INRECORD>2</INRECORD><OUTRECORD>4</OUTRECORD></item><item><INRECORD>4</INRECORD><OUTRECORD>5</OUTRECORD></item></SCOL_RELATION_INDEX>"}};
    private static final String variantData = "<STRUCTUREVARIANT><FIELD1>Field1_Value</FIELD1><FIELD2>Field2_Value</FIELD2><FIELDVAR><FBSTRUCTURE1><FIELD1>Field11_value</FIELD1><FIELD2>Field22_value</FIELD2><XX_-FIELD_N>Field_N value</XX_-FIELD_N></FBSTRUCTURE1></FIELDVAR></STRUCTUREVARIANT>";
    private static final String myData = "";
    private static final String structField1 = "Field1_Value";
    private static final String structField2 = "Field2_Value";
    private static final String variantField1 = "Field11_value";
    private static final String variantField2 = "Field22_value";
    private static final String variantFieldN = "Field_N value";

    public void testMarshallingAtomicType() throws Exception {
        String data = "This is a value of Simple type";
        byte[] oData = data.getBytes(this.ENCODING);
        EdoAtomicValue value = new EdoAtomicValue("STRING");
        value.setStringValue(data);
        this.verify(data.equals(value.getStringValue()), "Wrong value for simple data type");
        value.writeTo(this.x);
        byte[] mData = this.x.getXString();
        this.verify(Arrays.equals(mData, oData), "Wrong value for simple data type");
    }

    public void testUnmarshalingAtomicType() throws Exception {
        String data = "This is a value of Simple type";
        EdoAtomicValue value = new EdoAtomicValue("STRING");
        value.setStringValue(data);
        this.verify(data.equals(value.getStringValue()), "Wrong value for simple data type");
        value.setStringValue("BAD Data Value.");
        this.x.setXString(data.getBytes(this.ENCODING));
        value.readFrom(this.x);
        this.verify(data.equals(value.getStringValue()), "Wrong value for simple data type");
    }

    public void testMarshallingStructure() throws Exception {
        String data = "<FBSTRUCTURE1><FIELD1>field1 value</FIELD1><FIELD2>field2 value</FIELD2><XX_-FIELD_N>field_N value</XX_-FIELD_N></FBSTRUCTURE1>";
        byte[] oData = data.getBytes(this.ENCODING);
        StructureDescriptor[] descriptors = new StructureDescriptor[]{AbstractTest.desc1, AbstractTest.desc1a};
        int i = 0;
        int len = descriptors.length;
        while (i < len) {
            EdoStructure structure = new EdoStructure((IStructureDescriptor)descriptors[i]);
            structure.setStringValue("FIELD1", "field1 value");
            structure.setStringValue("FIELD2", "field2 value");
            structure.setStringValue("XX/FIELD_N", "field_N value");
            this.x.setXString(null);
            structure.writeTo(this.x);
            byte[] mData = this.x.getXString();
            this.verify(Arrays.equals(mData, oData), "Wrong value for structure " + structure.getDescriptor().getName(), 1);
            ++i;
        }
    }

    public void testUnmarshalingStructure() throws Exception {
        String[][] dataStrings = structDataStrings;
        int k = 0;
        int klen = dataStrings.length;
        while (k < klen) {
            String data = dataStrings[k][1];
            int j = 0;
            int jlen = descriptors.length;
            while (j < jlen) {
                EdoStructure structure = new EdoStructure((IStructureDescriptor)descriptors[j]);
                this.x.setXString(data.getBytes(this.ENCODING));
                structure.readFrom(this.x);
                int i = 0;
                int len = fieldNValues.length;
                while (i < len) {
                    String name = fieldNValues[i][0];
                    String value = fieldNValues[i][1];
                    this.verify(value.equals(structure.getStringValue(name)), dataStrings[k][0] + " : " + structure.getDescriptor().getName() + " : Wrong value for " + name, 1);
                    ++i;
                }
                int i2 = 0;
                int len2 = fieldNValues.length;
                while (i2 < len2) {
                    String name = fieldNValues[i2][0];
                    String value = "Some bad value";
                    structure.setStringValue(name, value);
                    ++i2;
                }
                this.x.setXString(data.getBytes(this.ENCODING));
                structure.readFrom(this.x);
                int i3 = 0;
                int len3 = fieldNValues.length;
                while (i3 < len3) {
                    String name = fieldNValues[i3][0];
                    String value = fieldNValues[i3][1];
                    this.verify(value.equals(structure.getStringValue(name)), dataStrings[k][0] + " : " + structure.getDescriptor().getName() + " : Wrong value for " + name, 1);
                    ++i3;
                }
                ++j;
            }
            ++k;
        }
    }

    public void testMarshallingTable_withOneRow() throws Exception {
        String data = tableDataStrings[0][1];
        byte[] oData = data.getBytes(this.ENCODING);
        int j = 0;
        int jlen = descriptors.length;
        while (j < jlen) {
            EdoTable table = new EdoTable((IStructureDescriptor)descriptors[j]);
            table.append(1);
            table.setStringValue(0, "FIELD1", "field1 value");
            table.setStringValue(0, "FIELD2", "field2 value");
            table.setStringValue(0, "XX/FIELD_N", "field_N value");
            this.x.clearXString();
            table.writeTo(this.x);
            byte[] mData = this.x.getXString();
            this.verify(Arrays.equals(mData, oData), "Wrong value for table " + table.getDescriptor().getName());
            ++j;
        }
    }

    public void testMarshallingTable_withManyRows() throws Exception {
        String data = "<FBSTRUCTURE1><item><FIELD1>0. field1 value</FIELD1><FIELD2>0. field2 value</FIELD2><XX_-FIELD_N>0. field_N value</XX_-FIELD_N></item><item><FIELD1>1. field1 value</FIELD1><FIELD2>1. field2 value</FIELD2><XX_-FIELD_N>1. field_N value</XX_-FIELD_N></item><item><FIELD1>2. field1 value</FIELD1><FIELD2>2. field2 value</FIELD2><XX_-FIELD_N>2. field_N value</XX_-FIELD_N></item><item><FIELD1>3. field1 value</FIELD1><FIELD2>3. field2 value</FIELD2><XX_-FIELD_N>3. field_N value</XX_-FIELD_N></item><item><FIELD1>4. field1 value</FIELD1><FIELD2>4. field2 value</FIELD2><XX_-FIELD_N>4. field_N value</XX_-FIELD_N></item><item><FIELD1>5. field1 value</FIELD1><FIELD2>5. field2 value</FIELD2><XX_-FIELD_N>5. field_N value</XX_-FIELD_N></item></FBSTRUCTURE1>";
        byte[] oData = data.getBytes(this.ENCODING);
        int j = 0;
        int jlen = descriptors.length;
        while (j < jlen) {
            EdoTable table = new EdoTable((IStructureDescriptor)descriptors[j]);
            table.append(6);
            int i = 0;
            while (i < 6) {
                table.setStringValue(i, "FIELD1", i + ". field1 value");
                table.setStringValue(i, "FIELD2", i + ". field2 value");
                table.setStringValue(i, "XX/FIELD_N", i + ". field_N value");
                ++i;
            }
            this.x.clearXString();
            table.writeTo(this.x);
            byte[] mData = this.x.getXString();
            this.verify(Arrays.equals(mData, oData), "Wrong value for table " + table.getDescriptor().getName());
            ++j;
        }
    }

    public void testUnmarshalingTable() throws Exception {
        String[][] dataStrings = tableDataStrings;
        int k = 0;
        int klen = dataStrings.length;
        while (k < klen) {
            String data = dataStrings[k][1];
            int j = 0;
            int jlen = descriptors.length;
            while (j < jlen) {
                EdoTable table = new EdoTable((IStructureDescriptor)descriptors[j]);
                this.x.setXString(data.getBytes(this.ENCODING));
                table.readFrom(this.x);
                this.verify(table.getRecordCount() == Integer.parseInt(dataStrings[k][2]), table.getDescriptor().getName() + " : Wrong number of rows");
                int row = 0;
                int rows = table.getRecordCount();
                while (rows < rows) {
                    int i = 0;
                    int len = fieldNValues.length;
                    while (i < len) {
                        String name = fieldNValues[i][0];
                        String value = fieldNValues[i][1];
                        this.verify(value.equals(table.getStringValue(row, name)), dataStrings[k][0] + " : " + table.getDescriptor().getName() + " : Wrong value for " + row + ',' + name, 1);
                        ++i;
                    }
                    ++row;
                }
                int row2 = 0;
                int rows2 = table.getRecordCount();
                while (rows2 < rows2) {
                    int i = 0;
                    int len = fieldNValues.length;
                    while (i < len) {
                        String name = fieldNValues[i][0];
                        String value = "Some bad value";
                        table.setStringValue(row2, name, value);
                        ++i;
                    }
                    ++row2;
                }
                this.x.setXString(data.getBytes(this.ENCODING));
                table.readFrom(this.x);
                this.verify(table.getRecordCount() == Integer.parseInt(dataStrings[k][2]), table.getDescriptor().getName() + " : Wrong number of rows");
                int row3 = 0;
                int rows3 = table.getRecordCount();
                while (rows3 < rows3) {
                    int i = 0;
                    int len = fieldNValues.length;
                    while (i < len) {
                        String name = fieldNValues[i][0];
                        String value = fieldNValues[i][1];
                        this.verify(value.equals(table.getStringValue(row3, name)), dataStrings[k][0] + " : " + table.getDescriptor().getName() + " : Wrong value for " + row3 + ',' + name, 1);
                        ++i;
                    }
                    ++row3;
                }
                ++j;
            }
            ++k;
        }
    }

    public void testMarshallingIndexTable() throws Exception {
        EdoIndexTable indexTable = new EdoIndexTable((IStructureDescriptor)AbstractTest.indexDesc, 0, 1);
        indexTable.clear();
        indexTable.addRelatedIndex(0, 1);
        this.x.clearXString();
        indexTable.writeTo(this.x);
        this.verify(Arrays.equals(indexTableDataStrings[0][1].getBytes(this.ENCODING), this.x.getXString()), "Wrong value for index table " + indexTableDataStrings[0][0], 1);
        indexTable.clear();
        indexTable.addRelatedIndex(0, 1);
        indexTable.addRelatedIndex(0, 2);
        indexTable.addRelatedIndex(1, 3);
        indexTable.addRelatedIndex(3, 4);
        this.x.clearXString();
        indexTable.writeTo(this.x);
        this.verify(Arrays.equals(indexTableDataStrings[2][1].getBytes(this.ENCODING), this.x.getXString()), "Wrong value for index table " + indexTableDataStrings[2][0], 1);
    }

    public void testUnmarshallingIndexTable() throws Exception {
        EdoIndexTable indexTable = new EdoIndexTable((IStructureDescriptor)AbstractTest.indexDesc, 0, 1);
        this.x.setXString(indexTableDataStrings[0][1].getBytes(this.ENCODING));
        indexTable.readFrom(this.x);
        int[][] indexes = new int[][]{{1}, new int[0]};
        int i = 0;
        int len = indexes.length;
        while (i < len) {
            int[] relatedIndexes = indexTable.getRelatedIndexes(i);
            this.verify(Arrays.equals(indexes[i], relatedIndexes), "Wrong relations index table " + indexTableDataStrings[0][0] + " at index " + 0 + " " + this.toString(relatedIndexes), 1);
            ++i;
        }
        this.x.setXString(indexTableDataStrings[1][1].getBytes(this.ENCODING));
        indexTable.readFrom(this.x);
        indexes = new int[][]{{1}, new int[0]};
        int i2 = 0;
        int len2 = indexes.length;
        while (i2 < len2) {
            int[] relatedIndexes = indexTable.getRelatedIndexes(i2);
            this.verify(Arrays.equals(indexes[i2], relatedIndexes), "Wrong relations index table " + indexTableDataStrings[0][0] + " at index " + 0 + " " + this.toString(relatedIndexes), 1);
            ++i2;
        }
        this.x.setXString(indexTableDataStrings[2][1].getBytes(this.ENCODING));
        indexTable.readFrom(this.x);
        indexes = new int[][]{{1, 2}, {3}, new int[0], {4}, new int[0]};
        int i3 = 0;
        int len3 = indexes.length;
        while (i3 < len3) {
            int[] relatedIndexes = indexTable.getRelatedIndexes(i3);
            this.verify(Arrays.equals(indexes[i3], relatedIndexes), "Wrong relations index table " + indexTableDataStrings[0][0] + " at index " + 0 + " " + this.toString(relatedIndexes), 1);
            ++i3;
        }
    }

    private String toString(int[] ia) {
        if (ia != null) {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            int i = 0;
            int len = ia.length;
            while (i < len) {
                buf.append(ia[i]).append(',');
                ++i;
            }
            buf.append(']');
            return buf.toString();
        }
        return null;
    }

    public void testMarshallingVariant() throws Exception {
        EdoStructure sVariant = new EdoStructure((IStructureDescriptor)AbstractTest.variantDesc);
        sVariant.clear();
        FieldDescriptor fieldDesc = (FieldDescriptor)sVariant.getDescriptor().getFieldDescriptor(2);
        fieldDesc.addVariant(AbstractTest.desc1);
        sVariant.setStringValue(0, structField1);
        sVariant.setStringValue(1, structField2);
        IEdoVariant variantValue = sVariant.getVariantValue(2, true);
        IEdoStructure s1 = variantValue.getValue(AbstractTest.desc1.getName(), true);
        s1.setStringValue(0, variantField1);
        s1.setStringValue(1, variantField2);
        s1.setStringValue(2, variantFieldN);
        this.x.setXString(null);
        sVariant.writeTo(this.x);
        byte[] mData = this.x.getXString();
        this.x.setXString(mData);
        EdoStructure sNewVariant = new EdoStructure((IStructureDescriptor)AbstractTest.variantDesc);
        sNewVariant.readFrom(this.x);
        IEdoVariant newVariantValue = sNewVariant.getVariantValue(2);
        IEdoStructure newS1 = newVariantValue.getValue();
        this.verify(s1.getStringValue(0).equals(newS1.getStringValue(0)), "Wrong value for field1", 1);
        this.verify(s1.getStringValue(1).equals(newS1.getStringValue(1)), "Wrong value for field2", 1);
        this.verify(s1.getStringValue(2).equals(newS1.getStringValue(2)), "Wrong value for field3", 1);
    }

    public void testMarshallingVariant2() throws Exception {
        EdoStructure sVariant = new EdoStructure((IStructureDescriptor)AbstractTest.variantDesc);
        sVariant.clear();
        FieldDescriptor fieldDesc = (FieldDescriptor)sVariant.getDescriptor().getFieldDescriptor(2);
        fieldDesc.addVariant(AbstractTest.desc1);
        sVariant.setStringValue(0, structField1);
        sVariant.setStringValue(1, structField2);
        IEdoVariant variantValue = sVariant.getVariantValue(2, true);
        IEdoStructure s1 = variantValue.getValue(AbstractTest.desc1.getName(), true);
        s1.setStringValue(0, variantField1);
        s1.setStringValue(1, variantField2);
        s1.setStringValue(2, variantFieldN);
        this.x.setXString(null);
        sVariant.writeTo(this.x);
        byte[] mData = this.x.getXString();
        this.x.setXString(mData);
        EdoStructure sNewVariant = new EdoStructure((IStructureDescriptor)AbstractTest.variantDesc);
        sNewVariant.readFrom(this.x);
        this.x.setXString(null);
        sNewVariant.writeTo(this.x);
        byte[] mNewData = this.x.getXString();
        this.verify(Arrays.equals(mData, mNewData), "Error in Lazy serializing");
    }
}

