/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.edo.AbstractTest;
import com.sap.tc.col.edo.core.Base64;
import com.sap.tc.col.edo.core.TypeHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TestTypeHelper
extends AbstractTest {
    public void testString() {
        TypeHelper.Type type = TypeHelper.getType("STRING");
        String defaultValue = "";
        this.verify(defaultValue.equals(type.parse(null)), "Parse failed for null.", 1);
        this.verify(defaultValue.equals(type.parse("")), "Parse failed for empty string.", 1);
        this.verify(null == type.format(null), "format failed for null.", 1);
        this.verify(defaultValue.equals(type.format("")), "format failed for empty string.", 1);
        String str1 = "A simple non-empty string.";
        this.verify(str1.equals(type.parse(str1)), "Parse failed for non empty string.", 1);
        this.verify(str1.equals(type.format(str1)), "Format failed for non empty string.", 1);
    }

    public void testInt() {
        TypeHelper.Type type = TypeHelper.getType("INTEGER");
        Integer defaultValue = new Integer(0);
        this.verify(defaultValue.equals(type.parse(null)), "Parse failed for null.", 1);
        this.verify(defaultValue.equals(type.parse("")), "Parse failed for empty string.", 1);
        this.verify(null == type.format(null), "format failed for null.", 1);
        String str1 = "100";
        Integer val1 = new Integer(100);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a number.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for a number.", 1);
        String str2 = "-100";
        Integer val2 = new Integer(-100);
        this.verify(val2.equals(type.parse(str2)), "Parse failed for a negative number.", 1);
        this.verify(str2.equals(type.format(val2)), "Format failed for a negative number.", 1);
    }

    public void testDouble() {
        TypeHelper.Type type = TypeHelper.getType("DOUBLE");
        Double defaultValue = new Double(0.0);
        this.verify(defaultValue.equals(type.parse(null)), "Parse failed for null.", 1);
        this.verify(defaultValue.equals(type.parse("")), "Parse failed for empty string.", 1);
        this.verify(null == type.format(null), "Format failed for null.", 1);
        String str1 = "100.0123";
        Double val1 = new Double(100.0123);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a number.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for a number.", 1);
        String str2 = "-100.0123";
        Double val2 = new Double(-100.0123);
        this.verify(val2.equals(type.parse(str2)), "Parse failed for a negative number.", 1);
        this.verify(str2.equals(type.format(val2)), "Format failed for a negative number.", 1);
    }

    public void testBigDecimal() {
        TypeHelper.Type type = TypeHelper.getType("DECIMAL");
        this.verify(null == type.parse(null), "Parse failed for null.", 1);
        this.verify(null == type.parse(""), "Parse failed for empty string.", 1);
        this.verify(null == type.format(null), "format failed for null.", 1);
        String str1 = "100.0123";
        BigDecimal val1 = new BigDecimal(str1);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a number.", 1);
        this.verify(str1.equals(type.format(val1)), "format failed for a number.", 1);
        String str2 = "-100.0123";
        BigDecimal val2 = new BigDecimal(str2);
        this.verify(val2.equals(type.parse(str2)), "Parse failed for a negative number.", 1);
        this.verify(str2.equals(type.format(val2)), "Format failed for a negative number.", 1);
    }

    public void testDate() {
        TypeHelper.Type type = TypeHelper.getType("DATE");
        this.verify(type.parse(null) == null, "Parse failed for null.", 1);
        this.verify(type.parse("") == null, "Parse failed for empty string.", 1);
        this.verify(type.parse("0000-00-00") == null, "Parse failed for default date.", 1);
        this.verify(type.format(null) == null, "Format failed for null.", 1);
        String str1 = "2001-12-13";
        Date val1 = Date.valueOf(str1);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a date.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for a date.", 1);
    }

    public void testTime() {
        TypeHelper.Type type = TypeHelper.getType("TIME");
        this.verify(type.parse(null) == null, "Parse failed for null.", 1);
        this.verify(type.parse("") == null, "Parse failed for empty string.", 1);
        this.verify(type.format(null) == null, "Format failed for null.", 1);
        String str1 = "12:12:13";
        Time val1 = Time.valueOf(str1);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a time.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for a time.", 1);
    }

    public void testTimestamp() {
        TypeHelper.Type type = TypeHelper.getType("TIMESTAMP");
        this.verify(type.parse(null) == null, "Parse failed for null.", 1);
        this.verify(type.parse("") == null, "Parse failed for empty string.", 1);
        this.verify(type.format(null) == null, "Format failed for null.", 1);
        this.verify(type.parse("0") == null, "Parse failed for default timestamp.", 1);
        this.verify(type.parse("00000000.0") == null, "Parse failed for default timestamp.", 1);
        this.verify(type.parse("00000000000000.0") == null, "Parse failed for default timestamp.", 1);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        String str1 = "20011213121201.123";
        cal.clear();
        cal.set(2001, 11, 13, 12, 12, 1);
        Timestamp val1 = new Timestamp(cal.getTime().getTime());
        val1.setNanos(123000000);
        this.verify(val1.equals(type.parse(str1)), "Parse failed for a time.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for a time.", 1);
        String str2 = "20011213121201";
        cal.clear();
        cal.set(2001, 11, 13, 12, 12, 1);
        Timestamp val2 = new Timestamp(cal.getTime().getTime());
        this.verify(val2.equals(type.parse(str2)), "Parse failed for a time.", 1);
        this.verify(str2.equals(type.format(val2)), "Format failed for a time.", 1);
    }

    public void testBoolean() {
        TypeHelper.Type type = TypeHelper.getType("BOOLEAN");
        this.verify(Boolean.FALSE.equals(type.parse(null)), "Parse failed for null.", 1);
        this.verify(Boolean.FALSE.equals(type.parse("")), "Parse failed for empty string.", 1);
        this.verify(null == type.format(null), "Format failed for null.", 1);
        String str1 = "X";
        Boolean val1 = Boolean.TRUE;
        this.verify(val1.equals(type.parse(str1)), "Parse failed for true.", 1);
        this.verify(str1.equals(type.format(val1)), "Format failed for true.", 1);
        String str2 = " ";
        Boolean val2 = Boolean.FALSE;
        this.verify(val2.equals(type.parse(str2)), "Parse failed for false.", 1);
        this.verify(str2.equals(type.format(val2)), "Format failed for false.", 1);
    }

    public void testBinary() {
        TypeHelper.Type type = TypeHelper.getType("BINARY");
        this.verify(type.parse(null) == null, "Parse failed for null.", 1);
        this.verify(type.parse("") == null, "Parse failed for empty string.", 1);
        this.verify(type.format(null) == null, "Format failed for null.", 1);
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        String str1 = Base64.byteArrayToBase64(data);
        this.verify(Arrays.equals(data, (byte[])type.parse(str1)), "Parse failed.", 1);
        this.verify(str1.equals(type.format(data)), "format failed.", 1);
    }
}

