/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.AbstractTest;
import com.sap.tc.col.edo.core.EdoStructure;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class TestStructure
extends AbstractTest {
    private final EdoStructure s1 = new EdoStructure((IStructureDescriptor)AbstractTest.desc1);
    private final EdoStructure s1a = new EdoStructure((IStructureDescriptor)AbstractTest.desc1a);
    private final EdoStructure s3 = new EdoStructure((IStructureDescriptor)AbstractTest.desc3);
    private final EdoStructure s11 = new EdoStructure((IStructureDescriptor)AbstractTest.desc1);
    private final EdoStructure s4 = new EdoStructure((IStructureDescriptor)AbstractTest.desc4);
    private static final String value1 = "First Value";
    private static final String value2 = "Second Value";
    private static final String valueX = "Another Value";

    public void testGetMeta() {
        this.verify("S".equals(this.s1.getMeta()), "Incorrect meta");
        this.verify("S".equals(this.s1a.getMeta()), "Incorrect meta");
        this.verify("S".equals(this.s3.getMeta()), "Incorrect meta");
        this.verify("S".equals(this.s11.getMeta()), "Incorrect meta");
    }

    public void testClear() {
        this.s1.setStringValue("FIELD1", value1);
        this.s1.setStringValue("FIELD2", value2);
        this.verify(null != this.s1.getStringValue(0), "Wrong Field Value");
        this.verify(null != this.s1.getStringValue(1), "Wrong Field Value");
        this.s1.clear();
        this.verify("".equals(this.s1.getStringValue(0)), "Wrong Field Value");
        this.verify("".equals(this.s1.getStringValue(1)), "Wrong Field Value");
    }

    public void testGetnSetValue() {
        this.s4.clear();
        int value0 = 1;
        GregorianCalendar cal = new GregorianCalendar(Locale.US);
        cal.clear();
        cal.set(2003, 3, 24);
        java.sql.Date value1 = new java.sql.Date(cal.getTime().getTime());
        String value2 = "This is generic test";
        boolean value3 = true;
        cal.clear();
        cal.set(1970, 0, 1, 12, 12, 34);
        Time value4 = new Time(cal.getTime().getTime());
        double value5 = 9.12345;
        BigDecimal value6 = new BigDecimal(value5);
        Timestamp value7 = new Timestamp(new Date().getTime());
        value7.setNanos(123006007);
        byte[] value8 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        this.s4.setValue("FIELDINT", (Object)new Integer(value0));
        this.s4.setValue("FIELDDATE", (Object)value1);
        this.s4.setValue("FIELDSTR", (Object)value2);
        this.s4.setValue("FIELDBOOLEAN", (Object)new Boolean(value3));
        this.s4.setValue("FIELDTIME", (Object)value4);
        this.s4.setValue("FIELDDOUBLE", (Object)new Double(value5));
        this.s4.setValue("FIELDDECIMAL", (Object)value6);
        this.s4.setValue("FIELDTIMESTAMP", (Object)value7);
        this.s4.setValue("FIELDBINARY", (Object)value8);
        this.verify(value0 == this.s4.getIntValue("FIELDINT"), "Wrong Field Value", 1);
        this.verify(value1.equals(this.s4.getDateValue("FIELDDATE")), "Wrong Field Value", 1);
        this.verify(value2.equals(this.s4.getStringValue("FIELDSTR")), "Wrong Field Value", 1);
        this.verify(value3 == this.s4.getBooleanValue("FIELDBOOLEAN"), "Wrong Field Value", 1);
        this.verify(value4.equals(this.s4.getTimeValue("FIELDTIME")), "Wrong Field Value", 1);
        this.verify(value5 == this.s4.getDoubleValue("FIELDDOUBLE"), "Wrong Field Value", 1);
        this.verify(value6.equals(this.s4.getDecimalValue("FIELDDECIMAL")), "Wrong Field Value", 1);
        Timestamp ts = this.s4.getTimestampValue("FIELDTIMESTAMP");
        this.verify(((Date)value7).getTime() == ((Date)ts).getTime() && value7.getNanos() / 100 * 100 == ts.getNanos(), "Wrong Field Value", 1);
        byte[] data = this.s4.getBinaryValue("FIELDBINARY");
        this.verify(Arrays.equals(data, value8), "Wrong Field Value", 1);
        this.s4.clear();
        this.s4.setIntValue(0, value0);
        this.s4.setDateValue(1, value1);
        this.s4.setStringValue(2, value2);
        this.s4.setBooleanValue(3, value3);
        this.s4.setTimeValue(4, value4);
        this.s4.setDoubleValue(5, value5);
        this.s4.setDecimalValue(6, value6);
        this.s4.setTimestampValue(7, value7);
        this.s4.setValue(8, (Object)value8);
        this.verify(value0 == (Integer)this.s4.getValue(0), "Wrong Field Value");
        this.verify(value1.toString().equals(this.s4.getValue(1).toString()), "Wrong Field Value");
        this.verify(value2.equals(this.s4.getValue(2)), "Wrong Field Value");
        this.verify(value3 == (Boolean)this.s4.getValue(3), "Wrong Field Value");
        this.verify(value4.toString().equals(this.s4.getValue(4).toString()), "Wrong Field Value");
        this.verify(value5 == (Double)this.s4.getValue(5), "Wrong Field Value");
        this.verify(value6.equals(this.s4.getValue(6)), "Wrong Field Value");
        ts = (Timestamp)this.s4.getValue(7);
        this.verify(((Date)value7).getTime() == ((Date)ts).getTime() && value7.getNanos() / 100 * 100 == ts.getNanos(), "Wrong Field Value");
        data = this.s4.getBinaryValue(8);
        this.verify(Arrays.equals(data, value8), "Wrong Field Value", 1);
    }

    public void testGetnSetStringValue() {
        this.s1.clear();
        this.s1.setStringValue("FIELD1", value1);
        this.s1.setStringValue("FIELD2", value2);
        this.verify(value1 == this.s1.getStringValue("FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.s1.getStringValue(0), "Wrong Field Value");
        this.verify(value2 == this.s1.getStringValue("FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.s1.getStringValue(1), "Wrong Field Value");
        this.s1.setStringValue("FIELD1", value2);
        this.s1.setStringValue("FIELD2", value1);
        this.verify(value2 == this.s1.getStringValue("FIELD1"), "Wrong Field Value");
        this.verify(value2 == this.s1.getStringValue(0), "Wrong Field Value");
        this.verify(value1 == this.s1.getStringValue("FIELD2"), "Wrong Field Value");
        this.verify(value1 == this.s1.getStringValue(1), "Wrong Field Value");
    }

    public void testSetFrom() {
        this.s1.clear();
        this.s11.clear();
        this.s1.setStringValue("FIELD1", value1);
        this.s1.setStringValue("FIELD2", value2);
        this.s11.setFrom(this.s1);
        this.verify(value1 == this.s11.getStringValue("FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.s11.getStringValue(0), "Wrong Field Value");
        this.verify(value2 == this.s11.getStringValue("FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.s11.getStringValue(1), "Wrong Field Value");
    }

    public void testSetCorresponding() {
        this.s1.clear();
        this.s1a.clear();
        this.s3.clear();
        this.s1.setStringValue("FIELD1", value1);
        this.s1.setStringValue("FIELD2", value2);
        this.s1a.setCorrespondingFrom(this.s1);
        this.verify(value1 == this.s1a.getStringValue("FIELD1"), "Wrong Field Value", 1);
        this.verify(value1 == this.s1a.getStringValue(0), "Wrong Field Value", 1);
        this.verify(value2 == this.s1a.getStringValue("FIELD2"), "Wrong Field Value", 1);
        this.verify(value2 == this.s1a.getStringValue(1), "Wrong Field Value", 1);
        this.verify("".equals(this.s1a.getStringValue("FIELDX")), "Wrong Field Value", 1);
        this.verify("".equals(this.s1a.getStringValue(2)), "Wrong Field Value", 1);
        this.s3.setCorrespondingFrom(this.s1);
        this.verify("".equals(this.s3.getStringValue("FIELD12")), "Wrong Field Value", 1);
        this.verify("".equals(this.s3.getStringValue(0)), "Wrong Field Value", 1);
        this.verify("".equals(this.s3.getStringValue("FIELD13")), "Wrong Field Value", 1);
        this.verify("".equals(this.s3.getStringValue(1)), "Wrong Field Value", 1);
        this.s1.clear();
        this.s1a.clear();
        this.s1a.setStringValue("FIELD1", value1);
        this.s1a.setStringValue("FIELD2", value2);
        this.s1a.setStringValue("FIELDX", valueX);
        this.s1.setCorrespondingFrom(this.s1a);
        this.verify(value1 == this.s1.getStringValue("FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.s1.getStringValue(0), "Wrong Field Value");
        this.verify(value2 == this.s1.getStringValue("FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.s1.getStringValue(1), "Wrong Field Value");
    }

    public void testGetValueInitial() {
        this.s4.clear();
        this.verify(new Integer(0).equals(this.s4.getValue("FIELDINT")), "For null value should return a null object", 1);
        this.verify("".equals(this.s4.getValue("FIELDSTR")), "For null value should return a null object", 1);
        this.verify(Boolean.FALSE.equals(this.s4.getValue("FIELDBOOLEAN")), "For null value should return a null object", 1);
        this.verify(new Double(0.0).equals(this.s4.getValue("FIELDDOUBLE")), "For null value should return a null object", 1);
        this.verify(null == this.s4.getValue("FIELDDATE"), "For null value should return a null object", 1);
        this.verify(null == this.s4.getValue("FIELDTIME"), "For null value should return a null object", 1);
        this.verify(null == this.s4.getValue("FIELDTIMESTAMP"), "For null value should return a null object", 1);
        this.verify(null == this.s4.getValue("FIELDDECIMAL"), "For null value should return a null object", 1);
        try {
            this.verify(null == this.s4.getDateValue("FIELDDATE"), "Should be equal to null", 1);
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
        try {
            this.verify(null == this.s4.getTimeValue("FIELDTIME"), "Should be equal to null", 1);
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
        try {
            this.verify(null == this.s4.getTimestampValue("FIELDTIMESTAMP"), "Should be equal to null", 1);
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
        try {
            this.verify(null == this.s4.getDecimalValue("FIELDDECIMAL"), "Should be equal to null");
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
        try {
            this.verify("".equals(this.s4.getStringValue("FIELDSTR")), "Should be empty", 1);
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
        try {
            this.verify(null == this.s4.getBinaryValue("FIELDBINARY"), "Should be equal to null", 1);
        }
        catch (Exception e) {
            this.flop("For initial structure null values, should never throw an exception", 1);
        }
    }

    public void testGenSetNullValue() {
        this.s4.clear();
        String default_string = "";
        Boolean default_boolean = Boolean.FALSE;
        Double default_double = new Double(0.0);
        Integer default_integer = new Integer(0);
        int i = 0;
        int len = this.s4.getFieldCount();
        while (i < len) {
            IFieldDescriptor fd = this.s4.getDescriptor().getFieldDescriptor(i);
            this.verify(this.s4.isInitial(i), "is initial returned false for " + fd.getName(), 1);
            ++i;
        }
        int i2 = 0;
        int len2 = this.s4.getFieldCount();
        while (i2 < len2) {
            IFieldDescriptor fd = this.s4.getDescriptor().getFieldDescriptor(i2);
            if ("STRING".equals(fd.getType())) {
                this.verify(default_string.equals(this.s4.getValue(i2)), "getValue not null for field " + fd.getName(), 1);
            } else if ("BOOLEAN".equals(fd.getType())) {
                this.verify(((Object)default_boolean).equals(this.s4.getValue(i2)), "getValue not null for field " + fd.getName(), 1);
            } else if ("INTEGER".equals(fd.getType())) {
                this.verify(((Object)default_integer).equals(this.s4.getValue(i2)), "getValue not null for field " + fd.getName(), 1);
            } else if ("DOUBLE".equals(fd.getType())) {
                this.verify(((Object)default_double).equals(this.s4.getValue(i2)), "getValue not null for field " + fd.getName(), 1);
            } else {
                this.verify(null == this.s4.getValue(i2), "getValue not null for field " + fd.getName(), 1);
            }
            ++i2;
        }
        int i3 = 0;
        int len3 = this.s4.getFieldCount();
        while (i3 < len3) {
            IFieldDescriptor fd = this.s4.getDescriptor().getFieldDescriptor(i3);
            try {
                this.s4.setValue(i3, null);
            }
            catch (Exception ex) {
                this.flop("setValue with null failed field " + fd.getName(), 1);
            }
            ++i3;
        }
        this.s4.clear();
    }
}

