/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.EdoException;
import com.sap.tc.col.edo.core.AbapNameHelper;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.EdoAtomicValue;
import com.sap.tc.col.edo.core.EdoConstants;
import com.sap.tc.col.edo.core.EdoIndexTable;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.EmptyStackException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventHandler
extends DefaultHandler
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler = SAXEventHandler.class$("com.sap.tc.col.edo.core.SAXEventHandler")) : class$com$sap$tc$col$edo$core$SAXEventHandler).getName();
    static final Location _location = Location.getLocation((String)_className);
    private final Stack m_stack = new Stack(12);
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler;

    public void setValueHandler(AbstractNodeHandler handler) {
        this.m_stack.clear();
        this.m_stack.push(handler);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        try {
            boolean done = false;
            while (!done && !this.m_stack.isEmpty()) {
                AbstractNodeHandler handler = this.m_stack.peek();
                done = handler.content(buf, offset, len, this.m_stack);
            }
        }
        catch (Exception ex) {
            SAXException ex1 = new SAXException(ex);
            throw ex1;
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        try {
            boolean done = false;
            while (!done && !this.m_stack.isEmpty()) {
                AbstractNodeHandler handler = this.m_stack.peek();
                done = handler.endElement(sName, this.m_stack);
            }
        }
        catch (Exception ex) {
            SAXException ex1 = new SAXException(ex);
            throw ex1;
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        try {
            boolean done = false;
            while (!done && !this.m_stack.isEmpty()) {
                AbstractNodeHandler handler = this.m_stack.peek();
                done = handler.startElement(sName, attrs, this.m_stack);
            }
        }
        catch (Exception ex) {
            SAXException ex1 = new SAXException(ex);
            throw ex1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/SAXEventHandler.java#1 $");
    }

    public static final class Variant
    extends AbstractValue {
        private EdoVariant m_variant;
        private Structure m_structure = new Structure();

        public void setVariant(EdoVariant variant) {
            this.m_variant = variant;
        }

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            try {
                String abapName = AbapNameHelper.convertXmlToAbap(name);
                EdoStructure structure = this.m_variant.createValue(abapName);
                this.m_variant.setValue(structure);
                this.m_structure.setRecord(structure);
                stack.push(this.m_structure);
            }
            catch (IllegalArgumentException ex) {
                EdoException nex = new EdoException(ex.getMessage(), ex);
                throw nex;
            }
            return false;
        }

        public boolean endElement(String name, Stack stack) {
            stack.pop();
            return false;
        }

        public Object getValue() {
            return this.m_variant;
        }

        public void clear() {
            this.m_variant = null;
        }
    }

    public static final class IndexTable
    extends CompoundValue {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$IndexTable == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$IndexTable = IndexTable.class$("com.sap.tc.col.edo.core.SAXEventHandler$IndexTable")) : class$com$sap$tc$col$edo$core$SAXEventHandler$IndexTable).getName();
        private static final TypeHelper.Type indexType = TypeHelper.getType("TABLE_INDEX");
        private EdoIndexTable m_indexTable;
        private int m_recordIndex = 0;
        private int m_fieldIndex = -1;
        private int m_srcIndex;
        private int m_relIndex;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$IndexTable;

        public void setIndexTable(EdoIndexTable indexTable) {
            this.m_indexTable = indexTable;
            this.setStructure(indexTable.m_descriptor);
        }

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    this.assertStructure(name);
                    this.m_fieldIndex = -2;
                    this.m_indexTable.clearInternal();
                    break;
                }
                case -2: {
                    if (!"item".equals(name)) {
                        EdoException ex = new EdoException("Unexpected tag : " + name + "<>" + "item");
                        throw ex;
                    }
                    this.m_fieldIndex = -3;
                    ++this.m_recordIndex;
                    this.m_srcIndex = -1;
                    this.m_relIndex = -1;
                    break;
                }
                case -3: {
                    this.m_fieldIndex = this.startField(name, stack);
                    break;
                }
                default: {
                    EdoException ex = new EdoException("Start element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
            }
            return true;
        }

        public boolean endElement(String name, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    EdoException ex = new EdoException("End element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
                case -2: {
                    this.m_fieldIndex = -1;
                    stack.pop();
                    break;
                }
                case -3: {
                    if (this.m_srcIndex == -1) {
                        EdoException ex = new EdoException("Source field not found in record " + this.m_recordIndex);
                        throw ex;
                    }
                    if (this.m_relIndex == -1) {
                        EdoException ex = new EdoException("Related field not found in record " + this.m_recordIndex);
                        throw ex;
                    }
                    this.m_indexTable.addRelatedIndexInternal(this.m_srcIndex, this.m_relIndex);
                    this.m_fieldIndex = -2;
                    break;
                }
                case 0x7FFFFFFF: {
                    this.skipField(name);
                    this.m_fieldIndex = -3;
                    break;
                }
                default: {
                    if (this.m_fieldIndex == this.m_indexTable.m_srcFieldIndex) {
                        this.m_srcIndex = indexType.parseInt((String)this.endField(name));
                    } else if (this.m_fieldIndex == this.m_indexTable.m_relFieldIndex) {
                        this.m_relIndex = indexType.parseInt((String)this.endField(name));
                    } else {
                        this.skipField(name);
                    }
                    this.m_fieldIndex = -3;
                }
            }
            return true;
        }

        public Object getValue() {
            return this.m_indexTable;
        }

        public void clear() {
            this.m_indexTable = null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Table
    extends CompoundValue {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$Table == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$Table = Table.class$("com.sap.tc.col.edo.core.SAXEventHandler$Table")) : class$com$sap$tc$col$edo$core$SAXEventHandler$Table).getName();
        private EdoTable m_table;
        private int m_recordIndex = -1;
        private int m_fieldIndex = -1;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$Table;

        public void setTable(EdoTable table) {
            this.m_table = table;
            this.setStructure(table.getDescriptor());
        }

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    this.assertStructure(name);
                    this.m_fieldIndex = -2;
                    this.m_table.clearInternal();
                    this.m_recordIndex = -1;
                    break;
                }
                case -2: {
                    if (!"item".equals(name)) {
                        EdoException ex = new EdoException("Unexpected tag : " + name + "<>" + "item");
                        throw ex;
                    }
                    this.m_fieldIndex = -3;
                    this.m_table.appendInternal();
                    ++this.m_recordIndex;
                    break;
                }
                case -3: {
                    this.m_fieldIndex = this.startField(name, stack);
                    break;
                }
                default: {
                    EdoException ex = new EdoException("Start element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
            }
            return true;
        }

        public boolean endElement(String name, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    EdoException ex = new EdoException("End element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
                case -2: {
                    this.m_fieldIndex = -1;
                    stack.pop();
                    break;
                }
                case -3: {
                    this.m_fieldIndex = -2;
                    break;
                }
                case 0x7FFFFFFF: {
                    this.skipField(name);
                    this.m_fieldIndex = -3;
                    break;
                }
                default: {
                    this.m_table.setValueInternal(this.m_recordIndex, this.m_fieldIndex, this.endField(name));
                    this.m_fieldIndex = -3;
                }
            }
            return true;
        }

        public Object getValue() {
            return this.m_table;
        }

        public void clear() {
            this.m_table = null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class Structure
    extends CompoundValue {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$Structure == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$Structure = Structure.class$("com.sap.tc.col.edo.core.SAXEventHandler$Structure")) : class$com$sap$tc$col$edo$core$SAXEventHandler$Structure).getName();
        private EdoStructure m_structure;
        private int m_fieldIndex = -1;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$Structure;

        public void setRecord(EdoStructure structure) {
            this.m_structure = structure;
            this.setStructure(structure.m_descriptor);
        }

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    this.assertStructure(name);
                    this.m_fieldIndex = -2;
                    this.m_structure.clearInternal();
                    break;
                }
                case -2: {
                    this.m_fieldIndex = this.startField(name, stack);
                    break;
                }
                default: {
                    EdoException ex = new EdoException("Start element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
            }
            return true;
        }

        public boolean endElement(String name, Stack stack) {
            switch (this.m_fieldIndex) {
                case -1: {
                    EdoException ex = new EdoException("End element not expected when fieldIndex is " + this.m_fieldIndex);
                    throw ex;
                }
                case -2: {
                    this.m_fieldIndex = -1;
                    stack.pop();
                    break;
                }
                case 0x7FFFFFFF: {
                    this.skipField(name);
                    this.m_fieldIndex = -2;
                    break;
                }
                default: {
                    this.m_structure.setValueInternal(this.m_fieldIndex, this.endField(name));
                    this.m_fieldIndex = -2;
                }
            }
            return true;
        }

        public Object getValue() {
            return this.m_structure;
        }

        public void clear() {
            this.m_structure = null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static abstract class CompoundValue
    extends AbstractValue {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$CompoundValue == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$CompoundValue = CompoundValue.class$("com.sap.tc.col.edo.core.SAXEventHandler$CompoundValue")) : class$com$sap$tc$col$edo$core$SAXEventHandler$CompoundValue).getName();
        protected static final int UNKNOWN_FIELD = Integer.MAX_VALUE;
        private IStructureDescriptor m_descriptor;
        private AbstractValue fieldValue;
        private SimpleValue simpleValue = new SimpleValue();
        private Variant variantValue;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$CompoundValue;

        public final void setStructure(IStructureDescriptor descriptor) {
            this.m_descriptor = descriptor;
        }

        public final int startField(String xmlName, Stack stack) {
            int fieldIndex = this.m_descriptor.getFieldIndex(xmlName);
            if (fieldIndex == -1) {
                String abapname = AbapNameHelper.convertXmlToAbap(xmlName);
                fieldIndex = this.m_descriptor.getFieldIndex(abapname);
            }
            if (fieldIndex >= 0) {
                this.fieldValue = this.simpleValue;
            } else {
                this.fieldValue = this.simpleValue;
                fieldIndex = Integer.MAX_VALUE;
            }
            stack.push(this.fieldValue);
            return fieldIndex;
        }

        public final Object endField(String name) {
            Object value = this.fieldValue.getValue();
            this.fieldValue.clear();
            this.fieldValue = null;
            return value;
        }

        public final void skipField(String name) {
            this.fieldValue.clear();
            this.fieldValue = null;
        }

        public final void assertStructure(String name) {
            String structName = this.m_descriptor.getName();
            if (!structName.equals(name) && !structName.equals(AbapNameHelper.convertXmlToAbap(name))) {
                EdoException ex = new EdoException("Unexpected tag : " + name + "<>" + structName);
                throw ex;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class AtomicValue
    extends SimpleValue {
        EdoAtomicValue m_value;

        public void setValue(EdoAtomicValue value) {
            this.m_value = value;
        }

        public Object getValue() {
            return this.m_value;
        }

        public void clear() {
            super.clear();
            this.m_value = null;
        }

        public boolean endElement(String name, Stack stack) {
            boolean done = super.endElement(name, stack);
            if (!done) {
                this.m_value.setStringValueInternal(this.getStringValue());
            }
            return done;
        }
    }

    public static class SimpleValue
    extends AbstractValue {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$SimpleValue == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$SimpleValue = SimpleValue.class$("com.sap.tc.col.edo.core.SAXEventHandler$SimpleValue")) : class$com$sap$tc$col$edo$core$SAXEventHandler$SimpleValue).getName();
        private static final String EMPTY = "";
        protected StringBuffer m_buffer = null;
        protected String m_strvalue = "";
        protected boolean skipEndTag = false;
        static final String[] charStringCache;
        static final int charStringCacheSize = 128;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$SimpleValue;

        public boolean endElement(String name, Stack stack) {
            if (this.skipEndTag) {
                this.skipEndTag = false;
                return true;
            }
            stack.pop();
            return false;
        }

        public boolean content(char[] buf, int offset, int len, Stack stack) {
            if (this.m_strvalue == EMPTY) {
                String str;
                char cacheIndex;
                this.m_strvalue = len == 1 ? ((cacheIndex = buf[offset]) < '\u0080' ? ((str = charStringCache[cacheIndex]) == null ? new String(buf, offset, len) : str) : new String(buf, offset, len)) : new String(buf, offset, len);
            } else if (this.m_strvalue != null) {
                this.m_buffer = new StringBuffer(this.m_strvalue.length() + len);
                this.m_buffer.append(this.m_strvalue);
                this.m_buffer.append(buf, offset, len);
                this.m_strvalue = null;
            } else if (this.m_buffer != null) {
                this.m_buffer.append(buf, offset, len);
            }
            return true;
        }

        public final String getStringValue() {
            if (this.m_strvalue == null) {
                this.m_strvalue = this.m_buffer.capacity() == this.m_buffer.length() ? this.m_buffer.toString() : this.m_buffer.substring(0);
                this.m_buffer = null;
            }
            return this.m_strvalue;
        }

        public Object getValue() {
            return this.getStringValue();
        }

        public void clear() {
            this.m_buffer = null;
            this.m_strvalue = EMPTY;
        }

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            if (attribs.getLength() == 1 && EdoConstants.VALUE_ELEMENT.equals(name) && EdoConstants.VALUE_ATTRIBUTE.equals(attribs.getLocalName(0))) {
                this.m_strvalue = attribs.getValue(0);
                this.skipEndTag = true;
                return true;
            }
            return super.startElement(name, attribs, stack);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'X', 'Y', 'x', 'y', ' ', '?', '.', ',', '\'', '\"', '\\', '_', '-', '#', '/', '&', ';', '<', '>'};
            charStringCache = new String[128];
            String buffer = new String(chars);
            int i = 0;
            int len = chars.length;
            while (i < len) {
                SimpleValue.charStringCache[chars[i]] = buffer.substring(i, i + 1);
                ++i;
            }
        }
    }

    public static abstract class AbstractValue
    extends AbstractNodeHandler {
        public abstract Object getValue();

        public abstract void clear();
    }

    public static abstract class AbstractNodeHandler
    implements CCDirectives {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventHandler$AbstractValue == null ? (class$com$sap$tc$col$edo$core$SAXEventHandler$AbstractValue = AbstractNodeHandler.class$("com.sap.tc.col.edo.core.SAXEventHandler$AbstractValue")) : class$com$sap$tc$col$edo$core$SAXEventHandler$AbstractValue).getName();
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventHandler$AbstractValue;

        public boolean startElement(String name, Attributes attribs, Stack stack) {
            EdoException ex = new EdoException(this.getClass().getName() + ": Start element not expected, got " + name);
            throw ex;
        }

        public boolean endElement(String name, Stack stack) {
            EdoException ex = new EdoException(this.getClass().getName() + ": End element not expected, got  " + name);
            throw ex;
        }

        public boolean content(char[] buf, int offset, int len, Stack stack) {
            if (new String(buf, offset, len).trim().length() > 0) {
                EdoException ex = new EdoException(this.getClass().getName() + ": Content not expected.");
                throw ex;
            }
            return true;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public final class Stack {
        private AbstractNodeHandler[] m_array;
        private int m_index;

        public Stack(int initialSize) {
            if (initialSize < 4) {
                initialSize = 4;
            }
            this.m_array = new AbstractNodeHandler[initialSize];
            this.m_index = -1;
        }

        public AbstractNodeHandler push(AbstractNodeHandler item) {
            int index = this.m_index + 1;
            try {
                this.m_array[index] = item;
            }
            catch (IndexOutOfBoundsException ex) {
                int size = this.m_array.length;
                if (index != size) {
                    throw ex;
                }
                AbstractNodeHandler[] array = new AbstractNodeHandler[size * 2];
                System.arraycopy(this.m_array, 0, array, 0, size);
                Arrays.fill(this.m_array, null);
                this.m_array = array;
                this.m_array[index] = item;
            }
            this.m_index = index;
            return item;
        }

        public AbstractNodeHandler pop() {
            try {
                AbstractNodeHandler item = this.m_array[this.m_index];
                this.m_array[this.m_index] = null;
                --this.m_index;
                return item;
            }
            catch (IndexOutOfBoundsException ex) {
                if (this.m_index == -1) {
                    throw new EmptyStackException();
                }
                throw ex;
            }
        }

        public AbstractNodeHandler peek() {
            try {
                return this.m_array[this.m_index];
            }
            catch (IndexOutOfBoundsException ex) {
                if (this.m_index == -1) {
                    throw new EmptyStackException();
                }
                throw ex;
            }
        }

        public boolean isEmpty() {
            return this.m_index == -1;
        }

        public void clear() {
            Arrays.fill(this.m_array, null);
            this.m_index = -1;
        }
    }
}

