/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.AbstractPerfTest;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.core.EdoTable;

public class PerfTestTable
extends AbstractPerfTest {
    private static final int NO_OF_FIELDS = 20;
    private static final int NO_OF_ROWS = 1000;
    private static final int NO_OF_REPEATS = 100;
    private static final String START = "Start";
    private static final String FILL = "Fill Table";
    private static final String SERIALIZE = "Serialize Table";
    private static final String CLEAR = "Clear Table";
    private static final String DESERIALIZE = "Deserialize Table";
    private static final String END = "End";

    public static void main(String[] args) {
        PerfTestTable test = new PerfTestTable();
        test.perfTest_table();
    }

    public void perfTest_table() {
        EdoTable table = new EdoTable((IStructureDescriptor)this.getDescriptor(20));
        int i = 0;
        while (i < 100) {
            this.logTime(START);
            this.fill(table, 1000);
            this.logTime(FILL);
            byte[] data = this.serialize(table);
            this.logTime(SERIALIZE);
            this.checkRecordCount(table, 1000);
            table.clear();
            this.logTime(CLEAR);
            this.deserialize(table, data);
            this.logTime(DESERIALIZE);
            this.checkRecordCount(table, 1000);
            ++i;
        }
    }

    private void checkRecordCount(IEdoTable table, int rowCount) {
        if (table.getRecordCount() != rowCount) {
            throw new RuntimeException("Wrong number of rows in the table. Expected " + rowCount + ", found " + table.getRecordCount() + ".");
        }
    }
}

