/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.DescriptorHelper;
import com.sap.tc.col.edo.core.EdoAbstractValue;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TableRowIterator;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public final class EdoTable
extends EdoAbstractValue
implements IEdoTable,
CCDirectives {
    private static final Location _location = Location.getLocation((Class)(class$com$sap$tc$col$edo$core$EdoTable == null ? (class$com$sap$tc$col$edo$core$EdoTable = EdoTable.class$("com.sap.tc.col.edo.core.EdoTable")) : class$com$sap$tc$col$edo$core$EdoTable));
    static int NO_OF_EXTRA_FIELDS;
    static int FIELD_OFFSET_RECORD;
    protected final IStructureDescriptor m_descriptor;
    protected final ArrayList m_table;
    protected final int m_fieldCount;
    protected static final int[] empty_fieldsThatNeedDeepCopy;
    protected int[] m_fieldsThatNeedDeepCopy;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$EdoTable;

    public EdoTable(IStructureDescriptor descriptor, int capacity) {
        this.m_descriptor = descriptor;
        this.m_fieldCount = descriptor.size();
        this.m_table = new ArrayList(capacity);
    }

    private EdoTable(EdoTable table) {
        this.m_descriptor = table.m_descriptor;
        this.m_fieldCount = table.m_fieldCount;
        this.m_fieldsThatNeedDeepCopy = table.m_fieldsThatNeedDeepCopy;
        this.m_table = new ArrayList(table.m_table.size());
        table.append(table, 0, table.m_table.size());
    }

    public EdoTable(IStructureDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_fieldCount = descriptor.size();
        this.m_table = new ArrayList();
    }

    public String getMeta() {
        return "T";
    }

    public String getType() {
        return this.m_descriptor.getName();
    }

    public IStructureDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public int getFieldCount() {
        return this.m_descriptor.size();
    }

    public int getRecordCount() {
        return this.m_table.size();
    }

    public void clear() {
        this.m_table.clear();
    }

    public Iterator getRecordIterator() {
        return new TableRowIterator(this, ((AbstractList)this.m_table).iterator());
    }

    public IEdoStructure getRecord(int recordIndex) {
        Object[] record = (Object[])this.m_table.get(recordIndex);
        return this.getRow(record);
    }

    public boolean isInitial(int recordIndex, String fieldName) {
        return this.isInitial(recordIndex, this.getFieldIndex(fieldName));
    }

    public final boolean isInitial(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        return this.getValueInternal(recordIndex, fieldIndex) == null;
    }

    public Object getValue(int recordIndex, String fieldName) {
        return this.getValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public final Object getValue(int recordIndex, int fieldIndex) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(recordIndex, fieldIndex);
        }
        return TypeHelper.parse(this.getStringValue(recordIndex, fieldIndex), type);
    }

    public void setValue(int recordIndex, String fieldName, Object value) {
        this.setValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final void setValue(int recordIndex, int fieldIndex, Object value) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            throw new NoSuchMethodError("Method setValue() is not supported for variants.");
        }
        this.setStringValue(recordIndex, fieldIndex, TypeHelper.format(value, type));
    }

    public Object getValue(int recordIndex, String fieldName, boolean createIfNull) {
        return this.getValue(recordIndex, this.getFieldIndex(fieldName), createIfNull);
    }

    public final Object getValue(int recordIndex, int fieldIndex, boolean createIfNull) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(recordIndex, fieldIndex, createIfNull);
        }
        return TypeHelper.parse(this.getStringValue(recordIndex, fieldIndex), type);
    }

    public final String getStringValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        Object value = this.getValueInternal(recordIndex, fieldIndex);
        return value == null ? "" : value.toString();
    }

    public String getStringValue(int recordIndex, String fieldname) {
        String value = (String)this.getValueInternal(recordIndex, this.getFieldIndex(fieldname));
        return value == null ? "" : value;
    }

    public final void setStringValue(int recordIndex, int fieldIndex, String value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        this.setValueInternal(recordIndex, fieldIndex, value);
    }

    public void setStringValue(int recordIndex, String fieldname, String value) {
        this.checkRecordIndex(recordIndex);
        this.setValueInternal(recordIndex, this.getFieldIndex(fieldname), value);
    }

    public int getIntValue(int recordIndex, String fieldName) {
        return this.getIntValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setIntValue(int recordIndex, String fieldName, int value) {
        this.setIntValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final int getIntValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "INTEGER");
        return TypeHelper.getType("INTEGER").parseInt((String)this.getValueInternal(recordIndex, fieldIndex));
    }

    public final void setIntValue(int recordIndex, int fieldIndex, int value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "INTEGER");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("INTEGER").format(value));
    }

    public boolean getBooleanValue(int recordIndex, String fieldName) {
        return this.getBooleanValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setBooleanValue(int recordIndex, String fieldName, boolean value) {
        this.setBooleanValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final boolean getBooleanValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BOOLEAN");
        return TypeHelper.getType("BOOLEAN").parseBoolean((String)this.getValueInternal(recordIndex, fieldIndex));
    }

    public final void setBooleanValue(int recordIndex, int fieldIndex, boolean value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BOOLEAN");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("BOOLEAN").format(value));
    }

    public double getDoubleValue(int recordIndex, String fieldName) {
        return this.getDoubleValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDoubleValue(int recordIndex, String fieldName, double value) {
        this.setDoubleValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final double getDoubleValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DOUBLE");
        return TypeHelper.getType("DOUBLE").parseDouble((String)this.getValueInternal(recordIndex, fieldIndex));
    }

    public final void setDoubleValue(int recordIndex, int fieldIndex, double value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DOUBLE");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("DOUBLE").format(value));
    }

    public Date getDateValue(int recordIndex, String fieldName) {
        return this.getDateValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDateValue(int recordIndex, String fieldName, Date value) {
        this.setDateValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final Date getDateValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DATE");
        return (Date)TypeHelper.parse((String)this.getValueInternal(recordIndex, fieldIndex), "DATE");
    }

    public final void setDateValue(int recordIndex, int fieldIndex, Date value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DATE");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "DATE"));
    }

    public Time getTimeValue(int recordIndex, String fieldName) {
        return this.getTimeValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setTimeValue(int recordIndex, String fieldName, Time value) {
        this.setTimeValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final Time getTimeValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIME");
        return (Time)TypeHelper.parse((String)this.getValueInternal(recordIndex, fieldIndex), "TIME");
    }

    public final void setTimeValue(int recordIndex, int fieldIndex, Time value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIME");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "TIME"));
    }

    public BigDecimal getDecimalValue(int recordIndex, String fieldName) {
        return this.getDecimalValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDecimalValue(int recordIndex, String fieldName, BigDecimal value) {
        this.setDecimalValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final BigDecimal getDecimalValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DECIMAL");
        return (BigDecimal)TypeHelper.parse((String)this.getValueInternal(recordIndex, fieldIndex), "DECIMAL");
    }

    public final void setDecimalValue(int recordIndex, int fieldIndex, BigDecimal value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DECIMAL");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "DECIMAL"));
    }

    public Timestamp getTimestampValue(int recordIndex, String fieldName) {
        return this.getTimestampValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setTimestampValue(int recordIndex, String fieldName, Timestamp value) {
        this.setTimestampValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final Timestamp getTimestampValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIMESTAMP");
        return (Timestamp)TypeHelper.parse((String)this.getValueInternal(recordIndex, fieldIndex), "TIMESTAMP");
    }

    public final void setTimestampValue(int recordIndex, int fieldIndex, Timestamp value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIMESTAMP");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "TIMESTAMP"));
    }

    public byte[] getBinaryValue(int recordIndex, String fieldName) {
        return this.getBinaryValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setBinaryValue(int recordIndex, String fieldName, byte[] value) {
        this.setBinaryValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final byte[] getBinaryValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BINARY");
        return (byte[])TypeHelper.parse((String)this.getValueInternal(recordIndex, fieldIndex), "BINARY");
    }

    public final void setBinaryValue(int recordIndex, int fieldIndex, byte[] value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BINARY");
        this.setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "BINARY"));
    }

    public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "VARIANT");
        Object value = this.getValueInternal(recordIndex, fieldIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof IEdoVariant) {
            return (IEdoVariant)value;
        }
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        IEdoVariant variant = EdoVariant.convertXMLToVariant(fieldDescriptor, (String)value);
        this.setValueInternal(recordIndex, fieldIndex, variant);
        return variant;
    }

    public IEdoVariant getVariantValue(int recordIndex, String fieldname) {
        return this.getVariantValue(recordIndex, this.getFieldIndex(fieldname));
    }

    public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex, boolean createIfNull) {
        IEdoVariant value = this.getVariantValue(recordIndex, fieldIndex);
        if (value == null && createIfNull) {
            return this.newVariantValueInternal(recordIndex, fieldIndex);
        }
        return value;
    }

    public IEdoVariant getVariantValue(int recordIndex, String fieldname, boolean createIfNull) {
        return this.getVariantValue(recordIndex, this.getFieldIndex(fieldname), createIfNull);
    }

    public int append(int count) {
        int retValue = this.m_table.size();
        while (count > 0) {
            this.m_table.add(this.newRecord());
            --count;
        }
        return retValue;
    }

    public int append(IEdoStructure source) {
        EdoStructure sRecord = (EdoStructure)source;
        this.checkDescriptor(source.getDescriptor());
        int retValue = this.m_table.size();
        this.m_table.add(this.newRecord(sRecord.m_record));
        return retValue;
    }

    public int appendCorresponding(IEdoStructure source) {
        EdoStructure sRecord = (EdoStructure)source;
        int[] indices = DescriptorHelper.getCorrespondingIndices(((EdoStructure)source).m_descriptor, this.m_descriptor);
        int retValue = this.m_table.size();
        this.m_table.add(this.newRecord(sRecord.m_record, indices));
        return retValue;
    }

    public int append(IEdoTable source, int sourceIndex, int count) {
        ArrayList sTable = ((EdoTable)source).m_table;
        this.checkDescriptor(source.getDescriptor());
        int retValue = this.m_table.size();
        this.m_table.ensureCapacity(retValue + count);
        int endIndex = sourceIndex + count;
        while (sourceIndex < endIndex) {
            this.m_table.add(this.newRecord(sTable.get(sourceIndex)));
            ++sourceIndex;
        }
        return retValue;
    }

    public int appendCorresponding(IEdoTable source, int sourceIndex, int count) {
        ArrayList sTable = ((EdoTable)source).m_table;
        int[] indices = DescriptorHelper.getCorrespondingIndices(((EdoTable)source).m_descriptor, this.m_descriptor);
        int retValue = this.m_table.size();
        this.m_table.ensureCapacity(retValue + count);
        int endIndex = sourceIndex + count;
        while (sourceIndex < endIndex) {
            this.m_table.add(this.newRecord(sTable.get(sourceIndex), indices));
            ++sourceIndex;
        }
        return retValue;
    }

    public void setRecord(int recordIndex, IEdoStructure source) {
        this.checkRecordIndex(recordIndex);
        this.checkDescriptor(source.getDescriptor());
        this.copyRecord(((EdoStructure)source).m_record, this.m_table.get(recordIndex));
    }

    public void getRecord(int recordIndex, IEdoStructure destination) {
        this.checkRecordIndex(recordIndex);
        this.checkDescriptor(destination.getDescriptor());
        this.copyRecord(this.m_table.get(recordIndex), ((EdoStructure)destination).m_record);
    }

    public void getCorrespondingRecord(int recordIndex, IEdoStructure destination) {
        this.checkRecordIndex(recordIndex);
        EdoStructure tDestination = (EdoStructure)destination;
        int[] indices = DescriptorHelper.getCorrespondingIndices(this.m_descriptor, tDestination.m_descriptor);
        this.copyRecord((Object[])this.m_table.get(recordIndex), tDestination.m_record, indices);
    }

    public void setCorrespondingRecord(int recordIndex, IEdoStructure source) {
        this.checkRecordIndex(recordIndex);
        EdoStructure tSource = (EdoStructure)source;
        int[] indices = DescriptorHelper.getCorrespondingIndices(tSource.m_descriptor, this.m_descriptor);
        this.copyRecord(tSource.m_record, (Object[])this.m_table.get(recordIndex), indices);
    }

    public void getTable(int[] recordIndices, IEdoTable destination) {
        int len = recordIndices.length;
        EdoTable d = (EdoTable)destination;
        this.checkDescriptor(d.m_descriptor);
        ArrayList dTable = d.m_table;
        dTable.ensureCapacity(dTable.size() + len);
        int i = 0;
        while (i < len) {
            int srcRecordIndex = recordIndices[i];
            this.checkRecordIndex(srcRecordIndex);
            dTable.add(this.newRecord(this.m_table.get(srcRecordIndex)));
            ++i;
        }
    }

    public void setTable(int[] recordIndices, IEdoTable source, int startIndex) {
        int len = recordIndices.length;
        EdoTable s = (EdoTable)source;
        this.checkDescriptor(s.m_descriptor);
        s.checkRecordIndex(startIndex + len - 1);
        ArrayList sTable = s.m_table;
        int i = 0;
        int srcRecordIndex = startIndex;
        while (i < len) {
            int destRecordIndex = recordIndices[i];
            this.checkRecordIndex(destRecordIndex);
            this.copyRecord(sTable.get(srcRecordIndex), this.m_table.get(destRecordIndex));
            ++i;
            ++srcRecordIndex;
        }
    }

    public void insertAt(int index, int count) {
        if (index == this.m_table.size()) {
            this.append(count);
        } else {
            this.checkRecordIndex(index);
            ArrayList<Object[]> tempList = new ArrayList<Object[]>(count);
            while (count > 0) {
                tempList.add(this.newRecord());
                --count;
            }
            this.m_table.addAll(index, tempList);
        }
    }

    public int insertAt(int index, IEdoStructure source) {
        EdoStructure sRecord = (EdoStructure)source;
        this.checkDescriptor(source.getDescriptor());
        int retValue = this.m_table.size();
        this.m_table.add(index, this.newRecord(sRecord.m_record));
        return retValue;
    }

    public int insertCorrespondingAt(int index, IEdoStructure source) {
        EdoStructure sRecord = (EdoStructure)source;
        int[] indices = DescriptorHelper.getCorrespondingIndices(((EdoStructure)source).m_descriptor, this.m_descriptor);
        int retValue = this.m_table.size();
        this.m_table.add(index, this.newRecord(sRecord.m_record, indices));
        return retValue;
    }

    public void insertAt(int index, IEdoTable source, int sourceIndex, int count) {
        if (index == this.m_table.size()) {
            this.append(source, sourceIndex, count);
        } else {
            this.checkRecordIndex(index);
            this.checkDescriptor(source.getDescriptor());
            ArrayList sTable = ((EdoTable)source).m_table;
            ArrayList<Object[]> tempList = new ArrayList<Object[]>(count);
            int endIndex = sourceIndex + count;
            while (sourceIndex < endIndex) {
                tempList.add(this.newRecord(sTable.get(sourceIndex)));
                ++sourceIndex;
            }
            this.m_table.addAll(index, tempList);
        }
    }

    public void insertCorrespondingAt(int index, IEdoTable source, int sourceIndex, int count) {
        if (index == this.m_table.size()) {
            this.appendCorresponding(source, sourceIndex, count);
        } else {
            ArrayList sTable = ((EdoTable)source).m_table;
            int[] indices = DescriptorHelper.getCorrespondingIndices(((EdoTable)source).m_descriptor, this.m_descriptor);
            ArrayList<Object[]> tempList = new ArrayList<Object[]>(count);
            int endIndex = sourceIndex + count;
            while (sourceIndex < endIndex) {
                tempList.add(this.newRecord(sTable.get(sourceIndex), indices));
                ++sourceIndex;
            }
            this.m_table.addAll(index, tempList);
        }
    }

    public void deleteFrom(int index) {
        this.checkRecordIndex(index);
        this.m_table.remove(index);
    }

    public void deleteFrom(int startIndex, int count) {
        this.checkRecordIndex(startIndex + count - 1);
        ((AbstractList)this.m_table).subList(startIndex, startIndex + count).clear();
    }

    public void readFrom(IEdoReadStream readStream) {
        readStream.read(this);
    }

    public void writeTo(IEdoWriteStream writeStream) {
        writeStream.write(this);
    }

    final int getRecordCountInternal() {
        return this.m_table.size();
    }

    final Object getValueInternal(int recordIndex, int fieldIndex) {
        return ((Object[])this.m_table.get(recordIndex))[fieldIndex];
    }

    final void setValueInternal(int recordIndex, int fieldIndex, Object value) {
        ((Object[])this.m_table.get((int)recordIndex))[fieldIndex] = value;
    }

    final EdoVariant newVariantValueInternal(int recordIndex, int fieldIndex) {
        EdoVariant value = new EdoVariant(this.m_descriptor.getFieldDescriptor(fieldIndex));
        this.setValueInternal(recordIndex, fieldIndex, value);
        return value;
    }

    final void clearInternal() {
        this.m_table.clear();
    }

    final void appendInternal() {
        this.m_table.add(this.newRecord());
    }

    final EdoStructure getRow(Object[] record) {
        EdoStructure row = (EdoStructure)record[this.m_fieldCount + FIELD_OFFSET_RECORD];
        if (row == null) {
            row = new EdoStructure(this.m_descriptor, record);
            record[this.m_fieldCount + EdoTable.FIELD_OFFSET_RECORD] = row;
        }
        return row;
    }

    EdoAbstractValue deepCopy() {
        return new EdoTable(this);
    }

    private int getFieldIndex(String fieldname) {
        int fieldIndex = this.m_descriptor.getFieldIndex(fieldname);
        if (0 > fieldIndex) {
            throw new IllegalArgumentException("Field name '" + fieldname + "' not found in structure '" + this.m_descriptor.getName() + "'.");
        }
        return fieldIndex;
    }

    private void checkRecordIndex(int recordIndex) {
        if (recordIndex < 0 || recordIndex >= this.m_table.size()) {
            throw new IndexOutOfBoundsException("Record index " + recordIndex + " out of range. Should be >= 0 and < " + this.m_table.size());
        }
    }

    private void checkFieldIndex(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.m_fieldCount) {
            throw new IndexOutOfBoundsException("Field index " + fieldIndex + " out of range. Should be >= 0 and < " + this.m_fieldCount);
        }
    }

    private void checkDescriptor(IStructureDescriptor descriptor) {
        if (!this.m_descriptor.equals(descriptor)) {
            throw new IllegalArgumentException("Different Structure type: expected '" + this.m_descriptor.getName() + "' found '" + descriptor.getName() + "'.");
        }
    }

    private Object[] newRecord() {
        return new Object[this.m_fieldCount + NO_OF_EXTRA_FIELDS];
    }

    private Object[] newRecord(Object[] src) {
        Object[] newRecord = new Object[this.m_fieldCount + NO_OF_EXTRA_FIELDS];
        this.copyRecord(src, newRecord);
        return newRecord;
    }

    private Object[] newRecord(Object src) {
        Object[] newRecord = new Object[this.m_fieldCount + NO_OF_EXTRA_FIELDS];
        this.copyRecord(src, newRecord);
        return newRecord;
    }

    private Object[] newRecord(Object src, int[] indices) {
        Object[] srcRecord = (Object[])src;
        Object[] newRecord = this.newRecord();
        this.copyRecord(srcRecord, newRecord, indices);
        return newRecord;
    }

    private void copyRecord(Object src, Object dest) {
        System.arraycopy(src, 0, dest, 0, this.m_fieldCount);
        this.deepCopyFieldsThatNeedDeepCopy((Object[])dest);
    }

    private void copyRecord(Object[] src, Object[] dest, int[] indices) {
        int i = 0;
        int len = indices.length - 1;
        while (i < len) {
            if (indices[i + 2] == 0) {
                dest[indices[i + 1]] = src[indices[i]];
            } else {
                EdoAbstractValue value = (EdoAbstractValue)src[indices[i]];
                if (value != null) {
                    dest[indices[i + 1]] = value.deepCopy();
                }
            }
            i += 3;
        }
    }

    private void deepCopyFieldsThatNeedDeepCopy(Object[] record) {
        if (this.m_fieldsThatNeedDeepCopy == empty_fieldsThatNeedDeepCopy) {
            return;
        }
        if (this.m_fieldsThatNeedDeepCopy == null) {
            this.m_fieldsThatNeedDeepCopy = DescriptorHelper.getFieldsThatNeedDeepCopy(this.m_descriptor);
            if (this.m_fieldsThatNeedDeepCopy.length == 0) {
                this.m_fieldsThatNeedDeepCopy = empty_fieldsThatNeedDeepCopy;
                return;
            }
        }
        int i = 0;
        int len = this.m_fieldsThatNeedDeepCopy.length;
        while (i < len) {
            int index = this.m_fieldsThatNeedDeepCopy[i];
            EdoAbstractValue value = (EdoAbstractValue)record[index];
            if (value != null) {
                record[index] = value.deepCopy();
            }
            ++i;
        }
    }

    private void checkFieldType(int fieldIndex, String type) {
        boolean typeInvalid = false;
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        if (type.equals("VARIANT") && !type.equals(fieldDescriptor.getType())) {
            typeInvalid = true;
        } else if (type.equals("STRING") && fieldDescriptor.getType().equals("VARIANT")) {
            typeInvalid = true;
        }
        if (typeInvalid) {
            throw new IllegalArgumentException("Different Field type : expected '" + type + "' found '" + fieldDescriptor.getType() + "'.");
        }
    }

    private String getFieldType(int fieldIndex) {
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        return fieldDescriptor.getType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/EdoTable.java#1 $");
        NO_OF_EXTRA_FIELDS = 1;
        FIELD_OFFSET_RECORD = 0;
        empty_fieldsThatNeedDeepCopy = new int[0];
    }
}

