/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

public class AbapNameHelper {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String convertAbapToXml(String abapName) {
        String xmlName;
        char c;
        boolean needsConversion = false;
        int position = 0;
        int length = abapName.length();
        if (!(length <= 0 || (c = abapName.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
            needsConversion = true;
            position = 0;
        }
        if (!needsConversion) {
            position = 1;
            while (position < length) {
                c = abapName.charAt(position);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c >= '0' && c <= '9' || c == '.')) {
                    needsConversion = true;
                    break;
                }
                ++position;
            }
        }
        if (needsConversion) {
            char c2;
            char[] xmlBuffer = new char[5 * length];
            int xmlBufferLen = 0;
            if (position > 0) {
                abapName.getChars(0, position, xmlBuffer, 0);
                xmlBufferLen = position;
            } else {
                c2 = abapName.charAt(position);
                xmlBuffer[0] = 95;
                xmlBuffer[1] = 45;
                xmlBuffer[2] = 45;
                xmlBuffer[3] = hex[c2 >> 4];
                xmlBuffer[4] = hex[c2 & 0xF];
                xmlBufferLen = 5;
                ++position;
            }
            while (position < length) {
                c2 = abapName.charAt(position);
                if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') {
                    xmlBuffer[xmlBufferLen++] = c2;
                } else if (c2 == '/') {
                    xmlBuffer[xmlBufferLen++] = 95;
                    xmlBuffer[xmlBufferLen++] = 45;
                } else {
                    xmlBuffer[xmlBufferLen++] = 95;
                    xmlBuffer[xmlBufferLen++] = 45;
                    xmlBuffer[xmlBufferLen++] = 45;
                    xmlBuffer[xmlBufferLen++] = hex[c2 >> 4];
                    xmlBuffer[xmlBufferLen++] = hex[c2 & 0xF];
                }
                ++position;
            }
            xmlName = String.copyValueOf(xmlBuffer, 0, xmlBufferLen);
        } else {
            xmlName = abapName;
        }
        return xmlName;
    }

    public static String convertXmlToAbap(String xmlName) {
        String abapName;
        int length = xmlName.length();
        int position = xmlName.indexOf("_-");
        if (position >= 0) {
            int start = 0;
            char[] xmlBuffer = new char[length];
            int xmlBufferLen = 0;
            if (position > 0) {
                xmlName.getChars(0, position, xmlBuffer, 0);
                xmlBufferLen = position;
            }
            do {
                xmlBuffer[xmlBufferLen++] = (position += 2) + 3 <= length && '-' == xmlName.charAt(position) ? (int)Integer.parseInt(xmlName.substring(++position, position += 2), 16) : 47;
                start = position;
                position = xmlName.indexOf("_-", start);
                int n = position = position >= 0 ? position : length;
                if (position <= start) continue;
                xmlName.getChars(start, position, xmlBuffer, xmlBufferLen);
                xmlBufferLen += position - start;
            } while (position < length);
            abapName = String.copyValueOf(xmlBuffer, 0, xmlBufferLen);
        } else {
            abapName = xmlName;
        }
        return abapName;
    }
}

