/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo;

import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.core.XMLHelper;
import java.util.Arrays;

public class AbstractPerfTest {
    protected String fieldNamePrefix = "FIELD_";
    private XMLHelper x = new XMLHelper();
    private long lastTime = System.currentTimeMillis();
    private static final String filler;

    protected StructureDescriptor getDescriptor(int fieldCount) {
        FieldDescriptor[] fields = new FieldDescriptor[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            fields[i] = new FieldDescriptor(this.fieldNamePrefix + Integer.toHexString(i + 1), "STRING");
            ++i;
        }
        return new StructureDescriptor("TEST_STRUCTURE", fields);
    }

    protected void fill(IEdoTable table, int rowCount) {
        table.clear();
        table.append(rowCount);
        int colCount = table.getDescriptor().size();
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < colCount) {
                String value = "The value at row = " + row + " and " + col + " field.";
                table.setStringValue(row, col, value);
                ++col;
            }
            ++row;
        }
    }

    protected byte[] serialize(IEdoValue table) {
        this.x.clearXString();
        table.writeTo(this.x);
        byte[] data = this.x.getXString();
        this.x.clearXString();
        return data;
    }

    protected void deserialize(IEdoValue table, byte[] data) {
        this.x.setXString(data);
        table.readFrom(this.x);
        this.x.clearXString();
    }

    protected void logTime(String message) {
        long now = System.currentTimeMillis();
        long time = now - this.lastTime;
        System.out.println(filler.substring(message.length()) + message + '\t' + time);
        this.lastTime = System.currentTimeMillis();
    }

    static {
        char[] c = new char[20];
        Arrays.fill(c, ' ');
        filler = new String(c);
    }
}

