/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui.providers;

import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.cbs.activation.internal.ui.XTreeNodeBuildVariant;
import com.sap.ide.eclipse.cbs.activation.internal.ui.XTreeNodeCompartment;
import com.sap.ide.eclipse.cbs.activation.internal.ui.XTreeNodeDCBuildResult;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.IBuildDCResult;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildResult;
import com.sap.tc.cbs.client.IBuildVariantResult;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DCBuildResultTreeContentProvider
implements ITreeContentProvider {
    private boolean m_showActivationResult;
    private List m_variantTreeNodes = new ArrayList();
    private List m_compartmentTreeNodes = new ArrayList();

    public DCBuildResultTreeContentProvider(boolean showActivationResult) {
        this.m_showActivationResult = showActivationResult;
    }

    public void dispose() {
        this.clearCaches();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof XTreeNodeCompartment) {
            return ((XTreeNodeCompartment)parentElement).getChildNodes();
        }
        if (parentElement instanceof XTreeNodeBuildVariant) {
            return ((XTreeNodeBuildVariant)parentElement).getChildNodes();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IBuildRequest) {
            IBuildResult buildResult;
            ActivationRuntimeDataStorage dataStorage = ActivationRuntimeDataStorage.getStorage();
            if (!this.m_showActivationResult && !dataStorage.isRuntimeSystemConfigured()) {
                MessageViewerInput messageInput = new MessageViewerInput("No runtime system configured.", 1);
                return new MessageViewerInput[]{messageInput};
            }
            IBuildRequest buildRequest = (IBuildRequest)inputElement;
            if (dataStorage.isBuildRequestInProcess(buildRequest)) {
                MessageViewerInput messageInput = new MessageViewerInput(this.m_showActivationResult ? "Result not yet available because request still in process." : "Runtime deployment result not yet available because activation still in process.", 1);
                return new MessageViewerInput[]{messageInput};
            }
            if (!this.m_showActivationResult) {
                Boolean isDeploymentFinished = dataStorage.isRuntimeDeploymentFinished(buildRequest);
                if (isDeploymentFinished == null) {
                    MessageViewerInput messageInput = new MessageViewerInput("Error occurred during retrieving of runtime deployment status.", 3);
                    return new MessageViewerInput[]{messageInput};
                }
                if (!isDeploymentFinished.booleanValue()) {
                    MessageViewerInput messageInput = new MessageViewerInput("Result not yet available because runtime deployment still in process.", 3);
                    return new MessageViewerInput[]{messageInput};
                }
            }
            if ((buildResult = dataStorage.getBuildResult(buildRequest)) == null) {
                MessageViewerInput messageInput = new MessageViewerInput("Error occurred during retrieving of build result.", 3);
                return new MessageViewerInput[]{messageInput};
            }
            IBuildDCResult[] dcResults = buildResult.getDcResults();
            if (dcResults != null) {
                if (dcResults.length == 0) {
                    BuildRequestStatus status = dataStorage.getBuildRequestStatus(buildRequest);
                    if (status == null) {
                        MessageViewerInput messageInput = new MessageViewerInput("Error occurred during retrieving of activation status.", 3);
                        return new MessageViewerInput[]{messageInput};
                    }
                    if (status.equals(BuildRequestStatus.SUCCEEDED)) {
                        MessageViewerInput messageInput = new MessageViewerInput(this.m_showActivationResult ? "Completed. Nothing to build." : "Nothing to deploy.", 1);
                        return new MessageViewerInput[]{messageInput};
                    }
                    MessageViewerInput messageInput = new MessageViewerInput(this.m_showActivationResult ? "Activation failed. No DC specific results available." : "No deployment result available because activation failed.", 1);
                    return new MessageViewerInput[]{messageInput};
                }
                IDevelopmentConfiguration devConfig = dataStorage.getActiveDevelopmentConfiguration();
                int i = 0;
                while (i < dcResults.length) {
                    Compartment compartment;
                    IBuildVariantResult[] variantResults = dcResults[i].getVariantResults();
                    if (variantResults != null && variantResults.length > 0 && (compartment = dataStorage.getCompartment(devConfig, dcResults[i].getCompartment())) != null) {
                        int j = 0;
                        while (j < variantResults.length) {
                            this.addToTreeModel(buildRequest, variantResults[j], dcResults[i], compartment);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if (!this.m_compartmentTreeNodes.isEmpty()) {
            return this.m_compartmentTreeNodes.toArray(new XTreeNodeCompartment[this.m_compartmentTreeNodes.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof XTreeNodeCompartment || element instanceof XTreeNodeBuildVariant;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.clearCaches();
        }
    }

    private void addToTreeModel(IBuildRequest buildRequest, IBuildVariantResult variantResult, IBuildDCResult dcResult, Compartment compartment) {
        if (variantResult == null || dcResult == null || compartment == null) {
            return;
        }
        XTreeNodeDCBuildResult dcNode = new XTreeNodeDCBuildResult(variantResult, dcResult);
        dcNode.setBuildRequest(buildRequest);
        this.addToParentTreeNodeVariant(dcNode, variantResult, compartment);
    }

    private void addToParentTreeNodeVariant(XTreeNodeDCBuildResult dcNode, IBuildVariantResult variantResult, Compartment compartment) {
        Iterator iter = this.m_variantTreeNodes.iterator();
        while (iter.hasNext()) {
            XTreeNodeBuildVariant variantNode = (XTreeNodeBuildVariant)iter.next();
            if (!variantNode.isRightParentNode(compartment, variantResult.getVariantName())) continue;
            variantNode.addChildNode(dcNode);
            this.addToParentTreeNodeCompartment(variantNode, compartment);
            return;
        }
        XTreeNodeBuildVariant newVariantNode = new XTreeNodeBuildVariant(compartment, variantResult.getVariantName());
        newVariantNode.addChildNode(dcNode);
        this.m_variantTreeNodes.add(newVariantNode);
        this.addToParentTreeNodeCompartment(newVariantNode, compartment);
    }

    private void addToParentTreeNodeCompartment(XTreeNodeBuildVariant variantNode, Compartment compartment) {
        Iterator iter = this.m_compartmentTreeNodes.iterator();
        while (iter.hasNext()) {
            XTreeNodeCompartment compartmentNode = (XTreeNodeCompartment)iter.next();
            if (!compartmentNode.isRightParentNode(compartment)) continue;
            compartmentNode.addChildNode(variantNode);
            return;
        }
        XTreeNodeCompartment newCompartmentNode = new XTreeNodeCompartment(compartment);
        newCompartmentNode.addChildNode(variantNode);
        this.m_compartmentTreeNodes.add(newCompartmentNode);
    }

    private void clearCaches() {
        this.m_compartmentTreeNodes.clear();
        this.m_variantTreeNodes.clear();
    }
}

