/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui.providers;

import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.ClosedActivityProvider;
import com.tssap.dtr.client.eclipse.ui.util.RefreshLogic;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.Viewer;

public class ConfigurableActivationTreeContentProvider
extends ClosedActivityProvider {
    private static final String ACTIVATION_STATE_ATTRIBUTE = "activationState";
    private static final String ACTIVATION_STATE_ACTIVE = "ACTIVE";
    private static final String ACTIVATION_STATE_INACTIVE = "INACTIVE";
    private boolean m_showInactive;
    private boolean m_withUserFilter;
    private boolean m_withSortPossiblity;
    private String m_viewId = null;

    protected Object[] getMyChildren(Object element) {
        Object[] activities;
        String user = "";
        if (this.m_withUserFilter && this.m_viewId != null) {
            user = this.getPreferenceStore().getString(this.m_viewId + "_viewForUser");
        }
        if (user.equals("*")) {
            user = null;
        }
        if (element instanceof IVfsRootFolder) {
            Object[] workspaces;
            if (RefreshLogic.doRefresh()) {
                ActivationRuntimeDataStorage.getStorage().resetActivityCache(this.m_showInactive, user);
            }
            if ((workspaces = ActivationRuntimeDataStorage.getStorage().getWorkspacesToShow(this.m_showInactive, user)) != null && workspaces.length > 0) {
                return this.sortElementsByPath(workspaces, true);
            }
        } else if (element instanceof IVfsWorkspace && (activities = ActivationRuntimeDataStorage.getStorage().getActivitiesToShow((IVfsWorkspace)element, this.m_showInactive, user)) != null) {
            boolean sortByName = false;
            boolean sortAscending = false;
            if (this.m_withSortPossiblity && this.m_viewId != null) {
                sortByName = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortActivityByName");
                sortAscending = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortActivityAscending");
            }
            return sortByName ? this.wrapActivityArray(this.sortElementsByName(activities, sortAscending), (IVfsWorkspace)element) : this.wrapActivityArray(this.sortElementsByDate(activities, sortAscending), (IVfsWorkspace)element);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    protected boolean isChildrenApplicable(Object element) {
        return element instanceof IVfsRootFolder || element instanceof IVfsWorkspace;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String activationState = config.getAttribute(ACTIVATION_STATE_ATTRIBUTE);
        if (activationState == null) {
            throw new IllegalArgumentException("Could not initialize ConfigurableActivationTreeContentProvider because the activation state is null.");
        }
        if (activationState.toUpperCase().equals(ACTIVATION_STATE_INACTIVE)) {
            this.m_showInactive = true;
        } else if (activationState.toUpperCase().equals(ACTIVATION_STATE_ACTIVE)) {
            this.m_showInactive = false;
        } else {
            throw new IllegalArgumentException("Could not initialize ConfigurableActivationTreeContentProvider because the activation state is unknown.");
        }
        if (data instanceof IConfigurationElement) {
            this.m_viewId = ((IConfigurationElement)data).getAttribute("id");
            this.m_withUserFilter = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSwitchUserMenu")));
            this.m_withSortPossiblity = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(((IConfigurationElement)data).getAttribute("showSortMenu")));
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

