/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui.providers;

import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.cbs.activation.ui.util.BuildStatusTranslator;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.IBuildRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class BuildRequestTreeLabelProvider
implements ITableLabelProvider,
IPropertyChangeListener {
    private Boolean m_showText;

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IBuildRequest && !this.showStatusAsText()) {
            if (columnIndex == 1) {
                BuildRequestStatus status = ActivationRuntimeDataStorage.getStorage().getBuildRequestStatus((IBuildRequest)element);
                if (status != null) {
                    if (status.equals(BuildRequestStatus.SUCCEEDED)) {
                        return ActivationPlugin.getDefault().getAtomicImage("succeeded_v.gif");
                    }
                    if (status.equals(BuildRequestStatus.CANCELLED) || status.equals(BuildRequestStatus.FAILED) || status.equals(BuildRequestStatus.INVALID)) {
                        return ActivationPlugin.getDefault().getAtomicImage("failed_v.gif");
                    }
                    if (status.equals(BuildRequestStatus.ABORTED) || status.equals(BuildRequestStatus.NEW) || status.equals(BuildRequestStatus.PENDING) || status.equals(BuildRequestStatus.PROCESSING) || status.equals(BuildRequestStatus.QUEUED) || status.equals(BuildRequestStatus.SUSPENDED) || status.equals(BuildRequestStatus.WAITING)) {
                        return ActivationPlugin.getDefault().getAtomicImage("processing_v.gif");
                    }
                }
                return ActivationPlugin.getDefault().getAtomicImage("unknown_v.gif");
            }
            if (columnIndex == 2) {
                String status = ActivationRuntimeDataStorage.getStorage().getRuntimeDeploymentStatus((IBuildRequest)element);
                if (status != null) {
                    if (status.equalsIgnoreCase("SUCCEEDED")) {
                        return ActivationPlugin.getDefault().getAtomicImage("succeeded_v.gif");
                    }
                    if (status.equalsIgnoreCase("FAILED")) {
                        return ActivationPlugin.getDefault().getAtomicImage("failed_v.gif");
                    }
                    if (status.equalsIgnoreCase("DEPLOYING") || status.equalsIgnoreCase("WAITING") || status.equalsIgnoreCase("QUEUED")) {
                        return ActivationPlugin.getDefault().getAtomicImage("processing_v.gif");
                    }
                    if (status.equals("")) {
                        return null;
                    }
                }
                return ActivationPlugin.getDefault().getAtomicImage("unknown_v.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IBuildRequest) {
            IBuildRequest buildRequest = (IBuildRequest)element;
            if (columnIndex == 0) {
                return "" + buildRequest.getRequestID();
            }
            if ((columnIndex == 1 || columnIndex == 2) && this.showStatusAsText()) {
                return this.getStatus(element, columnIndex);
            }
            return "";
        }
        if (element instanceof MessageViewerInput) {
            if (columnIndex == 0) {
                return ((MessageViewerInput)element).getLabel();
            }
            return "";
        }
        return "?";
    }

    public String getStatus(Object element, int columnIndex) {
        if (element instanceof IBuildRequest && (columnIndex == 1 || columnIndex == 2)) {
            IBuildRequest buildRequest = (IBuildRequest)element;
            if (columnIndex == 1) {
                BuildRequestStatus activationStatus = ActivationRuntimeDataStorage.getStorage().getBuildRequestStatus(buildRequest);
                return BuildStatusTranslator.getStatusText(activationStatus).toLowerCase();
            }
            if (columnIndex == 2) {
                String deployStatus = ActivationRuntimeDataStorage.getStorage().getRuntimeDeploymentStatus(buildRequest);
                return deployStatus != null ? deployStatus.toLowerCase() : "?";
            }
        }
        return "?";
    }

    private boolean showStatusAsText() {
        if (this.m_showText == null) {
            IPreferenceStore preferenceStore = ActivationPlugin.getDefault().getPreferenceStore();
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.m_showText = preferenceStore.getBoolean("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_showRequestStatusText") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.m_showText;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        ActivationPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_showRequestStatusText".equals(event.getProperty())) {
            this.m_showText = (Boolean)event.getNewValue();
        }
    }
}

