/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui.providers;

import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BuildRequestTreeContentProvider
implements ITreeContentProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$cbs$activation$ui$providers$BuildRequestTreeContentProvider == null ? (class$com$sap$ide$eclipse$cbs$activation$ui$providers$BuildRequestTreeContentProvider = BuildRequestTreeContentProvider.class$("com.sap.ide.eclipse.cbs.activation.ui.providers.BuildRequestTreeContentProvider")) : class$com$sap$ide$eclipse$cbs$activation$ui$providers$BuildRequestTreeContentProvider));
    private IBuildSpace m_buildSpace;
    static /* synthetic */ Class class$com$sap$ide$eclipse$cbs$activation$ui$providers$BuildRequestTreeContentProvider;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IBuildRequest) {
            IBuildRequest parentRequest = (IBuildRequest)parentElement;
            try {
                long[] followUpRequests = parentRequest.listFollowUpRequests();
                if (followUpRequests != null && this.getBuildSpace() != null) {
                    ArrayList<IBuildRequest> requests = new ArrayList<IBuildRequest>();
                    int i = 0;
                    while (i < followUpRequests.length) {
                        IBuildRequest buildRequest = this.getBuildSpace().getBuildRequest(followUpRequests[i]);
                        if (buildRequest != null) {
                            requests.add(buildRequest);
                        }
                        ++i;
                    }
                    return requests.toArray(new IBuildRequest[requests.size()]);
                }
            }
            catch (Exception x) {
                Logbook.getErrorChapter().println("Retrieving follow up requests of request " + parentRequest.getRequestID() + " failed: " + x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return new Object[0];
    }

    private IBuildSpace getBuildSpace() {
        IDevelopmentConfiguration devConfig;
        if (this.m_buildSpace == null && (devConfig = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration()) != null) {
            this.m_buildSpace = devConfig.getBuildSpace();
        }
        return this.m_buildSpace;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MessageViewerInput) {
            return new Object[]{inputElement};
        }
        if (inputElement instanceof IBuildRequest[]) {
            return (IBuildRequest[])inputElement;
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IBuildRequest[]) {
            ActivationRuntimeDataStorage.getStorage().updateBuildRequestStatus((IBuildRequest[])newInput);
            this.m_buildSpace = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

