/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui.actions;

import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildResult;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ViewActivationSummaryAction
extends VfsObjectSelectionAction {
    private IBuildRequest m_buildRequest;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor monitor) {
        if (this.m_buildRequest != null) {
            IBuildResult buildResult = ActivationRuntimeDataStorage.getStorage().getBuildResult(this.m_buildRequest);
            if (buildResult != null) {
                String logUrl = buildResult.getLogURL();
                if (logUrl != null && !logUrl.equals("")) {
                    Platform.getPlatform().openWithDefaultApplication(logUrl);
                } else {
                    this.showErrorMessage("Invalid URL of log file.");
                }
            } else {
                this.showErrorMessage("Error occurred during retrieving of build result.");
            }
        }
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected instanceof IBuildRequest) {
            this.m_buildRequest = (IBuildRequest)selected;
            return !ActivationRuntimeDataStorage.getStorage().isBuildRequestInProcess(this.m_buildRequest);
        }
        return false;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }
}

