/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui;

import com.sap.ide.eclipse.cbs.activation.ui.providers.BuildRequestTreeLabelProvider;
import com.sap.tc.cbs.client.IBuildRequest;
import com.tssap.dtr.client.lib.util.Logbook;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

final class BuildRequestViewerSorter
extends ViewerSorter {
    private boolean m_sortByStatus;
    private boolean m_ascending;

    public BuildRequestViewerSorter(boolean sortByStatus, boolean ascending) {
        this.m_sortByStatus = sortByStatus;
        this.m_ascending = ascending;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IBuildRequest) || !(e2 instanceof IBuildRequest)) {
            Logbook.getWarnChapter().println("Typ of object to compare in BuildRequestViewerSorter.compare is NOT IBuildRequest.");
            Logbook.getWarnChapter().flush();
            return 0;
        }
        if (!(viewer instanceof StructuredViewer)) {
            return 0;
        }
        IBaseLabelProvider labelProvider = ((StructuredViewer)viewer).getLabelProvider();
        if (!(labelProvider instanceof BuildRequestTreeLabelProvider)) {
            return 0;
        }
        BuildRequestTreeLabelProvider buildRequestLabelProvider = (BuildRequestTreeLabelProvider)labelProvider;
        if (!this.m_sortByStatus) {
            String label1 = buildRequestLabelProvider.getColumnText(e1, 0);
            String label2 = buildRequestLabelProvider.getColumnText(e2, 0);
            if (label1 == null || label2 == null) {
                Logbook.getWarnChapter().println("Argument's toString in BuildRequestViewerSorter.compare is <null>.");
                Logbook.getWarnChapter().flush();
                return 0;
            }
            int id1 = Integer.parseInt(label1);
            int id2 = Integer.parseInt(label2);
            return this.m_ascending ? id1 - id2 : id2 - id1;
        }
        String label1 = buildRequestLabelProvider.getStatus(e1, 1) + buildRequestLabelProvider.getStatus(e1, 2);
        String label2 = buildRequestLabelProvider.getStatus(e2, 1) + buildRequestLabelProvider.getStatus(e2, 2);
        if (label1 == null || label2 == null) {
            Logbook.getWarnChapter().println("Argument's toString in BuildRequestViewerSorter.compare is <null>.");
            Logbook.getWarnChapter().flush();
            return 0;
        }
        return this.m_ascending ? label1.compareToIgnoreCase(label2) : -label1.compareToIgnoreCase(label2);
    }
}

