/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui;

import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.IActivationListener;
import com.sap.ide.eclipse.cbs.activation.IDevelopmentConfigurationListener;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.cbs.activation.internal.ui.XTreeNodeDCBuildResult;
import com.sap.ide.eclipse.cbs.activation.ui.BuildRequestViewerSorter;
import com.sap.ide.eclipse.cbs.activation.ui.providers.BuildRequestTreeContentProvider;
import com.sap.ide.eclipse.cbs.activation.ui.providers.BuildRequestTreeLabelProvider;
import com.sap.ide.eclipse.cbs.activation.ui.providers.DCBuildResultTreeContentProvider;
import com.sap.ide.eclipse.cbs.activation.ui.providers.DCBuildResultTreeLabelProvider;
import com.sap.ide.eclipse.cbs.activation.ui.providers.RequestActivityTreeContentProvider;
import com.sap.ide.eclipse.cbs.activation.ui.providers.RequestActivityTreeLabelProvider;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.util.ILegend;
import com.tssap.dtr.client.eclipse.util.LegendElement;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.security.KeyStore;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class ActivationRequestView
extends ViewPart
implements ISetSelectionTarget,
IActivationListener,
IIDELoginListener,
IDevelopmentConfigurationListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$cbs$activation$ui$ActivationRequestView == null ? (class$com$sap$ide$eclipse$cbs$activation$ui$ActivationRequestView = ActivationRequestView.class$("com.sap.ide.eclipse.cbs.activation.ui.ActivationRequestView")) : class$com$sap$ide$eclipse$cbs$activation$ui$ActivationRequestView));
    private static final String VIEW_TITLE_SEPARATOR = " - ";
    private static final MessageViewerInput OFFLINE = new MessageViewerInput("OFFLINE", ActivationPlugin.getDefault().getAtomicImage("jiServerOffline.gif"));
    private static final int[] DEFAULT_SASH_WEIGHTS_ICON = new int[]{250, 650};
    private static final int[] DEFAULT_SASH_WEIGHTS_TEXT = new int[]{350, 550};
    private static final String KEY_SORT_BY_STATUS = "_sortRequestByStatus";
    private static final String KEY_SORT_ASCENDING = "_sortRequestAscending";
    private static final String LABEL_ACTIVATION_STATUS = "Activation Status";
    private static final String LABEL_DEPLOYMENT_STATUS = "Deployment Status";
    private TableTreeViewer m_requestTableTreeViewer;
    private TabFolder m_tabFolder;
    private Object m_currentSelection;
    private int m_currentTabIndex;
    private String m_viewId;
    private String m_viewName;
    private IRepositoryViewLegendManager m_legendManager;
    static /* synthetic */ Class class$com$sap$ide$eclipse$cbs$activation$ui$ActivationRequestView;

    public void createPartControl(Composite parent) {
        Composite viewArea = new Composite(parent, 0);
        viewArea.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(viewArea, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite selectionArea = this.createRequestSelectionArea((Composite)sashForm);
        selectionArea.setLayoutData((Object)new GridData(1040));
        Composite detailsArea = this.createRequestStateDetailsArea((Composite)sashForm);
        detailsArea.setLayoutData((Object)new GridData(1808));
        int[] sashWeights = this.showStatusAsText() ? DEFAULT_SASH_WEIGHTS_TEXT : DEFAULT_SASH_WEIGHTS_ICON;
        sashForm.setWeights(sashWeights);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_requestTableTreeViewer);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.m_requestTableTreeViewer.getTableTree());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.m_requestTableTreeViewer.getTableTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
        this.createToolbar();
        this.createMenu();
        this.updateViewTitle();
        if (VfsManagerProvider.getInstance().isUserLoggedinInSapIDE()) {
            this.setDefaultTableInput();
        } else {
            this.m_requestTableTreeViewer.setInput((Object)OFFLINE);
        }
        this.setInitialViewState();
    }

    private Composite createRequestSelectionArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        area.setLayout((Layout)gridLayout);
        this.m_requestTableTreeViewer = new TableTreeViewer(area, 770);
        this.m_requestTableTreeViewer.getTableTree().setLayoutData((Object)new GridData(1808));
        Table table = this.m_requestTableTreeViewer.getTableTree().getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        boolean showAsText = this.showStatusAsText();
        TableColumn column = new TableColumn(table, 0);
        column.setText("Request ID");
        layout.addColumnData((ColumnLayoutData)(showAsText ? new ColumnWeightData(60, 60, true) : new ColumnWeightData(80, 80, true)));
        column.setResizable(true);
        column = new TableColumn(table, 0);
        if (showAsText) {
            column.setText(LABEL_ACTIVATION_STATUS);
        } else {
            column.setImage(ActivationPlugin.getDefault().getAtomicImage("activate_hd.gif"));
        }
        layout.addColumnData((ColumnLayoutData)(showAsText ? new ColumnPixelData(80, true) : new ColumnPixelData(25, false)));
        column.setResizable(showAsText);
        column = new TableColumn(table, 0);
        if (showAsText) {
            column.setText(LABEL_DEPLOYMENT_STATUS);
        } else {
            column.setImage(ActivationPlugin.getDefault().getAtomicImage("deploy_hd.gif"));
        }
        layout.addColumnData((ColumnLayoutData)(showAsText ? new ColumnPixelData(80, true) : new ColumnPixelData(25, false)));
        column.setResizable(showAsText);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.m_requestTableTreeViewer.setContentProvider((IContentProvider)new BuildRequestTreeContentProvider());
        this.m_requestTableTreeViewer.setLabelProvider((IBaseLabelProvider)new BuildRequestTreeLabelProvider());
        this.m_requestTableTreeViewer.setSorter((ViewerSorter)new BuildRequestViewerSorter(this.isRequestViewerSortedByStatus(), this.isRequestViewerAscendingSorted()));
        this.m_requestTableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object oldSelection = ActivationRequestView.this.getCurrentSelection();
                    Object newSelection = null;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.size() > 1) {
                        newSelection = selection;
                    } else if (selection.size() == 1) {
                        newSelection = selection.getFirstElement();
                    }
                    if (!(newSelection instanceof IBuildRequest) || newSelection != null && !newSelection.equals(oldSelection)) {
                        ActivationRequestView.this.clearStatusBar();
                        ActivationRequestView.this.setCurrentSelection(newSelection);
                        ActivationRequestView.this.updateDetailsArea(true);
                    }
                }
            }
        });
        return area;
    }

    private Composite createRequestStateDetailsArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        area.setLayout((Layout)gridLayout);
        this.m_tabFolder = new TabFolder(area, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        this.m_tabFolder.setLayoutData((Object)gridData);
        TabItem[] tabPages = new TabItem[2];
        tabPages[0] = new TabItem(this.m_tabFolder, 0);
        tabPages[0].setText("Request Activities");
        tabPages[0].setImage(ActivationPlugin.getDefault().getAtomicImage("ACTIVITY_INACTIVE.gif"));
        tabPages[1] = new TabItem(this.m_tabFolder, 0);
        tabPages[1].setText("Activation Results");
        tabPages[1].setImage(ActivationPlugin.getDefault().getCompositeImage("jiDevelopmentComponent.gif", new String[]{"activate_co.gif"}));
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (evt.item instanceof TabItem) {
                    ActivationRequestView.this.clearStatusBar();
                    ActivationRequestView.this.setCurrentTabIndex(((TabItem)evt.item).getParent().getSelectionIndex());
                    ActivationRequestView.this.updateDetailsArea(false);
                }
            }
        });
        return area;
    }

    private void createMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        Action action_gotoWebUI = new Action("Go to CBS WebUI"){

            public ImageDescriptor getImageDescriptor() {
                return ActivationPlugin.getDefault().createImageDescriptor("cbs_webui.gif");
            }

            public void run() {
                block6: {
                    IDevelopmentConfiguration devConfig = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration();
                    if (devConfig != null) {
                        try {
                            String url = devConfig.getCBSwebUiURL();
                            if (url != null && !url.equals("")) {
                                IBuildSpace buildSpace = devConfig.getBuildSpace();
                                if (buildSpace != null) {
                                    url = url + "?BSName=" + buildSpace.getName();
                                }
                                Platform.getPlatform().openWithDefaultApplication(url);
                                break block6;
                            }
                            ActivationRequestView.this.setErrorMessageOnStatusBar("Invalid URL of CBS WebUI.");
                        }
                        catch (DevConfigException x) {
                            ActivationRequestView.this.setErrorMessageOnStatusBar("Retrieving URL of CBS WebUI failed: " + x.getMessage());
                            LogUtil.logException((Location)LOCATION, (Throwable)x);
                        }
                    } else {
                        ActivationRequestView.this.setErrorMessageOnStatusBar("Internal error: Current development configuration is <null>.");
                    }
                }
            }
        };
        menuManager.add((IAction)action_gotoWebUI);
        menuManager.add((IContributionItem)new Separator());
        MenuManager showIconOrTextMenu = new MenuManager("Show Status as");
        menuManager.add((IContributionItem)showIconOrTextMenu);
        Action action_showAsIcon = new Action("Icon"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationRequestView.this.showRequestStatusAsText(false);
            }
        };
        action_showAsIcon.setChecked(false);
        Action action_showAsText = new Action("Text"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationRequestView.this.showRequestStatusAsText(true);
            }
        };
        action_showAsText.setChecked(false);
        showIconOrTextMenu.add((IAction)action_showAsIcon);
        showIconOrTextMenu.add((IAction)action_showAsText);
        showIconOrTextMenu.addMenuListener(new IMenuListener((IAction)action_showAsIcon, (IAction)action_showAsText){
            private final /* synthetic */ IAction val$action_showAsIcon;
            private final /* synthetic */ IAction val$action_showAsText;
            {
                this.val$action_showAsIcon = val$action_showAsIcon;
                this.val$action_showAsText = val$action_showAsText;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean showAsText = ActivationRequestView.this.showStatusAsText();
                this.val$action_showAsIcon.setChecked(!showAsText);
                this.val$action_showAsText.setChecked(showAsText);
            }
        });
        MenuManager sortMenu = new MenuManager("Sort Requests");
        menuManager.add((IContributionItem)sortMenu);
        Action action_sortByID = new Action("by Creation Date"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationPlugin.getDefault().getPreferenceStore().setValue("com.sap.ide.eclipse.cbs.activation_sortRequestByStatus", !this.isChecked());
                ActivationRequestView.this.sortRequestViewer();
            }
        };
        action_sortByID.setChecked(false);
        Action action_sortByStatus = new Action("by Status"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationPlugin.getDefault().getPreferenceStore().setValue("com.sap.ide.eclipse.cbs.activation_sortRequestByStatus", this.isChecked());
                ActivationRequestView.this.sortRequestViewer();
            }
        };
        action_sortByStatus.setChecked(false);
        Action action_sortAscending = new Action("Ascending"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationPlugin.getDefault().getPreferenceStore().setValue("com.sap.ide.eclipse.cbs.activation_sortRequestAscending", this.isChecked());
                ActivationRequestView.this.sortRequestViewer();
            }
        };
        action_sortAscending.setChecked(false);
        Action action_sortDescending = new Action("Descending"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                ActivationPlugin.getDefault().getPreferenceStore().setValue("com.sap.ide.eclipse.cbs.activation_sortRequestAscending", !this.isChecked());
                ActivationRequestView.this.sortRequestViewer();
            }
        };
        action_sortDescending.setChecked(false);
        sortMenu.add((IAction)action_sortByID);
        sortMenu.add((IAction)action_sortByStatus);
        sortMenu.add((IContributionItem)new Separator());
        sortMenu.add((IAction)action_sortAscending);
        sortMenu.add((IAction)action_sortDescending);
        sortMenu.addMenuListener(new IMenuListener((IAction)action_sortByID, (IAction)action_sortByStatus, (IAction)action_sortAscending, (IAction)action_sortDescending){
            private final /* synthetic */ IAction val$action_sortByID;
            private final /* synthetic */ IAction val$action_sortByStatus;
            private final /* synthetic */ IAction val$action_sortAscending;
            private final /* synthetic */ IAction val$action_sortDescending;
            {
                this.val$action_sortByID = val$action_sortByID;
                this.val$action_sortByStatus = val$action_sortByStatus;
                this.val$action_sortAscending = val$action_sortAscending;
                this.val$action_sortDescending = val$action_sortDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByStatus = ActivationRequestView.this.isRequestViewerSortedByStatus();
                boolean sortAscending = ActivationRequestView.this.isRequestViewerAscendingSorted();
                this.val$action_sortByID.setChecked(!sortByStatus);
                this.val$action_sortByStatus.setChecked(sortByStatus);
                this.val$action_sortAscending.setChecked(sortAscending);
                this.val$action_sortDescending.setChecked(!sortAscending);
            }
        });
        Action action_viewLegend = new Action("Display Legend"){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor("showlegend.gif");
            }

            public void run() {
                new LegendDialog(ActivationRequestView.this.getSite().getShell(), ActivationRequestView.this.getLegendManager(), this.getImageDescriptor().createImage(true)).open();
            }
        };
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)action_viewLegend);
        menuManager.addMenuListener(new IMenuListener((IAction)action_gotoWebUI){
            private final /* synthetic */ IAction val$action_gotoWebUI;
            {
                this.val$action_gotoWebUI = val$action_gotoWebUI;
            }

            public void menuAboutToShow(IMenuManager arg0) {
                IDevelopmentConfiguration devConfig = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration();
                this.val$action_gotoWebUI.setEnabled(devConfig != null);
            }
        });
    }

    private boolean showStatusAsText() {
        return ActivationPlugin.getDefault().getPreferenceStore().getBoolean("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_showRequestStatusText");
    }

    private boolean isRequestViewerSortedByStatus() {
        return ActivationPlugin.getDefault().getPreferenceStore().getBoolean("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_sortRequestByStatus");
    }

    private boolean isRequestViewerAscendingSorted() {
        return ActivationPlugin.getDefault().getPreferenceStore().getBoolean("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_sortRequestAscending");
    }

    private void showRequestStatusAsText(final boolean asText) {
        ActivationPlugin.getDefault().getPreferenceStore().setValue("com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView_showRequestStatusText", asText);
        BusyIndicator.showWhile((Display)this.getViewSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ActivationRequestView.this.m_requestTableTreeViewer.refresh(true);
                Table table = ActivationRequestView.this.m_requestTableTreeViewer.getTableTree().getTable();
                TableColumn column1 = table.getColumn(1);
                TableColumn column2 = table.getColumn(2);
                column1.setText(asText ? ActivationRequestView.LABEL_ACTIVATION_STATUS : "");
                column1.setImage(asText ? null : ActivationPlugin.getDefault().getAtomicImage("activate_hd.gif"));
                column1.setResizable(asText);
                column2.setText(asText ? ActivationRequestView.LABEL_DEPLOYMENT_STATUS : "");
                column2.setImage(asText ? null : ActivationPlugin.getDefault().getAtomicImage("deploy_hd.gif"));
                column2.setResizable(asText);
                if (!asText) {
                    column1.setWidth(25);
                    column2.setWidth(25);
                } else {
                    column1.pack();
                    column2.pack();
                }
            }
        });
    }

    private void sortRequestViewer() {
        BusyIndicator.showWhile((Display)this.getViewSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ActivationRequestView.this.m_requestTableTreeViewer.setSorter((ViewerSorter)new BuildRequestViewerSorter(ActivationRequestView.this.isRequestViewerSortedByStatus(), ActivationRequestView.this.isRequestViewerAscendingSorted()));
            }
        });
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)ActivationRequestView.this.getViewSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!(ActivationRequestView.access$1300(17.access$1400(this.this$1)).getInput() instanceof IBuildRequest[])) {
                            return;
                        }
                        ActivationRequestView.access$100(17.access$1400(this.this$1));
                        ISelection lastSelected = ActivationRequestView.access$1300(17.access$1400(this.this$1)).getSelection();
                        ActivationRequestView.access$200(17.access$1400(this.this$1), null);
                        ActivationRuntimeDataStorage.getStorage().updateBuildRequestStatus((IBuildRequest[])ActivationRequestView.access$1300(17.access$1400(this.this$1)).getInput());
                        ActivationRequestView.access$1300(17.access$1400(this.this$1)).refresh();
                        ActivationRequestView.access$1300(17.access$1400(this.this$1)).setSelection(lastSelected, true);
                    }
                });
            }

            public ImageDescriptor getImageDescriptor() {
                return ActivationPlugin.getDefault().createImageDescriptor("refresh.gif");
            }

            public String getToolTipText() {
                return "Refresh";
            }

            static /* synthetic */ ActivationRequestView access$1400(17 x0) {
                return x0.ActivationRequestView.this;
            }
        };
        toolbarManager.add((IAction)refreshAction);
    }

    private void setInitialViewState() {
        if (this.m_requestTableTreeViewer.getElementAt(0) != null) {
            this.m_requestTableTreeViewer.setSelection((ISelection)new StructuredSelection(this.m_requestTableTreeViewer.getElementAt(0)));
        }
    }

    private void updateDetailsArea(final boolean inputChanged) {
        if (inputChanged || !(this.getCurrentSelection() instanceof IBuildRequest)) {
            int i = 0;
            while (i < this.m_tabFolder.getItemCount()) {
                this.m_tabFolder.getItem(i).setControl(null);
                ++i;
            }
        }
        if (!(this.getCurrentSelection() instanceof IBuildRequest)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TabItem tabItem = ActivationRequestView.this.m_tabFolder.getItem(ActivationRequestView.this.getCurrentTabIndex());
                if (tabItem != null && (tabItem.getControl() == null || inputChanged)) {
                    if (ActivationRequestView.this.getCurrentTabIndex() == 0) {
                        tabItem.setControl(ActivationRequestView.this.createTabActivity((Composite)ActivationRequestView.this.m_tabFolder, (IBuildRequest)ActivationRequestView.this.getCurrentSelection()));
                    } else if (ActivationRequestView.this.getCurrentTabIndex() == 1) {
                        tabItem.setControl(ActivationRequestView.this.createTabActivationResult((Composite)ActivationRequestView.this.m_tabFolder, (IBuildRequest)ActivationRequestView.this.getCurrentSelection()));
                    } else if (ActivationRequestView.this.getCurrentTabIndex() == 2) {
                        tabItem.setControl(ActivationRequestView.this.createTabDeploymentResult((Composite)ActivationRequestView.this.m_tabFolder, (IBuildRequest)ActivationRequestView.this.getCurrentSelection()));
                    }
                }
            }
        });
    }

    private Control createTabActivity(Composite parent, IBuildRequest buildRequest) {
        Composite tabArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        tabArea.setLayout((Layout)gridLayout);
        tabArea.setLayoutData((Object)new GridData(1808));
        Group group = new Group(tabArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = new TreeViewer((Composite)group, 768);
        treeViewer.setContentProvider((IContentProvider)new RequestActivityTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new RequestActivityTreeLabelProvider());
        treeViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        treeViewer.getTree().setBackground(this.getSite().getShell().getDisplay().getSystemColor(22));
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.setInput((Object)buildRequest);
        return tabArea;
    }

    private Control createTabActivationResult(Composite parent, IBuildRequest buildRequest) {
        return this.createResultTab(parent, buildRequest, true);
    }

    private Control createTabDeploymentResult(Composite parent, IBuildRequest buildRequest) {
        return this.createResultTab(parent, buildRequest, false);
    }

    private Control createResultTab(Composite parent, IBuildRequest buildRequest, final boolean showActivationResult) {
        Composite tabArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        tabArea.setLayout((Layout)gridLayout);
        tabArea.setLayoutData((Object)new GridData(1808));
        Group group = new Group(tabArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        final TreeViewer treeViewer = new TreeViewer((Composite)group, 768);
        treeViewer.setContentProvider((IContentProvider)new DCBuildResultTreeContentProvider(showActivationResult));
        treeViewer.setLabelProvider((IBaseLabelProvider)new DCBuildResultTreeLabelProvider(showActivationResult));
        treeViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        treeViewer.getTree().setBackground(this.getSite().getShell().getDisplay().getSystemColor(22));
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        Composite buttonArea = new Composite(tabArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 6;
        buttonArea.setLayout((Layout)gridLayout);
        buttonArea.setLayoutData((Object)new GridData(1042));
        final Button bnViewLog = new Button(buttonArea, 8);
        bnViewLog.setText(showActivationResult ? "View Activation Log" : "View Deployment Log");
        bnViewLog.setEnabled(false);
        GridData gridData = new GridData(2);
        gridData.widthHint = LayoutHelper.getButtonWidthHint((Button)bnViewLog);
        gridData.heightHint = LayoutHelper.getButtonHeigthHint((Button)bnViewLog);
        bnViewLog.setLayoutData((Object)gridData);
        Action actViewLog = new Action(){

            public String getText() {
                return bnViewLog.getText();
            }

            public void run() {
                ActivationRequestView.this.clearStatusBar();
                Object selected = ((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
                if (selected instanceof XTreeNodeDCBuildResult) {
                    XTreeNodeDCBuildResult nodeDCBuildResult = (XTreeNodeDCBuildResult)selected;
                    String logUrl = "";
                    logUrl = showActivationResult ? nodeDCBuildResult.getBuildVariantResult().getLogURL() : ActivationRuntimeDataStorage.getStorage().getDeploymentLogUrl(nodeDCBuildResult.getBuildRequest(), nodeDCBuildResult.getBuildDCResult(), nodeDCBuildResult.getBuildVariantResult());
                    if (!"".equals(logUrl)) {
                        Platform.getPlatform().openWithDefaultApplication(logUrl);
                    } else {
                        ActivationRequestView.this.setErrorMessageOnStatusBar("Invalid URL of log file.");
                    }
                }
            }
        };
        bnViewLog.addSelectionListener((SelectionListener)new SelectionAdapter((IAction)actViewLog){
            private final /* synthetic */ IAction val$actViewLog;
            {
                this.val$actViewLog = val$actViewLog;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$actViewLog.run();
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    Object selected;
                    ActivationRequestView.this.clearStatusBar();
                    IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                    if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof XTreeNodeDCBuildResult) {
                        if (showActivationResult) {
                            bnViewLog.setEnabled(true);
                        } else {
                            XTreeNodeDCBuildResult dcNode = (XTreeNodeDCBuildResult)selection.getFirstElement();
                            Boolean isFinished = ActivationRuntimeDataStorage.getStorage().isRuntimeDeploymentFinished(dcNode.getBuildRequest(), dcNode.getBuildDCResult(), dcNode.getBuildVariantResult());
                            bnViewLog.setEnabled(isFinished != null && isFinished != false);
                        }
                        return;
                    }
                }
                bnViewLog.setEnabled(false);
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)actViewLog);
        Menu contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener((IAction)actViewLog){
            private final /* synthetic */ IAction val$actViewLog;
            {
                this.val$actViewLog = val$actViewLog;
            }

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                if (treeViewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)treeViewer.getSelection()).size() == 1 && selection.getFirstElement() instanceof XTreeNodeDCBuildResult) {
                    if (showActivationResult) {
                        this.val$actViewLog.setEnabled(true);
                    } else {
                        XTreeNodeDCBuildResult dcNode = (XTreeNodeDCBuildResult)selection.getFirstElement();
                        Boolean isFinished = ActivationRuntimeDataStorage.getStorage().isRuntimeDeploymentFinished(dcNode.getBuildRequest(), dcNode.getBuildDCResult(), dcNode.getBuildVariantResult());
                        this.val$actViewLog.setEnabled(isFinished != null && isFinished != false);
                    }
                    return;
                }
                this.val$actViewLog.setEnabled(false);
            }
        });
        treeViewer.setInput((Object)buildRequest);
        return tabArea;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        ActivationPlugin.getDefault().addActivationListener(this);
        ActivationPlugin.getDefault().addDevelopmentConfigurationListener(this);
        VfsManagerProvider.getInstance().addIDELoginListener((IIDELoginListener)this);
        this.m_viewId = cfig.getAttribute("id");
        this.m_viewName = cfig.getAttribute("name");
    }

    public void dispose() {
        ActivationPlugin.getDefault().removeActivationListener(this);
        ActivationPlugin.getDefault().removeDevelopmentConfigurationListener(this);
        VfsManagerProvider.getInstance().removeIDELoginListener((IIDELoginListener)this);
        super.dispose();
    }

    public void setFocus() {
        if (this.m_requestTableTreeViewer != null) {
            this.m_requestTableTreeViewer.getTableTree().setFocus();
        }
    }

    public void selectReveal(ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IBuildRequest) {
            if (this.m_requestTableTreeViewer.testFindItem(obj) == null) {
                this.m_requestTableTreeViewer.refresh();
            }
            this.m_requestTableTreeViewer.setSelection(selection, true);
        }
    }

    private void setErrorMessageOnStatusBar(String message) {
        this.clearStatusBar();
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
    }

    public void onActivationRequestCreated(IBuildRequest buildRequest) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ActivationRequestView.this.setDefaultTableInput();
                ActivationRequestView.this.setInitialViewState();
            }
        });
    }

    public void onActivationRequestStatusChanged(final IBuildRequest[] buildRequests) {
        if (buildRequests != null) {
            BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < buildRequests.length) {
                        ActivationRequestView.this.m_requestTableTreeViewer.refresh((Object)buildRequests[i], true);
                        ++i;
                    }
                }
            });
        }
    }

    public void onActivationRequestFinished(final IBuildRequest[] buildRequests) {
        if (buildRequests != null) {
            BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < buildRequests.length) {
                        ActivationRequestView.this.m_requestTableTreeViewer.refresh((Object)buildRequests[i], true);
                        ++i;
                    }
                }
            });
        }
    }

    public void onActivationRequestDeleted(IBuildRequest[] buildRequests) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ActivationRequestView.this.setDefaultTableInput();
                ActivationRequestView.this.setInitialViewState();
            }
        });
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ActivationRequestView.this.setDefaultTableInput();
                ActivationRequestView.this.setInitialViewState();
            }
        });
    }

    public void onUserLoggedOut() {
        this.m_requestTableTreeViewer.setInput((Object)OFFLINE);
    }

    private void setDefaultTableInput() {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IBuildRequest[] requests = ActivationRuntimeDataStorage.getStorage().getActivationHistory();
                if (requests != null && requests.length > 0) {
                    ActivationRequestView.this.m_requestTableTreeViewer.setInput((Object)requests);
                } else {
                    ActivationRequestView.this.m_requestTableTreeViewer.setInput((Object)new MessageViewerInput("No activation requests found.", 1));
                }
            }
        });
    }

    private Object getCurrentSelection() {
        return this.m_currentSelection;
    }

    private void setCurrentSelection(Object currentSelection) {
        this.m_currentSelection = currentSelection;
    }

    private int getCurrentTabIndex() {
        return this.m_currentTabIndex;
    }

    private void setCurrentTabIndex(int currentTabIndex) {
        this.m_currentTabIndex = currentTabIndex;
    }

    private void clearStatusBar() {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
    }

    public void onActiveDevelopmentConfigurationChanged(IDevelopmentConfiguration newDevConfig, IDevelopmentConfiguration oldDevConfig) {
        if (!VfsManagerProvider.getInstance().isUserLoggedinInSapIDE()) {
            this.m_requestTableTreeViewer.setInput((Object)OFFLINE);
        } else {
            this.setDefaultTableInput();
        }
        this.setInitialViewState();
        this.updateDetailsArea(true);
        this.updateViewTitle();
    }

    private void updateViewTitle() {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient == null) {
            return;
        }
        String activeClientName = activeClient.getName();
        if (activeClientName != null) {
            String title = this.getTitle();
            if (title.indexOf(VIEW_TITLE_SEPARATOR) == -1) {
                this.setTitle(title + VIEW_TITLE_SEPARATOR + activeClientName);
            } else {
                this.setTitle(title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR)) + VIEW_TITLE_SEPARATOR + activeClientName);
            }
        }
    }

    private IRepositoryViewLegendManager getLegendManager() {
        if (this.m_legendManager == null) {
            this.m_legendManager = new IRepositoryViewLegendManager(){

                public ILegend[] getViewLegend() {
                    ArrayList<LegendElement> legendList = new ArrayList<LegendElement>();
                    ActivationPlugin plugin = ActivationPlugin.getDefault();
                    legendList.add(new LegendElement("Object Types:"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("jiSCInactive.gif"), "Software Component"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("build_variant.gif"), "Build Variant"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("jiDevelopmentComponent.gif"), "Development Component"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("ACTIVITY_INACTIVE.gif"), "Request Activity"));
                    legendList.add(new LegendElement("Version, folder", (Object)VfsFolderItemCategory.FOLDER, (Object)"VERSIONED", null, null, null));
                    legendList.add(new LegendElement("Version, file", (Object)VfsFolderItemCategory.FILE, (Object)"VERSIONED", null, null, null));
                    legendList.add(new LegendElement("Decorators:"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("activate_co.gif"), ActivationRequestView.LABEL_ACTIVATION_STATUS));
                    legendList.add(new LegendElement(plugin.getAtomicImage("deploy_co.gif"), ActivationRequestView.LABEL_DEPLOYMENT_STATUS));
                    legendList.add(new LegendElement(plugin.getAtomicImage("succeeded_v.gif"), "Status: succeeded"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("processing_v.gif"), "Status: processing"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("failed_v.gif"), "Status: failed"));
                    legendList.add(new LegendElement(plugin.getAtomicImage("unknown_v.gif"), "Status: unknown"));
                    return legendList.toArray(new ILegend[legendList.size()]);
                }

                public String getViewId() {
                    return ActivationRequestView.this.m_viewId != null ? ActivationRequestView.this.m_viewId : "com.sap.ide.eclipse.cbs.activation.ui.views.ActivationRequestView";
                }

                public String getViewName() {
                    return ActivationRequestView.this.m_viewName != null ? ActivationRequestView.this.m_viewName : "Activation Requests";
                }
            };
        }
        return this.m_legendManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

