/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.ui;

import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.cbs.activation.ui.ActivationRequestMessageDialog;
import com.sap.ide.eclipse.cbs.activation.ui.ExplanationDialog;
import com.sap.ide.eclipse.cbs.activation.ui.providers.IntersectionTreeLabelProvider;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.sap.tc.cbs.client.ActivationCheckMode;
import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.IActivityIntersection;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.InputMode;
import com.sap.tc.cbs.client.error.ActivationCheckFailedException;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsVersionLabelProvider;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.MultiMap;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActivationIntersectionDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$cbs$activation$ui$ActivationIntersectionDialog == null ? (class$com$sap$ide$eclipse$cbs$activation$ui$ActivationIntersectionDialog = ActivationIntersectionDialog.class$("com.sap.ide.eclipse.cbs.activation.ui.ActivationIntersectionDialog")) : class$com$sap$ide$eclipse$cbs$activation$ui$ActivationIntersectionDialog));
    private static final String BUTTON_LABEL_ACTIVATE = "Activate";
    private static final String BUTTON_LABEL_ACTIVATE_ALL = "Activate with all Predecessors";
    private static final String BUTTON_LABEL_ADVANCED = "Advanced";
    private static final String BUTTON_LABEL_ADVANCED_EXT_ON = " >>";
    private static final String BUTTON_LABEL_ADVANCED_EXT_OFF = "<< ";
    private static final int BUTTON_ID_ADVANCED = 1025;
    private static final String OPTION_LABEL_IF_BUILD_FAILS = "Activate even if build fails";
    private static final String MSG_FOUND_COUNT = "(found";
    private static final int PROGRESS_START = 25000;
    private static final int PROGRESS_END = 100000;
    private IBuildSpace m_buildSpace;
    private ClosedActivityWrapper[] m_selection;
    private List m_oidsOfSelection = null;
    private boolean m_ignoreDCIntersection;
    private boolean m_activateWithAll;
    private List m_activitySetList = new ArrayList();
    private Map m_activityOidAndIntersection = new HashMap();
    private Map m_oidAndClosedActivityWrapper = new HashMap();
    private Map m_intersectionsDummyMap;
    private Map m_objectIntersections;
    private Map m_dcIntersections;
    private Label m_image;
    private Label m_message;
    private TreeViewer m_intersectionViewer;
    private Text m_txDesc;
    private Text m_txLastmodi;
    private TableViewer m_tabViewer;
    private Button m_cxActivateIfFails;
    private ProgressMonitorPart m_progressBar;
    private KeyListener m_keyListener;
    private MessageViewerInput m_treeNode_selection;
    private MessageViewerInput m_treeNode_intersection;
    private Button m_cxDCIntersection;
    static /* synthetic */ Class class$com$sap$ide$eclipse$cbs$activation$ui$ActivationIntersectionDialog;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper;
    static /* synthetic */ Class class$java$lang$String;

    public ActivationIntersectionDialog(Shell parent, IBuildSpace buildSpace, ClosedActivityWrapper[] wrappers) {
        super(parent);
        if (buildSpace == null || wrappers == null || wrappers.length < 1) {
            throw new IllegalArgumentException("Clould not initialize ActivationIntersectionDialog because argument is <null>.");
        }
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.m_buildSpace = buildSpace;
        this.m_selection = wrappers;
        this.m_ignoreDCIntersection = this.getPreferenceStore().getBoolean("com.sap.ide.eclipse.cbs.activation_ignoreDCIntersection");
        this.m_treeNode_selection = wrappers.length > 1 ? new MessageViewerInput("Selected Activities", ActivationPlugin.getDefault().getAtomicImage("selection.gif")) : new MessageViewerInput("Selected Activity", ActivationPlugin.getDefault().getAtomicImage("selection.gif"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Activation");
    }

    public int open() {
        this.setBlockOnOpen(false);
        int open = super.open();
        if (this.m_ignoreDCIntersection && this.m_objectIntersections == null || !this.m_ignoreDCIntersection && this.m_dcIntersections == null) {
            this.performIntersectionCheck();
        }
        return open;
    }

    private KeyListener getDialogKeyListener() {
        if (this.m_keyListener == null) {
            this.m_keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000A && e.stateMask == 0) {
                        ActivationIntersectionDialog.this.explainIntersectionOption();
                    }
                    if (e.keyCode == 27 && e.stateMask == 0) {
                        ActivationIntersectionDialog.this.buttonPressed(1);
                    }
                }
            };
        }
        return this.m_keyListener;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Composite monitorComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        monitorComposite.setLayout((Layout)gridLayout);
        monitorComposite.setLayoutData((Object)new GridData(776));
        Composite buttonBar = (Composite)super.createButtonBar(composite);
        buttonBar.setLayoutData((Object)new GridData(136));
        Layout layout = buttonBar.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
        }
        this.m_progressBar = new ProgressMonitorPart(monitorComposite, (Layout)new GridLayout());
        this.m_progressBar.setLayoutData((Object)new GridData(768));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, BUTTON_LABEL_ACTIVATE_ALL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 1025, "Advanced >>", false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setText(BUTTON_LABEL_ACTIVATE);
        this.addDialogKeyListener((Composite)this.getShell());
        return control;
    }

    private void addDialogKeyListener(Composite parent) {
        parent.addKeyListener(this.getDialogKeyListener());
        Control[] childrens = parent.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] instanceof Composite) {
                this.addDialogKeyListener((Composite)childrens[i]);
            } else {
                childrens[i].addKeyListener(this.getDialogKeyListener());
            }
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseArea = (Composite)super.createDialogArea(parent);
        int defaultMessageWidth = this.getMinimumMessageWidth();
        Composite messageArea = new Composite(baseArea, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        messageArea.setLayout((Layout)gridLayout);
        messageArea.setLayoutData((Object)new GridData(768));
        this.m_image = new Label(messageArea, 0);
        this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
        this.m_image.setLayoutData((Object)new GridData(2));
        this.m_message = new Label(messageArea, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = defaultMessageWidth * 4 / 3;
        this.m_message.setLayoutData((Object)gridData);
        this.m_message.setText("");
        Composite selectionArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        selectionArea.setLayout((Layout)gridLayout);
        selectionArea.setLayoutData((Object)new GridData(1809));
        Label lbIntersection = new Label(selectionArea, 0);
        lbIntersection.setText("Predecessors Check:");
        lbIntersection.setLayoutData((Object)new GridData());
        this.m_intersectionViewer = new TreeViewer(selectionArea, 2816);
        IntersectionTreeContentProvider contentProvider = new IntersectionTreeContentProvider();
        this.m_intersectionViewer.setContentProvider((IContentProvider)contentProvider);
        this.m_intersectionViewer.setLabelProvider((IBaseLabelProvider)new IntersectionTreeLabelProvider());
        this.m_intersectionViewer.setSorter((ViewerSorter)new IntersectionTreeSorter());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = defaultMessageWidth / 3;
        this.m_intersectionViewer.getTree().setLayoutData((Object)gridData);
        this.m_cxDCIntersection = new Button(selectionArea, 32);
        this.m_cxDCIntersection.setText("Calculate predecessor activities based ONLY on overlapping files");
        this.m_cxDCIntersection.setToolTipText("Press F1 for Help");
        this.m_cxDCIntersection.setLayoutData((Object)new GridData(32));
        Button bnInfo = new Button(selectionArea, 0x800008);
        bnInfo.setImage(ActivationPlugin.getDefault().getAtomicImage("explain.gif"));
        bnInfo.setToolTipText("Get Explanation...");
        gridData = new GridData(32);
        gridData.heightHint = 20;
        gridData.widthHint = 20;
        bnInfo.setLayoutData((Object)gridData);
        Group infoGroup = new Group(baseArea, 0);
        infoGroup.setText("Activity Details");
        infoGroup.setLayout((Layout)new GridLayout(2, false));
        infoGroup.setLayoutData((Object)new GridData(1809));
        Label label = new Label((Composite)infoGroup, 0);
        label.setText("Description:");
        label.setLayoutData((Object)new GridData(2));
        this.m_txDesc = new Text((Composite)infoGroup, 2632);
        gridData = new GridData(1792);
        gridData.heightHint = defaultMessageWidth / 6;
        this.m_txDesc.setLayoutData((Object)gridData);
        label = new Label((Composite)infoGroup, 0);
        label.setText("Elements:");
        label.setLayoutData((Object)new GridData(2));
        this.m_tabViewer = new TableViewer((Composite)infoGroup, 2818);
        this.m_tabViewer.setContentProvider((IContentProvider)new ActivityElementsContentProvider());
        this.m_tabViewer.setLabelProvider((IBaseLabelProvider)new VfsVersionLabelProvider());
        this.m_tabViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        gridData = new GridData(1808);
        gridData.heightHint = defaultMessageWidth / 4;
        this.m_tabViewer.getTable().setLayoutData((Object)gridData);
        this.m_tabViewer.getTable().setBackground(this.getShell().getDisplay().getSystemColor(22));
        label = new Label((Composite)infoGroup, 0);
        label.setText("Last modified:");
        label.setLayoutData((Object)new GridData());
        this.m_txLastmodi = new Text((Composite)infoGroup, 2060);
        this.m_txLastmodi.setLayoutData((Object)new GridData(768));
        gridData = new GridData(768);
        new Label(baseArea, 0).setLayoutData((Object)gridData);
        Composite advanceArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        advanceArea.setLayout((Layout)gridLayout);
        advanceArea.setLayoutData((Object)new GridData(768));
        this.m_cxActivateIfFails = new Button(advanceArea, 32);
        this.m_cxActivateIfFails.setText(OPTION_LABEL_IF_BUILD_FAILS);
        this.m_cxActivateIfFails.setLayoutData((Object)new GridData(896));
        this.m_cxActivateIfFails.setVisible(false);
        this.m_cxDCIntersection.setSelection(this.m_ignoreDCIntersection);
        this.m_cxDCIntersection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)ActivationIntersectionDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ActivationIntersectionDialog.access$500(2.access$400(this.this$1));
                        ActivationIntersectionDialog.access$602(2.access$400(this.this$1), ActivationIntersectionDialog.access$700(2.access$400(this.this$1)).getSelection());
                        ActivationIntersectionDialog.access$800(2.access$400(this.this$1)).setValue("com.sap.ide.eclipse.cbs.activation_ignoreDCIntersection", ActivationIntersectionDialog.access$600(2.access$400(this.this$1)));
                        ActivationIntersectionDialog.access$900(2.access$400(this.this$1));
                    }
                });
            }

            static /* synthetic */ ActivationIntersectionDialog access$400(2 x0) {
                return x0.ActivationIntersectionDialog.this;
            }
        });
        bnInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivationIntersectionDialog.this.explainIntersectionOption();
            }
        });
        this.m_intersectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                BusyIndicator.showWhile((Display)ActivationIntersectionDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this, event){
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        Object selected = ((IStructuredSelection)this.val$event.getSelection()).getFirstElement();
                        if (selected != null) {
                            ActivationIntersectionDialog.access$1100(5.access$1000(this.this$1), selected);
                        }
                    }
                });
            }

            static /* synthetic */ ActivationIntersectionDialog access$1000(5 x0) {
                return x0.ActivationIntersectionDialog.this;
            }
        });
        this.m_intersectionViewer.setInput((Object)this.m_selection);
        this.m_intersectionViewer.expandToLevel(2);
        this.m_intersectionViewer.getTree().setFocus();
        this.m_cxActivateIfFails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog warnDialog;
                if (ActivationIntersectionDialog.this.m_cxActivateIfFails.getSelection() && (warnDialog = new MessageDialog(ActivationIntersectionDialog.this.getShell(), "DC(s) Could be Broken!", null, "Attention: Involved Development Component(s) could be broken!\n\nAre you sure you want to activate with the option \"Activate even if build fails\"?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1)).open() != 0) {
                    ActivationIntersectionDialog.this.m_cxActivateIfFails.setSelection(false);
                }
            }
        });
        return baseArea;
    }

    private void explainIntersectionOption() {
        String text = "Predecessor activities are activities that have been checked-in before the selected activties but that are not yet activated. They are of the following types:\n\n1. Predecessors based ONLY on overlapping files (file predecessors)\n\tare activities which contain same files as in selected activities.\n\n2. Predecessors based on involved Development Components (DC predecessors)\n\tare activities which contain files from same DCs as in selected activities.\n\tNote: This includes all activities of type 1.\n\nChoosing type 2 (deselected checkbox) increases the probability for successful activation for involved DCs, as all DC predecessors are considered. Therefor the probability for semantical (i.e. non-compile time) errors is usually reduced.\n\nNote: Predecessors may also be from other users.\n\n\nIf the \"Activate\" or \"Activate with all Predecessors\" button is pressed, all displayed activities (calculated depending on the state of checkbox) will be used for activation. After activation, either all displayed activities are active or (if activation fails) none of them.";
        new ExplanationDialog(this.getShell(), "Predecessor Activity Types", text).open();
    }

    private void updateIntersectionTree(Map intersectionMap) {
        ClosedActivityWrapper[] intersections = (ClosedActivityWrapper[])Util.getArrayFromIterator(intersectionMap.values().iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? (class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper = ActivationIntersectionDialog.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper")) : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper));
        int count = intersections.length;
        MessageViewerInput messageViewerInput = this.m_treeNode_intersection = count > 1 ? new MessageViewerInput("Predecessor Activities", Dialog.getImage((String)"dialog_messasge_warning_image")) : new MessageViewerInput("Predecessor Activity", Dialog.getImage((String)"dialog_messasge_warning_image"));
        if (count > 0) {
            ((IntersectionTreeContentProvider)this.m_intersectionViewer.getContentProvider()).addAllIntersections(intersections);
            String predActMessage = count > 1 ? "predecessor activities" : "predecessor activity";
            predActMessage = this.m_ignoreDCIntersection ? predActMessage + " based on overlapping files" : predActMessage + " based on involved Development Components";
            this.setMessage("" + count + " " + predActMessage + " detected.", 2);
        } else {
            ((IntersectionTreeContentProvider)this.m_intersectionViewer.getContentProvider()).addAllIntersections(null);
            this.setMessage("No predecessor activity detected.", 1);
        }
        this.m_intersectionViewer.refresh();
        if (count > 0) {
            this.m_intersectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_treeNode_intersection), true);
            this.m_intersectionViewer.expandToLevel((Object)this.m_treeNode_intersection, 1);
        }
        this.switchActivateButtons(count > 0);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.performActivation();
        } else if (buttonId == 1025) {
            this.handleAdvancedButtonPressed();
        } else if (buttonId == 1) {
            ProgressMonitorPart progressMonitorPart = this.m_progressBar;
            synchronized (progressMonitorPart) {
                if (this.m_progressBar.getVisible()) {
                    this.m_progressBar.setCanceled(true);
                }
                this.close();
            }
        }
        this.setReturnCode(buttonId);
    }

    private void performActivation() {
        IDevelopmentConfiguration activeDevConfig = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration();
        if (activeDevConfig == null) {
            this.handleErrorOccurred("Internal error: Unable to determine the current development configuration.");
            return;
        }
        final IBuildSpace buildSpace = activeDevConfig.getBuildSpace();
        if (buildSpace == null) {
            this.handleErrorOccurred("No build space defined for development configuration [" + activeDevConfig.getConfigurationData().getName() + "].");
            return;
        }
        this.clearMessageArea();
        if (!this.checkForeignActivity()) {
            this.getButton(1).setFocus();
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IActivitySet[] activitySets = ActivationIntersectionDialog.this.getActivitySetForActivation();
                if (activitySets == null) {
                    return;
                }
                try {
                    IBuildRequest buildRequest = buildSpace.activate(activitySets, ActivationIntersectionDialog.this.m_ignoreDCIntersection, false, ActivationIntersectionDialog.this.m_cxActivateIfFails.getSelection(), ActivationIntersectionDialog.this.m_activateWithAll ? ActivationCheckMode.FORCE : ActivationCheckMode.REJECT);
                    if (buildRequest == null) {
                        ActivationIntersectionDialog.this.handleErrorOccurred("Internal error: Build request is <null>.");
                        return;
                    }
                    ActivationRuntimeDataStorage.getStorage().addToActivationHistory(buildRequest);
                    new ActivationRequestMessageDialog(ActivationIntersectionDialog.this.getShell(), buildRequest).open();
                }
                catch (Exception x) {
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                    if (x instanceof ActivationCheckFailedException && ((ActivationCheckFailedException)x).getErrorCode().equals("ACTV_CHECK_FAILED")) {
                        ActivationIntersectionDialog.this.handleErrorOccurred("Activation not possible because of inactive predecessors!");
                        ActivationIntersectionDialog.this.performIntersectionCheck();
                        return;
                    }
                    if (x instanceof AuthorizationException && ((AuthorizationException)x).getErrorCode().equals("USR_MISSING_PRIVILEGE")) {
                        try {
                            InputMode inputMode = buildSpace.getInputMode();
                            if (inputMode.equals(InputMode.PRIVILEGED)) {
                                ActivationIntersectionDialog.this.handleErrorOccurred("Buildspace \"" + buildSpace.getName() + "\" currently is in privileged mode." + "Only administrators are allowed to activate. Please try again later.");
                                return;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Logbook.getErrorChapter().println("Activation failed: " + x.getMessage());
                    ActivationIntersectionDialog.this.handleErrorOccurred("Activation failed: " + x.getMessage());
                    return;
                }
                ActivationIntersectionDialog.this.close();
            }
        });
    }

    private boolean checkForeignActivity() {
        if (this.m_ignoreDCIntersection && this.m_objectIntersections == null || !this.m_ignoreDCIntersection && this.m_dcIntersections == null) {
            this.performIntersectionCheck();
        }
        ClosedActivityWrapper[] intersections = this.m_ignoreDCIntersection ? (ClosedActivityWrapper[])Util.getArrayFromIterator(this.m_objectIntersections.values().iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? (class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper = ActivationIntersectionDialog.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper")) : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper)) : (ClosedActivityWrapper[])Util.getArrayFromIterator(this.m_dcIntersections.values().iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? (class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper = ActivationIntersectionDialog.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper")) : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper));
        boolean hasForeignActivity = false;
        int i = 0;
        while (i < intersections.length) {
            try {
                if (intersections[i].activity.isForeign()) {
                    hasForeignActivity = true;
                    break;
                }
            }
            catch (VfsException x) {
                String actName = "?";
                try {
                    actName = intersections[i].activity.getDisplayName();
                }
                catch (VfsException x1) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x1);
                }
                this.setMessage("Retrieving author of activity [" + actName + "] failed: " + x.getMessage(), 2);
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                MessageDialog warnDialog = new MessageDialog(this.getShell(), "Retrieving Author Failed", null, "Retrieving author of activity [" + actName + "] failed: " + x.getMessage() + "\n\nThis can result in activation of another user's activity. Continue?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                return warnDialog.open() == 0;
            }
            ++i;
        }
        if (hasForeignActivity) {
            this.setMessage("The current activation request contains activity(ies) from other user(s).", 2);
            MessageDialog warnDialog = new MessageDialog(this.getShell(), "Foreign Activity(ies)", null, "The current activation request contains activity(ies) from other user(s).\n\nContinue activating?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            return warnDialog.open() == 0;
        }
        return true;
    }

    private IActivitySet[] getActivitySetForActivation() {
        if (this.m_activitySetList.isEmpty()) {
            Compartment compartment;
            CBSFactory cbsFactory = new CBSFactory();
            MultiMap multiMap = new MultiMap();
            int i = 0;
            while (i < this.m_selection.length) {
                IVfsActivity activity = this.m_selection[i].activity;
                compartment = ActivationRuntimeDataStorage.getStorage().getCompartmentForWorksapce(this.m_selection[i].workspace, true);
                if (compartment == null) {
                    String errorMessage = "Internal error: Unable to determine the compartment for workspace [";
                    try {
                        errorMessage = errorMessage + this.m_selection[i].workspace.getBrowsePath();
                    }
                    catch (VfsException x) {
                        Logbook.getErrorChapter().println(x.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    }
                    this.handleErrorOccurred(errorMessage + "].");
                    return null;
                }
                multiMap.put((Object)compartment, (Object)activity);
                ++i;
            }
            Iterator iter = multiMap.keySet().iterator();
            while (iter.hasNext()) {
                compartment = (Compartment)iter.next();
                ArrayList<String> oids = new ArrayList<String>();
                Iterator acts = multiMap.getAll((Object)compartment).iterator();
                while (acts.hasNext()) {
                    try {
                        oids.add(((IVfsActivity)acts.next()).getObjectID());
                    }
                    catch (VfsException x) {
                        this.handleErrorOccurred(x.getMessage());
                        Logbook.getErrorChapter().println(x.getMessage());
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    }
                }
                if (oids.isEmpty()) continue;
                IActivitySet activitySet = cbsFactory.createEmptyActivitySet();
                activitySet.setActivityUIDs(oids.toArray(new String[oids.size()]));
                activitySet.setCompartmentName(compartment.getName());
                this.m_activitySetList.add(activitySet);
            }
            if (this.m_activitySetList.isEmpty()) {
                this.handleErrorOccurred("Building activity set for activation failed.");
                return null;
            }
        }
        return this.m_activitySetList.toArray(new IActivitySet[this.m_activitySetList.size()]);
    }

    private void switchActivateButtons(boolean enableActivateWithAll) {
        this.getButton(0).setText(enableActivateWithAll ? BUTTON_LABEL_ACTIVATE_ALL : BUTTON_LABEL_ACTIVATE);
        if (enableActivateWithAll) {
            this.getButton(1).setFocus();
        }
        this.m_activateWithAll = enableActivateWithAll;
    }

    private void handleAdvancedButtonPressed() {
        boolean visible = this.m_cxActivateIfFails.isVisible();
        this.m_cxActivateIfFails.setVisible(!visible);
        this.getButton(1025).setText(visible ? "Advanced >>" : "<< Advanced");
    }

    private void performIntersectionCheck() {
        if (this.m_ignoreDCIntersection && this.m_objectIntersections == null || !this.m_ignoreDCIntersection && this.m_dcIntersections == null) {
            Color prevColor = this.m_intersectionViewer.getControl().getBackground();
            this.m_intersectionViewer.getControl().setBackground(this.getShell().getDisplay().getSystemColor(22));
            this.m_cxDCIntersection.setEnabled(false);
            this.getDialogArea().setEnabled(false);
            this.getButton(0).setEnabled(false);
            this.getButton(1025).setEnabled(false);
            String predecessorKind = this.m_ignoreDCIntersection ? "predecessors based on overlapping files" : "predecessors based on involved DCs";
            this.setMessage("Calculating " + predecessorKind + " for activation...", 1);
            this.m_progressBar.setVisible(true);
            this.m_progressBar.beginTask("Calculating predecessors...", 100000);
            this.m_progressBar.worked(25000);
            try {
                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ActivationIntersectionDialog.this.findAllIntersectionsForActivation(ActivationIntersectionDialog.this.m_selection, true, monitor, 75000);
                        ActivationIntersectionDialog.this.excludeInitialSelectionFromAllIntersections();
                    }
                }, (boolean)true, (IProgressMonitor)this.m_progressBar, (Display)this.getShell().getDisplay());
            }
            catch (InvocationTargetException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
            catch (InterruptedException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
            if (this.m_progressBar.isCanceled()) {
                return;
            }
            this.m_progressBar.done();
            this.m_progressBar.setVisible(false);
            this.getDialogArea().setEnabled(true);
            this.m_intersectionViewer.getControl().setBackground(prevColor);
            this.m_cxDCIntersection.setEnabled(true);
            this.getButton(0).setEnabled(true);
            this.getButton(1025).setEnabled(true);
            if (this.m_ignoreDCIntersection) {
                this.m_objectIntersections = this.m_intersectionsDummyMap;
            } else {
                this.m_dcIntersections = this.m_intersectionsDummyMap;
            }
        }
        if (this.m_ignoreDCIntersection) {
            this.updateIntersectionTree(this.m_objectIntersections);
        } else {
            this.updateIntersectionTree(this.m_dcIntersections);
        }
    }

    private void findAllIntersectionsForActivation(ClosedActivityWrapper[] wrappers, boolean firstTime, IProgressMonitor monitor, int restProgress) {
        if (firstTime) {
            this.m_intersectionsDummyMap = new HashMap();
        }
        HashSet<ClosedActivityWrapper> notCached = new HashSet<ClosedActivityWrapper>();
        int i = 0;
        while (i < wrappers.length) {
            String oid = this.getObjectID(wrappers[i]);
            if (oid != null) {
                if (firstTime) {
                    if (!this.m_intersectionsDummyMap.containsKey(oid)) {
                        notCached.add(wrappers[i]);
                    }
                } else if (!this.isAlreadyChoosed(oid) && !this.m_activityOidAndIntersection.containsKey(oid)) {
                    notCached.add(wrappers[i]);
                }
            }
            ++i;
        }
        if (!notCached.isEmpty()) {
            ClosedActivityWrapper[] acts = (ClosedActivityWrapper[])Util.getArrayFromIterator(notCached.iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? (class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper = ActivationIntersectionDialog.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper")) : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper));
            int progress = restProgress / acts.length;
            int i2 = 0;
            while (i2 < acts.length) {
                ProgressMonitorPart progressMonitorPart = this.m_progressBar;
                synchronized (progressMonitorPart) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                }
                String actName = "?";
                try {
                    actName = acts[i2].activity.getDisplayName();
                }
                catch (VfsException x) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
                ProgressMonitorPart progressMonitorPart2 = this.m_progressBar;
                synchronized (progressMonitorPart2) {
                    if (!this.m_progressBar.isDisposed()) {
                        monitor.setTaskName("Checking predecessors of \"" + actName + "\"");
                    }
                }
                Map intersections = this.getIntersectingActivities(this.getObjectID(acts[i2]), this.getCompartment(acts[i2]), this.m_ignoreDCIntersection);
                if (intersections != null && !intersections.isEmpty()) {
                    ClosedActivityWrapper[] nextActs;
                    final int oldCount = this.m_intersectionsDummyMap.size();
                    this.m_intersectionsDummyMap.putAll(intersections);
                    if (this.getShell() != null) {
                        this.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                String message;
                                if (ActivationIntersectionDialog.this.m_intersectionsDummyMap.size() > oldCount && (message = ActivationIntersectionDialog.this.getMessage()) != null) {
                                    int index = message.indexOf(" (found");
                                    if (index != -1) {
                                        message = message.substring(0, index);
                                    }
                                    ActivationIntersectionDialog.this.setMessage(message + " " + ActivationIntersectionDialog.MSG_FOUND_COUNT + " " + ActivationIntersectionDialog.this.m_intersectionsDummyMap.size() + ")", 1);
                                }
                            }
                        });
                    }
                    if ((nextActs = (ClosedActivityWrapper[])Util.getArrayFromIterator(intersections.values().iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? ActivationIntersectionDialog.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper") : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper))) != null && nextActs.length > 0) {
                        this.findAllIntersectionsForActivation(nextActs, false, monitor, progress);
                    }
                }
                ProgressMonitorPart progressMonitorPart3 = this.m_progressBar;
                synchronized (progressMonitorPart3) {
                    if (!this.m_progressBar.isDisposed()) {
                        monitor.worked(progress);
                    }
                }
                ++i2;
            }
        }
    }

    private boolean isAlreadyChoosed(String oid) {
        if (this.getOidListOfSelection() != null) {
            return this.getOidListOfSelection().contains(oid);
        }
        return false;
    }

    private List getOidListOfSelection() {
        if (this.m_oidsOfSelection == null) {
            this.m_oidsOfSelection = new ArrayList();
            int i = 0;
            while (i < this.m_selection.length) {
                this.m_oidsOfSelection.add(this.getObjectID(this.m_selection[i]));
                ++i;
            }
        }
        return this.m_oidsOfSelection;
    }

    private void excludeInitialSelectionFromAllIntersections() {
        List oids = this.getOidListOfSelection();
        if (oids != null) {
            Iterator iter = oids.iterator();
            while (iter.hasNext()) {
                this.m_intersectionsDummyMap.remove(iter.next());
            }
        }
    }

    private void handleErrorOccurred(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.getButton(1).setFocus();
    }

    private void updateInfoGroup(Object selected) {
        if (selected instanceof ClosedActivityWrapper) {
            IVfsActivity activity = ((ClosedActivityWrapper)selected).activity;
            try {
                String description = activity.getDescription() == null ? "" : activity.getDescription();
                this.m_txDesc.setText(description);
                this.m_tabViewer.setInput((Object)activity);
                this.m_txLastmodi.setText(Util.getGMTString((Date)activity.getCheckedInDate()) + " by " + activity.getAuthor());
            }
            catch (VfsException x) {
                this.setErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        } else {
            this.m_txDesc.setText("");
            this.m_txLastmodi.setText("");
            this.m_tabViewer.setInput(null);
        }
    }

    private int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    private void setMessage(String message, int messageType) {
        this.m_message.setText(message);
        switch (messageType) {
            case 3: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(3));
                this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(22));
                break;
            }
            case 1: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(29));
                break;
            }
            case 2: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(20));
                break;
            }
            default: {
                this.m_image.setText("");
                this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(22));
            }
        }
        this.m_message.getParent().pack();
    }

    private void setErrorMessage(String message) {
        this.setMessage(message, 3);
    }

    private void clearMessageArea() {
        this.setMessage("", 0);
    }

    private String getMessage() {
        return this.m_message.getText();
    }

    private IPreferenceStore getPreferenceStore() {
        return ActivationPlugin.getDefault().getPreferenceStore();
    }

    private IActivityIntersection getAllIntersectionsForActivity(String oid, Compartment compartment) {
        if (oid != null && compartment != null) {
            if (this.m_activityOidAndIntersection.containsKey(oid)) {
                return (IActivityIntersection)this.m_activityOidAndIntersection.get(oid);
            }
            try {
                IActivityIntersection intersection = this.m_buildSpace.listIntersections(oid, compartment.getName(), false);
                if (intersection != null) {
                    this.m_activityOidAndIntersection.put(oid, intersection);
                    return intersection;
                }
            }
            catch (Exception x) {
                final Exception ex = x;
                if (this.getShell() != null) {
                    this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ActivationIntersectionDialog.this.setErrorMessage("Checking predecessor activities failed: " + ex.getMessage());
                        }
                    });
                }
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    private Map getIntersectingActivities(String oid, Compartment compartment, boolean ignoreDCIntersection) {
        IActivityIntersection intersection;
        if (oid != null && compartment != null && (intersection = this.getAllIntersectionsForActivity(oid, compartment)) != null) {
            String[] oids;
            String[] stringArray = oids = ignoreDCIntersection ? intersection.getIntersectingActivitiesByObject() : intersection.getIntersectingActivitiesByComponent();
            if (oids != null && oids.length > 0) {
                IVfsWorkspace workspace = ActivationRuntimeDataStorage.getStorage().getWorkspaceForCompartment(compartment.getName(), true);
                if (workspace != null) {
                    Set wrappers = this.getClosedActivityWrappers(oids, workspace);
                    if (!wrappers.isEmpty()) {
                        HashMap<String, ClosedActivityWrapper> oidAndClosedActivityWrapper = new HashMap<String, ClosedActivityWrapper>();
                        Iterator iter = wrappers.iterator();
                        while (iter.hasNext()) {
                            ClosedActivityWrapper act = (ClosedActivityWrapper)iter.next();
                            String actId = this.getObjectID(act);
                            if (actId == null) continue;
                            oidAndClosedActivityWrapper.put(actId, act);
                        }
                        return oidAndClosedActivityWrapper;
                    }
                } else {
                    this.setErrorMessage("Internal error: Unable to determine the workspace for compartment [" + compartment.getName() + "].");
                }
            }
        }
        return null;
    }

    private Set getClosedActivityWrappers(String[] oids, IVfsWorkspace workspace) {
        HashSet<Object> wrappers = new HashSet<Object>();
        HashSet<String> notCachedOids = new HashSet<String>();
        int i = 0;
        while (i < oids.length) {
            if (this.m_oidAndClosedActivityWrapper.containsKey(oids[i])) {
                wrappers.add(this.m_oidAndClosedActivityWrapper.get(oids[i]));
            } else {
                notCachedOids.add(oids[i]);
            }
            ++i;
        }
        if (!notCachedOids.isEmpty()) {
            String[] objectIds = (String[])Util.getArrayFromIterator(notCachedOids.iterator(), (Class)(class$java$lang$String == null ? (class$java$lang$String = ActivationIntersectionDialog.class$("java.lang.String")) : class$java$lang$String));
            IVfsActivity[] activities = ActivationRuntimeDataStorage.getStorage().getActivities(objectIds, workspace);
            ClosedActivityWrapper[] actWrappers = this.wrapClosedActivity(workspace, activities);
            int i2 = 0;
            while (i2 < actWrappers.length) {
                String oid = this.getObjectID(actWrappers[i2]);
                if (oid != null) {
                    this.m_oidAndClosedActivityWrapper.put(oid, actWrappers[i2]);
                    wrappers.add(actWrappers[i2]);
                }
                ++i2;
            }
        }
        return wrappers;
    }

    private String getObjectID(ClosedActivityWrapper wrapper) {
        try {
            return wrapper.activity.getObjectID();
        }
        catch (VfsException x) {
            this.setErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    private Compartment getCompartment(ClosedActivityWrapper wrapper) {
        return ActivationRuntimeDataStorage.getStorage().getCompartmentForWorksapce(wrapper.workspace, true);
    }

    private ClosedActivityWrapper[] wrapClosedActivity(IVfsWorkspace workspace, IVfsActivity[] activities) {
        ArrayList<ClosedActivityWrapper> wrappers = new ArrayList<ClosedActivityWrapper>();
        int i = 0;
        while (i < activities.length) {
            wrappers.add(new ClosedActivityWrapper(activities[i], workspace));
            ++i;
        }
        return wrappers.toArray(new ClosedActivityWrapper[wrappers.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$500(ActivationIntersectionDialog x0) {
        x0.clearMessageArea();
    }

    static /* synthetic */ boolean access$602(ActivationIntersectionDialog x0, boolean x1) {
        x0.m_ignoreDCIntersection = x1;
        return x0.m_ignoreDCIntersection;
    }

    static /* synthetic */ Button access$700(ActivationIntersectionDialog x0) {
        return x0.m_cxDCIntersection;
    }

    static /* synthetic */ IPreferenceStore access$800(ActivationIntersectionDialog x0) {
        return x0.getPreferenceStore();
    }

    static /* synthetic */ void access$1100(ActivationIntersectionDialog x0, Object x1) {
        x0.updateInfoGroup(x1);
    }

    private class ActivityElementsContentProvider
    implements IStructuredContentProvider {
        private ActivityElementsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IVfsActivity) {
                    if (!((IVfsActivity)inputElement).isOpen()) {
                        return ((IVfsActivity)inputElement).getElementsFromClosedActivity();
                    }
                    return ((IVfsActivity)inputElement).getElementsFromOpenActivity();
                }
            }
            catch (VfsException x) {
                ActivationIntersectionDialog.this.setErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class IntersectionTreeSorter
    extends AscendingElementLabelSorter {
        private IntersectionTreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MessageViewerInput && e2 instanceof MessageViewerInput) {
                if (e1.equals(ActivationIntersectionDialog.this.m_treeNode_selection) && e2.equals(ActivationIntersectionDialog.this.m_treeNode_intersection)) {
                    return -1;
                }
                if (e2.equals(ActivationIntersectionDialog.this.m_treeNode_selection) && e1.equals(ActivationIntersectionDialog.this.m_treeNode_intersection)) {
                    return 1;
                }
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class IntersectionTreeContentProvider
    implements ITreeContentProvider {
        private ClosedActivityWrapper[] p_intersectingActs = null;
        static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper;

        private IntersectionTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement.equals(ActivationIntersectionDialog.this.m_treeNode_selection)) {
                return ActivationIntersectionDialog.this.m_selection;
            }
            if (parentElement.equals(ActivationIntersectionDialog.this.m_treeNode_intersection)) {
                if (this.p_intersectingActs != null) {
                    return this.p_intersectingActs;
                }
            } else if (parentElement instanceof ClosedActivityWrapper) {
                Map intersectingActs;
                String oid = ActivationIntersectionDialog.this.getObjectID((ClosedActivityWrapper)parentElement);
                IVfsWorkspace workspace = ((ClosedActivityWrapper)parentElement).workspace;
                if (oid != null && workspace != null && (intersectingActs = ActivationIntersectionDialog.this.getIntersectingActivities(oid, ActivationIntersectionDialog.this.getCompartment((ClosedActivityWrapper)parentElement), ActivationIntersectionDialog.this.m_ignoreDCIntersection)) != null && !intersectingActs.isEmpty()) {
                    return Util.getArrayFromIterator(intersectingActs.values().iterator(), (Class)(class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper == null ? (class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper = IntersectionTreeContentProvider.class$("com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper")) : class$com$tssap$dtr$client$eclipse$vfs$ClosedActivityWrapper));
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element.equals(ActivationIntersectionDialog.this.m_treeNode_selection) || element.equals(ActivationIntersectionDialog.this.m_treeNode_intersection)) {
                return true;
            }
            return element instanceof ClosedActivityWrapper;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ClosedActivityWrapper[]) {
                if (this.p_intersectingActs != null) {
                    return new MessageViewerInput[]{ActivationIntersectionDialog.this.m_treeNode_selection, ActivationIntersectionDialog.this.m_treeNode_intersection};
                }
                return new MessageViewerInput[]{ActivationIntersectionDialog.this.m_treeNode_selection};
            }
            return new Object[0];
        }

        public void dispose() {
            ActivationIntersectionDialog.this.m_oidAndClosedActivityWrapper.clear();
            ActivationIntersectionDialog.this.m_activityOidAndIntersection.clear();
            if (ActivationIntersectionDialog.this.m_intersectionsDummyMap != null) {
                ActivationIntersectionDialog.this.m_intersectionsDummyMap.clear();
            }
            if (ActivationIntersectionDialog.this.m_objectIntersections != null) {
                ActivationIntersectionDialog.this.m_objectIntersections.clear();
            }
            if (ActivationIntersectionDialog.this.m_dcIntersections != null) {
                ActivationIntersectionDialog.this.m_dcIntersections.clear();
            }
            if (ActivationIntersectionDialog.this.m_oidsOfSelection != null) {
                ActivationIntersectionDialog.this.m_oidsOfSelection.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void addAllIntersections(ClosedActivityWrapper[] allIntersections) {
            this.p_intersectingActs = allIntersections;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

