/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.internal.ui;

import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.tc.cbs.client.IBuildDCResult;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildVariantResult;
import org.eclipse.swt.graphics.Image;

public class XTreeNodeDCBuildResult {
    private IBuildVariantResult m_variantResult;
    private IBuildDCResult m_dcResult;
    private IBuildRequest m_buildRequest;

    public XTreeNodeDCBuildResult(IBuildVariantResult variantResult, IBuildDCResult dcResult) {
        this.m_variantResult = variantResult;
        this.m_dcResult = dcResult;
    }

    public String getLabel(boolean showActivationResult) {
        String status;
        String label = this.m_dcResult.getName();
        if (!showActivationResult && this.m_variantResult.isSuccessful() && (status = ActivationRuntimeDataStorage.getStorage().getRuntimeDeploymentStatus(this.m_buildRequest, this.m_dcResult, this.m_variantResult)) != null && status.equals("")) {
            label = label + "   < NOT DEPLOYABLE >";
        }
        return label;
    }

    public Image getImage(boolean showActivationResult) {
        String stateDecorator = null;
        if (showActivationResult) {
            stateDecorator = this.m_variantResult.isBroken() ? "failed.gif" : (this.m_variantResult.isSuccessful() ? "succeeded.gif" : "failed.gif");
        } else if (this.m_variantResult.isSuccessful()) {
            String status = ActivationRuntimeDataStorage.getStorage().getRuntimeDeploymentStatus(this.m_buildRequest, this.m_dcResult, this.m_variantResult);
            if (status == null) {
                stateDecorator = "unknown.gif";
            } else if (status.equalsIgnoreCase("FAILED")) {
                stateDecorator = "failed.gif";
            } else if (status.equalsIgnoreCase("SUCCEEDED")) {
                stateDecorator = "succeeded.gif";
            } else if (!status.equals("")) {
                stateDecorator = "processing.gif";
            }
        }
        if (stateDecorator != null) {
            return ActivationPlugin.getDefault().getCompositeImage("jiDevelopmentComponent.gif", new String[]{stateDecorator});
        }
        return ActivationPlugin.getDefault().getAtomicImage("jiDevelopmentComponent.gif");
    }

    public IBuildVariantResult getBuildVariantResult() {
        return this.m_variantResult;
    }

    public IBuildDCResult getBuildDCResult() {
        return this.m_dcResult;
    }

    public IBuildRequest getBuildRequest() {
        return this.m_buildRequest;
    }

    public void setBuildRequest(IBuildRequest request) {
        this.m_buildRequest = request;
    }
}

