/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation.internal;

import com.sap.cms.tcs.servletapi.DcInfo;
import com.sap.cms.tcs.servletapi.TCSConnectionException;
import com.sap.cms.tcs.servletapi.TCSDeployInfoFact;
import com.sap.cms.tcs.servletapi.TCSDeployInfoIF;
import com.sap.cms.tcs.servletapi.TCSNoEntryFoundException;
import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.IActivationListener;
import com.sap.ide.eclipse.cbs.activation.ui.ActivationView;
import com.sap.ide.eclipse.cbs.activation.ui.actions.ActivateActivityAction;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IBuildDCResult;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildResult;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IBuildVariantResult;
import com.sap.tc.cbs.client.error.UnknownRequestException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.Property;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.ui.util.MessageDialogWithToggle;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.util.MultiMap;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActivationRuntimeDataStorage
implements IConfigurationListener,
IVfsManagerListener,
IVfsActivityListener,
IIDELoginListener,
IActivationListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$cbs$activation$internal$ActivationRuntimeDataStorage == null ? (class$com$sap$ide$eclipse$cbs$activation$internal$ActivationRuntimeDataStorage = ActivationRuntimeDataStorage.class$("com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage")) : class$com$sap$ide$eclipse$cbs$activation$internal$ActivationRuntimeDataStorage));
    private static final String KEY_PART_ACTIVATION_REQUEST = "_activationRequests-";
    private static final String KEY_SEPARATOR = "+";
    private static final String KEY_HIDE_INFO_ACTIVITY_CONTAINS_FOLDER_ONLY = "hideInfo_activityContainsFolderOnly";
    protected static final String PROP_NAME_PROPAGATION_STATE = "XCM:propagation-request-id";
    private static ActivationRuntimeDataStorage m_instance;
    private IVersionedFileSystemManager m_lastReleasedVfsManager;
    private IDevelopmentConfiguration m_activeDevConfig;
    private Map m_devConfigAndCompartments;
    private Map m_compartmentAndWorkspaces = new HashMap();
    private boolean isMap_compartmentAndWorkspaces_filledOnce;
    private Map m_inactiveWorkspaceAndActivities = new HashMap();
    private Map m_activeWorkspaceAndActivities = new HashMap();
    private Map m_inactiveWorkspaceAndForeignActivities = new HashMap();
    private Map m_activeWorkspaceAndForeignActivities = new HashMap();
    private String m_lastOtherUser = "";
    private Map m_oidAndActivity;
    private MultiMap m_activationHistories = new MultiMap();
    private List m_depersistedDevConfig = new ArrayList();
    private Map m_buildStatus;
    private Map m_buildRequestsInProcess;
    private Map m_requestActivities;
    private Map m_buildResults;
    private Map m_devConfigAndTcsServletUrl;
    private Map m_buildVariantResultAndStatusOfFinishedDeployement;
    private Map m_buildVariantResultInDeploying;
    private Map m_devConfigAndImportedBuildVariant;
    private Map m_buildRequestAndStatusOfFinishedDeployement;
    private Map m_buildRequestInDeploying;
    private Map m_buildVariantResultAndDeploymentLogUrl;
    private Map m_buildRequestAndDeploymentLogUrl;
    private static final String PROPERTY_TCS_SERVLET = "TCS_SERVLET";
    private static final String PROPERTY_NAMESPACE_URI = "http://xml.sap.com/2003/07/DevelopmentConfiguration/Transport-Controller";
    static /* synthetic */ Class class$com$sap$ide$eclipse$cbs$activation$internal$ActivationRuntimeDataStorage;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$IBuildRequest;

    public static synchronized ActivationRuntimeDataStorage getStorage() {
        if (m_instance == null) {
            m_instance = new ActivationRuntimeDataStorage();
            m_instance.registerListeners();
        }
        return m_instance;
    }

    private ActivationRuntimeDataStorage() {
    }

    public void destroyStorage() {
        if (this.m_devConfigAndCompartments != null) {
            this.m_devConfigAndCompartments.clear();
        }
        this.m_compartmentAndWorkspaces.clear();
        this.m_inactiveWorkspaceAndActivities.clear();
        this.m_activeWorkspaceAndActivities.clear();
        this.m_inactiveWorkspaceAndForeignActivities.clear();
        this.m_activeWorkspaceAndForeignActivities.clear();
        if (this.m_oidAndActivity != null) {
            this.m_oidAndActivity.clear();
        }
        this.m_activationHistories.clear();
        this.m_depersistedDevConfig.clear();
        if (this.m_buildStatus != null) {
            this.m_buildStatus.clear();
        }
        if (this.m_buildRequestsInProcess != null) {
            this.m_buildRequestsInProcess.clear();
        }
        if (this.m_requestActivities != null) {
            this.m_requestActivities.clear();
        }
        if (this.m_buildResults != null) {
            this.m_buildResults.clear();
        }
        if (this.m_devConfigAndTcsServletUrl != null) {
            this.m_devConfigAndTcsServletUrl.clear();
        }
        if (this.m_buildVariantResultAndStatusOfFinishedDeployement != null) {
            this.m_buildVariantResultAndStatusOfFinishedDeployement.clear();
        }
        if (this.m_buildVariantResultInDeploying != null) {
            this.m_buildVariantResultInDeploying.clear();
        }
        if (this.m_devConfigAndImportedBuildVariant != null) {
            this.m_devConfigAndImportedBuildVariant.clear();
        }
        if (this.m_buildRequestAndStatusOfFinishedDeployement != null) {
            this.m_buildRequestAndStatusOfFinishedDeployement.clear();
        }
        if (this.m_buildRequestInDeploying != null) {
            this.m_buildRequestInDeploying.clear();
        }
        if (this.m_buildVariantResultAndDeploymentLogUrl != null) {
            this.m_buildVariantResultAndDeploymentLogUrl.clear();
        }
        if (this.m_buildRequestAndDeploymentLogUrl != null) {
            this.m_buildRequestAndDeploymentLogUrl.clear();
        }
        ActivationRuntimeDataStorage.getStorage().unregisterListeners();
    }

    private void registerListeners() {
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.addVfsManagerListener((IVfsManagerListener)this);
        ActivationPlugin.getDefault().addActivationListener(this);
        VfsManagerProvider.getInstance().addIDELoginListener((IIDELoginListener)this);
    }

    private void unregisterListeners() {
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.removeVfsManagerListener((IVfsManagerListener)this);
        ActivationPlugin.getDefault().removeActivationListener(this);
        VfsManagerProvider.getInstance().removeIDELoginListener((IIDELoginListener)this);
    }

    public IDevelopmentConfiguration getActiveDevelopmentConfiguration() {
        if (this.m_activeDevConfig == null) {
            IClient activeDtrClient = Configuration.getConfiguration().getActiveClient();
            if (activeDtrClient == null) {
                Logbook.getWarnChapter().println("No development configuration imported.");
                this.m_activeDevConfig = null;
            } else {
                this.setActiveDevelopmentConfiguration(activeDtrClient.getAbsoluteLocalRoot());
            }
        }
        return this.m_activeDevConfig;
    }

    private void setActiveDevelopmentConfiguration(String absoluteLocalRootOfConfig) {
        Iterator devConfigs = DevConfManager.getInstalledDevConfs().iterator();
        while (devConfigs.hasNext()) {
            IDevelopmentConfiguration devConfig = (IDevelopmentConfiguration)devConfigs.next();
            String devConfigRoot = devConfig.getConfigurationRootFolder();
            if (!absoluteLocalRootOfConfig.equals(devConfigRoot)) continue;
            this.m_activeDevConfig = devConfig;
            return;
        }
        this.m_activeDevConfig = null;
    }

    public Compartment getCompartmentForWorksapce(IVfsWorkspace workspace, boolean inactive) {
        if (workspace != null) {
            if (!this.isMap_compartmentAndWorkspaces_filledOnce) {
                this.getWorkspacesToShow(false, "");
            }
            int index = inactive ? 0 : 1;
            Iterator iter = this.m_compartmentAndWorkspaces.keySet().iterator();
            while (iter.hasNext()) {
                Compartment compartment = (Compartment)iter.next();
                if (!workspace.equals(((IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment))[index])) continue;
                return compartment;
            }
        }
        return null;
    }

    public IVfsWorkspace getWorkspaceForCompartment(String compartmentName, boolean inactive) {
        if (compartmentName != null) {
            if (!this.isMap_compartmentAndWorkspaces_filledOnce) {
                this.getWorkspacesToShow(false, "");
            }
            int index = inactive ? 0 : 1;
            Iterator iter = this.m_compartmentAndWorkspaces.keySet().iterator();
            while (iter.hasNext()) {
                Compartment compartment = (Compartment)iter.next();
                if (!compartmentName.equals(compartment.getName())) continue;
                return ((IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment))[index];
            }
            IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
            if (devConfig != null) {
                try {
                    return devConfig.getWorkspaceOfCompartment(compartmentName, !inactive);
                }
                catch (Exception x) {
                    Logbook.getErrorChapter().println("Retrieving workspace of compartment [" + compartmentName + "] failed: " + x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        }
        return null;
    }

    public Compartment getCompartment(IDevelopmentConfiguration devConfig, String compartmentName) {
        Map compartments;
        DevelopmentConfiguration configData;
        if (devConfig != null && compartmentName != null && (configData = devConfig.getConfigurationData()) != null && (compartments = configData.getCompartments()) != null) {
            return (Compartment)compartments.get(compartmentName);
        }
        return null;
    }

    public IVfsWorkspace[] getWorkspacesToShow(boolean inactive, String userName) {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null) {
            return null;
        }
        this.isMap_compartmentAndWorkspaces_filledOnce = true;
        if (this.m_devConfigAndCompartments == null) {
            this.m_devConfigAndCompartments = new HashMap();
        }
        if (!this.m_devConfigAndCompartments.containsKey(devConfig)) {
            this.cacheActivationRelevantCompartments(devConfig);
        }
        ArrayList<IVfsWorkspace> activeWorkspaces = new ArrayList<IVfsWorkspace>();
        ArrayList<IVfsWorkspace> inactiveWorkspaces = new ArrayList<IVfsWorkspace>();
        Iterator iter = ((List)this.m_devConfigAndCompartments.get(devConfig)).iterator();
        while (iter.hasNext()) {
            Compartment compartment = (Compartment)iter.next();
            if (!this.m_compartmentAndWorkspaces.containsKey(compartment)) {
                this.cacheActivationRelevantWorkspaces(devConfig, compartment);
                if (!this.m_compartmentAndWorkspaces.containsKey(compartment)) break;
            }
            int index = inactive ? 0 : 1;
            IVfsWorkspace workspace = ((IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment))[index];
            if (workspace == null) continue;
            if (!"".equals(userName) && (this.m_lastOtherUser != null && !this.m_lastOtherUser.equals(userName) || userName != null && !userName.equals(this.m_lastOtherUser))) {
                this.clearWorkspaceAndForeignActivitiesCache(inactive);
                this.m_lastOtherUser = userName;
            }
            if (inactive) {
                if ("".equals(userName)) {
                    if (!this.m_inactiveWorkspaceAndActivities.containsKey(workspace)) {
                        this.cacheInactiveActivities(devConfig, workspace, userName);
                    }
                    if (!this.m_inactiveWorkspaceAndActivities.containsKey(workspace)) continue;
                    inactiveWorkspaces.add(workspace);
                    continue;
                }
                if (!this.m_inactiveWorkspaceAndForeignActivities.containsKey(workspace)) {
                    this.cacheInactiveActivities(devConfig, workspace, userName);
                }
                if (!this.m_inactiveWorkspaceAndForeignActivities.containsKey(workspace)) continue;
                inactiveWorkspaces.add(workspace);
                continue;
            }
            if ("".equals(userName)) {
                if (!this.m_activeWorkspaceAndActivities.containsKey(workspace)) {
                    this.cacheActiveActivities(devConfig, workspace, userName);
                }
                if (!this.m_activeWorkspaceAndActivities.containsKey(workspace)) continue;
                activeWorkspaces.add(workspace);
                continue;
            }
            if (!this.m_activeWorkspaceAndForeignActivities.containsKey(workspace)) {
                this.cacheActiveActivities(devConfig, workspace, userName);
            }
            if (!this.m_activeWorkspaceAndForeignActivities.containsKey(workspace)) continue;
            activeWorkspaces.add(workspace);
        }
        if (inactive) {
            return inactiveWorkspaces.toArray(new IVfsWorkspace[inactiveWorkspaces.size()]);
        }
        return activeWorkspaces.toArray(new IVfsWorkspace[activeWorkspaces.size()]);
    }

    public IVfsActivity[] getActivitiesToShow(IVfsWorkspace workspace, boolean inactive, String userName) {
        if (inactive) {
            if ("".equals(userName)) {
                if (this.m_inactiveWorkspaceAndActivities.containsKey(workspace)) {
                    List inactiveActivities = (List)this.m_inactiveWorkspaceAndActivities.get(workspace);
                    return inactiveActivities.toArray(new IVfsActivity[inactiveActivities.size()]);
                }
                Logbook.getErrorChapter().println("Internal error: No inactive activity found in cache for current user and for workspace [" + workspace.getName() + "].");
            } else {
                if (this.m_inactiveWorkspaceAndForeignActivities.containsKey(workspace)) {
                    List inactiveActivities = (List)this.m_inactiveWorkspaceAndForeignActivities.get(workspace);
                    return inactiveActivities.toArray(new IVfsActivity[inactiveActivities.size()]);
                }
                Logbook.getErrorChapter().println("Internal error: No inactive activity found in cache for other user and for workspace [" + workspace.getName() + "].");
            }
        } else if ("".equals(userName)) {
            if (this.m_activeWorkspaceAndActivities.containsKey(workspace)) {
                List activeActivities = (List)this.m_activeWorkspaceAndActivities.get(workspace);
                return activeActivities.toArray(new IVfsActivity[activeActivities.size()]);
            }
            Logbook.getErrorChapter().println("Internal error: No active activity found in cache for current user and for workspace [" + workspace.getName() + "].");
        } else {
            if (this.m_activeWorkspaceAndForeignActivities.containsKey(workspace)) {
                List activeActivities = (List)this.m_activeWorkspaceAndForeignActivities.get(workspace);
                return activeActivities.toArray(new IVfsActivity[activeActivities.size()]);
            }
            Logbook.getErrorChapter().println("Internal error: No active activity found in cache for other user and for workspace [" + workspace.getName() + "].");
        }
        return null;
    }

    public void resetActivityCache(boolean inactive, String userName) {
        List compartments;
        IDevelopmentConfiguration activeDevConfig = this.getActiveDevelopmentConfiguration();
        if (activeDevConfig != null && this.m_devConfigAndCompartments != null && (compartments = (List)this.m_devConfigAndCompartments.get(activeDevConfig)) != null) {
            int index = inactive ? 0 : 1;
            Iterator iter = compartments.iterator();
            while (iter.hasNext()) {
                Compartment compartment = (Compartment)iter.next();
                IVfsWorkspace[] workspaces = (IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment);
                if (workspaces == null || workspaces[index] == null) continue;
                if (inactive) {
                    if ("".equals(userName)) {
                        this.m_inactiveWorkspaceAndActivities.remove(workspaces[index]);
                        continue;
                    }
                    this.m_inactiveWorkspaceAndForeignActivities.remove(workspaces[index]);
                    continue;
                }
                if ("".equals(userName)) {
                    this.m_activeWorkspaceAndActivities.remove(workspaces[index]);
                    continue;
                }
                this.m_activeWorkspaceAndForeignActivities.remove(workspaces[index]);
            }
        }
    }

    private void cacheActivationRelevantCompartments(IDevelopmentConfiguration devConfig) {
        ArrayList<Compartment> compartmentsPerDevConfig = new ArrayList<Compartment>();
        Iterator iter = devConfig.getConfigurationData().getCompartments().values().iterator();
        while (iter.hasNext()) {
            Compartment compartment = (Compartment)iter.next();
            if (!compartment.hasSourceState() || compartment.getSourceState().getType() != 0) continue;
            compartmentsPerDevConfig.add(compartment);
            this.cacheActivationRelevantWorkspaces(devConfig, compartment);
        }
        this.m_devConfigAndCompartments.put(devConfig, compartmentsPerDevConfig);
    }

    private void cacheActivationRelevantWorkspaces(IDevelopmentConfiguration devConfig, Compartment compartment) {
        try {
            IVfsWorkspace inactiveWorkspace = devConfig.getWorkspaceOfCompartment(compartment.getName(), false);
            IVfsWorkspace activeWorkspace = devConfig.getWorkspaceOfCompartment(compartment.getName(), true);
            this.m_compartmentAndWorkspaces.put(compartment, new IVfsWorkspace[]{inactiveWorkspace, activeWorkspace});
        }
        catch (Exception x) {
            Logbook.getErrorChapter().println("Retrieving workspace of compartment [" + compartment.getName() + "] failed: " + x.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return;
        }
    }

    private void cacheInactiveActivities(IDevelopmentConfiguration devConfig, IVfsWorkspace workspace, String userName) {
        if (devConfig.getBuildSpace() == null) {
            Logbook.getErrorChapter().println("No build space defined for development configuration [" + devConfig.getConfigurationData().getName() + "].");
            return;
        }
        Compartment compartment = this.getCompartmentForWorksapce(workspace, true);
        if (compartment == null) {
            Logbook.getErrorChapter().println("Internal error: Could not find compartment for the inactive workspace \"" + workspace.getName() + "\".");
            return;
        }
        if ("".equals(userName)) {
            userName = devConfig.getUser();
        }
        String[] oids = null;
        try {
            oids = devConfig.getBuildSpace().listPendingActivitiesWithFiles(compartment.getName(), userName);
        }
        catch (Exception x) {
            Logbook.getErrorChapter().println("Retrieving pending activities failed: " + x.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        if (oids != null && oids.length > 0) {
            ArrayList<IVfsActivity> inactiveActivities = new ArrayList<IVfsActivity>();
            IVfsWorkspace inactiveWorkspace = ((IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment))[0];
            if (inactiveWorkspace == null) {
                Logbook.getErrorChapter().println("Internal error: No inactive workspace found for compartment [" + compartment.getName() + "].");
                return;
            }
            IVfsActivity[] acts = this.getActivities(oids, inactiveWorkspace);
            int i = 0;
            while (i < acts.length) {
                inactiveActivities.add(acts[i]);
                ++i;
            }
            if (!inactiveActivities.isEmpty()) {
                if (devConfig.getUser().equals(userName)) {
                    this.m_inactiveWorkspaceAndActivities.put(inactiveWorkspace, inactiveActivities);
                } else {
                    this.m_inactiveWorkspaceAndForeignActivities.put(inactiveWorkspace, inactiveActivities);
                }
            }
        }
    }

    private void cacheActiveActivities(IDevelopmentConfiguration devConfig, IVfsWorkspace workspace, String userName) {
        IVfsActivity[] activities = null;
        try {
            activities = "".equals(userName) ? workspace.getActivities(VfsActivityState.CLOSED) : workspace.getClosedActivitiesBy(userName, new Date(0L), new Date());
        }
        catch (VfsException x) {
            Logbook.getErrorChapter().println("Retrieving closed activities from workspace [" + workspace.getLocalPath() + "] failed.");
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        if (activities != null && activities.length > 0) {
            ArrayList<IVfsActivity> activeActivities = new ArrayList<IVfsActivity>();
            int i = 0;
            while (i < activities.length) {
                try {
                    String value;
                    IVfsProperty property = activities[i].getProperty(PROP_NAME_PROPAGATION_STATE);
                    if (property != null && ((value = property.getValue()) == null || value.trim().equals(""))) {
                        activeActivities.add(activities[i]);
                    }
                }
                catch (VfsException x) {
                    Logbook.getErrorChapter().println("Retrieving property [XCM:propagation-request-id] of activity failed.");
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
                ++i;
            }
            if (!activeActivities.isEmpty()) {
                if ("".equals(userName)) {
                    this.m_activeWorkspaceAndActivities.put(workspace, activeActivities);
                } else {
                    this.m_activeWorkspaceAndForeignActivities.put(workspace, activeActivities);
                }
            }
        }
    }

    private void clearWorkspaceAndForeignActivitiesCache(boolean inactive) {
        if (inactive) {
            this.m_inactiveWorkspaceAndForeignActivities.clear();
        } else {
            this.m_activeWorkspaceAndForeignActivities.clear();
        }
    }

    public IVfsActivity[] getActivities(String[] oids, IVfsWorkspace workspace) {
        if (oids != null && oids.length > 0) {
            if (this.m_oidAndActivity == null) {
                this.m_oidAndActivity = new HashMap();
            }
            HashSet<String> notCachedOids = new HashSet<String>();
            ArrayList<Object> cachedActivities = new ArrayList<Object>();
            int i = 0;
            while (i < oids.length) {
                if (this.m_oidAndActivity.containsKey(oids[i])) {
                    cachedActivities.add(this.m_oidAndActivity.get(oids[i]));
                } else {
                    notCachedOids.add(oids[i]);
                }
                ++i;
            }
            if (!notCachedOids.isEmpty()) {
                String[] ids = (String[])Util.getArrayFromIterator(notCachedOids.iterator(), (Class)(class$java$lang$String == null ? (class$java$lang$String = ActivationRuntimeDataStorage.class$("java.lang.String")) : class$java$lang$String));
                try {
                    IVfsActivity[] newActs = workspace.getRepository().getActivitiesById(ids);
                    int i2 = 0;
                    while (i2 < newActs.length) {
                        this.m_oidAndActivity.put(newActs[i2].getObjectID(), newActs[i2]);
                        cachedActivities.add(newActs[i2]);
                        ++i2;
                    }
                }
                catch (VfsException x) {
                    Logbook.getErrorChapter().println(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            }
            return cachedActivities.toArray(new IVfsActivity[cachedActivities.size()]);
        }
        return null;
    }

    public void addToActivationHistory(IBuildRequest buildRequest) {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig != null) {
            this.m_activationHistories.put((Object)devConfig, (Object)buildRequest);
            ActivationPlugin.getDefault().fireActivationRequestCreatedEvent(buildRequest);
            this.persistActivationHistories();
        }
    }

    public void deleteBuildRequests(IBuildRequest[] buildRequests) {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig != null && buildRequests != null) {
            int i = 0;
            while (i < buildRequests.length) {
                this.m_activationHistories.remove((Object)devConfig, (Object)buildRequests[i]);
                String key = this.createCacheKeyOfBuildRequest(devConfig, buildRequests[i]);
                if (this.m_buildRequestAndStatusOfFinishedDeployement != null) {
                    this.m_buildRequestAndStatusOfFinishedDeployement.remove(key);
                }
                if (this.m_buildRequestInDeploying != null) {
                    this.m_buildRequestInDeploying.remove(key);
                }
                ++i;
            }
            ActivationPlugin.getDefault().fireActivationRequestDeletedEvent(buildRequests);
            this.persistActivationHistories();
        }
    }

    public IBuildRequest[] getActivationHistory() {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (!this.m_depersistedDevConfig.contains(devConfig)) {
            this.depersistBuildRequests(devConfig);
        }
        return (IBuildRequest[])Util.getArrayFromIterator(this.m_activationHistories.getAll((Object)devConfig).iterator(), (Class)(class$com$sap$tc$cbs$client$IBuildRequest == null ? (class$com$sap$tc$cbs$client$IBuildRequest = ActivationRuntimeDataStorage.class$("com.sap.tc.cbs.client.IBuildRequest")) : class$com$sap$tc$cbs$client$IBuildRequest));
    }

    private void persistActivationHistories() {
        Iterator iterator = this.m_activationHistories.keySet().iterator();
        while (iterator.hasNext()) {
            IDevelopmentConfiguration devConfig = (IDevelopmentConfiguration)iterator.next();
            if (!this.m_depersistedDevConfig.contains(devConfig)) {
                this.depersistBuildRequests(devConfig);
            }
            IBuildRequest[] requests = (IBuildRequest[])Util.getArrayFromIterator(this.m_activationHistories.getAll((Object)devConfig).iterator(), (Class)(class$com$sap$tc$cbs$client$IBuildRequest == null ? ActivationRuntimeDataStorage.class$("com.sap.tc.cbs.client.IBuildRequest") : class$com$sap$tc$cbs$client$IBuildRequest));
            this.persistBuildRequests(devConfig, requests);
        }
    }

    private void depersistBuildRequests(IDevelopmentConfiguration devConfig) {
        if (devConfig == null) {
            return;
        }
        String oidsString = this.getPreferenceStore().getString("com.sap.ide.eclipse.cbs.activation_activationRequests-" + devConfig.getConfigurationRootFolder());
        if (!oidsString.equals("")) {
            while (oidsString.indexOf(KEY_SEPARATOR) != -1) {
                IBuildRequest buildRequest;
                String oid;
                if ((oidsString = oidsString.substring(1)).indexOf(KEY_SEPARATOR) != -1) {
                    oid = oidsString.substring(0, oidsString.indexOf(KEY_SEPARATOR));
                    oidsString = oidsString.substring(oid.length());
                } else {
                    oid = oidsString;
                }
                IBuildSpace buildSpace = devConfig.getBuildSpace();
                if (buildSpace == null || (buildRequest = buildSpace.getBuildRequest(Long.parseLong(oid))) == null) continue;
                this.m_activationHistories.put((Object)devConfig, (Object)buildRequest);
            }
        }
        this.m_depersistedDevConfig.add(devConfig);
    }

    private void persistBuildRequests(IDevelopmentConfiguration devConfig, IBuildRequest[] requests) {
        if (devConfig == null) {
            return;
        }
        String oidsString = "";
        int i = 0;
        while (i < requests.length) {
            oidsString = oidsString + KEY_SEPARATOR + requests[i].getRequestID();
            ++i;
        }
        String key = "com.sap.ide.eclipse.cbs.activation_activationRequests-" + devConfig.getConfigurationRootFolder();
        this.getPreferenceStore().setValue(key, oidsString);
    }

    public BuildRequestStatus getBuildRequestStatus(IBuildRequest buildRequest) {
        String key;
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null || buildRequest == null) {
            return null;
        }
        if (this.m_buildStatus == null) {
            this.m_buildStatus = new HashMap();
        }
        if (this.m_buildRequestsInProcess == null) {
            this.m_buildRequestsInProcess = new HashMap();
        }
        if (!this.m_buildStatus.containsKey(key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest))) {
            this.cacheBuildRequestStatus(devConfig, buildRequest, false);
        }
        return (BuildRequestStatus)this.m_buildStatus.get(key);
    }

    public boolean isBuildRequestInProcess(IBuildRequest buildRequest) {
        String key;
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null || buildRequest == null) {
            return false;
        }
        if (this.m_buildStatus == null) {
            this.m_buildStatus = new HashMap();
        }
        if (this.m_buildRequestsInProcess == null) {
            this.m_buildRequestsInProcess = new HashMap();
        }
        if (!this.m_buildStatus.containsKey(key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest))) {
            this.cacheBuildRequestStatus(devConfig, buildRequest, false);
        }
        return this.m_buildRequestsInProcess.containsKey(key);
    }

    public void updateBuildRequestStatus(IBuildRequest[] buildRequests) {
        if (buildRequests != null) {
            IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
            if (devConfig == null) {
                return;
            }
            if (this.m_buildStatus == null) {
                this.m_buildStatus = new HashMap();
            }
            if (this.m_buildRequestsInProcess == null) {
                this.m_buildRequestsInProcess = new HashMap();
            }
            int i = 0;
            while (i < buildRequests.length) {
                String key = this.createCacheKeyOfBuildRequest(devConfig, buildRequests[i]);
                if (this.m_buildRequestsInProcess.containsKey(key) || !this.m_buildStatus.containsKey(key)) {
                    this.cacheBuildRequestStatus(devConfig, buildRequests[i], true);
                }
                if (this.m_buildRequestInDeploying != null && devConfig != null) {
                    this.m_buildRequestInDeploying.remove(key);
                }
                ++i;
            }
            if (this.m_buildVariantResultInDeploying != null) {
                this.m_buildVariantResultInDeploying.clear();
            }
        }
    }

    private void cacheBuildRequestStatus(IDevelopmentConfiguration devConfig, IBuildRequest buildRequest, boolean toUpdate) {
        if (devConfig == null || buildRequest == null) {
            return;
        }
        String key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest);
        try {
            BuildRequestStatus status = buildRequest.getStatus();
            if (status != null) {
                this.m_buildStatus.put(key, status);
                if (status.equals(BuildRequestStatus.ABORTED) || status.equals(BuildRequestStatus.NEW) || status.equals(BuildRequestStatus.PENDING) || status.equals(BuildRequestStatus.PROCESSING) || status.equals(BuildRequestStatus.QUEUED) || status.equals(BuildRequestStatus.SUSPENDED) || status.equals(BuildRequestStatus.WAITING)) {
                    this.m_buildRequestsInProcess.put(key, status);
                    if (toUpdate) {
                        ActivationPlugin.getDefault().fireActivationRequestStatusChangedEvent(new IBuildRequest[]{buildRequest});
                    }
                } else if (this.m_buildRequestsInProcess.containsKey(key) && toUpdate) {
                    this.m_buildRequestsInProcess.remove(key);
                    ActivationPlugin.getDefault().fireActivationRequestFinishedEvent(new IBuildRequest[]{buildRequest});
                }
            }
        }
        catch (Exception x) {
            if (x instanceof UnknownRequestException) {
                Logbook.getWarnChapter().println("Activation request " + buildRequest.getRequestID() + " is not longer available.");
                this.m_buildStatus.put(key, null);
            } else {
                Logbook.getErrorChapter().println("Retrieving activation status of request " + buildRequest.getRequestID() + " failed: " + x.getMessage());
            }
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
    }

    public IActivitySet[] getRequestActivities(IBuildRequest buildRequest) {
        String key;
        block7: {
            IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
            if (devConfig == null || buildRequest == null) {
                return null;
            }
            if (this.m_requestActivities == null) {
                this.m_requestActivities = new HashMap();
            }
            if (!this.m_requestActivities.containsKey(key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest))) {
                if (this.getBuildRequestStatus(buildRequest) == null) {
                    this.m_requestActivities.put(key, null);
                    return null;
                }
                try {
                    IActivitySet[] activitySets = buildRequest.getRequestActivities();
                    if (activitySets != null && activitySets.length > 0) {
                        this.m_requestActivities.put(key, activitySets);
                    }
                }
                catch (Exception x) {
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                    Logbook.getErrorChapter().println("Retrieving request activities failed: " + x.getMessage());
                    if (!(x instanceof UnknownRequestException)) break block7;
                    this.m_requestActivities.put(key, null);
                }
            }
        }
        return (IActivitySet[])this.m_requestActivities.get(key);
    }

    public IBuildResult getBuildResult(IBuildRequest buildRequest) {
        String key;
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null || buildRequest == null) {
            return null;
        }
        if (this.m_buildResults == null) {
            this.m_buildResults = new HashMap();
        }
        if (!this.m_buildResults.containsKey(key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest))) {
            if (this.getBuildRequestStatus(buildRequest) == null) {
                this.m_buildResults.put(key, null);
                return null;
            }
            try {
                IBuildResult buildResult = buildRequest.getResult(false);
                if (buildResult != null) {
                    this.m_buildResults.put(key, buildResult);
                }
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                Logbook.getErrorChapter().print(x.getMessage());
            }
        }
        return (IBuildResult)this.m_buildResults.get(key);
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        IDevelopmentConfiguration oldDevConfig = this.getActiveDevelopmentConfiguration();
        IDevelopmentConfiguration newDevConfig = null;
        if (newClient != null) {
            this.setActiveDevelopmentConfiguration(newClient.getAbsoluteLocalRoot());
            newDevConfig = this.getActiveDevelopmentConfiguration();
        }
        this.isMap_compartmentAndWorkspaces_filledOnce = false;
        ActivationPlugin.getDefault().fireActiveDevelopmentConfigurationChangedEvent(newDevConfig, oldDevConfig);
        try {
            IVersionedFileSystemManager vfsManager;
            if (oldClient != null && (vfsManager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(oldClient.getContext())) != null) {
                vfsManager.removeActivityListener((IVfsActivityListener)this);
            }
            if (newClient != null && this.getActiveDevelopmentConfiguration() != null && (vfsManager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(newClient.getContext())) != null) {
                vfsManager.addActivityListener((IVfsActivityListener)this);
            }
        }
        catch (VfsException x) {
            Logbook.getErrorChapter().println(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    public void onConfigurationChanged(IConfiguration arg0) {
    }

    public void created(IVersionedFileSystemManager vfsManager) {
        if (vfsManager != null) {
            vfsManager.addActivityListener((IVfsActivityListener)this);
        }
    }

    public void released(IVersionedFileSystemManager vfsManager) {
        if (vfsManager != null && !vfsManager.equals(this.m_lastReleasedVfsManager)) {
            this.handleVfsManagerReleased(vfsManager);
            this.m_lastReleasedVfsManager = vfsManager;
        }
    }

    private void handleVfsManagerReleased(IVersionedFileSystemManager vfsManager) {
        Iterator<Object> iter = this.m_compartmentAndWorkspaces.keySet().iterator();
        while (iter.hasNext()) {
            Compartment compartment = (Compartment)iter.next();
            IVfsWorkspace[] workspaces = (IVfsWorkspace[])this.m_compartmentAndWorkspaces.get(compartment);
            boolean worksapceIsReleased = false;
            if (workspaces != null) {
                if (workspaces[0] != null && workspaces[0].isReleased()) {
                    worksapceIsReleased = true;
                    this.m_inactiveWorkspaceAndActivities.remove(workspaces[0]);
                    this.m_inactiveWorkspaceAndForeignActivities.remove(workspaces[0]);
                }
                if (workspaces[1] != null && workspaces[1].isReleased()) {
                    worksapceIsReleased = true;
                    this.m_activeWorkspaceAndActivities.remove(workspaces[1]);
                    this.m_activeWorkspaceAndForeignActivities.remove(workspaces[1]);
                }
            }
            if (!worksapceIsReleased) continue;
            iter.remove();
            this.isMap_compartmentAndWorkspaces_filledOnce = false;
        }
        if (this.m_oidAndActivity != null) {
            ArrayList<String> releasedOids = new ArrayList<String>();
            iter = this.m_oidAndActivity.keySet().iterator();
            while (iter.hasNext()) {
                String oid = (String)iter.next();
                IVfsActivity activity = (IVfsActivity)this.m_oidAndActivity.get(oid);
                if (activity != null && !activity.isReleased()) continue;
                releasedOids.add(oid);
            }
            iter = releasedOids.iterator();
            while (iter.hasNext()) {
                this.m_oidAndActivity.remove(iter.next());
            }
        }
    }

    public void onActivationRequestCreated(IBuildRequest buildRequest) {
    }

    public void onActivationRequestDeleted(IBuildRequest[] buildRequests) {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null) {
            return;
        }
        if (buildRequests != null) {
            int i = 0;
            while (i < buildRequests.length) {
                String key = this.createCacheKeyOfBuildRequest(devConfig, buildRequests[i]);
                if (this.m_buildStatus != null) {
                    this.m_buildStatus.remove(key);
                }
                if (this.m_buildRequestsInProcess != null) {
                    this.m_buildRequestsInProcess.remove(key);
                }
                if (this.m_requestActivities != null) {
                    this.m_requestActivities.remove(key);
                }
                if (this.m_buildResults != null) {
                    this.m_buildResults.remove(key);
                }
                ++i;
            }
        }
    }

    public void onActivationRequestFinished(IBuildRequest[] buildRequests) {
        boolean activated = false;
        int i = 0;
        while (i < buildRequests.length) {
            if (BuildRequestStatus.SUCCEEDED.equals(this.getBuildRequestStatus(buildRequests[i]))) {
                activated = true;
                break;
            }
            ++i;
        }
        if (activated) {
            String currentUserFilter = BluebirdPlugin.getDefault().getPreferenceStore().getString("com.sap.ide.eclipse.cbs.activation.ui.views.InactiveActivityView_viewForUser");
            this.resetActivityCache(false, currentUserFilter);
            this.refreshActivationView();
        }
    }

    public void onActivationRequestStatusChanged(IBuildRequest[] buildRequests) {
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        IVersionedFileSystemManager vfsManager = this.getCurrentVfsManager();
        if (vfsManager != null) {
            vfsManager.addActivityListener((IVfsActivityListener)this);
        }
    }

    public void onUserLoggedOut() {
    }

    public void stateChanged(IVfsActivity activity, VfsActivityState oldState) {
        if (this.getActiveDevelopmentConfiguration() == null) {
            return;
        }
        try {
            if (activity.getState() != VfsActivityState.CLOSED) {
                return;
            }
            IVersionedFileSystemManager currentVfsManager = this.getCurrentVfsManager();
            if (currentVfsManager == null) {
                return;
            }
            if (currentVfsManager.equals(activity.getVersionedFileSystemManager())) {
                if (activity.containsOnlyFolders()) {
                    IWorkbenchPart part;
                    MessageDialogWithToggle dialogWithToggle;
                    boolean hideInfo = this.getPreferenceStore().getBoolean(KEY_HIDE_INFO_ACTIVITY_CONTAINS_FOLDER_ONLY);
                    if (!hideInfo && (dialogWithToggle = MessageDialogWithToggle.openInformation((Shell)((part = this.getActiveUIPart()) != null ? part.getSite().getShell() : Display.getDefault().getActiveShell()), (String)"Activity Checked-In", (String)"Activities containing only folders are not considered for activation and transport.", null, (boolean)false)).getToggleState()) {
                        this.getPreferenceStore().setValue(KEY_HIDE_INFO_ACTIVITY_CONTAINS_FOLDER_ONLY, true);
                    }
                    return;
                }
                ClosedActivityWrapper wrapper = new ClosedActivityWrapper(activity, activity.getWorkspace());
                ActivateActivityAction activateAction = new ActivateActivityAction();
                Action fakeAction = new Action(){};
                activateAction.setActivePart((IAction)fakeAction, this.getActiveUIPart());
                activateAction.selectionChanged((IAction)fakeAction, (ISelection)new StructuredSelection((Object)wrapper));
                activateAction.run((IAction)fakeAction);
                IVfsWorkspace ws = activity.getWorkspace();
                if (this.m_inactiveWorkspaceAndActivities.containsKey(ws)) {
                    List inactiveActs = (List)this.m_inactiveWorkspaceAndActivities.get(ws);
                    inactiveActs.add(activity);
                    this.m_inactiveWorkspaceAndActivities.put(ws, inactiveActs);
                } else {
                    ArrayList<IVfsActivity> acts = new ArrayList<IVfsActivity>();
                    acts.add(activity);
                    this.m_inactiveWorkspaceAndActivities.put(ws, acts);
                }
                if (this.m_oidAndActivity == null) {
                    this.m_oidAndActivity = new HashMap();
                }
                this.m_oidAndActivity.put(activity.getObjectID(), activity);
            }
        }
        catch (VfsException x) {
            Logbook.getErrorChapter().println(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    public void created(IVfsActivity activity) {
    }

    public void deleted(IVfsActivity activity, VfsActivityState oldState) {
    }

    public void itemsAddedOrRemoved(IVfsActivity activity) {
    }

    public void beforeCheckin(IVfsActivity activity) {
    }

    public void nameOrDescriptionChanged(IVfsActivity activity) {
    }

    private IVersionedFileSystemManager getCurrentVfsManager() {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            try {
                return VfsManagerProvider.getInstance().getVersionedFileSystemManager(activeClient.getContext());
            }
            catch (VfsException x) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                Logbook.getErrorChapter().println(x.getMessage());
            }
        }
        return null;
    }

    private void refreshActivationView() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchWindow actWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (actWindow == null) {
                    return;
                }
                IWorkbenchPage[] pages = actWindow.getPages();
                if (pages != null) {
                    int i = 0;
                    while (i < pages.length) {
                        IViewReference[] views = pages[i].getViewReferences();
                        if (views != null) {
                            int j = 0;
                            while (j < views.length) {
                                IViewPart view = views[j].getView(false);
                                if (view instanceof ActivationView && ((ActivationView)view).getViewID().equals("com.sap.ide.eclipse.cbs.activation.ui.views.InactiveActivityView")) {
                                    ((ActivationView)view).getRepositoryTreeViewer().getTreeViewer().refresh();
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private IWorkbenchPart getActiveUIPart() {
        IWorkbenchPage activePage = ActivationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    public boolean isRuntimeSystemConfigured() {
        return this.getTcsDeployInfoHandler(this.getActiveDevelopmentConfiguration()) != null;
    }

    public String getRuntimeDeploymentStatus(IBuildRequest buildRequest) {
        if (buildRequest == null) {
            return null;
        }
        IDevelopmentConfiguration activeDevConfig = this.getActiveDevelopmentConfiguration();
        if (activeDevConfig == null) {
            return null;
        }
        if (!this.isRuntimeSystemConfigured()) {
            return "";
        }
        BuildRequestStatus activationStatus = this.getBuildRequestStatus(buildRequest);
        if (!BuildRequestStatus.SUCCEEDED.equals(activationStatus)) {
            return "";
        }
        String key = this.createCacheKeyOfBuildRequest(activeDevConfig, buildRequest);
        if (this.m_buildRequestAndStatusOfFinishedDeployement == null) {
            this.m_buildRequestAndStatusOfFinishedDeployement = new HashMap();
        }
        if (this.m_buildRequestInDeploying == null) {
            this.m_buildRequestInDeploying = new HashMap();
        }
        if (this.m_buildRequestAndStatusOfFinishedDeployement.containsKey(key)) {
            return (String)this.m_buildRequestAndStatusOfFinishedDeployement.get(key);
        }
        if (this.m_buildRequestInDeploying.containsKey(key)) {
            return (String)this.m_buildRequestInDeploying.get(key);
        }
        IBuildSpace buildSpace = activeDevConfig.getBuildSpace();
        if (buildSpace == null) {
            Logbook.getErrorChapter().println("Internal error: unable to retrieve deployment status of build request \"" + buildRequest.getRequestID() + "\": BuildSpace is <null>.");
            return null;
        }
        TCSDeployInfoIF deployInfoHandler = this.getTcsDeployInfoHandler(activeDevConfig);
        if (deployInfoHandler == null) {
            Logbook.getErrorChapter().println("Internal error: unable to retrieve deployment status of build request \"" + buildRequest.getRequestID() + "\": TcsDeployInfoHandler is <null>.");
            return null;
        }
        IActivitySet[] activitySets = this.getRequestActivities(buildRequest);
        if (activitySets == null) {
            return null;
        }
        HashSet<String> states = new HashSet<String>();
        int i = 0;
        while (i < activitySets.length) {
            String buildVariant = this.getImportedBuildVariant(activeDevConfig, activitySets[i].getCompartmentName());
            if (buildVariant != null) {
                String status = null;
                try {
                    deployInfoHandler.openConnection();
                    status = deployInfoHandler.getDeploymentStatus(buildSpace.getName(), "" + buildRequest.getRequestID(), buildVariant);
                    deployInfoHandler.closeConnection();
                }
                catch (TCSConnectionException x) {
                    if (x instanceof TCSNoEntryFoundException) {
                        Logbook.getWarnChapter().println("Deployment status of build request \"" + buildRequest.getRequestID() + "\" not available.");
                    } else {
                        Logbook.getErrorChapter().println("Retrieving deployment status of build request \"" + buildRequest.getRequestID() + "\" failed.");
                    }
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
                if (status == null || status.equals("")) {
                    return null;
                }
                if (status.equalsIgnoreCase("FAILED")) {
                    this.m_buildRequestAndStatusOfFinishedDeployement.put(key, status);
                    return status;
                }
                states.add(status);
            }
            ++i;
        }
        if (states.contains("QUEUED")) {
            this.m_buildRequestInDeploying.put(key, "QUEUED");
            return "QUEUED";
        }
        if (states.contains("WAITING")) {
            this.m_buildRequestInDeploying.put(key, "WAITING");
            return "WAITING";
        }
        if (states.contains("DEPLOYING")) {
            this.m_buildRequestInDeploying.put(key, "DEPLOYING");
            return "DEPLOYING";
        }
        this.m_buildRequestAndStatusOfFinishedDeployement.put(key, "SUCCEEDED");
        return "SUCCEEDED";
    }

    public String getRuntimeDeploymentStatus(IBuildRequest buildRequest, IBuildDCResult buildDCResult, IBuildVariantResult buildVariantResult) {
        if (buildRequest == null || buildDCResult == null || buildVariantResult == null) {
            return null;
        }
        if (!this.isRuntimeSystemConfigured()) {
            return "";
        }
        if (!buildVariantResult.isDeployable()) {
            return "";
        }
        if (this.m_buildVariantResultAndStatusOfFinishedDeployement == null) {
            this.m_buildVariantResultAndStatusOfFinishedDeployement = new HashMap();
        }
        if (this.m_buildVariantResultInDeploying == null) {
            this.m_buildVariantResultInDeploying = new HashMap();
        }
        if (this.m_buildVariantResultAndStatusOfFinishedDeployement.containsKey(buildVariantResult)) {
            return (String)this.m_buildVariantResultAndStatusOfFinishedDeployement.get(buildVariantResult);
        }
        if (this.m_buildVariantResultInDeploying.containsKey(buildVariantResult)) {
            return (String)this.m_buildVariantResultInDeploying.get(buildVariantResult);
        }
        DcInfo dcDeployInfo = this.getDcDeploymentInfo(buildRequest, buildDCResult, buildVariantResult);
        if (dcDeployInfo != null) {
            return dcDeployInfo.getStatus();
        }
        return null;
    }

    private String getImportedBuildVariant(IDevelopmentConfiguration devConfig, String compartmentName) {
        String key;
        if (this.m_devConfigAndImportedBuildVariant == null) {
            this.m_devConfigAndImportedBuildVariant = new HashMap();
        }
        if (!this.m_devConfigAndImportedBuildVariant.containsKey(key = devConfig.getConfigurationRootFolder() + KEY_SEPARATOR + compartmentName)) {
            try {
                String importedBuildVariant = com.sap.ide.eclipse.component.core.Util.getBuildVariant((IDevelopmentConfiguration)devConfig, (String)compartmentName);
                this.m_devConfigAndImportedBuildVariant.put(key, importedBuildVariant);
            }
            catch (Exception x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                return null;
            }
        }
        return (String)this.m_devConfigAndImportedBuildVariant.get(key);
    }

    public URL getDeploymentLogUrl(IBuildRequest buildRequest) {
        if (buildRequest == null) {
            return null;
        }
        Boolean isFinished = this.isRuntimeDeploymentFinished(buildRequest);
        if (isFinished == null || !isFinished.booleanValue()) {
            return null;
        }
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null) {
            return null;
        }
        String key = this.createCacheKeyOfBuildRequest(devConfig, buildRequest);
        if (this.m_buildRequestAndDeploymentLogUrl == null) {
            this.m_buildRequestAndDeploymentLogUrl = new HashMap();
        }
        if (this.m_buildRequestAndDeploymentLogUrl.containsKey(key)) {
            return (URL)this.m_buildRequestAndDeploymentLogUrl.get(key);
        }
        IActivitySet[] activitySets = this.getRequestActivities(buildRequest);
        if (activitySets == null) {
            return null;
        }
        String importedBuildVariant = null;
        int i = 0;
        while (i < activitySets.length) {
            String variant = this.getImportedBuildVariant(devConfig, activitySets[i].getCompartmentName());
            if (variant == null) {
                return null;
            }
            if (importedBuildVariant == null) {
                importedBuildVariant = variant;
            } else if (!importedBuildVariant.equalsIgnoreCase(variant)) {
                return null;
            }
            ++i;
        }
        TCSDeployInfoIF deployInfoHandler = this.getTcsDeployInfoHandler(devConfig);
        if (deployInfoHandler == null) {
            return null;
        }
        IBuildSpace buildSpace = devConfig.getBuildSpace();
        if (buildSpace == null) {
            return null;
        }
        try {
            deployInfoHandler.openConnection();
            URL logUrl = deployInfoHandler.getDeploymentLog(buildSpace.getName(), "" + buildRequest.getRequestID(), importedBuildVariant);
            deployInfoHandler.closeConnection();
            this.m_buildRequestAndDeploymentLogUrl.put(key, logUrl);
            return logUrl;
        }
        catch (TCSConnectionException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    public String getDeploymentLogUrl(IBuildRequest buildRequest, IBuildDCResult buildDCResult, IBuildVariantResult buildVariantResult) {
        if (buildRequest == null || buildDCResult == null || buildVariantResult == null) {
            return null;
        }
        if (!buildVariantResult.isDeployable()) {
            return null;
        }
        Boolean isFinished = this.isRuntimeDeploymentFinished(buildRequest, buildDCResult, buildVariantResult);
        if (isFinished == null || !isFinished.booleanValue()) {
            return null;
        }
        if (this.m_buildVariantResultAndDeploymentLogUrl == null) {
            this.m_buildVariantResultAndDeploymentLogUrl = new HashMap();
        }
        if (this.m_buildVariantResultAndDeploymentLogUrl.containsKey(buildVariantResult)) {
            return (String)this.m_buildVariantResultAndDeploymentLogUrl.get(buildVariantResult);
        }
        DcInfo dcDeployInfo = this.getDcDeploymentInfo(buildRequest, buildDCResult, buildVariantResult);
        if (dcDeployInfo != null) {
            return dcDeployInfo.getLogPath();
        }
        return null;
    }

    private TCSDeployInfoIF getTcsDeployInfoHandler(IDevelopmentConfiguration devConfig) {
        if (this.m_devConfigAndTcsServletUrl == null) {
            this.m_devConfigAndTcsServletUrl = new HashMap();
        }
        if (!this.m_devConfigAndTcsServletUrl.containsKey(devConfig)) {
            if (devConfig == null) {
                return null;
            }
            DevelopmentConfiguration devConfigData = devConfig.getConfigurationData();
            if (devConfigData == null) {
                return null;
            }
            Property propertyTcsServlet = devConfigData.getProperty(PROPERTY_TCS_SERVLET, PROPERTY_NAMESPACE_URI);
            if (propertyTcsServlet == null) {
                return null;
            }
            String tcsServletUrlString = propertyTcsServlet.getValue();
            try {
                URL tcsServletUrl = new URL(tcsServletUrlString);
                TCSDeployInfoIF deployInfo = TCSDeployInfoFact.getDeployInfo((URL)tcsServletUrl);
                this.m_devConfigAndTcsServletUrl.put(devConfig, deployInfo);
            }
            catch (MalformedURLException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return (TCSDeployInfoIF)this.m_devConfigAndTcsServletUrl.get(devConfig);
    }

    private DcInfo getDcDeploymentInfo(IBuildRequest buildRequest, IBuildDCResult buildDCResult, IBuildVariantResult buildVariantResult) {
        IDevelopmentConfiguration devConfig = this.getActiveDevelopmentConfiguration();
        if (devConfig == null || buildRequest == null) {
            return null;
        }
        TCSDeployInfoIF deployInfoHandler = this.getTcsDeployInfoHandler(devConfig);
        if (deployInfoHandler == null) {
            Logbook.getErrorChapter().println("Internal error: unable to retrieve deployment status of build request \"" + buildRequest.getRequestID() + "\": TcsDeployInfoHandler is <null>.");
            return null;
        }
        IBuildSpace buildSpace = devConfig.getBuildSpace();
        if (buildSpace == null) {
            Logbook.getErrorChapter().println("Internal error: unable to retrieve deployment status of build request \"" + buildRequest.getRequestID() + "\": BuildSpace is <null>.");
            return null;
        }
        if (this.m_buildVariantResultAndDeploymentLogUrl == null) {
            this.m_buildVariantResultAndDeploymentLogUrl = new HashMap();
        }
        try {
            deployInfoHandler.openConnection();
            DcInfo dcDeployInfo = deployInfoHandler.getDeploymentInfo(buildSpace.getName(), buildDCResult.getName(), buildDCResult.getVendor(), buildVariantResult.getVariantName());
            deployInfoHandler.closeConnection();
            if (dcDeployInfo != null) {
                Boolean isFinished;
                this.m_buildVariantResultAndDeploymentLogUrl.put(buildVariantResult, dcDeployInfo.getLogPath());
                String status = dcDeployInfo.getStatus();
                if (status != null && (isFinished = this.isDeploymentFinished(status)) != null) {
                    if (isFinished.booleanValue()) {
                        this.m_buildVariantResultAndStatusOfFinishedDeployement.put(buildVariantResult, status);
                    } else {
                        this.m_buildVariantResultInDeploying.put(buildVariantResult, status);
                    }
                }
                return dcDeployInfo;
            }
        }
        catch (TCSConnectionException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        return null;
    }

    public Boolean isRuntimeDeploymentFinished(IBuildRequest buildRequest, IBuildDCResult buildDCResult, IBuildVariantResult buildVariantResult) {
        String status = this.getRuntimeDeploymentStatus(buildRequest, buildDCResult, buildVariantResult);
        return this.isDeploymentFinished(status);
    }

    public Boolean isRuntimeDeploymentFinished(IBuildRequest buildRequest) {
        String status = this.getRuntimeDeploymentStatus(buildRequest);
        return this.isDeploymentFinished(status);
    }

    private Boolean isDeploymentFinished(String status) {
        if (status != null && !status.equals("")) {
            if (status.equalsIgnoreCase("FAILED") || status.equalsIgnoreCase("SUCCEEDED")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private String createCacheKeyOfBuildRequest(IDevelopmentConfiguration devConfig, IBuildRequest buildRequest) {
        return devConfig.getConfigurationRootFolder() + KEY_SEPARATOR + buildRequest.getRequestID();
    }

    private IPreferenceStore getPreferenceStore() {
        return ActivationPlugin.getDefault().getPreferenceStore();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

