/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.cbs.activation;

import com.sap.ide.eclipse.cbs.activation.IActivationListener;
import com.sap.ide.eclipse.cbs.activation.IDevelopmentConfigurationListener;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.util.MultiCompositeImageDescriptor;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActivationPlugin
extends AbstractUIPlugin
implements IStartup {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$ide$eclipse$cbs$activation$ActivationPlugin == null ? (class$com$sap$ide$eclipse$cbs$activation$ActivationPlugin = ActivationPlugin.class$("com.sap.ide.eclipse.cbs.activation.ActivationPlugin")) : class$com$sap$ide$eclipse$cbs$activation$ActivationPlugin));
    private static final String m_imageDirectory = "icons/";
    private static ActivationPlugin m_instance;
    private Set m_activationListeners = new HashSet();
    private Set m_devConfigListeners = new HashSet();
    private ImageRegistry m_imageRegistry;
    static /* synthetic */ Class class$com$sap$ide$eclipse$cbs$activation$ActivationPlugin;

    public ActivationPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        m_instance = this;
    }

    public static ActivationPlugin getDefault() {
        return m_instance;
    }

    public void startup() throws CoreException {
        super.startup();
        ActivationRuntimeDataStorage.getStorage();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        ActivationRuntimeDataStorage.getStorage().destroyStorage();
    }

    public Image getAtomicImage(String filename) {
        if (this.m_imageRegistry == null) {
            this.m_imageRegistry = this.getImageRegistry();
        }
        if (this.m_imageRegistry.get(filename) == null) {
            this.m_imageRegistry.put(filename, this.createImageDescriptor(filename));
        }
        return this.m_imageRegistry.get(filename);
    }

    public Image getCompositeImage(String baseImageName, String[] decoratorNames) {
        if (this.m_imageRegistry == null) {
            this.m_imageRegistry = this.getImageRegistry();
        }
        String key = baseImageName;
        if (decoratorNames != null && decoratorNames.length > 0) {
            ArrayList<ImageDescriptor> descriptorList = new ArrayList<ImageDescriptor>();
            int i = 0;
            while (i < decoratorNames.length) {
                key = key + "+" + decoratorNames[i];
                descriptorList.add(this.createImageDescriptor(decoratorNames[i]));
                ++i;
            }
            if (this.m_imageRegistry.get(key) == null) {
                this.m_imageRegistry.put(key, (ImageDescriptor)new MultiCompositeImageDescriptor(this.getAtomicImage(baseImageName), descriptorList.toArray(new ImageDescriptor[descriptorList.size()])));
            }
        }
        return this.m_imageRegistry.get(key);
    }

    public ImageDescriptor createImageDescriptor(String filename) {
        URL installURL = this.getDescriptor().getInstallURL();
        try {
            URL imageURL = new URL(installURL, m_imageDirectory + filename);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (MalformedURLException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    public void addDevelopmentConfigurationListener(IDevelopmentConfigurationListener listener) {
        this.m_devConfigListeners.add(listener);
    }

    public void removeDevelopmentConfigurationListener(IDevelopmentConfigurationListener listener) {
        this.m_devConfigListeners.remove(listener);
    }

    public void addActivationListener(IActivationListener listener) {
        this.m_activationListeners.add(listener);
    }

    public void removeActivationListener(IActivationListener listener) {
        this.m_activationListeners.remove(listener);
    }

    public void fireActiveDevelopmentConfigurationChangedEvent(IDevelopmentConfiguration newDevConfig, IDevelopmentConfiguration oldDevConfig) {
        Iterator iter = this.m_devConfigListeners.iterator();
        while (iter.hasNext()) {
            IDevelopmentConfigurationListener listener = (IDevelopmentConfigurationListener)iter.next();
            listener.onActiveDevelopmentConfigurationChanged(newDevConfig, oldDevConfig);
        }
    }

    public void fireActivationRequestCreatedEvent(IBuildRequest buildRequest) {
        Iterator iterator = this.m_activationListeners.iterator();
        while (iterator.hasNext()) {
            ((IActivationListener)iterator.next()).onActivationRequestCreated(buildRequest);
        }
    }

    public void fireActivationRequestStatusChangedEvent(IBuildRequest[] buildRequests) {
        Iterator iter = this.m_activationListeners.iterator();
        while (iter.hasNext()) {
            ((IActivationListener)iter.next()).onActivationRequestStatusChanged(buildRequests);
        }
    }

    public void fireActivationRequestFinishedEvent(IBuildRequest[] buildRequests) {
        Iterator iter = this.m_activationListeners.iterator();
        while (iter.hasNext()) {
            ((IActivationListener)iter.next()).onActivationRequestFinished(buildRequests);
        }
    }

    public void fireActivationRequestDeletedEvent(IBuildRequest[] buildRequests) {
        Iterator iterator = this.m_activationListeners.iterator();
        while (iterator.hasNext()) {
            ((IActivationListener)iterator.next()).onActivationRequestDeleted(buildRequests);
        }
    }

    public void earlyStartup() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

