/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards.tablebinding;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Table;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TableColumn;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.metamodel.webdynpro.type.NativeType;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.ContextModel;
import com.sap.ide.webdynpro.template.wizards.ContextSelectPage;
import com.sap.ide.webdynpro.template.wizards.TextPool;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import com.sap.ide.webdynpro.template.wizards.listener.IWizardPageListener;
import com.sap.ide.webdynpro.template.wizards.tablebinding.TableBindingWizard;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.IWizardPage;

public class TableWizardPageListener
implements IWizardPageListener {
    private IContextAttributeModel[] mAttributeBindingModels;
    private ContextElement mBoundNode;
    private ContextModel mContextModel;
    private IWizardPage mPage;
    private int mPageIndex = 0;
    private Table mTable;
    private TableBindingWizard.ExistingBindingCache mBindingCache;

    public TableWizardPageListener(int pageIndex, IWizardPage page, Table table, TableBindingWizard.ExistingBindingCache bindingCache, ContextModel contextModel) {
        this.mPageIndex = pageIndex;
        this.mTable = table;
        this.mPage = page;
        this.mBindingCache = bindingCache;
        this.mContextModel = contextModel;
    }

    public void postInitialize() {
        switch (this.mPageIndex) {
            case 1: {
                this.initializeContextSelectionPage();
                this.registerSelectionEvent();
                break;
            }
            case 2: {
                this.initializeTablePage();
            }
        }
    }

    private void registerSelectionEvent() {
        final ContextSelectPage ctxSelectionPage = (ContextSelectPage)this.mPage;
        ctxSelectionPage.setCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() != null) {
                    ctxSelectionPage.setErrorMessage(null);
                    ContextElement selectedElement = (ContextElement)event.getElement();
                    if (selectedElement instanceof ContextNode) {
                        ctxSelectionPage.clearAllSelection();
                        ctxSelectionPage.expand(selectedElement);
                        ContextAttribute[] attribs = ((ContextNode)selectedElement).getAttributes();
                        if (attribs != null) {
                            int i = 0;
                            while (i < attribs.length) {
                                ctxSelectionPage.setSelection((ContextElement)attribs[i], event.getChecked());
                                TableWizardPageListener.this.setModelAttributeState((ContextElement)attribs[i], event.getChecked());
                                ++i;
                            }
                        }
                        ctxSelectionPage.setSelection(selectedElement, event.getChecked());
                    } else if (selectedElement instanceof ContextAttribute) {
                        if (TableWizardPageListener.this.isParentRoot(ctxSelectionPage, (ContextElement)selectedElement.getParent())) {
                            ctxSelectionPage.clearAllSelection();
                            ctxSelectionPage.setSelection(selectedElement, true);
                            return;
                        }
                        if (!ctxSelectionPage.getChecked(selectedElement.getParent()) && !ctxSelectionPage.getGrayed(selectedElement.getParent())) {
                            ctxSelectionPage.clearAllSelection();
                        }
                        ctxSelectionPage.setSelection(selectedElement, event.getChecked());
                        if (event.getChecked()) {
                            ctxSelectionPage.setGraySelection((ContextElement)selectedElement.getParent(), event.getChecked());
                        }
                        TableWizardPageListener.this.setModelAttributeState(selectedElement, event.getChecked());
                        if (event.getChecked()) {
                            ctxSelectionPage.updateParentSelection((ContextAttribute)selectedElement);
                        } else {
                            ctxSelectionPage.setGraySelection((ContextElement)selectedElement.getParent(), true);
                            ctxSelectionPage.clearParentSelection((ContextAttribute)selectedElement);
                        }
                        selectedElement = (ContextElement)selectedElement.getParent();
                    }
                    if (event.getChecked()) {
                        if (!selectedElement.equals(TableWizardPageListener.this.mBoundNode)) {
                            TableWizardPageListener.this.clearOtherElements(selectedElement);
                            TableWizardPageListener.this.mContextModel.setModel(TableWizardPageListener.this.getAttributeClasses(TableWizardPageListener.this.mContextModel.getVisibleContextAttributeModel()));
                            TableWizardPageListener.this.mContextModel.setContextAttributesForBinding(((ContextNode)selectedElement).getAttributes());
                            TableWizardPageListener.this.mBoundNode = selectedElement;
                        } else {
                            TableWizardPageListener.this.clearOtherElements(TableWizardPageListener.this.mBoundNode);
                            TableWizardPageListener.this.mContextModel.setModel((AttributeBindingModel[])TableWizardPageListener.this.mAttributeBindingModels);
                        }
                    }
                    ContextAttribute[] attrs = ctxSelectionPage.getSelectedContextAttributes();
                    TableWizardPageListener.this.validateType();
                    TableWizardPageListener.this.checkForPageCompleteness(ctxSelectionPage);
                }
            }
        });
    }

    private ContextAttribute[] getValidAttributesForBinding(ContextNode node) {
        ContextAttribute[] attributes = null;
        if (node != null) {
            ContextAttribute[] allAttributes = node.getAttributes();
            ArrayList<ContextAttribute> list = new ArrayList<ContextAttribute>();
            if (allAttributes != null) {
                int i = 0;
                while (i < allAttributes.length) {
                    if (this.isTypeValid(allAttributes[i])) {
                        list.add(allAttributes[i]);
                    }
                    ++i;
                }
            }
            if (list.size() > 0) {
                attributes = new ContextAttribute[list.size()];
                attributes = list.toArray(attributes);
            }
        }
        return attributes;
    }

    private boolean isTypeValid(ContextAttribute attribute) {
        DevelopmentObject dataType;
        return attribute == null || (dataType = CheckLayerHelper.getType((ContextAttribute)attribute)) == null || !(dataType instanceof NativeType);
    }

    private AttributeBindingModel[] getAttributeClasses(IContextAttributeModel[] models) {
        AttributeBindingModel[] modelClasses = new AttributeBindingModel[models.length];
        int i = 0;
        while (i < modelClasses.length) {
            modelClasses[i] = (AttributeBindingModel)models[i];
            ++i;
        }
        return modelClasses;
    }

    private void validateType() {
        ContextSelectPage ctxSelectionPage = (ContextSelectPage)this.mPage;
        IContextAttributeModel[] modelElements = this.mContextModel.getVisibleContextAttributeModel();
        if (modelElements != null) {
            ContextAttribute attribute = null;
            int i = 0;
            while (i < modelElements.length) {
                DevelopmentObject dataType;
                attribute = modelElements[i].getContextAttribute();
                if (attribute != null && ctxSelectionPage.getChecked(attribute) && (dataType = CheckLayerHelper.getType((ContextAttribute)attribute)) instanceof NativeType) {
                    String message = null;
                    message = "ContextAttribute " + attribute.getName() + " has JavaNativeType " + dataType.getName() + " \n" + "ContextAttribute with java native type cannot be selected";
                    ctxSelectionPage.setErrorMessage(message);
                    ctxSelectionPage.setPageComplete(false);
                    return;
                }
                ++i;
            }
        }
        ctxSelectionPage.setErrorMessage(null);
        ctxSelectionPage.setPageComplete(true);
    }

    private boolean isParentRoot(ContextSelectPage ctxSelectionPage, ContextElement element) {
        if (!ctxSelectionPage.isRootNode(element)) {
            ctxSelectionPage.setPageComplete(true);
            return false;
        }
        ctxSelectionPage.setErrorMessage(TextPool.getInstance().getText(12));
        ctxSelectionPage.setPageComplete(false);
        return true;
    }

    private void clearOtherElements(ContextElement parent) {
        if (null == parent) {
            return;
        }
        if (this.mAttributeBindingModels == null) {
            return;
        }
        int i = 0;
        while (i < this.mAttributeBindingModels.length) {
            AttributeBindingModel model = (AttributeBindingModel)this.mAttributeBindingModels[i];
            if (null != model && null != model.getParent() && !model.getParent().equals(parent)) {
                model.setIsSelected(false);
            }
            ++i;
        }
    }

    private void setModelAttributeState(ContextElement element, boolean checked) {
        if (null == this.mContextModel) {
            return;
        }
        IContextAttributeModel[] models = this.mContextModel.getContextAttributeModel();
        boolean found = false;
        int i = 0;
        while (i < models.length) {
            AttributeBindingModel model = (AttributeBindingModel)models[i];
            if (element.equals(model.getContextAttribute())) {
                model.setIsSelected(checked);
                found = true;
            }
            ++i;
        }
        if (!checked || found) {
            return;
        }
        AttributeBindingModel newModel = (AttributeBindingModel)this.mContextModel.createContextAttributeModel((DevelopmentObject)element);
        newModel.setIsSelected(checked);
        newModel.setIsNew(true);
        this.mAttributeBindingModels = this.mContextModel.getContextAttributeModel();
    }

    private void initializeTablePage() {
    }

    private void initializeContextSelectionPage() {
        if (null == this.mTable) {
            return;
        }
        ContextSelectPage ctxSelectionPage = (ContextSelectPage)this.mPage;
        UIElementContextBinding contextBinding = this.mTable.getContextBinding("dataSource");
        if (null == contextBinding) {
            return;
        }
        this.mBoundNode = contextBinding.getBoundContextElement();
        if (null == this.mBoundNode) {
            return;
        }
        ctxSelectionPage.setSelection(this.mBoundNode, true);
        Vector<AttributeBindingModel> existingModels = new Vector<AttributeBindingModel>();
        int colIndex = 0;
        while (colIndex < this.mTable.getColumnCount()) {
            TableColumn column = this.mTable.getColumn(colIndex);
            if (null == column.getTableCellEditor()) {
                AttributeBindingModel bindingModel = (AttributeBindingModel)this.mContextModel.createContextAttributeModel();
                bindingModel.setDefaultInputFieldType();
                bindingModel.setInputLabel(column.getName());
                existingModels.add(bindingModel);
            } else {
                UIElementContextBinding[] bindings = column.getTableCellEditor().getContextBindings();
                if (bindings.length == 0) {
                    AttributeBindingModel bindingModel = (AttributeBindingModel)this.mContextModel.createContextAttributeModel();
                    bindingModel.setInputFieldType(this.getEditorName(column.getTableCellEditor()));
                    bindingModel.setInputLabel(column.getName());
                    bindingModel.updateBindingProperty();
                    existingModels.add(bindingModel);
                } else {
                    boolean found = false;
                    int i = 0;
                    while (i < bindings.length) {
                        ContextElement element = bindings[i].getBoundContextElement();
                        if (null != element) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        AttributeBindingModel bindingModel = (AttributeBindingModel)this.mContextModel.createContextAttributeModel();
                        bindingModel.setInputFieldType(this.getEditorName(column.getTableCellEditor()));
                        bindingModel.setInputLabel(column.getName());
                        bindingModel.updateBindingProperty();
                        existingModels.add(bindingModel);
                    } else {
                        int bindIndex = 0;
                        while (bindIndex < bindings.length) {
                            ContextElement element = bindings[bindIndex].getBoundContextElement();
                            if (null != element && element.getParent().equals(this.mBoundNode)) {
                                ctxSelectionPage.setSelection(element, true);
                                String editorName = null;
                                UIElement uiElement = column.getTableCellEditor();
                                editorName = this.getEditorName(uiElement);
                                AttributeBindingModel attributeBindingModel = (AttributeBindingModel)this.mContextModel.createContextAttributeModel((DevelopmentObject)element);
                                String property = this.getBoundProperty(bindings, bindIndex, uiElement);
                                attributeBindingModel.setInputFieldType(editorName);
                                attributeBindingModel.setBindingProperty(property);
                                attributeBindingModel.setInputLabel(column.getName());
                                existingModels.add(attributeBindingModel);
                            }
                            ++bindIndex;
                        }
                    }
                }
            }
            ++colIndex;
        }
        this.mAttributeBindingModels = new AttributeBindingModel[existingModels.size()];
        int i = 0;
        while (i < this.mAttributeBindingModels.length) {
            this.mAttributeBindingModels[i] = (AttributeBindingModel)existingModels.get(i);
            ++i;
        }
        this.mContextModel.setContextAttributesForBinding(((ContextNode)this.mBoundNode).getAttributes());
        this.mContextModel.setModel((AttributeBindingModel[])this.mAttributeBindingModels);
        ctxSelectionPage.setPageComplete(true);
    }

    private String getBindingProperty(UIElementContextBinding[] bindings, int bindIndex, UIElement element) {
        String bindingProperty = null;
        boolean set = false;
        if (this.isPrimary(element, bindings[bindIndex].getName())) {
            bindingProperty = bindings[bindIndex].getName();
            set = true;
        }
        return null;
    }

    private String getEditorName(UIElement uiElement) {
        String editorName = null != uiElement.getDefinition() ? uiElement.getDefinition().getName() : uiElement.getMetaClass().getName();
        editorName = editorName.substring(editorName.lastIndexOf(".") + 1, editorName.length());
        return editorName;
    }

    private String getBoundProperty(UIElementContextBinding[] bindings, int bindIndex, UIElement element) {
        String boundProperty = "";
        boolean set = false;
        int l = 0;
        while (l < bindings.length) {
            if (this.isPrimary(element, bindings[bindIndex].getName())) {
                boundProperty = bindings[bindIndex].getName();
                set = true;
                break;
            }
            ++l;
        }
        if (!set) {
            String elementName = element.getMetaClass().getName();
            elementName = elementName.substring(elementName.lastIndexOf(".") + 1);
            ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)elementName);
            Object lPrimary = null;
            AbstractViewElementPropertyDef[] lProperties = null;
            while (lDefinition != null && !set) {
                lProperties = lDefinition.getProperties();
                int m = 0;
                while (m < lProperties.length) {
                    if (lProperties[m].getPrimary()) {
                        boundProperty = lProperties[m].getName();
                        set = true;
                    }
                    ++m;
                }
                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
            }
        }
        if (!set && bindings.length > 0) {
            boundProperty = bindings[0].getName();
            set = true;
        }
        return boundProperty;
    }

    private boolean isPrimary(UIElement element, String property) {
        String elementName = element.getMetaClass().getName();
        elementName = elementName.substring(elementName.lastIndexOf(".") + 1);
        ViewElementDefinition lDefinition = MetamodelServices.getViewElementDefinition((String)this.mTable.getRoot().getMetamodel().getName(), (String)elementName);
        Object lPrimary = null;
        AbstractViewElementPropertyDef[] lProperties = null;
        while (lDefinition != null) {
            lProperties = lDefinition.getProperties();
            int j = 0;
            while (j < lProperties.length) {
                if (property.equals(lProperties[j].getName())) {
                    return true;
                }
                ++j;
            }
            lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
        }
        return false;
    }

    private void checkForPageCompleteness(ContextSelectPage wizardPage) {
        if (wizardPage.getErrorMessage() != null && !wizardPage.getErrorMessage().equals("")) {
            return;
        }
        if (wizardPage.getSelectedContextAttributes() == null || wizardPage.getSelectedContextAttributes().length == 0) {
            wizardPage.setPageComplete(false);
        } else {
            wizardPage.setPageComplete(true);
        }
    }
}

