/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards.formview;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.type.NativeType;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.template.wizards.AttributeBindingModel;
import com.sap.ide.webdynpro.template.wizards.ContextModel;
import com.sap.ide.webdynpro.template.wizards.ContextSelectPage;
import com.sap.ide.webdynpro.template.wizards.UIElementInfoProvider;
import com.sap.ide.webdynpro.template.wizards.generation.data.IContextAttributeModel;
import com.sap.ide.webdynpro.template.wizards.listener.IWizardPageListener;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;

public class ContextSelectionPageListener
implements IWizardPageListener {
    private ContextSelectPage wizardPage;
    private ContextModel contextModel;
    private ContextAttribute[] contextAttributes;
    private ContextNode rootContextNode;

    public ContextSelectionPageListener(ContextSelectPage page, ContextModel model) {
        this.wizardPage = page;
        this.contextModel = model;
        if (this.contextModel.getDevelopmentOject() != null) {
            this.rootContextNode = ((View)this.contextModel.getDevelopmentOject().getMDO()).getViewController().getContext();
        }
        this.initializeContextAttributes();
        if (this.contextAttributes != null) {
            this.contextModel.setContextAttributesForBinding(this.contextAttributes);
        }
    }

    public void postInitialize() {
        this.registerStateListener();
    }

    private void registerStateListener() {
        this.wizardPage.setCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() != null) {
                    ContextSelectionPageListener.this.wizardPage.setErrorMessage(null);
                    ContextElement selectedElement = (ContextElement)event.getElement();
                    ContextSelectionPageListener.this.expandAllSelectedNodes();
                    if (selectedElement instanceof ContextNode && ((ContextNode)selectedElement).equals(ContextSelectionPageListener.this.rootContextNode)) {
                        ContextSelectionPageListener.this.wizardPage.setGraySelection(selectedElement, true);
                        ContextSelectionPageListener.this.wizardPage.setSelection(selectedElement, true);
                        return;
                    }
                    if (selectedElement instanceof ContextNode) {
                        ContextSelectionPageListener.this.wizardPage.expand(selectedElement);
                        ContextSelectionPageListener.this.selectAllChildren((ContextNode)selectedElement, false, event.getChecked());
                        ContextSelectionPageListener.this.updateParentNode(((ContextNode)selectedElement).getParentNode());
                    } else if (selectedElement instanceof ContextAttribute) {
                        ContextSelectionPageListener.this.wizardPage.setSelection(selectedElement, event.getChecked());
                        ContextSelectionPageListener.this.updateParentNode(((ContextAttribute)selectedElement).getNode());
                    }
                    ContextSelectionPageListener.this.contextModel.setModel(null);
                    ContextSelectionPageListener.this.contextModel.setModel(ContextSelectionPageListener.this.getOutput());
                    ContextSelectionPageListener.this.validateType();
                    ContextSelectionPageListener.this.checkForPageCompleteness();
                }
            }
        });
    }

    private void validateType() {
        IContextAttributeModel[] modelElements = this.contextModel.getContextAttributeModel();
        if (modelElements != null) {
            ContextAttribute attribute = null;
            int i = 0;
            while (i < modelElements.length) {
                DevelopmentObject dataType;
                attribute = modelElements[i].getContextAttribute();
                if (attribute != null && (dataType = CheckLayerHelper.getType((ContextAttribute)attribute)) instanceof NativeType) {
                    String message = null;
                    message = "ContextAttribute " + attribute.getName() + " has JavaNativeType " + dataType.getName() + " \n" + "ContextAttribute with java native type cannot be selected";
                    this.wizardPage.setErrorMessage(message);
                    this.wizardPage.setPageComplete(false);
                    return;
                }
                ++i;
            }
        }
        this.wizardPage.setErrorMessage(null);
        this.wizardPage.setPageComplete(true);
    }

    private boolean isTypeValid(ContextAttribute attribute) {
        DevelopmentObject dataType;
        return attribute == null || (dataType = CheckLayerHelper.getType((ContextAttribute)attribute)) == null || !(dataType instanceof NativeType);
    }

    private boolean isCardinalityValid(ContextNode node) {
        CardinalityEnum cardinalityEnum;
        return node != null && ((cardinalityEnum = node.getCardinality()) == CardinalityEnum._0_1 || cardinalityEnum == CardinalityEnum._1_1);
    }

    private void updateParentNode(ContextNode parentNode) {
        if (parentNode != null && !parentNode.equals(this.rootContextNode)) {
            if (this.isNodeSelected((ContextElement)parentNode)) {
                this.wizardPage.setGraySelection((ContextElement)parentNode, false);
                this.wizardPage.setSelection((ContextElement)parentNode, true);
            } else if (this.isNodeDeselected((ContextElement)parentNode)) {
                this.wizardPage.setGraySelection((ContextElement)parentNode, false);
                this.wizardPage.setSelection((ContextElement)parentNode, false);
            } else {
                this.wizardPage.setGraySelection((ContextElement)parentNode, true);
            }
            this.updateParentNode(parentNode.getParentNode());
        }
    }

    private boolean isNodeSelected(ContextElement element) {
        if (element != null) {
            AbstractContextNode[] childNodes;
            ContextAttribute[] attributes = ((ContextNode)element).getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    if (!this.wizardPage.getChecked(attributes[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((childNodes = ((ContextNode)element).getChildNodes()) != null) {
                int i = 0;
                while (i < childNodes.length) {
                    if (!this.isNodeSelected((ContextElement)childNodes[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isNodeDeselected(ContextElement element) {
        if (element != null) {
            AbstractContextNode[] childNodes;
            ContextAttribute[] attributes = ((ContextNode)element).getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    if (this.wizardPage.getChecked(attributes[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((childNodes = ((ContextNode)element).getChildNodes()) != null) {
                int i = 0;
                while (i < childNodes.length) {
                    if (!this.isNodeDeselected((ContextElement)childNodes[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private void selectAllChildren(ContextNode contextNode, boolean greyStatus, boolean status) {
        if (contextNode != null) {
            AbstractContextNode[] nodes;
            this.wizardPage.expand((ContextElement)contextNode);
            this.wizardPage.setGraySelection((ContextElement)contextNode, greyStatus);
            this.wizardPage.setSelection((ContextElement)contextNode, status);
            ContextAttribute[] attributes = contextNode.getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    this.wizardPage.setGraySelection((ContextElement)attributes[i], greyStatus);
                    this.wizardPage.setSelection((ContextElement)attributes[i], status);
                    ++i;
                }
            }
            if ((nodes = contextNode.getChildNodes()) != null) {
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] instanceof ContextNode) {
                        this.selectAllChildren((ContextNode)nodes[i], greyStatus, status);
                        this.wizardPage.setGraySelection((ContextElement)nodes[i], greyStatus);
                        this.wizardPage.setSelection((ContextElement)nodes[i], status);
                    }
                    ++i;
                }
            }
        }
    }

    private void expandAllSelectedNodes() {
        Object[] selectedNodes = this.wizardPage.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.length > 0) {
            int i = 0;
            while (i < selectedNodes.length) {
                this.wizardPage.expand((ContextElement)selectedNodes[i]);
                ++i;
            }
        }
    }

    private boolean validateCardinality(ContextNode node) {
        boolean status = true;
        if (node != null) {
            AbstractContextNode[] childnodes;
            if (!node.equals(this.rootContextNode) && this.wizardPage.getChecked(node) && !this.isCardinalityValid(node)) {
                boolean setErrMsg = false;
                if (this.wizardPage.getGrayed(node)) {
                    ContextAttribute[] childAttributes = node.getAttributes();
                    if (childAttributes != null) {
                        int i = 0;
                        while (i < childAttributes.length) {
                            if (this.wizardPage.getChecked(childAttributes[i])) {
                                String message = null;
                                message = "ContextNode " + node.getName() + " has cardinality n \n" + "ContextNode with cardinality n cannot be selected";
                                this.wizardPage.setErrorMessage(message);
                                this.wizardPage.setPageComplete(false);
                                status = false;
                                return status;
                            }
                            ++i;
                        }
                    }
                } else {
                    String message = null;
                    message = "ContextNode " + node.getName() + " has cardinality n \n" + "ContextNode with cardinality n cannot be selected";
                    this.wizardPage.setErrorMessage(message);
                    this.wizardPage.setPageComplete(false);
                    status = false;
                    return status;
                }
            }
            if ((childnodes = node.getChildNodes()) != null) {
                int i = 0;
                while (i < childnodes.length) {
                    status = this.validateCardinality((ContextNode)childnodes[i]);
                    if (!status) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    private AttributeBindingModel[] getOutput() {
        ContextAttribute[] ctxAttribs = this.wizardPage.getSelectedContextAttributes();
        ArrayList<AttributeBindingModel> list = new ArrayList<AttributeBindingModel>();
        ArrayList<ContextAttribute> attribList = new ArrayList<ContextAttribute>();
        AttributeBindingModel[] modelElements = null;
        AttributeBindingModel model = null;
        if (ctxAttribs != null) {
            UIElementInfoProvider uiInfoProvider = this.contextModel.getUIInfoProvider();
            attribList.add(null);
            int i = 0;
            while (i < ctxAttribs.length) {
                model = new AttributeBindingModel(uiInfoProvider, ctxAttribs[i]);
                list.add(model);
                attribList.add(ctxAttribs[i]);
                ++i;
            }
            modelElements = new AttributeBindingModel[list.size()];
            modelElements = list.toArray(modelElements);
            ctxAttribs = new ContextAttribute[attribList.size()];
            ctxAttribs = attribList.toArray(ctxAttribs);
            if (this.contextModel.getUIInfoProvider().getSelectedAttributes() == null) {
                if (this.contextAttributes == null) {
                    this.contextModel.setContextAttributesForBinding(ctxAttribs);
                } else {
                    this.contextModel.setContextAttributesForBinding(this.contextAttributes);
                }
            }
        }
        return modelElements;
    }

    private void checkForPageCompleteness() {
        if (this.wizardPage.getErrorMessage() != null && !this.wizardPage.getErrorMessage().equals("")) {
            return;
        }
        if (this.wizardPage.getSelectedContextAttributes() == null || this.wizardPage.getSelectedContextAttributes().length == 0) {
            this.wizardPage.setPageComplete(false);
        } else {
            this.wizardPage.setPageComplete(true);
        }
    }

    private void initializeContextAttributes() {
        if (this.contextModel != null && this.contextModel.getDevelopmentOject() != null) {
            DevelopmentObject devObject = this.contextModel.getDevelopmentOject();
            ContextValueNode valueNode = ((View)devObject.getMDO()).getViewController().getContext();
            this.contextAttributes = this.getContextAttributes((ContextNode)valueNode);
        }
    }

    private ContextAttribute[] getContextAttributes(ContextNode node) {
        ContextAttribute[] attributes = null;
        if (node != null) {
            attributes = node.getAttributes();
            AbstractContextNode[] childNodes = node.getChildNodes();
            if (childNodes != null) {
                ContextAttribute[] childAttribs = null;
                int i = 0;
                while (i < childNodes.length) {
                    if (childNodes[i] instanceof ContextNode) {
                        childAttribs = this.getContextAttributes((ContextNode)childNodes[i]);
                        attributes = this.addAttributes(attributes, childAttribs);
                    }
                    ++i;
                }
            }
        }
        return attributes;
    }

    private ContextAttribute[] addAttributes(ContextAttribute[] firArray, ContextAttribute[] secArray) {
        ContextAttribute[] attributes = null;
        ArrayList<ContextAttribute> list = new ArrayList<ContextAttribute>();
        if (firArray != null) {
            int i = 0;
            while (i < firArray.length) {
                if (this.isTypeValid(firArray[i])) {
                    list.add(firArray[i]);
                }
                ++i;
            }
        }
        if (firArray != null) {
            int i = 0;
            while (i < secArray.length) {
                if (this.isTypeValid(secArray[i])) {
                    list.add(secArray[i]);
                }
                ++i;
            }
        }
        if (list.size() > 0) {
            attributes = new ContextAttribute[list.size()];
            attributes = list.toArray(attributes);
        }
        return attributes;
    }
}

