/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.template.wizards;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.framework.FrameworkObjectDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.MarkerInterface;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementLibrary;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UIElementInfoProvider {
    public static int TMP_FORM_VIEW = 0;
    public static int TMP_TABLE_VIEW = 1;
    public static String INPUTFIELD = "InputField";
    public static String CHECKBOX = "CheckBox";
    public static String IMAGE = "Image";
    public static String BUTTON = "Button";
    public static String LINKTOACTION = "LinkToAction";
    public static String LINKTOURL = "LinkToURL";
    public static String TEXTVIEW = "TextView";
    public static String CAPTION = "Caption";
    public static String DROPDOWNBYINDEX = "DropDownByIndex";
    public static String DROPDOWNBYKEY = "DropDownByKey";
    public static String RADIOBUTTON = "RadioButton";
    public static String[] invalidTypes = new String[]{"Button", "Caption", "Image", "DynproImage"};
    public static String STRING = "string";
    public static String BOOLEAN = "boolean";
    public static String BOOLEANOBJECT = "booleanObject";
    public static String BINARY = "binary";
    private DevelopmentObject devObject;
    private String[] inputFieldTypes;
    private String[] bindingProperties;
    private ContextAttribute[] contextAttributes;
    private Map bindingPropsMap;
    private Map defaultPropsMap;
    private int templateInitializer = -1;
    static /* synthetic */ Class class$java$lang$Boolean;

    public UIElementInfoProvider() {
        this.bindingPropsMap = new HashMap();
        this.defaultPropsMap = new HashMap();
        this.inputFieldTypes = new String[0];
        this.bindingProperties = new String[0];
    }

    public UIElementInfoProvider(DevelopmentObject devObject) {
        this.devObject = devObject;
        this.bindingPropsMap = new HashMap();
        this.defaultPropsMap = new HashMap();
        this.initializeInputFieldTypes();
        this.initializeBindingProperties();
    }

    private void initializeInputFieldTypes() {
        UIElementLibrary[] lLibraries = MetamodelServices.getLibraries((String)this.devObject.getRoot().getMetamodel().getName());
        boolean found = false;
        UIElementDefinition[] lDefinitions = null;
        ArrayList<String> mItems = new ArrayList<String>();
        int j = 0;
        while (j < lLibraries.length) {
            lDefinitions = MetamodelServices.getUIElementDefinitions((UIElementLibrary)lLibraries[j]);
            int i = 0;
            while (i < lDefinitions.length) {
                found = false;
                if (!lDefinitions[i].getAbstract()) {
                    MarkerInterface[] interfaces = lDefinitions[i].getImplementedInterfaces();
                    int k = 0;
                    while (k < interfaces.length) {
                        if (interfaces[k].getName().equals("TableCellEditor") && this.isEditorTypeValid(lDefinitions[i].getName())) {
                            mItems.add(lDefinitions[i].getName());
                            found = true;
                        }
                        ++k;
                    }
                    if (!found) {
                        FrameworkObjectDefinition fwDefinition = lDefinitions[i].getSuperClass();
                        while (fwDefinition != null) {
                            if (!(fwDefinition instanceof ViewElementDefinition)) break;
                            MarkerInterface[] markerInterfaces = ((ViewElementDefinition)fwDefinition).getImplementedInterfaces();
                            int k2 = 0;
                            if (k2 < markerInterfaces.length) {
                                if (markerInterfaces[k2].getName().equals("TableCellEditor") && this.isEditorTypeValid(lDefinitions[i].getName())) {
                                    mItems.add(lDefinitions[i].getName());
                                }
                            }
                            fwDefinition = fwDefinition.getSuperClass();
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        if (this.templateInitializer == TMP_FORM_VIEW) {
            this.inputFieldTypes = new String[mItems.size() + 1];
            this.inputFieldTypes = mItems.toArray(this.inputFieldTypes);
            this.inputFieldTypes[mItems.size()] = "TextEdit";
        } else {
            this.inputFieldTypes = new String[mItems.size()];
            this.inputFieldTypes = mItems.toArray(this.inputFieldTypes);
        }
        Arrays.sort(this.inputFieldTypes);
    }

    private boolean isEditorTypeValid(String editorType) {
        if (editorType != null) {
            int i = 0;
            while (i < invalidTypes.length) {
                if (invalidTypes[i].equals(editorType)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void initializeBindingProperties() {
        ArrayList<String> propList = null;
        String lPrimary = null;
        AbstractViewElementPropertyDef[] lProperties = null;
        ViewElementDefinition lDefinition = null;
        if (this.inputFieldTypes != null) {
            int i = 0;
            while (i < this.inputFieldTypes.length) {
                propList = new ArrayList<String>();
                lPrimary = null;
                lDefinition = MetamodelServices.getViewElementDefinition((String)this.devObject.getRoot().getMetamodel().getName(), (String)this.inputFieldTypes[i]);
                while (lDefinition != null) {
                    lProperties = lDefinition.getProperties();
                    int j = 0;
                    while (j < lProperties.length) {
                        propList.add(lProperties[j].getName());
                        if (lProperties[j].getPrimary()) {
                            lPrimary = lProperties[j].getName();
                        }
                        ++j;
                    }
                    lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
                }
                if (lPrimary != null) {
                    this.defaultPropsMap.put(this.inputFieldTypes[i], lPrimary);
                } else {
                    this.defaultPropsMap.put(this.inputFieldTypes[i], "");
                }
                this.bindingProperties = new String[propList.size()];
                this.bindingProperties = propList.toArray(this.bindingProperties);
                Arrays.sort(this.bindingProperties);
                this.bindingPropsMap.put(this.inputFieldTypes[i], this.bindingProperties);
                ++i;
            }
        }
    }

    public void setTemplateType(int type) {
        this.templateInitializer = type;
        if (this.templateInitializer == TMP_FORM_VIEW) {
            this.initializeInputFieldTypes();
            this.initializeBindingProperties();
        }
    }

    public String[] getInputFieldTypes() {
        return this.inputFieldTypes;
    }

    public String[] getBindingProperties(String editorType) {
        return (String[])this.bindingPropsMap.get(editorType);
    }

    public void setSelectedAttributes(ContextAttribute[] attributes) {
        this.contextAttributes = attributes;
    }

    public ContextAttribute[] getSelectedAttributes() {
        return this.contextAttributes;
    }

    public int getAttributeIndex(String name) {
        if (name != null && this.contextAttributes != null) {
            int i = 0;
            while (i < this.contextAttributes.length) {
                if (this.contextAttributes[i] != null && ContextService.getAbsoluteContextElementPath((ContextElement)this.contextAttributes[i]).equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public ContextAttribute getContextAttribute(int index) {
        if (this.contextAttributes != null && index != -1 && index < this.contextAttributes.length) {
            return this.contextAttributes[index];
        }
        return null;
    }

    public int getInputFieldTypeIndex(String fieldType) {
        if (fieldType != null && this.inputFieldTypes != null) {
            int i = 0;
            while (i < this.inputFieldTypes.length) {
                if (this.inputFieldTypes[i].equals(fieldType)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public int getBindingPropertyIndex(String inputFieldType, String bindProp) {
        if (inputFieldType != null) {
            this.bindingProperties = this.getBindingProperties(inputFieldType);
        }
        if (bindProp != null && this.bindingProperties != null) {
            int i = 0;
            while (i < this.bindingProperties.length) {
                if (this.bindingProperties[i].equals(bindProp)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public String getInputFieldType(int index) {
        if (this.inputFieldTypes != null && index < this.inputFieldTypes.length) {
            return this.inputFieldTypes[index];
        }
        return null;
    }

    public String getBindingProperty(String inputFieldType, int index) {
        if (inputFieldType != null) {
            this.bindingProperties = (String[])this.bindingPropsMap.get(inputFieldType);
            if (index < this.bindingProperties.length) {
                return this.bindingProperties[index];
            }
        }
        return null;
    }

    public String getDefaultEditorForElementType(ContextAttribute ctxAttrib, DevelopmentObject elementType) {
        String defaultEditor = INPUTFIELD;
        if (this.templateInitializer == TMP_TABLE_VIEW) {
            defaultEditor = TEXTVIEW;
        }
        if (ctxAttrib != null && elementType != null) {
            int enumCount;
            DtSimpleType simpleType;
            String typeName = elementType.getName();
            if (null == typeName) {
                return defaultEditor;
            }
            if (elementType instanceof DtSimpleType && null != (simpleType = (DtSimpleType)elementType).getSchemaType() && (enumCount = simpleType.getSchemaType().getEnumerationValueCount()) > 0) {
                return DROPDOWNBYKEY;
            }
            if (typeName.equals(BOOLEAN)) {
                defaultEditor = CHECKBOX;
            } else if (typeName.equals(BINARY)) {
                defaultEditor = CHECKBOX;
            } else if (typeName.equals(BOOLEANOBJECT)) {
                defaultEditor = CHECKBOX;
            } else if (typeName.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = UIElementInfoProvider.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                defaultEditor = CHECKBOX;
            }
        }
        return defaultEditor;
    }

    public String getDefaultPropertyForEditorType(String inputField) {
        return (String)this.defaultPropsMap.get(inputField);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

